/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.IOException;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.JpegPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;

public class FFMpegJpegPipeReader
implements Runnable {
    JpegPipeReader jpegPipeReader;
    private String[] command;
    private Process process;
    ProcessListener processListener;

    public FFMpegJpegPipeReader(String ffmpegPath, String inputPath, String[] options) {
        this.command = FFMpegCommandUtil.makeJpegOutputPipeCommand(ffmpegPath, inputPath, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = runtime.exec(this.command);
            SimpleProcessPrinter printer = new SimpleProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
            monitor.setMonitorInput(false);
            monitor.startMonitor();
            this.jpegPipeReader = new JpegPipeReader(this.process.getInputStream());
            if (this.processListener != null) {
                this.processListener.started();
            }
            try {
                this.process.waitFor();
                FFMpegJpegPipeReader fFMpegJpegPipeReader = this;
                synchronized (fFMpegJpegPipeReader) {
                    this.jpegPipeReader.setDone(true);
                }
                if (this.processListener != null) {
                    this.processListener.finished();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void close() throws IOException {
        if (this.jpegPipeReader != null) {
            this.jpegPipeReader.close();
        }
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public ProcessListener getProcessListener() {
        return this.processListener;
    }

    public void setProcessListener(ProcessListener processListener) {
        this.processListener = processListener;
    }

    public JpegPipeReader getJpegPipeReader() {
        return this.jpegPipeReader;
    }

    public void setJpegPipeReader(JpegPipeReader jpegPipeReader) {
        this.jpegPipeReader = jpegPipeReader;
    }
}

