/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.StoredObject;

abstract class IndexedStoreObject
extends StoredObject {
    public IndexedStoreObject() {
    }

    public IndexedStoreObject(Field f, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        super(f, store, address);
    }

    protected final IndexAnchor acquireAnchor(ObjectAddress address) throws IndexedStoreException {
        return (IndexAnchor)this.acquireObject(address);
    }

    protected final IndexNode acquireNode(ObjectAddress address) throws IndexedStoreException {
        return (IndexNode)this.acquireObject(address);
    }

    protected final StoredObject acquireObject(ObjectAddress address) throws IndexedStoreException {
        StoredObject object;
        try {
            object = this.store.acquireObject(address);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(14, (Throwable)e);
        }
        return object;
    }

    protected final ObjectAddress insertObject(StoredObject object) throws IndexedStoreException {
        try {
            ObjectAddress address = this.store.insertObject(object);
            return address;
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(20, (Throwable)e);
        }
    }

    protected final void release() throws IndexedStoreException {
        try {
            this.store.releaseObject(this);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(17, (Throwable)e);
        }
    }

    protected final void removeObject(ObjectAddress address) throws IndexedStoreException {
        try {
            this.store.removeObject(address);
        }
        catch (ObjectStoreException e) {
            throw new IndexedStoreException(18, (Throwable)e);
        }
    }
}

