/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   All rights reserved                    */

#include <stdio.h>
#include "synthesis.h"
#include "confpara.h"
#include "main.h"

//void RepMsg( char *, ... );

extern bool s_mode;

void send_speakerset()
{
	int i;

	RepMsg( "rep SpeakerSet =" );
	for( i=0; i<n_speaker; ++i )  RepMsg( " %s", speaker[i].code );
	RepMsg( "\n" );
}

void send_speaker()
{
	RepMsg( "rep Speaker = %s\n", speaker[spid].code );
}

void send_text( char *slot )
{
	MORPH *morph, *next;

	morph = mphead;
	RepMsg( "rep %s = ", slot );
	while( morph )  {
		if( morph->silence != SILB && morph->silence != SILE &&
			morph->silence != PAU )
			RepMsg( "%s", morph->kanji );
		next = morph -> next;
		morph = next;
	}
	RepMsg( "\n" );
}

void send_phonemes( char *slot )
{
	PHONEME *phoneme;
	int dur;

	phoneme = phhead;
	RepMsg( "rep %s =", slot );
	while( phoneme )  {
		dur = (int)(phoneme->time);
		RepMsg( " %s[%d]", phoneme->phoneme, dur );
		phoneme = phoneme->next;
	}
	//*******for server mode *******
	if (s_mode) {
	  RepMsg( "phoneme_end\n" );
	}
	else {
	  RepMsg( "\n" );
	}
}

void send_duration( char *slot )
{
	PHONEME *phoneme, *next;
	int durTotal, dur;

	durTotal = 0;
	phoneme = phhead;
	while( phoneme )  {
		dur = (int)(phoneme->time);
		durTotal += dur;
		next = phoneme->next;
		phoneme = next;
	}
	RepMsg( "rep %s = %d\n", slot, durTotal );
}

extern int talked_DA_msec;
extern int already_talked;

void send_talked_duration()
{
	if( already_talked == 1 )  {
		if( talked_DA_msec < 0 )  {
			send_duration( "Speak.len" );
		} else {
			RepMsg( "rep Speak.len = %d\n", talked_DA_msec );
		}
	} else {
		RepMsg( "rep Speak.len = %d\n", 0 );
	}
}

void send_talked_phonemes()
{
	PHONEME *phoneme, *next;
	int dur;

	if( already_talked == 0 )  {
		RepMsg( "rep Speak.utt =\n" );
		return;
	}

	if( talked_DA_msec < 0 )  {
		send_phonemes( "Speak.utt" );
		return;
	}

	phoneme = phhead;
	RepMsg( "rep Speak.utt =" );
	while( phoneme )  {
		dur = (int)(phoneme->time);
		if( phoneme->ctime+phoneme->time >= talked_DA_msec )  {
			RepMsg( "\n" );
			return;
		} else {
			RepMsg( " %s[%d]", phoneme->phoneme, dur );
		}
		next = phoneme->next;
		phoneme = next;
	}

	//*******for server mode *******
	if (s_mode) {
	  RepMsg( "phoneme_end\n" );
	}
	else {
	  RepMsg( "\n" );
	}
}




