/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   All rights reserved                    */

#ifndef _PRONUNCIATION_H_
#define _PRONUNCIATION_H_

/* \LƉf̑Ή */

struct {
	char *kana;
	char *phonemes;
} prnTable[] = {
	{ "A", "a" },
	{ "C", "i" },
	{ "E", "u" },
	{ "G", "e" },
	{ "I", "o" },
	{ "J", "k a" },
	{ "L", "k i" },
	{ "N", "k u" },
	{ "P", "k e" },
	{ "R", "k o" },
	{ "T", "s a" },
	{ "V", "sh i" },
	{ "X", "s u" },
	{ "Z", "s e" },
	{ "\", "s o" },
	{ "^", "t a" },
	{ "`", "ch i" },
	{ "c", "ts u" },
	{ "e", "t e" },
	{ "g", "t o" },
	{ "i", "n a" },
	{ "j", "n i" },
	{ "k", "n u" },
	{ "l", "n e" },
	{ "m", "n o" },
	{ "n", "h a" },
	{ "q", "h i" },
	{ "t", "f u" },
	{ "w", "h e" },
	{ "z", "h o" },
	{ "}", "m a" },
	{ "~", "m i" },
	{ "", "m u" },
	{ "", "m e" },
	{ "", "m o" },
	{ "", "y a" },
	{ "", "y u" },
	{ "", "y o" },
	{ "", "r a" },
	{ "", "r i" },
	{ "", "r u" },
	{ "", "r e" },
	{ "", "r o" },
	{ "", "w a" },
	{ "", "o" },
	{ "", "N" },

	{ "K", "g a" },
	{ "M", "g i" },
	{ "O", "g u" },
	{ "Q", "g e" },
	{ "S", "g o" },
	{ "U", "z a" },
	{ "W", "j i" },
	{ "Y", "z u" },
	{ "[", "z e" },
	{ "]", "z o" },
	{ "_", "d a" },
	{ "a", "j i" },
	{ "d", "z u" },
	{ "f", "d e" },
	{ "h", "d o" },
	{ "o", "b a" },
	{ "r", "b i" },
	{ "u", "b u" },
	{ "x", "b e" },
	{ "{", "b o" },
	{ "p", "p a" },
	{ "s", "p i" },
	{ "v", "p u" },
	{ "y", "p e" },
	{ "|", "p o" },

	{ "L", "ky a" },
	{ "L", "ky u" },
	{ "LF", "ky e" },
	{ "L", "ky o" },
	{ "M", "gy a" },
	{ "M", "gy u" },
	{ "MF", "gy e" },
	{ "M", "gy o" },
	{ "V", "sh a" },
	{ "V", "sh u" },
	{ "VF", "sh e" },
	{ "V", "sh o" },
	{ "W", "j a" },
	{ "W", "j u" },
	{ "WF", "j e" },
	{ "W", "j o" },
	{ "`", "ch a" },
	{ "`", "ch u" },
	{ "`F", "ch e" },
	{ "`", "ch o" },
	{ "a", "j a" },
	{ "a", "j u" },
	{ "aF", "j e" },
	{ "a", "j o" },
	{ "j", "ny a" },
	{ "j", "ny u" },
	{ "jF", "ny e" },
	{ "j", "ny o" },
	{ "q", "hy a" },
	{ "q", "hy u" },
	{ "qF", "hy e" },
	{ "q", "hy o" },
	{ "r", "by a" },
	{ "r", "by u" },
	{ "rF", "by e" },
	{ "r", "by o" },
	{ "s", "py a" },
	{ "s", "py u" },
	{ "sF", "py e" },
	{ "s", "py o" },
	{ "~", "my a" },
	{ "~", "my u" },
	{ "~F", "my e" },
	{ "~", "my o" },
	{ "", "ry a" },
	{ "", "ry u" },
	{ "F", "ry e" },
	{ "", "ry o" },

	{ "t@", "f a" },
	{ "tB", "f i" },
	{ "tF", "f e" },
	{ "tH", "f o" },
	{ "@", "b a" },
	{ "B", "b i" },
	{ "",   "b u" },
	{ "F", "b e" },
	{ "H", "b o" },

	{ "E@", "w a" },
	{ "EB", "w i" },
	{ "EF", "w e" },
	{ "EH", "w o" },
	{ "eB", "t i" },
	{ "gD", "t u" },
	{ "fB", "d i" },
	{ "hD", "d u" },
	{ "f", "dy u" },
	{ "c@", "ts a" },
	{ "cB", "ts i" },
	{ "cF", "ts e" },
	{ "cH", "ts o" },

	{ "b", "cl" },

	{ "@", "a" },
	{ "B", "i" },
	{ "D", "u" },
	{ "F", "e" },
	{ "H", "o" },
	{ "", "y a" },
	{ "", "y u" },
	{ "", "y o" },

	{ "H", "pau" },
	{ "A", "pau" },
	{ "B", "pau" }
};

#define	NUM_KANA	(sizeof(prnTable)/sizeof(prnTable[0]))

#endif //_PRONUNCIATION_H_
