/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected URL installLocation = null;
    protected URL configurationLocation = null;
    protected String parentConfigurationLocation = null;
    protected String framework = "org.eclipse.osgi";
    protected String devClassPath = null;
    protected boolean inDevelopmentMode = false;
    private String exitData = null;
    private String vm = null;
    private String[] vmargs = null;
    private String[] commands = null;
    private String showSplash = null;
    private String endSplash = null;
    private boolean initialize = false;
    private Process showProcess = null;
    private boolean splashDown = false;
    private final Runnable endSplashHandler = new Runnable(){

        public void run() {
            Main.this.takeDownSplash();
        }
    };
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String CONFIGURATION = "-configuration";
    private static final String EXITDATA = "-exitdata";
    private static final String NOSPLASH = "-nosplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String ENDSPLASH = "-endsplash";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String FILE_SCHEME = "file:";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    private static final String PROP_BASE_CONFIG_AREA = "osgi.baseConfiguration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    private static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_SPLASHPATH = "osgi.splashPath";
    private static final String PROP_SPLASHLOCATION = "osgi.splashLocation";
    private static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    private static final String PROP_LOGFILE = "osgi.logfile";
    private static final String PROP_EOF = "eof";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.core.launcher";
    protected File logFile = null;
    protected BufferedWriter log = null;
    protected boolean newSession = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected Object basicRun(String[] args) throws Exception {
        System.getProperties().setProperty("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        this.commands = args;
        String[] passThruArgs = this.processCommandLine(args);
        this.setupVMProperties();
        this.processConfiguration();
        this.getInstallLocation();
        URL[] bootPath = this.getBootPath(this.bootLocation);
        this.handleSplash(bootPath);
        URLClassLoader loader = new URLClassLoader(bootPath, null);
        Class<?> clazz = loader.loadClass(STARTER);
        Class[] classArray = new Class[2];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Runnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            return method.invoke(clazz, passThruArgs, this.endSplashHandler);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
    }

    private String decode(String urlString) {
        try {
            Object result;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            Method method = clazz2.getDeclaredMethod("decode", classArray);
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            if ((result = method.invoke(null, urlString, "UTF-8")) != null) {
                return (String)result;
            }
        }
        catch (Exception exception) {}
        boolean replaced = false;
        byte[] encodedBytes = urlString.getBytes();
        int encodedLength = encodedBytes.length;
        byte[] decodedBytes = new byte[encodedLength];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedLength) {
            byte b = encodedBytes[i];
            if (b == 37) {
                byte enc1 = encodedBytes[++i];
                byte enc2 = encodedBytes[++i];
                b = (byte)((this.hexToByte(enc1) << 4) + this.hexToByte(enc2));
                replaced = true;
            }
            decodedBytes[decodedLength++] = b;
            ++i;
        }
        if (!replaced) {
            return urlString;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(decodedBytes, 0, decodedLength);
        }
    }

    private String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    private URL[] getDevPath(URL base) throws IOException {
        ArrayList result = new ArrayList(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(base, result);
        }
        this.addBaseJars(base, result);
        return result.toArray(new URL[result.size()]);
    }

    private void addBaseJars(URL base, ArrayList result) throws IOException {
        String baseJarList = System.getProperty(PROP_CLASSPATH);
        if (baseJarList == null) {
            Properties defaults;
            URL url = new URL(base, ECLIPSE_PROPERTIES);
            if (this.debug) {
                System.out.println("Loading framework classpath from:\n    " + url.toExternalForm());
            }
            if ((baseJarList = (defaults = this.loadProperties(url)).getProperty(PROP_CLASSPATH)) == null) {
                throw new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            System.getProperties().put(PROP_CLASSPATH, baseJarList);
        }
        String[] baseJars = this.getArrayFromList(baseJarList);
        int i = 0;
        while (i < baseJars.length) {
            String string = baseJars[i];
            try {
                URL url = null;
                url = string.startsWith(FILE_SCHEME) ? new File(string.substring(5)).toURL() : new URL(string);
                this.addEntry(url, result);
            }
            catch (MalformedURLException malformedURLException) {
                this.addEntry(new URL(base, string), result);
            }
            ++i;
        }
    }

    private void addEntry(URL url, List result) {
        if (new File(url.getFile()).exists()) {
            result.add(url);
        }
    }

    private void addDevEntries(URL base, List result) throws MalformedURLException {
        String[] locations = this.getArrayFromList(this.devClassPath);
        int i = 0;
        while (i < locations.length) {
            String location = locations[i];
            char lastChar = location.charAt(location.length() - 1);
            URL url = location.endsWith(".jar") || lastChar == '/' || lastChar == '\\' ? new URL(base, location) : new URL(base, String.valueOf(location) + "/");
            this.addEntry(url, result);
            ++i;
        }
    }

    private URL[] getBootPath(String base) throws IOException {
        URL url = null;
        if (base != null) {
            url = Main.buildURL(base, true);
        } else {
            url = this.getInstallLocation();
            String path = new File(url.getFile(), "plugins").toString();
            if ((path = this.searchFor(this.framework, path)) == null) {
                throw new RuntimeException("Could not find framework");
            }
            url = url.getProtocol().equals("file") ? new File(path).toURL() : new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        if (System.getProperty(PROP_FRAMEWORK) == null) {
            System.getProperties().put(PROP_FRAMEWORK, url.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + url.toExternalForm());
        }
        URL[] result = this.getDevPath(url);
        if (this.debug) {
            System.out.println("Framework classpath:");
            int i = 0;
            while (i < result.length) {
                System.out.println("    " + result[i].toExternalForm());
                ++i;
            }
        }
        return result;
    }

    private String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.isDirectory() && (candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_"));
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i].getName();
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = candidates[i].getAbsolutePath();
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = candidates[i].getAbsolutePath();
                maxVersion = currentVersion;
            }
            ++i;
        }
        if (result == null) {
            return null;
        }
        return String.valueOf(result.replace(File.separatorChar, '/')) + "/";
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith(FILE_SCHEME);
        try {
            if (isFile) {
                return Main.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return Main.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    /*
     * Exception decompiling
     */
    private URL buildLocation(String property, URL defaultLocation, String userDefaultAppendage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 186->189)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return String.valueOf(value) + source.substring(var.length());
    }

    private String computeDefaultConfigurationLocation() {
        File installDir;
        URL install = this.getInstallLocation();
        if (install.getProtocol().equals("file") && (installDir = new File(install.getFile())).canWrite()) {
            return String.valueOf(installDir.getAbsolutePath()) + File.separator + CONFIG_DIR;
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private String computeDefaultUserAreaLocation(String pathAppendage) {
        URL installURL = this.getInstallLocation();
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getFile());
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion;
            }
            catch (IOException iOException) {}
        }
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, String.valueOf(appName) + "/" + pathAppendage).getAbsolutePath();
    }

    public static void main(String argString) {
        Vector<Object> list = new Vector<Object>(5);
        StringTokenizer tokens = new StringTokenizer(argString, " ");
        while (tokens.hasMoreElements()) {
            list.addElement(tokens.nextElement());
        }
        Main.main(list.toArray(new String[list.size()]));
    }

    public static void main(String[] args) {
        int result = new Main().run(args);
        System.exit(result);
    }

    public int run(String[] args) {
        int result = 0;
        try {
            this.basicRun(args);
            String exitCode = System.getProperty(PROP_EXITCODE);
            try {
                result = exitCode == null ? 0 : Integer.parseInt(exitCode);
            }
            catch (NumberFormatException numberFormatException) {
                result = 17;
            }
        }
        catch (Throwable e) {
            this.takeDownSplash();
            if (!"13".equals(System.getProperty(PROP_EXITCODE))) {
                this.log("Exception launching the Eclipse Platform:");
                this.log(e);
                String message = "An error has occurred";
                message = this.logFile == null ? String.valueOf(message) + " and could not be logged: \n" + e.getMessage() : String.valueOf(message) + ".  See the log file\n" + this.logFile.getAbsolutePath();
                System.getProperties().put(PROP_EXITDATA, message);
            }
            result = 13;
        }
        System.getProperties().put(PROP_EXITCODE, Integer.toString(result));
        this.setExitData();
        return result;
    }

    private void setExitData() {
        String data = System.getProperty(PROP_EXITDATA);
        if (this.exitData == null || data == null) {
            return;
        }
        this.runCommand(true, this.exitData, data, " -exitdata");
    }

    protected String[] processCommandLine(String[] args) {
        if (args.length == 0) {
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else {
                if (args[i].equalsIgnoreCase(NOSPLASH)) {
                    this.splashDown = true;
                    found = true;
                }
                if (args[i].equalsIgnoreCase(INITIALIZE)) {
                    this.initialize = true;
                } else if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                    this.inDevelopmentMode = true;
                } else if (found) {
                    configArgs[configArgIndex++] = i;
                } else if (args[i].equalsIgnoreCase(VMARGS)) {
                    args[i] = null;
                    this.vmargs = new String[args.length - ++i];
                    int j = 0;
                    while (i < args.length) {
                        this.vmargs[j++] = args[i];
                        args[i] = null;
                        ++i;
                    }
                } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                    String arg = args[++i];
                    if (args[i - 1].equalsIgnoreCase(DEV)) {
                        this.inDevelopmentMode = true;
                        this.devClassPath = this.processDevArg(arg);
                    } else {
                        if (args[i - 1].equalsIgnoreCase(FRAMEWORK)) {
                            this.framework = arg;
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(INSTALL)) {
                            System.getProperties().put(PROP_INSTALL_AREA, arg);
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                            System.getProperties().put(PROP_CONFIG_AREA, arg);
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(EXITDATA)) {
                            this.exitData = arg;
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(SHOWSPLASH)) {
                            this.showSplash = arg;
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(ENDSPLASH)) {
                            this.endSplash = arg;
                            found = true;
                        }
                        if (args[i - 1].equalsIgnoreCase(VM)) {
                            this.vm = arg;
                            found = true;
                        }
                        if (found) {
                            configArgs[configArgIndex++] = i - 1;
                            configArgs[configArgIndex++] = i;
                        }
                    }
                }
            }
            ++i;
        }
        String[] passThruArgs = new String[args.length - configArgIndex - (this.vmargs == null ? 0 : this.vmargs.length + 1)];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else if (args[i2] != null) {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    private String processDevArg(String arg) {
        if (arg == null) {
            return null;
        }
        try {
            URL location = new URL(arg);
            Properties props = this.load(location, null);
            String result = props.getProperty(OSGI);
            return result == null ? props.getProperty("*") : result;
        }
        catch (MalformedURLException malformedURLException) {
            return arg;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA, null, "");
        if (this.configurationLocation == null) {
            this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "");
            if (this.configurationLocation == null) {
                this.configurationLocation = Main.buildURL(this.computeDefaultConfigurationLocation(), true);
            }
        }
        if (this.configurationLocation != null) {
            System.getProperties().put(PROP_CONFIG_AREA, this.configurationLocation.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Configuration location:\n    " + this.configurationLocation);
        }
        return this.configurationLocation;
    }

    private void processConfiguration() {
        Properties configuration;
        URL baseConfigurationLocation = null;
        Properties baseConfiguration = null;
        if (System.getProperty(PROP_CONFIG_AREA) == null) {
            String baseLocation = System.getProperty(PROP_BASE_CONFIG_AREA);
            if (baseLocation != null) {
                baseConfigurationLocation = Main.buildURL(baseLocation, true);
            }
            if (baseConfigurationLocation == null) {
                try {
                    baseConfigurationLocation = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((baseConfiguration = this.loadConfiguration(baseConfigurationLocation)) != null) {
                String location = baseConfiguration.getProperty(PROP_CONFIG_AREA);
                if (location != null) {
                    System.getProperties().put(PROP_CONFIG_AREA, location);
                }
                if ((location = baseConfiguration.getProperty(PROP_INSTALL_AREA)) != null && System.getProperty(PROP_INSTALL_AREA) == null) {
                    System.getProperties().put(PROP_INSTALL_AREA, location);
                }
            }
        }
        if ((configuration = baseConfiguration) == null || !this.getConfigurationLocation().equals(baseConfigurationLocation.toExternalForm())) {
            configuration = this.loadConfiguration(this.getConfigurationLocation());
        }
        this.mergeProperties(System.getProperties(), configuration);
        if ("false".equalsIgnoreCase(System.getProperty(PROP_CONFIG_CASCADED))) {
            System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
        } else {
            URL sharedConfigURL = this.buildLocation(PROP_SHARED_CONFIG_AREA, null, "");
            if (sharedConfigURL == null) {
                try {
                    sharedConfigURL = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (sharedConfigURL != null) {
                if (sharedConfigURL.equals(this.getConfigurationLocation())) {
                    System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
                } else {
                    configuration = baseConfiguration;
                    if (!sharedConfigURL.equals(baseConfigurationLocation)) {
                        configuration = this.loadConfiguration(sharedConfigURL);
                    }
                    this.mergeProperties(System.getProperties(), configuration);
                    System.getProperties().put(PROP_SHARED_CONFIG_AREA, sharedConfigURL.toExternalForm());
                    if (this.debug) {
                        System.out.println("Shared configuration location:\n    " + sharedConfigURL.toExternalForm());
                    }
                }
            }
        }
        String urlString = System.getProperty(PROP_FRAMEWORK, null);
        if (urlString != null) {
            URL url = Main.buildURL(urlString, true);
            System.getProperties().put(PROP_FRAMEWORK, url.toExternalForm());
            this.bootLocation = this.resolve(urlString);
        }
    }

    private URL getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        String installArea = System.getProperty(PROP_INSTALL_AREA);
        if (installArea != null) {
            this.installLocation = Main.buildURL(installArea, true);
            if (this.installLocation == null) {
                throw new IllegalStateException("Install location is invalid: " + installArea);
            }
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
            if (this.debug) {
                System.out.println("Install location:\n    " + this.installLocation);
            }
            return this.installLocation;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.core.launcher.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL result = clazz.getProtectionDomain().getCodeSource().getLocation();
        String path = this.decode(result.getFile());
        File file = new File(path);
        path = file.toString().replace('\\', '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(path.charAt(0))) {
            char[] chars = path.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            path = new String(chars);
        }
        if (path.endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        try {
            try {
                path = new File(path).toURL().getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            this.installLocation = new URL(result.getProtocol(), result.getHost(), result.getPort(), path);
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        if (this.debug) {
            System.out.println("Install location:\n    " + this.installLocation);
        }
        return this.installLocation;
    }

    private Properties loadConfiguration(URL url) {
        Properties result;
        block6: {
            result = null;
            try {
                url = new URL(url, CONFIG_FILE);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                if (this.debug) {
                    System.out.print("Configuration file:\n    " + url.toString());
                }
                result = this.loadProperties(url);
                if (this.debug) {
                    System.out.println(" loaded");
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break block6;
                System.out.println(" not found or not read");
            }
        }
        return result;
    }

    private Properties loadProperties(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        Properties result = null;
        IOException originalException = null;
        try {
            result = this.load(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                result = this.load(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException) {
                try {
                    result = this.load(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException2) {
                    throw originalException;
                }
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private Properties load(URL url, String suffix) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 107->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleSplash(URL[] defaultPath) {
        if (this.initialize || this.splashDown) {
            this.showSplash = null;
            this.endSplash = null;
            return;
        }
        if (this.endSplash != null) {
            this.showSplash = null;
            return;
        }
        if (this.showSplash == null) {
            return;
        }
        String location = this.getSplashLocation(defaultPath);
        if (this.debug) {
            System.out.println("Splash location:\n    " + location);
        }
        if (location == null) {
            return;
        }
        this.showProcess = this.runCommand(false, this.showSplash, location, " -showsplash");
    }

    private Process runCommand(boolean block, String command, String data, String separator) {
        String[] args = new String[data != null ? 4 : 3];
        int sIndex = 0;
        int eIndex = command.indexOf(separator);
        if (eIndex == -1) {
            return null;
        }
        args[0] = command.substring(sIndex, eIndex);
        sIndex = eIndex + 1;
        if ((eIndex = command.indexOf(" ", sIndex)) == -1) {
            return null;
        }
        args[1] = command.substring(sIndex, eIndex);
        args[2] = command.substring(eIndex + 1);
        if (data != null) {
            args[3] = data;
        }
        Process result = null;
        try {
            result = Runtime.getRuntime().exec(args);
            if (block) {
                result.waitFor();
            }
        }
        catch (Exception e) {
            this.log("Exception running command: " + command);
            this.log(e);
        }
        return result;
    }

    protected void takeDownSplash() {
        if (this.splashDown) {
            return;
        }
        if (this.endSplash != null) {
            try {
                Runtime.getRuntime().exec(this.endSplash);
            }
            catch (Exception exception) {}
        }
        if (this.showProcess != null) {
            this.showProcess.destroy();
            this.showProcess = null;
        }
        this.splashDown = true;
    }

    private String getSplashLocation(URL[] bootPath) {
        int pix;
        String result = System.getProperty(PROP_SPLASHLOCATION);
        if (result != null) {
            return result;
        }
        String splashPath = System.getProperty(PROP_SPLASHPATH);
        if (splashPath != null) {
            String[] entries = this.getArrayFromList(splashPath);
            ArrayList<String> path = new ArrayList<String>(entries.length);
            int i = 0;
            while (i < entries.length) {
                String entry = this.resolve(entries[i]);
                if (entry == null || entry.startsWith(FILE_SCHEME)) {
                    File entryFile = new File(entry.substring(5).replace('/', File.separatorChar));
                    if ((entry = this.searchFor(entryFile.getName(), entryFile.getParent())) != null) {
                        path.add(entry);
                    }
                } else {
                    this.log("Invalid splash path entry: " + entries[i]);
                }
                ++i;
            }
            result = this.searchForSplash(path.toArray(new String[path.size()]));
            if (result != null) {
                System.getProperties().put(PROP_SPLASHLOCATION, result);
                return result;
            }
        }
        String temp = bootPath[0].getFile();
        int ix = (temp = temp.replace('/', File.separatorChar)).lastIndexOf("plugins" + File.separator);
        if (ix != -1 && (pix = temp.indexOf(File.separator, ix + 8)) != -1 && (result = this.searchForSplash(new String[]{temp = temp.substring(0, pix)})) != null) {
            System.getProperties().put(PROP_SPLASHLOCATION, result);
        }
        return result;
    }

    private String searchForSplash(String[] searchPath) {
        if (searchPath == null) {
            return null;
        }
        String localePath = Locale.getDefault().toString().replace('_', File.separatorChar);
        while (localePath != null) {
            int ix;
            String suffix = localePath.equals("") ? SPLASH_IMAGE : "nl" + File.separator + localePath + File.separator + SPLASH_IMAGE;
            int i = 0;
            while (i < searchPath.length) {
                File result;
                String path = searchPath[i];
                if (!path.endsWith(File.separator)) {
                    path = String.valueOf(path) + File.separator;
                }
                if ((result = new File(path = String.valueOf(path) + suffix)).exists()) {
                    return result.getAbsolutePath();
                }
                ++i;
            }
            localePath = localePath.equals("") ? null : ((ix = localePath.lastIndexOf(File.separator)) == -1 ? "" : localePath.substring(0, ix));
        }
        return null;
    }

    private String resolve(String urlString) {
        if (urlString.startsWith("reference:")) {
            urlString = urlString.substring(10);
            System.getProperties().put(PROP_FRAMEWORK, urlString);
        }
        if (urlString.startsWith(PLATFORM_URL)) {
            String path = urlString.substring(PLATFORM_URL.length());
            return this.getInstallLocation() + path;
        }
        return urlString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void log(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            block16: {
                try {
                    block15: {
                        this.openLogFile();
                        try {
                            if (this.newSession) {
                                this.log.write(SESSION);
                                this.log.write(32);
                                String timestamp = new Date().toString();
                                this.log.write(timestamp);
                                this.log.write(32);
                                int i = SESSION.length() + timestamp.length();
                                while (true) {
                                    if (i >= 78) {
                                        this.log.newLine();
                                        this.newSession = false;
                                        break;
                                    }
                                    this.log.write(45);
                                    ++i;
                                }
                            }
                            this.write(obj);
                            Object var4_8 = null;
                            if (this.logFile != null) break block15;
                            if (this.log == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            if (this.logFile == null) {
                                if (this.log == null) throw throwable;
                                this.log.flush();
                                throw throwable;
                            }
                            this.closeLogFile();
                            throw throwable;
                        }
                        this.log.flush();
                        break block16;
                    }
                    this.closeLogFile();
                }
                catch (Exception e) {
                    System.err.println("An exception occurred while writing to the platform log:");
                    e.printStackTrace(System.err);
                    System.err.println("Logging to the console instead.");
                    try {
                        this.log = this.logForStream(System.err);
                        this.write(obj);
                        this.log.flush();
                    }
                    catch (Exception e2) {
                        System.err.println("An exception occurred while logging to the console:");
                        e2.printStackTrace(System.err);
                    }
                }
            }
            Object var6_11 = null;
            this.log = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.log = null;
            throw throwable;
        }
    }

    private void write(Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Throwable) {
            this.log.write(STACK);
            this.log.newLine();
            ((Throwable)obj).printStackTrace(new PrintWriter(this.log));
        } else {
            this.log.write(ENTRY);
            this.log.write(32);
            this.log.write(PLUGIN_ID);
            this.log.write(32);
            this.log.write(String.valueOf(4));
            this.log.write(32);
            this.log.write(String.valueOf(0));
            this.log.write(32);
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
                this.log.write(formatter.format(new Date()));
            }
            catch (Exception exception) {
                this.log.write(Long.toString(System.currentTimeMillis()));
            }
            this.log.newLine();
            this.log.write(MESSAGE);
            this.log.write(32);
            this.log.write(String.valueOf(obj));
        }
        this.log.newLine();
    }

    private void computeLogFileLocation() {
        String logFileProp = System.getProperty(PROP_LOGFILE);
        if (logFileProp != null) {
            if (this.logFile == null || !logFileProp.equals(this.logFile.getAbsolutePath())) {
                this.logFile = new File(logFileProp);
                this.logFile.getParentFile().mkdirs();
            }
            return;
        }
        URL base = Main.buildURL(System.getProperty(PROP_CONFIG_AREA), false);
        if (base == null) {
            return;
        }
        this.logFile = new File(base.getPath(), String.valueOf(Long.toString(System.currentTimeMillis())) + ".log");
        this.logFile.getParentFile().mkdirs();
        System.setProperty(PROP_LOGFILE, this.logFile.getAbsolutePath());
    }

    private int hexToByte(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    private void openLogFile() throws IOException {
        this.computeLogFileLocation();
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException e) {
            this.logFile = null;
            throw e;
        }
    }

    private BufferedWriter logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.log = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.log = null;
            return;
        }
    }

    private void mergeProperties(Properties destination, Properties source) {
        if (destination == null || source == null) {
            return;
        }
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals(PROP_EOF)) continue;
            String value = source.getProperty(key);
            if (destination.getProperty(key) != null) continue;
            destination.put(key, value);
        }
    }

    private void setupVMProperties() {
        if (this.vm != null) {
            System.getProperties().put(PROP_VM, this.vm);
        }
        this.setMultiValueProperty(PROP_VMARGS, this.vmargs);
        this.setMultiValueProperty(PROP_COMMANDS, this.commands);
    }

    private void setMultiValueProperty(String property, String[] value) {
        if (value != null) {
            StringBuffer result = new StringBuffer(300);
            int i = 0;
            while (i < value.length) {
                if (value[i] != null) {
                    result.append(value[i]);
                    result.append('\n');
                }
                ++i;
            }
            System.getProperties().put(property, result.toString());
        }
    }
}

