/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech.multi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.speech.AudioUtils;
import org.jpn.xucker.speech.multi.MultiTypeText;
import org.jpn.xucker.speech.multi.MultiTypeTextPlayer;
import org.jpn.xucker.speech.multi.MultiTypeTextSpeechListener;
import org.jpn.xucker.speech.multi.MultiTypeTextSplitter;

public class MultiTypeTextSpeech {
    public static Log log;
    List playerList = new ArrayList();
    private MultiTypeTextSplitter spliter;
    boolean playing;
    boolean stopping;
    MultiTypeTextPlayer currentPlayer;
    List listenerList = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.speech.multi.MultiTypeTextSpeech");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void addPlayer(MultiTypeTextPlayer player) {
        this.playerList.add(player);
    }

    public void removePlayer(MultiTypeTextPlayer player) {
        this.playerList.remove(player);
    }

    public MultiTypeTextPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(MultiTypeTextPlayer currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public MultiTypeTextSplitter getSpliter() {
        return this.spliter;
    }

    public void setSpliter(MultiTypeTextSplitter spliter) {
        this.spliter = spliter;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    public void addMultiTypeSpeechListener(MultiTypeTextSpeechListener listener) {
        this.listenerList.add(listener);
    }

    public void removeMultiTypeSpeechListener(MultiTypeTextSpeechListener listener) {
        this.listenerList.remove(listener);
    }

    public void play(String text) {
        if (!this.playing) {
            Play play = new Play(text);
            play.start();
        }
    }

    public void write(File file, String text) throws IOException {
        if (!this.playing) {
            Write write = new Write(file, text);
            write.start();
        }
    }

    public void cancel() {
        this.stopping = true;
        if (this.currentPlayer != null) {
            this.currentPlayer.cancel();
        }
        this.playing = false;
    }

    public void fireCancel() {
        MultiTypeTextSpeechListener[] listener;
        MultiTypeTextSpeech multiTypeTextSpeech = this;
        synchronized (multiTypeTextSpeech) {
            listener = this.listenerList.toArray(new MultiTypeTextSpeechListener[this.listenerList.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            listener[i].cancel();
            ++i;
        }
    }

    public void fireStart() {
        MultiTypeTextSpeechListener[] listener;
        MultiTypeTextSpeech multiTypeTextSpeech = this;
        synchronized (multiTypeTextSpeech) {
            listener = this.listenerList.toArray(new MultiTypeTextSpeechListener[this.listenerList.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            listener[i].playStart();
            ++i;
        }
    }

    public void fireFinish() {
        MultiTypeTextSpeechListener[] listener;
        MultiTypeTextSpeech multiTypeTextSpeech = this;
        synchronized (multiTypeTextSpeech) {
            listener = this.listenerList.toArray(new MultiTypeTextSpeechListener[this.listenerList.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            listener[i].playFinish();
            ++i;
        }
    }

    public class Play
    extends Thread {
        private String text;

        public Play(String text) {
            this.text = text;
        }

        public void run() {
            log.trace((Object)("play:" + this.text));
            MultiTypeTextSpeech.this.stopping = false;
            MultiTypeTextSpeech.this.playing = true;
            MultiTypeTextSpeech.this.fireStart();
            MultiTypeText[] texts = MultiTypeTextSpeech.this.spliter.split(this.text);
            MultiTypeTextPlayer[] players = MultiTypeTextSpeech.this.playerList.toArray(new MultiTypeTextPlayer[MultiTypeTextSpeech.this.playerList.size()]);
            int i = 0;
            while (i < texts.length) {
                if (MultiTypeTextSpeech.this.stopping) {
                    MultiTypeTextSpeech.this.fireCancel();
                    return;
                }
                int j = 0;
                while (j < players.length) {
                    if (players[j].available(texts[i])) {
                        MultiTypeTextSpeech.this.currentPlayer = players[j];
                        players[j].play(texts[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            MultiTypeTextSpeech.this.playing = false;
            MultiTypeTextSpeech.this.fireFinish();
        }
    }

    public class Write
    extends Thread {
        private String text;
        private File file;

        public Write(File file, String text) {
            this.text = text;
            this.file = file;
        }

        public void run() {
            log.trace((Object)("file:" + this.file.getAbsolutePath()));
            MultiTypeTextSpeech.this.stopping = false;
            MultiTypeTextSpeech.this.playing = true;
            MultiTypeTextSpeech.this.fireStart();
            MultiTypeText[] texts = MultiTypeTextSpeech.this.spliter.split(this.text);
            MultiTypeTextPlayer[] players = MultiTypeTextSpeech.this.playerList.toArray(new MultiTypeTextPlayer[MultiTypeTextSpeech.this.playerList.size()]);
            ArrayList<File> writeFileList = new ArrayList<File>();
            int i = 0;
            while (i < texts.length) {
                if (MultiTypeTextSpeech.this.stopping) {
                    MultiTypeTextSpeech.this.fireCancel();
                    File[] files = writeFileList.toArray(new File[writeFileList.size()]);
                    int j = 0;
                    while (j < files.length) {
                        files[j].delete();
                        ++j;
                    }
                }
                int j = 0;
                while (j < players.length) {
                    if (players[j].available(texts[i])) {
                        MultiTypeTextSpeech.this.currentPlayer = players[j];
                        try {
                            File tmpFile = File.createTempFile("speech", ".wav");
                            players[j].write(texts[i], tmpFile);
                            writeFileList.add(tmpFile);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            MultiTypeTextSpeech.this.playing = false;
            MultiTypeTextSpeech.this.fireFinish();
            File[] files = writeFileList.toArray(new File[writeFileList.size()]);
            try {
                AudioUtils.mixFile(this.file, files, AudioFileFormat.Type.WAVE);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

