/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.FlushableExtension;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class RegistryCacheReader {
    MultiStatus problems = null;
    protected List objectTable = null;
    private boolean lazilyLoadExtensions;
    private boolean flushableExtensions = true;
    private boolean failed;
    protected File cacheFile;
    public static final byte REGISTRY_CACHE_VERSION = 7;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;

    public RegistryCacheReader(File cacheFile, MultiStatus problems, boolean lazilyLoadExtensions, boolean flushable) {
        this.cacheFile = cacheFile;
        this.problems = problems;
        this.lazilyLoadExtensions = lazilyLoadExtensions;
        this.flushableExtensions = flushable;
        this.objectTable = new ArrayList();
    }

    public RegistryCacheReader(File cacheFile, MultiStatus problems) {
        this(cacheFile, problems, false, true);
    }

    private int addToObjectTable(Object object) {
        this.objectTable.add(object);
        return this.objectTable.size() - 1;
    }

    private void debug(String msg) {
        System.out.println("RegistryCacheReader: " + msg);
    }

    private boolean readHeaderInformation(DataInputStream in, long expectedTimestamp) throws InvalidRegistryCacheException {
        try {
            if (in.readInt() != 7) {
                return false;
            }
            long installStamp = in.readLong();
            long registryStamp = in.readLong();
            String osStamp = in.readUTF();
            String windowsStamp = in.readUTF();
            String localeStamp = in.readUTF();
            InternalPlatform info = InternalPlatform.getDefault();
            return (expectedTimestamp == 0L || expectedTimestamp == registryStamp) && installStamp == info.getStateTimeStamp() && osStamp.equals(info.getOS()) && windowsStamp.equals(info.getWS()) && localeStamp.equals(info.getNL());
        }
        catch (IOException e) {
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "HeaderInformation"), e);
        }
    }

    private void skipConfigurationElement(RegistryModelObject parent, DataInputStream in) throws IOException {
        this.readCachedString(in, false);
        this.skipString(in);
        int length = in.readInt();
        int i = 0;
        while (i < length) {
            this.skipConfigurationProperty(in);
            ++i;
        }
        length = in.readInt();
        i = 0;
        while (i < length) {
            this.skipConfigurationElement(null, in);
            ++i;
        }
    }

    private ConfigurationElement readConfigurationElement(RegistryModelObject parent, DataInputStream in) throws IOException {
        ConfigurationElement result = new ConfigurationElement();
        result.setParent(parent);
        result.setName(this.readCachedString(in, false));
        result.setValue(this.readString(in, false));
        int length = in.readInt();
        ConfigurationProperty[] properties = new ConfigurationProperty[length];
        int i = 0;
        while (i < length) {
            properties[i] = this.readConfigurationProperty(in);
            ++i;
        }
        result.setProperties(properties);
        length = in.readInt();
        IConfigurationElement[] elements = new ConfigurationElement[length];
        int i2 = 0;
        while (i2 < length) {
            elements[i2] = this.readConfigurationElement(result, in);
            ++i2;
        }
        result.setChildren(elements);
        return result;
    }

    private void skipConfigurationProperty(DataInputStream in) throws IOException {
        this.readCachedString(in, false);
        this.skipString(in);
    }

    private ConfigurationProperty readConfigurationProperty(DataInputStream in) throws IOException {
        String name = this.readCachedString(in, false);
        ConfigurationProperty result = new ConfigurationProperty();
        result.setName(name);
        result.setValue(this.readString(in, false));
        return result;
    }

    private Extension readExtension(DataInputStream in) throws InvalidRegistryCacheException {
        Extension result = null;
        try {
            result = (Extension)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.flushableExtensions ? new FlushableExtension() : new Extension();
            this.addToObjectTable(result);
            result.setSimpleIdentifier(this.readString(in, false));
            result.setParent(this.readBundleModel(in));
            result.setName(this.readString(in, false));
            result.setExtensionPointIdentifier(this.readCachedString(in, false));
            result.setSubElements(this.readSubElements(result, in));
            return result;
        }
        catch (IOException e) {
            String extensionId = null;
            if (result != null && result.getParent() != null) {
                extensionId = String.valueOf(result.getParentIdentifier()) + "." + result.getSimpleIdentifier();
            }
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "extension:  " + extensionId), e);
        }
    }

    private ExtensionPoint readExtensionPoint(Namespace bundle, DataInputStream in) throws InvalidRegistryCacheException {
        ExtensionPoint result = null;
        try {
            result = (ExtensionPoint)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = new ExtensionPoint();
            this.addToObjectTable(result);
            result.setParent(bundle);
            result.setSimpleIdentifier(this.readString(in, true));
            result.setName(this.readString(in, false));
            result.setSchema(this.readString(in, false));
            int length = in.readInt();
            IExtension[] extensions = new Extension[length];
            int i = 0;
            while (i < length) {
                extensions[i] = this.readExtension(in);
                ++i;
            }
            result.setExtensions(extensions);
            return result;
        }
        catch (IOException e) {
            String extensionPointId = null;
            if (result != null && result.getParent() != null) {
                extensionPointId = result.getUniqueIdentifier();
            }
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "extension point: " + extensionPointId), e);
        }
    }

    private Namespace readBundleModel(DataInputStream in) throws InvalidRegistryCacheException {
        Namespace result = null;
        try {
            result = (Namespace)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = new Namespace();
            this.addToObjectTable(result);
            result.setUniqueIdentifier(this.readCachedString(in, true));
            result.setBundle(InternalPlatform.getDefault().getBundleContext().getBundle(in.readLong()));
            result.setParent(this.readRegistry(in));
            result.setHostIdentifier(this.readCachedString(in, false));
            int length = in.readInt();
            IExtensionPoint[] extensionPoints = new ExtensionPoint[length];
            int i = 0;
            while (i < length) {
                extensionPoints[i] = this.readExtensionPoint(result, in);
                ++i;
            }
            result.setExtensionPoints(extensionPoints);
            length = in.readInt();
            IExtension[] extensions = this.flushableExtensions ? new FlushableExtension[length] : new Extension[length];
            int i2 = 0;
            while (i2 < length) {
                extensions[i2] = this.readExtension(in);
                ++i2;
            }
            result.setExtensions(extensions);
            return result;
        }
        catch (IOException e) {
            String bundleId = result == null || result.getUniqueIdentifier() == null ? "<not available>" : result.getUniqueIdentifier();
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "plugin: " + bundleId), e);
        }
    }

    private ExtensionRegistry readCache(DataInputStream in, long expectedTimestamps) throws InvalidRegistryCacheException {
        if (!this.readHeaderInformation(in, expectedTimestamps)) {
            if (InternalPlatform.DEBUG_REGISTRY) {
                this.debug("Cache header information out of date - ignoring cache");
            }
            return null;
        }
        return this.readRegistry(in);
    }

    private ExtensionRegistry readRegistry(DataInputStream in) throws InvalidRegistryCacheException {
        try {
            ExtensionRegistry result = (ExtensionRegistry)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = new ExtensionRegistry();
            if (this.lazilyLoadExtensions) {
                result.setCacheReader(this);
            }
            this.addToObjectTable(result);
            int length = in.readInt();
            if (length == 0) {
                return null;
            }
            int i = 0;
            while (i < length) {
                result.basicAdd(this.readBundleModel(in), false);
                ++i;
            }
            if (this.lazilyLoadExtensions) {
                result.setCacheReader(this);
            }
            return result;
        }
        catch (IOException e) {
            throw new InvalidRegistryCacheException(Policy.bind("meta.regCacheIOExceptionReading", "ExtensionRegistry"), e);
        }
    }

    private ConfigurationElement[] readSubElements(Extension parent, DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        int offset = in.readInt();
        if (this.lazilyLoadExtensions) {
            Extension extension = parent;
            extension.setSubElementsCacheOffset(offset);
            this.skipBasicSubElements(parent, in);
            extension.setFullyLoaded(false);
            return null;
        }
        return this.readBasicSubElements(parent, in);
    }

    private void skipBasicSubElements(Extension parent, DataInputStream in) throws IOException {
        int length = in.readInt();
        int i = 0;
        while (i < length) {
            this.skipConfigurationElement(parent, in);
            ++i;
        }
    }

    private ConfigurationElement[] readBasicSubElements(Extension parent, DataInputStream in) throws IOException {
        int length = in.readInt();
        ConfigurationElement[] result = new ConfigurationElement[length];
        int i = 0;
        while (i < length) {
            result[i] = this.readConfigurationElement(parent, in);
            ++i;
        }
        return result;
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    private void skipString(DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return;
        }
        int utfLength = in.readUnsignedShort();
        byte[] bytearr = new byte[utfLength];
        in.readFully(bytearr, 0, utfLength);
    }

    private String readCachedString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 2) {
            return (String)this.objectTable.get(in.readInt());
        }
        String stringRead = null;
        stringRead = intern ? in.readUTF().intern() : in.readUTF();
        this.addToObjectTable(stringRead);
        return stringRead;
    }

    private Object readIndex(DataInputStream in) throws IOException {
        byte type = in.readByte();
        return type == 2 ? this.objectTable.get(in.readInt()) : null;
    }

    private DataInputStream openCacheFile() throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile), 2048));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ConfigurationElement[] loadConfigurationElements(Extension parent, int offset) {
        DataInputStream in;
        block13: {
            ConfigurationElement[] configurationElementArray;
            in = null;
            try {
                try {
                    in = this.openCacheFile();
                    in.skipBytes(offset);
                    in.readInt();
                    configurationElementArray = this.readBasicSubElements(parent, in);
                    Object var7_5 = null;
                }
                catch (IOException e) {
                    IOException exception = InternalPlatform.DEBUG_REGISTRY ? e : null;
                    String message = Policy.bind("meta.unableToReadCache");
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
                    break block13;
                }
                catch (OutOfMemoryError oome) {
                    this.logError(oome);
                    break block13;
                }
                catch (RuntimeException re) {
                    this.logError(re);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (in == null) return configurationElementArray;
            in.close();
            return configurationElementArray;
        }
        Object var7_7 = null;
        try {}
        catch (IOException iOException) {}
        if (in != null) {
            in.close();
        }
        this.failed = true;
        return new ConfigurationElement[0];
    }

    boolean hasFailed() {
        return this.failed;
    }

    private void logError(Throwable t) {
        String message = Policy.bind("meta.registryCacheReadProblems");
        InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, null));
        Throwable exceptionToLog = InternalPlatform.DEBUG_REGISTRY ? t : null;
        InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, t.toString(), exceptionToLog));
    }

    public final ExtensionRegistry loadCache() {
        return this.loadCache(0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ExtensionRegistry loadCache(long expectedTimestamp) {
        DataInputStream in;
        block14: {
            ExtensionRegistry extensionRegistry;
            in = null;
            try {
                in = this.openCacheFile();
            }
            catch (IOException e) {
                IOException exception = InternalPlatform.DEBUG_REGISTRY ? e : null;
                String message = Policy.bind("meta.unableToReadCache");
                InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, message, exception));
                return null;
            }
            try {
                try {
                    extensionRegistry = this.readCache(in, expectedTimestamp);
                    Object var6_10 = null;
                }
                catch (InvalidRegistryCacheException e) {
                    Throwable exception = InternalPlatform.DEBUG_REGISTRY ? e.getCause() : null;
                    InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 0, e.getMessage(), exception));
                    break block14;
                }
                catch (OutOfMemoryError oome) {
                    this.logError(oome);
                    break block14;
                }
                catch (RuntimeException re) {
                    this.logError(re);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (in == null) return extensionRegistry;
            in.close();
            return extensionRegistry;
        }
        Object var6_12 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (in == null) return null;
        in.close();
        return null;
    }

    public class InvalidRegistryCacheException
    extends Exception {
        Throwable cause = null;

        public InvalidRegistryCacheException(String msg, Throwable cause) {
            super(msg);
            this.cause = cause;
        }

        public InvalidRegistryCacheException(String string) {
            super(string);
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

