/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaInfo;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceChangeEvent
extends EventObject
implements IResourceChangeEvent {
    int type;
    IResource resource;
    IResourceDelta delta;
    private static final IMarkerDelta[] NO_MARKER_DELTAS = new IMarkerDelta[0];

    protected ResourceChangeEvent(Object source, int type, IResource resource) {
        super(source);
        this.resource = resource;
        this.type = type;
    }

    protected ResourceChangeEvent(Object source, int type, IResourceDelta delta) {
        super(source);
        this.delta = delta;
        this.type = type;
    }

    public IMarkerDelta[] findMarkerDeltas(String type, boolean includeSubtypes) {
        if (this.delta == null) {
            return NO_MARKER_DELTAS;
        }
        ResourceDeltaInfo info = ((ResourceDelta)this.delta).getDeltaInfo();
        if (info == null) {
            return NO_MARKER_DELTAS;
        }
        Map markerDeltas = info.getMarkerDeltas();
        if (markerDeltas == null || markerDeltas.size() == 0) {
            return NO_MARKER_DELTAS;
        }
        ArrayList<MarkerDelta> matching = new ArrayList<MarkerDelta>();
        Iterator deltaSets = markerDeltas.values().iterator();
        while (deltaSets.hasNext()) {
            MarkerSet deltas = (MarkerSet)deltaSets.next();
            IMarkerSetElement[] elements = deltas.elements();
            int i = 0;
            while (i < elements.length) {
                MarkerDelta delta = (MarkerDelta)elements[i];
                if (type == null || (includeSubtypes ? delta.isSubtypeOf(type) : delta.getType().equals(type))) {
                    matching.add(delta);
                }
                ++i;
            }
        }
        return matching.toArray(new IMarkerDelta[matching.size()]);
    }

    public IResourceDelta getDelta() {
        return this.delta;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getType() {
        return this.type;
    }

    public void setDelta(IResourceDelta value) {
        this.delta = value;
    }
}

