/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
package org.apache.jetspeed.util;

import org.apache.ecs.Filter;

import java.io.Serializable;

/**
A filter for ECS that doesn't do anything.

*/

public class JetspeedNullFilter implements Filter, Serializable 
{
    
    public Filter addAttribute(String name, Object attribute) {
        return this;
    }
    
    public Filter removeAttribute(String name) {
        return this;
    }
    
    public boolean hasAttribute(String name) {
        return false;
    }
    
    public String process(String to_process) {
        return to_process;
    }
    
    public String getInfo() {
        return "info";
    }
    
}

