package org.apache.jetspeed.om.apps.coffees;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;


/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Coffees
 */
public abstract class BaseCoffees extends BaseObject
{
    /** The Peer class */
    private static final CoffeesPeer peer =
        new CoffeesPeer();

      
    /** The value for the coffeeId field */
    private int coffeeId;
      
    /** The value for the coffeeName field */
    private String coffeeName;
      
    /** The value for the supplierId field */
    private int supplierId;
      
    /** The value for the price field */
    private double price;
      
    /** The value for the sales field */
    private int sales;
      
    /** The value for the total field */
    private int total;
  
  
    /**
     * Get the CoffeeId
     * @return int
     */
    public int getCoffeeId()
    {
        return coffeeId;
    }

                        
    /**
     * Set the value of CoffeeId
     */
    public void setCoffeeId(int v ) 
    {
    
                  if (this.coffeeId != v)
              {
            this.coffeeId = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the CoffeeName
     * @return String
     */
    public String getCoffeeName()
    {
        return coffeeName;
    }

                        
    /**
     * Set the value of CoffeeName
     */
    public void setCoffeeName(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.coffeeName, v))
              {
            this.coffeeName = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the SupplierId
     * @return int
     */
    public int getSupplierId()
    {
        return supplierId;
    }

                        
    /**
     * Set the value of SupplierId
     */
    public void setSupplierId(int v ) 
    {
    
                  if (this.supplierId != v)
              {
            this.supplierId = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Price
     * @return double
     */
    public double getPrice()
    {
        return price;
    }

                        
    /**
     * Set the value of Price
     */
    public void setPrice(double v ) 
    {
    
                  if (this.price != v)
              {
            this.price = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Sales
     * @return int
     */
    public int getSales()
    {
        return sales;
    }

                        
    /**
     * Set the value of Sales
     */
    public void setSales(int v ) 
    {
    
                  if (this.sales != v)
              {
            this.sales = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Total
     * @return int
     */
    public int getTotal()
    {
        return total;
    }

                        
    /**
     * Set the value of Total
     */
    public void setTotal(int v ) 
    {
    
                  if (this.total != v)
              {
            this.total = v;
            setModified(true);
        }
    
          
              }

  
         
                
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList();
              fieldNames.add("CoffeeId");
              fieldNames.add("CoffeeName");
              fieldNames.add("SupplierId");
              fieldNames.add("Price");
              fieldNames.add("Sales");
              fieldNames.add("Total");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
          if (name.equals("CoffeeId"))
        {
                return new Integer(getCoffeeId());
            }
          if (name.equals("CoffeeName"))
        {
                return getCoffeeName();
            }
          if (name.equals("SupplierId"))
        {
                return new Integer(getSupplierId());
            }
          if (name.equals("Price"))
        {
                return new Double(getPrice());
            }
          if (name.equals("Sales"))
        {
                return new Integer(getSales());
            }
          if (name.equals("Total"))
        {
                return new Integer(getTotal());
            }
          return null;
    }
    
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(CoffeesPeer.COFFEE_ID ))
        {
                return new Integer(getCoffeeId());
            }
          if (name.equals(CoffeesPeer.COFFEE_NAME ))
        {
                return getCoffeeName();
            }
          if (name.equals(CoffeesPeer.SUPPLIER_ID ))
        {
                return new Integer(getSupplierId());
            }
          if (name.equals(CoffeesPeer.PRICE ))
        {
                return new Double(getPrice());
            }
          if (name.equals(CoffeesPeer.SALES ))
        {
                return new Integer(getSales());
            }
          if (name.equals(CoffeesPeer.TOTAL ))
        {
                return new Integer(getTotal());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
        {
                return new Integer(getCoffeeId());
            }
              if ( pos == 1 )
        {
                return getCoffeeName();
            }
              if ( pos == 2 )
        {
                return new Integer(getSupplierId());
            }
              if ( pos == 3 )
        {
                return new Double(getPrice());
            }
              if ( pos == 4 )
        {
                return new Integer(getSales());
            }
              if ( pos == 5 )
        {
                return new Integer(getTotal());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
          save(CoffeesPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    CoffeesPeer.doInsert((Coffees)this, con);
                    setNew(false);
                }
                else
                {
                    CoffeesPeer.doUpdate((Coffees)this, con);
                }

                      if (isCacheOnSave())
                {
                    CoffeesManager.putInstance(this);
                }
              }

                      alreadyInSave = false;
        }
      }

    /**
     * Specify whether to cache the object after saving to the db.
     * This method returns false
     */
    protected boolean isCacheOnSave()
    {
        return true;
    }

                  
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey coffeeId
     */
    public void setPrimaryKey(ObjectKey coffeeId)
         {
            setCoffeeId(((NumberKey)coffeeId).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
            setCoffeeId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getCoffeeId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections.
       */
      public Coffees copy() throws TorqueException
    {
        Coffees copyObj = new Coffees();
            copyObj.setCoffeeId(coffeeId);
          copyObj.setCoffeeName(coffeeName);
          copyObj.setSupplierId(supplierId);
          copyObj.setPrice(price);
          copyObj.setSales(sales);
          copyObj.setTotal(total);
  
                      copyObj.setCoffeeId(0);
                                          
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public CoffeesPeer getPeer()
    {
        return peer;
    }
}
