/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.Portlet;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletConfig;

/**
 * The <CODE>Event</CODE> is the base interface for all events
 * that can occur whithin the portlet container. To be informed
 * of events, a listener has to be registered with the respective
 * event source.
 * 
 * <P>
 * The portlet container delivers all events to the respective
 * event listeners (and thereby the portlets) before the content
 * generation is started. Should a listener, while processing the
 * event, find that another event needs to be generated, that
 * event will be queued by the portlet container and delivered
 * at a point of time that is at the discretion of the portlet
 * container. It is only guarantued that it will be deliverd
 * and that it will happen before the content generation phase.
 * </P>
 * <P>
 * This also means, that no further events will be delivered
 * once the content generation phase has started. For example,
 * message cannot be sent from within the service() methods.
 * The resulting message event will not be delivered and
 * essentially discarded.
 * </P>
 * <P>
 * Intelligent portlet containers should provide a cyclic event
 * detection mechanism, so that the portlet container does not
 * come to a screaming halt, if two or more portlets happen
 * to send each other events that are triggered by each other.
 * </P>
 * 
 * @author <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 */
public interface Event
{
    /**
     ** Returns the portlet request that has caused this event.
     ** If this event is not triggered by a request,
     ** this methods returns <CODE>null</CODE>.
     **
     ** @return   the portlet request
     **/

    public PortletRequest getRequest ();

    /**
     ** Returns the virtual instance of the portlet
     ** that receives this event.
     **
     ** @return   the virtual instance of the portlet
     **/

    public Portlet getPortlet ();

    /**
     ** Returns the portlet config of the virtual instance
     ** that receives this event.
     **
     ** @return   the portlet config
     **/

    public PortletConfig getConfig ();

}