/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.mail.file;

import java.io.File;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.util.ALMailUtils;

/**
 * ローカルのファイルシステムを利用し、メールの送受信を操作するクラスです。 <br />
 * 
 */
public class ALFileMailHandler extends ALMailHandler {

  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(ALFileMailHandler.class.getName());

  /**
   * コンストラクタ
   */
  private ALFileMailHandler() {
  }

  public static ALMailHandler getInstance() {
    return new ALFileMailHandler();
  }

  protected ALMailReceiver getALMailReceiver(ALMailReceiverContext rcontext) {
    return new ALFilePop3MailReceiver(rcontext);
  }

  public ALMailSender getALMailSender(ALMailSenderContext scontext) {
    return new ALFileSmtpMailSender(scontext);
  }

  public ALFolder getALFolder(int type_mail, String org_id, int user_id,
      int account_id) {
    return new ALFileLocalFolder(type_mail, org_id, user_id, account_id);
  }

  /**
   * アカウントフォルダを削除する．
   * 
   * @param userRootFolderName
   * @param accountName
   * @return
   */
  public boolean removeAccount(String org_id, int user_id, int account_id) {
    String rootFolderPath = ALMailUtils.rootFolderPath + File.separator
        + org_id + File.separator + user_id + File.separator + account_id;
    File folder = new File(rootFolderPath);
    return ALMailUtils.deleteFolder(folder);
  }

}
