#============================================================================================================
#
#	g@\ - BE(HS)ۂ
#	0ch_BE_HS.pl
#
#	by 낿˂vX
#	http://zerochplus.sourceforge.jp/
#
#	  O  K  r e a d m e . t x t         B
#	ǂ܂ȂƂȂ͖̒   Q       B
#
#	---------------------------------------------------------------------------
#
#	2010.08.26 start
#
#============================================================================================================
package ZPL_BE_HS;

#------------------------------------------------------------------------------------------------------------
#
#	RXgN^
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	IuWFNg
#
#------------------------------------------------------------------------------------------------------------
sub new
{
	my $this = shift;
	my $obj={};
	bless($obj,$this);
	return $obj;
}

#------------------------------------------------------------------------------------------------------------
#
#	g@\̎擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	̕
#
#------------------------------------------------------------------------------------------------------------
sub getName
{
	my	$this = shift;
	return 'BE(HS)ۂ';
}

#------------------------------------------------------------------------------------------------------------
#
#	g@\擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	
#
#------------------------------------------------------------------------------------------------------------
sub getExplanation
{
	my	$this = shift;
	return 'Q˂BEɃOCł悤ɂ܂';
}

#------------------------------------------------------------------------------------------------------------
#
#	g@\^Cv擾
#	-------------------------------------------------------------------------------------
#	@param	Ȃ
#	@return	g@\^Cv(X:1,X:2,read:4,index:8)
#
#------------------------------------------------------------------------------------------------------------
sub getType
{
	my	$this = shift;
	return (1 | 2);
}

#------------------------------------------------------------------------------------------------------------
#
#	g@\sC^tFCX
#	-------------------------------------------------------------------------------------
#	@param	$sys	MELKOR
#	@param	$form	SAMWISE
#	@return	Ȉꍇ0
#
#------------------------------------------------------------------------------------------------------------
sub execute
{
	use strict;
	use warnings;
	my $this = shift;
	my ($sys, $form, $type) = @_;
	
	#--------------------------------------------------------------------------------------------------------
	#	[U[ݒ荀
	#	---------------------------------------------------------------------------------
	#	ڂreadme.txt
	#--------------------------------------------------------------------------------------------------------
	
	# sssp://(BEACR\)LɂH(1:L,0:)
	my $be_icon = 0;
	
	
	# O擾
	my $name = $form->Get('FROM');
	
	# {擾
	my $mes  = $form->Get('MESSAGE');
	
	# ΍łƂ肠ɂ
	$form->Set('BEID', '');
	$form->Set('BERANK', '0');
	
	if ( $name =~ /!BE.+!HS/ ) {
		
		my ( $beid, $key );
		
		if ( $name =~ /!BE(\d+)!HS.*?#(.+)$/ ) {
			$beid = $1;
			$key = $2;
		}
		elsif ( $name =~ /!BE(\d+)-#(.+)!HS/ ) {
			$beid = $1;
			$key = $2;
		}
		
		my ($CONV, $SET, $trip, $key2, $column, @ct_arg);
		if (defined $sys->{'MainCGI'}) {
			$CONV = $sys->{'MainCGI'}->{'CONV'};
			$SET = $sys->{'MainCGI'}->{'SET'};
			$column = $SET->Get('BBS_TRIPCOLUMN');
			$trip = $CONV->ConvertTrip(\$key, $column, $sys->Get('TRIP12'));
		}
		else {
			require './module/galadriel.pl';
			$CONV = GALADRIEL->new;
			require './module/isildur.pl';
			$SET = ISILDUR->new;
			$SET->Load($sys);
			$column = $SET->Get('BBS_TRIPCOLUMN');
			$key = "#$key";
			$CONV->ConvertTrip(\$key, $column);
			$key =~ m|([A-Za-z0-9\.]+)|;
			$trip = $1;
		}
		
		# Ƃ肠
		$name =~ s/!BE.+!HS//;
		if ($form->IsExist('TRIPKEY') && $name =~ /#(.+)$/) {
			$key2 = $1;
			$ct_arg[0] = \$key2;
			$key2 = $CONV->ConvertTrip(\$key2, $column, $sys->Get('TRIP12'));
			$form->Set('TRIPKEY', $key2);
		}
		
		$form->Set('FROM', $name);
		
		# BEvtURLłˁI
		my $beprof = "http://be.2ch.net/test/p.php?i=$beid";
		
		# LWP̐ݒ
		my ( $code, $content ) = BeGet($beprof);
		
		# HTML
		if ( $code ne 200 ) {
			$form->Set('BEID', "BE:擾G[($code)");
			return 0;
		}
		
		# Shift_JISc
		require Encode;
		Encode::from_to( $content, 'EUC-JP', 'Shift_JIS' );
		
		if ( $content =~ /<div id="sitename">\n<h1>(.+)<\/h1>/ ) {
			
			my $name = $1;
			$name =~ s|^.*([A-Za-z0-9\./]{10,12}).*$|$1|;
			
			# ̓gbvƃvt̃gbv̈v𒲂ׂ
			if ( $trip eq $name ) {
				
				my $point = 0;
				
				# |Cg擾
				if ( $content =~ m/<p><b>be.{8}<\/b>:([0-9]+)<\/p>/ ) {
					$point = BeRank($form, $1);
				}
				else {
					# ݂ȂO|Cg
					$point = '2BP(0)';
				}
				
				$form->Set('BEID', "BE:$beid-$point");
				
				# ACRƂĂI
				if ( $be_icon ) {
					
					# sssp://http://ɕϊ
					$mes =~ s|sssp://|http://|gi;
					
					if ( $content =~ m|<img src="http://img.2ch.net/(.+)" />\n\n|i ) {
						my $sssp = "sssp://img.2ch.net/$1";
						$mes = "$sssp<br>$mes";
					}
					
					$form->Set('MESSAGE', "$mes");
					
				}
				
			}
			else {
				#$form->Set('BEID', "BE:F؃G[($trip:$name)");
				return 0;
			}
			
		}
		else {
			$form->Set('BEID', '擾G[(-1)');
			return 0;
		}
		
	}
	
	return 0;
}

#------------------------------------------------------------------------------------------------------------
#
#	gbv쐬֐
#	-------------------------------------------------------------------------------------
#	@param	$key	gbvL[
#	@return	$trip	gbv
#
#------------------------------------------------------------------------------------------------------------
sub ConvertTrip1
{
	
	my ( $key ) = @_;
	
	# ]̃gbv
	my $salt = substr($key . 'H.', 1, 2);
	$salt =~ s/[^\.-z]/\./go;
	$salt =~ tr/:;<=>?@[\\]^_`/ABCDEFGabcdef/;
	
	# 0x80Č
	$key =~ s/\x80[\x00-\xff]*$//;
	
	my $trip = substr(crypt($key, $salt), -10);
	
	return $trip;
	
}

#------------------------------------------------------------------------------------------------------------
#
#	BEvtB[y[W擾
#	-------------------------------------------------------------------------------------
#	@param	$url	BEvt
#	@return	$code	HTTPXe[^X
#	@return $cont	BevtHTML
#
#------------------------------------------------------------------------------------------------------------
sub BeGet {
	
	my ( $url ) = @_;
	
	require LWP::UserAgent;
	my $ua   = new LWP::UserAgent;
	$ua->agent('Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.9.2.8) Gecko/20100722 Firefox/3.6.8');
	$ua->timeout(5);
	
	# ƂĂ
	my $req  = HTTP::Request->new(GET => $url);
	my $res  = $ua->request($req);
	my $cont = $res->content;
	my $code = $res->code;
	
	return ( $code, $cont );
	

}
#------------------------------------------------------------------------------------------------------------
#
#	BEN擾
#	-------------------------------------------------------------------------------------
#	@param	$form	$form
#	@param	$point	|Cg
#	@return	N\` 2BP(0)
#
#------------------------------------------------------------------------------------------------------------
sub BeRank {
	
	my ( $form, $point ) = @_;
	
	if ( $point < 10000 ) {
		$point = "2BP($point)";
		$form->Set('BERANK', 1);
	}
	elsif ( $point < 12000 ) {
		$point = "BRZ($point)";
		$form->Set('BERANK', 2);
	}
	elsif ( $point < 100000 ) {
		$point = "PLT($point)";
		$form->Set('BERANK', 3);
	}
	elsif ( $point < 500000 ) {
		$point = "DIA($point)";
		$form->Set('BERANK', 4);
	}
	elsif ( $point >= 500000 ) {
		$point = "S($point)";
		$form->Set('BERANK', 5);
	}
	else {
		$point = "2BP(0)";
		$form->Set('BERANK', 1);
	}
	
	return $point;
	
}


#============================================================================================================
#	Module END
#============================================================================================================
1;
__END__
