package net.yher.waft.controller;

import net.yher.waft.controller.URLMap;
import net.yher.waft.controller.URLMapPattern;
import junit.framework.TestCase;

public class URLMapTest extends TestCase {
	String url = "^/task/(\\d+)/$";
	String klass = "net.yher.waft.controller.URLMapTestGroovyObject";
	String method = "testInvokeAction";
	String argument = "{id:$1, show:\"detail\"}";

	protected void setUp() throws Exception {
		super.setUp();
	}

	public void testIsMatch() {
		URLMapPattern pattern = new URLMapPattern(url + "\t" + klass + "\t" + method + "\t" + argument);
		assertTrue(pattern.matcher("/task/1/").isMatch());
		assertTrue(pattern.matcher("/task/1").isMatch());
		assertFalse(pattern.matcher("/task/x/").isMatch());
	}

	public void testInvokeAction() throws Exception {
		URLMap map = new URLMapPattern(url + "\t" + klass + "\t" + method + "\t" + argument).matcher("/task/22/");
		String result = map.invokeAction(null, null);
		assertEquals("OK:22:detail", result);
	}

	public void testInvokeAction_no_url_replace_argument() throws Exception {
		URLMap map = new URLMapPattern(url + "\t" + klass + "\t" + "testInvokeAction_no_url_replace_argument").matcher("/task/22/");
		String result = map.invokeAction(null, null);
		assertEquals("OK2", result);
	}
	public void testInvokeAction_use_2_groovy_files() throws Exception {
		URLMap map = new URLMapPattern(url + "\t" + klass + "\t" + "testInvokeAction_use_2_groovy_files").matcher("/task/22/");
		String result = map.invokeAction(null, null);
		assertEquals("hoge", result);
	}
	public void testInvokeAction_import_groovy_files() throws Exception {
		URLMap map = new URLMapPattern(url + "\t" + klass + "\t" + "testInvokeAction_import_groovy_files").matcher("/task/22/");
		String result = map.invokeAction(null, null);
		assertEquals("import_hoge", result);
	}
	public void testInvokeAction_integer_argument() throws Exception {
		URLMap map = new URLMapPattern(url + "\t" + klass + "\t" + "testInvokeAction_integer_argument" + "\t" + "$1").matcher("/task/22/");
		String result = map.invokeAction(null, null);
		assertEquals("OK:22", result);
	}
	public void testInvokeAction_double_argument() throws Exception {
		URLMap map = new URLMapPattern("^/task/(\\d+\\.\\d+)/$"+ "\t" + klass + "\t" + "testInvokeAction_double_argument" + "\t" + "$1").matcher("/task/2.2/");
		String result = map.invokeAction(null, null);
		assertEquals("OK:2.2", result);
	}
	public void testInvokeAction_boolean_argument() throws Exception {
		URLMap map = new URLMapPattern("^/(.*)/$" + "\t" + klass + "\t" + "testInvokeAction_boolean_argument" + "\t" + "$1").matcher("/true/");
		String result = map.invokeAction(null, null);
		assertEquals("OK:true", result);
	}
	public void testInvokeAction_string_argument() throws Exception {
		URLMap map = new URLMapPattern("^/(.*)/$" + "\t" + klass + "\t" + "testInvokeAction_string_argument" + "\t" + "$1").matcher("/xxx/");
		String result = map.invokeAction(null, null);
		assertEquals("OK:xxx", result);
	}
	public void testInvokeAction_json_array() throws Exception {
		URLMap map = new URLMapPattern(url + "\t" + klass + "\t" + "testInvokeAction_json_array" + "\t" + "[{id:$1}, {test:$1}]").matcher("/task/22/");
		String result = map.invokeAction(null, null);
		assertEquals("OK:length=2", result);
	}
}
