/**
 * Copyright (c) 2006, yher.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.commons.collections;

import java.util.ArrayList;
import java.util.List;

import net.yher.commons.collections.CollectionUtils;

import junit.framework.TestCase;

public class CollectionUtilsTest extends TestCase {
	public void testToCsv_文字列CollectionからCSV文字列を作成する() {
		List<String> collection = new ArrayList<String>();
		collection.add("A");
		collection.add("B");
		collection.add("C");

		assertEquals("A,B,C", CollectionUtils.toCsv(collection));
	}
	public void testToCsv_数値CollectionからCSV文字列を作成する() {
		List<Integer> collection = new ArrayList<Integer>();
		collection.add(1);
		collection.add(2);
		collection.add(3);

		assertEquals("1,2,3", CollectionUtils.toCsv(collection));
	}
	public void testToCsv_小数CollectionからCSV文字列を作成する() {
		List<Double> collection = new ArrayList<Double>();
		collection.add(1.1);
		collection.add(2.2);
		collection.add(3.3);

		assertEquals("1.1,2.2,3.3", CollectionUtils.toCsv(collection));
	}
	public void testToCsv_空のCollectionからは空文字を作成する() {
		List<String> collection = new ArrayList<String>();
		assertEquals("", CollectionUtils.toCsv(collection));
	}
}
