package net.yher.workstyle.action.task.rest;

import javax.servlet.http.HttpServletRequest;

import net.yher.commons.struts.Validator;
import net.yher.workstyle.Properties;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class LinkForm extends ActionForm {
	private int srcTaskId;
	private int destTaskId;

	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		srcTaskId = 0;
		destTaskId = 0;
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyId(Properties.TASK_ID, srcTaskId);
		validator.verifyId(Properties.TASK_ID, destTaskId);
		return validator.getErrors();
	}

	public int getSrcTaskId() {
		return srcTaskId;
	}

	public void setSrcTaskId(int taskId) {
		this.srcTaskId = taskId;
	}

	public int getDestTaskId() {
		return destTaskId;
	}

	public void setDestTaskId(int destTaskId) {
		this.destTaskId = destTaskId;
	}
}
