package net.yher.workstyle.action;

import java.util.List;

import net.yher.waft.db.Transaction;
import net.yher.workstyle.action.task.TaskUtils;
import net.yher.workstyle.TaskQuery;
import net.yher.workstyle.TaskPager;
import net.yher.workstyle.manager.TaskManager;
import net.yher.workstyle.torque.bean.TaskBean;
import net.yher.commons.lang.BeanUtils;
import net.yher.commons.lang.DateUtils;
import net.yher.commons.struts.ActionException;

public String get (request, response, id) {
	Transaction.commitOnSuccess({con ->
		new TaskUtils(request, con).get(id);
	})
	return "/TaskDetail.vhtml";
}

public String search(request, response) {
	Transaction.commitOnSuccess({con ->
		new TaskUtils(request, con).search(buildQuery(request), buildPager(request));
	})
	return "/TaskList.vhtml";
}
public String searchUnlinked(request, response, id) {
	Transaction.commitOnSuccess({con ->
		TaskQuery query = buildQuery(request);
		query.unlinkedTaskId = id;
		new TaskUtils(request, con).searchUnlinkedTask(query, buildPager(request));
	})
	return "/UnlinkedTaskList.vhtml";
}
public String atom(request, response) {
	Transaction.commitOnSuccess({con ->
		TaskQuery query = buildQuery(request);
		query.setUpdateDateFrom(DateUtils.addDay(new Date(), -3));
		query.setOrder(TaskQuery.ORDER_BY_UPDATE_DATE_ASC);
		def taskList = new TaskUtils(request, con).searchDetail(query, buildPager(request));
		
		if (taskList.size() > 0) {
			String date = DateUtils.formatRfc1123(taskList.get(taskList.size()-1).getUpdateDate());
			response.setHeader("Date", date);
			response.setHeader("Last-Modified", date);
		}
	})
	return "/atom0.3.vxml";
}

def buildQuery(request) {
    return request.param.populate(new TaskQuery());
}
def buildPager(request) {
    return request.param.populate(new TaskPager());
}

public String updatePriority(request, response, urlData) {
	Transaction.commitOnSuccess({con ->
		if (request.fromPost) {
			new TaskManager(con).updatePriority(urlData.id , urlData.priority);
		}
		new TaskUtils(request, con).get(urlData.id);
	})
	return "/xml/Task.vxml";
}

public String updateProperty(request, response, id) {
    try {
		Transaction.commitOnSuccess({con ->
			if (request.fromPost) {
				new TaskManager(con).updateProperty(buildProperty(request, id));
			}
			new TaskUtils(request, con).get(id);
		})
    } catch (ActionException e) {
        request.setAttribute("error", e);
    }
	return "/xml/Task.vxml";
}
def buildProperty(request, id) {
    TaskBean prop = request.post.populate(new TaskBean());
    prop.taskId = id;
    return prop;
}