/**
 * Copyright (c) 2006, yher.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.commons.struts;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;

public class Validator {
	private ErrorsUtils errors;
	
	public Validator(ActionErrors errors) {
		if (errors == null) errors = new ActionErrors();
		this.errors = new ErrorsUtils(errors);
	}

	public ActionErrors getErrors() {
		return errors.getErrors();
	}

	/**
	 * 範囲検査を行う
	 * @param property
	 * @param value
	 * @param min
	 * @param max
	 */
	protected void verifyRange(String property, int value, int min, int max) {
		if (value < min || max < value) {
			errors.addRange(property, min, max);
		}
	}

	/**
	 * enumの検査を行う.
	 */
	public void verifyEnum(String property, List<Integer> valueList, int target) {
		if (!valueList.contains(target)) {
			errors.addInvalid(property);
		}
	}

	/**
	 * enumの検査を行う.
	 * @param groups
	 * @param groupFlag
	 */
	public void verifyEnum(String property, Enum masters[], String[] flags) {
		if(flags != null){
			for (String flag : flags) {
				boolean check = false;
				for (Enum master : masters) {
					if (master.toString().equals(flag)) {
						check = true;
						break;
					}
				}
				if (!check) {
					errors.addInvalid(property);
				}
			}
		}
	}

	/**
	 * enumの検査を行う.
	 * @param groups
	 * @param groupFlag
	 */
	public void verifyRequiredEnum(String property, Enum masters[], String flag) {
		if(StringUtils.isNotBlank(flag)){
			
			boolean check = false;
			for (Enum master : masters) {
				if (master.toString().equals(flag)) {
					check = true;
					break;
				}
			}
			if (!check) {
				errors.addInvalid(property);
			}
		} else {
			errors.addInvalid(property);
		}
	}

	/**
	 * enumの検査を行う.
	 * @param groups
	 * @param groupFlag
	 */
	public void verifyEnum(String property, Enum masters[], String flag) {
		if(StringUtils.isNotBlank(flag)){
			boolean check = false;
			for (Enum master : masters) {
				if (master.toString().equals(flag)) {
					check = true;
					break;
				}
			}
			if (!check) {
				errors.addInvalid(property);
			}
		}
	}
	/**
	 * 必須チェックを行う。
	 * @param target 対象の入力値
	 */
	public void verifyRequired(String property, Object target) {
		if (target == null) {
			errors.addRequired(property);
		}
	}
	/**
	 * 必須チェックを行う。
	 * @param target 対象の入力値
	 */
	public void verifyRequired(String property, String target) {
		if (StringUtils.isBlank(target)) {
			errors.addRequired(property);
		}
	}
	/**
	 * 必須チェックを行う。
	 * @param target 対象の入力値
	 */
	public void verifyRequired(String property, String[] target) {
		if(target == null || target.length == 0){
			errors.addRequired(property);
		}
	}
	
	/**
	 * 最大文字数チェックを行う
	 * @param property 属性名
	 * @param target 検査対象
	 * @param maxLength 最大文字数
	 */
	public void verifyMaxLength(String property, String target, int maxLength) {
		if (StringUtils.isNotBlank(target) && target.length() > maxLength) {
			errors.addMaxLength(property, maxLength);
		}
	}

	/**
	 * IDのチェックを行う。
	 * @param property 属性名
	 * @param id 
	 */
	public void verifyId(String property, int id) {
		if (id <= 0) {
			errors.addInvalid(property);
		}
	}
	/**
	 * IDのチェックを行う。
	 * @param property 属性名
	 * @param id 
	 */
	public void verifyIdAcceptZero(String property, int id) {
		if (id < 0) {
			errors.addInvalid(property);
		}
	}

	/**
	 * メールアドレスのチェックを行う。
	 * @param property 属性名
	 * @param mail 
	 */
	public void verifyMailAddress(String property, String mail) {
		int maxLength = 255;
		if (StringUtils.isNotBlank(mail)) {
			if(mail.length() > maxLength) {
				errors.addMaxLength(property, maxLength);
			}
			if (!mail.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*")) {
				errors.addInvalid(property);
			}
		}
		
	}

	/**
	 * 値の最小値をチェックする
	 * @param property 属性名
	 * @param target 検査対象
	 * @param min 最小値
	 */
	public void verifyMin(String property, int target, int min) {
		if (target < min) {
			errors.addMin(property, min);
		}
	}
}
