/**
 * Copyright (c) 2006, yher.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.commons.struts;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

public class ErrorsUtils {
	public static final String MAX_LENGTH = "errors.maxLength";
	public static final String RANGE = "errors.range";
	public static final String REQUIRED = "errors.required";
	public static final String INVALID = "errors.invalid";
	public static final String MIN =  "errors.min";
	private ActionErrors errors = null;
	public ErrorsUtils(ActionErrors errors) {
		this.errors = errors;
	}
	
	public ActionErrors getErrors() {
		return errors;
	}
	public void addRequired(String property) {
		errors.add(property, new ActionMessage(REQUIRED, new Object[]{property}));
	}
	public void addInvalid(String property) {
		errors.add(property, new ActionMessage(INVALID, new Object[]{property}));
	}
	public void addRange(String property, int min, int max) {
		errors.add(property, new ActionMessage(RANGE, new Object[]{property, min, max}));
	}
	public void addMaxLength(String property, int maxLength) {
		errors.add(property, new ActionMessage(MAX_LENGTH, new Object[]{property, maxLength}));
	}

	public void addMin(String property, int min) {
		errors.add(property, new ActionMessage(MIN, new Object[]{property, Integer.toString(min)}));
	}
}
