/**
 * Copyright (c) 2006, yher.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.commons.lang;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Resource {
	
	private static String resourceFileName="project";
	static Map<Locale, ExtendResourceBundle> resourceMap = new HashMap<Locale, ExtendResourceBundle>();
	static Map<Locale, Date> resourceDateMap = new HashMap<Locale, Date>();

	private static ExtendResourceBundle getBundle() {
		return getBundle(Locale.getDefault());
	}
	private static ExtendResourceBundle getBundle(Locale locale) {
		Date currentDate = new Date();
		
		if (!resourceMap.containsKey(locale) || 
				!resourceDateMap.containsKey(locale) || 
				(currentDate.getTime()-resourceDateMap.get(locale).getTime()) > (1000*60*60)) {
			ExtendResourceBundle resourceBundle = ExtendResourceBundle.getBundle(Resource.resourceFileName, locale);
			Date date = currentDate;
			resourceMap.put(locale, resourceBundle);
			resourceDateMap.put(locale, date);
		}
		return resourceMap.get(locale);
		
	}
	
	public static void setResourceFileName(String baseName) {
		resourceFileName = baseName;
	}

	public static String getString(String key) {
		return getBundle().getString(key);
	}
	public static String getString(String key, Locale locale) {
		return getBundle(locale).getString(key);
	}
	
	public static String[] getStringArray(String key) {
		return getBundle().getStringArray(key);
	}
	
	public static String[] getStringArray(String key, Locale locale) {
		return getBundle(locale).getStringArray(key);
	}

	public static float getFloat(String key) {
		return getBundle().getFloat(key);
	}
	public static float getFloat(String key, Locale locale) {
		return getBundle(locale).getFloat(key);
	}
	public static double getDouble(String key) {
		return getBundle().getDouble(key);
	}
	public static double getDouble(String key, Locale locale) {
		return getBundle(locale).getDouble(key);
	}
	public static int getInt(String key) {
		return getBundle().getInt(key);
	}
	public static int getInt(String key, Locale locale) {
		return getBundle(locale).getInt(key);
	}
	public static int getInt(String key, int defaultValue) {
		return getBundle().getInt(key, defaultValue);
	}
	public static int getInt(String key, int defaultValue, Locale locale) {
		return getBundle(locale).getInt(key, defaultValue);
	}
}
