/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.data;

import junit.framework.TestCase;
import net.yher2.junit.db.data.XmlParser;

public class XmlParserTest
extends TestCase {
    public void testNomalize() {
        XmlParserTest.assertEquals((String)"<date value=\"2004%2F12%2F21+13%3A52%3A11\" format=\"yyyy%2FMM%2Fdd+HH%3Amm%3Ass\"/>", (String)new XmlParser("<date value=\"2004/12/21 13:52:11\" format=\"yyyy/MM/dd HH:mm:ss\"/>").getXml());
        XmlParserTest.assertEquals((String)"<date/>", (String)new XmlParser("<date/>").getXml());
        XmlParserTest.assertEquals((String)"<char value=\"1%3C%3E%26quot%3B\"/>", (String)new XmlParser("<char value \t\r\n= \t\r\n\"1<>&quot;\"/>").getXml());
        XmlParserTest.assertEquals((String)"<random length=\"3\" type=\"alphabet\"/>", (String)new XmlParser("<random length=\"3\" \n type=\"alphabet\"/>").getXml());
        XmlParserTest.assertEquals((String)"<random length=\"2\" type=\"alphabet\"/>", (String)new XmlParser("<random length=\"2\" \r\n type=\"alphabet\"/>").getXml());
        XmlParserTest.assertEquals((String)"<random length=\"2\" type=\"number\"/>", (String)new XmlParser("<random length=\"2\" \t type=\"number\"/>").getXml());
        XmlParserTest.assertEquals((String)"<date/>", (String)new XmlParser("\n\r \t<date/>\n\r \t").getXml());
    }

    public void testIsXml() {
        XmlParserTest.assertTrue((boolean)new XmlParser("<date value=\"2004/12/21 13:52:11\" format=\"yyyy/MM/dd HH:mm:ss\"/>").isXml());
        XmlParserTest.assertTrue((boolean)new XmlParser("<date/>").isXml());
        XmlParserTest.assertTrue((boolean)new XmlParser("<string value=\"1\"/>").isXml());
        XmlParserTest.assertTrue((boolean)new XmlParser("<random length=\"3\" \n type=\"alphabet\"/>").isXml());
        XmlParserTest.assertTrue((boolean)new XmlParser("<random length=\"2\" \r\n type=\"alphabet\"/>").isXml());
        XmlParserTest.assertTrue((boolean)new XmlParser("<random length=\"2\" \t type=\"number\"/>").isXml());
        XmlParserTest.assertTrue((boolean)new XmlParser("\n\r \t<date/>\n\r \t").isXml());
        XmlParserTest.assertFalse((boolean)new XmlParser("d<ate/>").isXml());
        XmlParserTest.assertFalse((boolean)new XmlParser("<date/").isXml());
        XmlParserTest.assertFalse((boolean)new XmlParser("<date>").isXml());
    }

    public void testParse() {
        XmlParser parser = new XmlParser("<date value=\"2004/12/21 13:52:11\" format=\"yyyy/MM/dd HH:mm:ss\"/>");
        parser.parse();
        XmlParserTest.assertEquals((String)"date", (String)parser.getElementName());
        XmlParserTest.assertEquals((String)"2004/12/21 13:52:11", (String)parser.getAttribute("value"));
        XmlParserTest.assertEquals((String)"yyyy/MM/dd HH:mm:ss", (String)parser.getAttribute("format"));
        parser = new XmlParser("<dAte/>");
        parser.parse();
        XmlParserTest.assertEquals((String)"date", (String)parser.getElementName());
        XmlParserTest.assertFalse((boolean)parser.hasAttribute("value"));
        XmlParserTest.assertFalse((boolean)parser.hasAttribute("format"));
        parser = new XmlParser("<char value \t\r\n= \t\r\n\"1<>&quot;&amp; \n\r\t\"/>");
        parser.parse();
        XmlParserTest.assertEquals((String)"char", (String)parser.getElementName());
        XmlParserTest.assertEquals((String)"1<>\"& \n\r\t", (String)parser.getAttribute("value"));
    }

    public void testParseNoElementName() {
        try {
            new XmlParser("<hoge=\"\">").parse();
        }
        catch (Exception e) {
            return;
        }
        XmlParserTest.fail();
    }

    public void testParseNoAttributeName() {
        try {
            new XmlParser("<hoge =\"\">").parse();
        }
        catch (Exception e) {
            return;
        }
        XmlParserTest.fail();
    }

    public void testParseNoAttributeValue() {
        try {
            new XmlParser("<hoge hoge=>").parse();
        }
        catch (Exception e) {
            return;
        }
        XmlParserTest.fail();
    }

    public void testParseInvalidXml() {
        try {
            new XmlParser("<hoge>").parse();
        }
        catch (Exception e) {
            return;
        }
        XmlParserTest.fail();
    }

    public void testParseInvalidXml2() {
        try {
            new XmlParser("d<hoge/>").parse();
        }
        catch (Exception e) {
            return;
        }
        XmlParserTest.fail();
    }

    public void testParseInvalidXml3() {
        try {
            new XmlParser("<hoge").parse();
        }
        catch (Exception e) {
            return;
        }
        XmlParserTest.fail();
    }
}

