/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml.streamingmarkupsupport;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class StreamingMarkupWriter
extends Writer {
    protected final Writer writer;
    protected final String encoding;
    protected final CharsetEncoder encoder;
    private final Writer bodyWriter = new Writer(){

        public void close() throws IOException {
            StreamingMarkupWriter.this.close();
        }

        public void flush() throws IOException {
            StreamingMarkupWriter.this.flush();
        }

        public void write(int c) throws IOException {
            if (!StreamingMarkupWriter.this.encoder.canEncode((char)c)) {
                StreamingMarkupWriter.this.writer.write("&#x");
                StreamingMarkupWriter.this.writer.write(Integer.toHexString(c));
                StreamingMarkupWriter.this.writer.write(59);
            } else if (c == 60) {
                StreamingMarkupWriter.this.writer.write("&lt;");
            } else if (c == 62) {
                StreamingMarkupWriter.this.writer.write("&gt;");
            } else if (c == 38) {
                StreamingMarkupWriter.this.writer.write("&amp;");
            } else {
                StreamingMarkupWriter.this.writer.write(c);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        public Writer attributeValue() {
            return StreamingMarkupWriter.this.attributeWriter;
        }

        public Writer bodyText() {
            return StreamingMarkupWriter.this.bodyWriter;
        }

        public Writer unescaped() {
            return StreamingMarkupWriter.this;
        }
    };
    private final Writer attributeWriter = new Writer(){

        public void close() throws IOException {
            StreamingMarkupWriter.this.close();
        }

        public void flush() throws IOException {
            StreamingMarkupWriter.this.flush();
        }

        public void write(int c) throws IOException {
            if (c == 39) {
                StreamingMarkupWriter.this.writer.write("&apos;");
            } else {
                StreamingMarkupWriter.this.bodyWriter.write(c);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        public Writer attributeValue() {
            return StreamingMarkupWriter.this.attributeWriter;
        }

        public Writer bodyText() {
            return StreamingMarkupWriter.this.bodyWriter;
        }

        public Writer unescaped() {
            return StreamingMarkupWriter.this;
        }
    };

    public StreamingMarkupWriter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding != null ? encoding : (writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : "US-ASCII");
        this.encoder = Charset.forName(this.encoding).newEncoder();
    }

    public StreamingMarkupWriter(Writer writer) {
        this(writer, null);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public Writer attributeValue() {
        return this.attributeWriter;
    }

    public Writer bodyText() {
        return this.bodyWriter;
    }

    public Writer unescaped() {
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

