/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMCategory {
    private static boolean trimWhitespace = true;

    public static Object get(Object o, String elementName) {
        if (o instanceof Element) {
            return DOMCategory.get((Element)o, elementName);
        }
        if (o instanceof NodeList) {
            return DOMCategory.get((NodeList)o, elementName);
        }
        if (o instanceof NamedNodeMap) {
            return DOMCategory.get((NamedNodeMap)o, elementName);
        }
        return null;
    }

    private static Object get(Element element, String elementName) {
        return DOMCategory.getAt(element, elementName);
    }

    private static Object get(NodeList nodeList, String elementName) {
        return DOMCategory.getAt(nodeList, elementName);
    }

    private static Object get(NamedNodeMap nodeMap, String elementName) {
        return DOMCategory.getAt(nodeMap, elementName);
    }

    private static Object getAt(Element element, String elementName) {
        if ("..".equals(elementName)) {
            return DOMCategory.parent(element);
        }
        if ("**".equals(elementName)) {
            return DOMCategory.depthFirst(element);
        }
        if (elementName.startsWith("@")) {
            return element.getAttribute(elementName.substring(1));
        }
        return DOMCategory.getChildElements(element, elementName);
    }

    private static Object getAt(NodeList nodeList, String elementName) {
        ArrayList results = new ArrayList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            DOMCategory.addResult(results, DOMCategory.get(node, elementName));
        }
        if (elementName.startsWith("@")) {
            return results;
        }
        return new NodeListsHolder(results);
    }

    public static NamedNodeMap attributes(Element element) {
        return element.getAttributes();
    }

    private static String getAt(NamedNodeMap namedNodeMap, String elementName) {
        Attr a = (Attr)namedNodeMap.getNamedItem(elementName);
        return a.getValue();
    }

    public static int size(NamedNodeMap namedNodeMap) {
        return namedNodeMap.getLength();
    }

    public static Node getAt(Element element, int i) {
        if (DOMCategory.hasChildElements(element, "*")) {
            NodeList nodeList = DOMCategory.getChildElements(element, "*");
            return nodeList.item(i);
        }
        return null;
    }

    public static Node getAt(NodeList nodeList, int i) {
        if (i >= 0 && i < nodeList.getLength()) {
            return nodeList.item(i);
        }
        return null;
    }

    public static String name(Element element) {
        return element.getNodeName();
    }

    public static Node parent(Node node) {
        return node.getParentNode();
    }

    public static String text(Object o) {
        Node n;
        if (o instanceof Element) {
            return DOMCategory.text((Element)o);
        }
        if (o instanceof Node && (n = (Node)o).getNodeType() == 3) {
            return n.getNodeValue();
        }
        if (o instanceof NodeList) {
            return DOMCategory.text((NodeList)o);
        }
        return null;
    }

    private static String text(Element element) {
        if (!element.hasChildNodes()) {
            return "";
        }
        if (element.getFirstChild().getNodeType() != 3) {
            return "";
        }
        return element.getFirstChild().getNodeValue();
    }

    private static String text(NodeList nodeList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            sb.append(DOMCategory.text(nodeList.item(i)));
        }
        return sb.toString();
    }

    public static List list(NodeList self) {
        ArrayList answer = new ArrayList();
        Iterator it = DefaultGroovyMethods.iterator(self);
        while (it.hasNext()) {
            answer.add(it.next());
        }
        return answer;
    }

    public static NodeList depthFirst(Element self) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        result.add(DOMCategory.createNodeList(self));
        result.add(self.getElementsByTagName("*"));
        return new NodeListsHolder(result);
    }

    private static NodeList createNodeList(Element self) {
        ArrayList<Element> first = new ArrayList<Element>();
        first.add(self);
        return new NodesHolder(first);
    }

    public static NodeList breadthFirst(Element self) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        NodeList thisLevel = DOMCategory.createNodeList(self);
        while (thisLevel.getLength() > 0) {
            result.add(thisLevel);
            thisLevel = DOMCategory.getNextLevel(thisLevel);
        }
        return new NodeListsHolder(result);
    }

    private static NodeList getNextLevel(NodeList thisLevel) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        for (int i = 0; i < thisLevel.getLength(); ++i) {
            Node n = thisLevel.item(i);
            if (!(n instanceof Element)) continue;
            result.add(DOMCategory.getChildElements((Element)n, "*"));
        }
        return new NodeListsHolder(result);
    }

    public static NodeList children(Element self) {
        return DOMCategory.getChildElements(self, "*");
    }

    private static boolean hasChildElements(Element self, String elementName) {
        return DOMCategory.getChildElements(self, elementName).getLength() > 0;
    }

    private static NodeList getChildElements(Element self, String elementName) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList nodeList = self.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                if (!"*".equals(elementName) && !child.getTagName().equals(elementName)) continue;
                result.add(child);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            String value = node.getNodeValue();
            if (trimWhitespace) {
                value = value.trim();
            }
            if (!"*".equals(elementName) || value.length() <= 0) continue;
            node.setNodeValue(value);
            result.add(node);
        }
        return new NodesHolder(result);
    }

    public static String toString(Object o) {
        if (o instanceof Node && ((Node)o).getNodeType() == 3) {
            return ((Node)o).getNodeValue();
        }
        if (o instanceof NodeList) {
            return DOMCategory.toString((NodeList)o);
        }
        return o.toString();
    }

    private static String toString(NodeList self) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator it = DefaultGroovyMethods.iterator(self);
        while (it.hasNext()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(it.next().toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static int size(NodeList self) {
        return self.getLength();
    }

    public static boolean isEmpty(NodeList self) {
        return DOMCategory.size(self) == 0;
    }

    private static void addResult(List results, Object result) {
        if (result != null) {
            if (result instanceof Collection) {
                results.addAll((Collection)result);
            } else {
                results.add(result);
            }
        }
    }

    private static class NodesHolder
    implements NodeList {
        private List nodes;

        private NodesHolder(List nodes) {
            this.nodes = nodes;
        }

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int index) {
            if (index < 0 || index >= this.getLength()) {
                return null;
            }
            return (Node)this.nodes.get(index);
        }
    }

    private static class NodeListsHolder
    implements NodeList {
        private List nodeLists;

        private NodeListsHolder(List nodeLists) {
            this.nodeLists = nodeLists;
        }

        public int getLength() {
            int length = 0;
            for (int i = 0; i < this.nodeLists.size(); ++i) {
                NodeList nl = (NodeList)this.nodeLists.get(i);
                length += nl.getLength();
            }
            return length;
        }

        public Node item(int index) {
            int relativeIndex = index;
            for (int i = 0; i < this.nodeLists.size(); ++i) {
                NodeList nl = (NodeList)this.nodeLists.get(i);
                if (relativeIndex < nl.getLength()) {
                    return nl.item(relativeIndex);
                }
                relativeIndex -= nl.getLength();
            }
            return null;
        }

        public String toString() {
            return DOMCategory.toString(this);
        }
    }
}

