/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.util.BuilderSupport;
import groovy.util.IndentPrinter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class MarkupBuilder
extends BuilderSupport {
    private IndentPrinter out;
    private boolean nospace;
    private int state;
    private boolean nodeIsEmpty = true;

    public MarkupBuilder() {
        this(new IndentPrinter());
    }

    public MarkupBuilder(PrintWriter writer) {
        this(new IndentPrinter(writer));
    }

    public MarkupBuilder(Writer writer) {
        this(new IndentPrinter(new PrintWriter(writer)));
    }

    public MarkupBuilder(IndentPrinter out) {
        this.out = out;
    }

    protected IndentPrinter getPrinter() {
        return this.out;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        this.nodeIsEmpty = true;
        this.toState(1, name);
        return name;
    }

    protected Object createNode(Object name, Object value) {
        this.toState(2, name);
        this.out.print(">");
        this.out.print(this.escapeElementContent(value.toString()));
        return name;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        this.toState(1, name);
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.out.print(" ");
            this.print(entry.getKey().toString());
            this.out.print("='");
            this.print(this.escapeAttributeValue(entry.getValue().toString()));
            this.out.print("'");
        }
        if (value != null) {
            this.nodeIsEmpty = false;
            this.out.print(">" + this.escapeElementContent(value.toString()) + "</" + name + ">");
        }
        return name;
    }

    protected Object createNode(Object name, Map attributes) {
        return this.createNode(name, attributes, null);
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.toState(3, node);
        this.out.flush();
    }

    protected void print(Object node) {
        this.out.print(node == null ? "null" : node.toString());
    }

    protected Object getName(String methodName) {
        return super.getName(methodName);
    }

    protected String transformValue(String value) {
        if (value.matches(".*&.*")) {
            value = value.replaceAll("&", "&amp;");
        }
        if (value.matches(".*\\'.*")) {
            value = value.replaceAll("\\'", "&apos;");
        }
        if (value.matches(".*<.*")) {
            value = value.replaceAll("<", "&lt;");
        }
        if (value.matches(".*>.*")) {
            value = value.replaceAll(">", "&gt;");
        }
        return value;
    }

    private String escapeAttributeValue(String value) {
        return this.escapeXmlValue(value, true);
    }

    private String escapeElementContent(String value) {
        return this.escapeXmlValue(value, false);
    }

    private String escapeXmlValue(String value, boolean isAttrValue) {
        StringBuffer buffer = new StringBuffer(value);
        int n = buffer.length();
        block6: for (int i = 0; i < n; ++i) {
            switch (buffer.charAt(i)) {
                case '&': {
                    buffer.replace(i, i + 1, "&amp;");
                    i += 4;
                    n += 4;
                    continue block6;
                }
                case '<': {
                    buffer.replace(i, i + 1, "&lt;");
                    i += 3;
                    n += 3;
                    continue block6;
                }
                case '>': {
                    buffer.replace(i, i + 1, "&gt;");
                    i += 3;
                    n += 3;
                    continue block6;
                }
                case '\'': {
                    if (!isAttrValue) continue block6;
                    buffer.replace(i, i + 1, "&apos;");
                    i += 5;
                    n += 5;
                    continue block6;
                }
            }
        }
        return buffer.toString();
    }

    private void toState(int next, Object name) {
        block0 : switch (this.state) {
            case 0: {
                switch (next) {
                    case 1: 
                    case 2: {
                        this.out.print("<");
                        this.print(name);
                        break block0;
                    }
                    case 3: {
                        throw new Error();
                    }
                }
                break;
            }
            case 1: {
                switch (next) {
                    case 1: 
                    case 2: {
                        this.out.print(">");
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.incrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break;
                    }
                    case 3: {
                        if (!this.nodeIsEmpty) break;
                        this.out.print(" />");
                    }
                }
                break;
            }
            case 2: {
                switch (next) {
                    case 1: 
                    case 2: {
                        throw new Error();
                    }
                    case 3: {
                        this.out.print("</");
                        this.print(name);
                        this.out.print(">");
                    }
                }
                break;
            }
            case 3: {
                switch (next) {
                    case 1: 
                    case 2: {
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break block0;
                    }
                    case 3: {
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.decrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("</");
                        this.print(name);
                        this.out.print(">");
                    }
                }
            }
        }
        this.state = next;
    }
}

