/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.array.CharArrayMorpher;
import net.sf.ezmorph.array.CharacterObjectArrayMorpher;
import net.sf.ezmorph.object.CharacterObjectMorpher;
import net.sf.ezmorph.primitive.CharMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONString;
import net.sf.json.regexp.RegexpMatcher;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.JSONDynaBean;
import net.sf.json.util.JSONDynaClass;

public final class JSONUtils {
    private static RegexpMatcher FUNCTION_HEADER_MATCHER;
    private static final String FUNCTION_HEADER_PATTERN = "^function[ ]?\\(.*\\)$";
    private static RegexpMatcher FUNCTION_MACTHER;
    private static RegexpMatcher FUNCTION_PARAMS_MATCHER;
    private static final String FUNCTION_PARAMS_PATTERN = "^function[ ]?\\((.*?)\\)$";
    private static final String FUNCTION_PATTERN = "^function[ ]?\\(.*\\)[ ]?\\{.*\\}$";
    private static final MorpherRegistry morpherRegistry;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$net$sf$json$JSONFunction;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$net$sf$json$util$JSONDynaBean;

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String getFunctionParams(String function) {
        return FUNCTION_PARAMS_MATCHER.getGroupIfMatches(function, 1);
    }

    public static Class getInnerComponentType(Class type) {
        if (!type.isArray()) {
            return type;
        }
        return JSONUtils.getInnerComponentType(type.getComponentType());
    }

    public static MorpherRegistry getMorpherRegistry() {
        return morpherRegistry;
    }

    public static Map getProperties(JSONObject jsonObject) {
        HashMap<String, Class> properties = new HashMap<String, Class>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            properties.put(key, JSONUtils.getTypeClass(jsonObject.get(key)));
        }
        return properties;
    }

    public static Class getTypeClass(Object obj) {
        if (JSONUtils.isNull(obj)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSONUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (JSONUtils.isArray(obj)) {
            return class$java$util$List == null ? (class$java$util$List = JSONUtils.class$("java.util.List")) : class$java$util$List;
        }
        if (JSONUtils.isFunction(obj)) {
            return class$net$sf$json$JSONFunction == null ? (class$net$sf$json$JSONFunction = JSONUtils.class$("net.sf.json.JSONFunction")) : class$net$sf$json$JSONFunction;
        }
        if (JSONUtils.isBoolean(obj)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (JSONUtils.isNumber(obj)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (JSONUtils.isString(obj)) {
            return class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String;
        }
        if (JSONUtils.isObject(obj)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSONUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        throw new JSONException("Unsupported type");
    }

    public static boolean isArray(Class clazz) {
        return clazz != null && (clazz.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = JSONUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz));
    }

    public static boolean isArray(Object obj) {
        if (obj != null && obj.getClass().isArray()) {
            return true;
        }
        return obj instanceof Collection;
    }

    public static boolean isBoolean(Class clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz));
    }

    public static boolean isBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        return obj != null && obj.getClass() == Boolean.TYPE;
    }

    public static boolean isDouble(Class clazz) {
        return clazz != null && (Double.TYPE.isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz));
    }

    public static boolean isFunction(Object obj) {
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            return FUNCTION_MACTHER.matches(str);
        }
        return obj != null && obj instanceof JSONFunction;
    }

    public static boolean isFunctionHeader(Object obj) {
        if (obj != null && obj instanceof String) {
            String str = (String)obj;
            return FUNCTION_HEADER_MATCHER.matches(str);
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).isNullObject();
        }
        return JSONNull.getInstance().equals(obj);
    }

    public static boolean isNumber(Class clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || (class$java$lang$Byte == null ? (class$java$lang$Byte = JSONUtils.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || (class$java$lang$Short == null ? (class$java$lang$Short = JSONUtils.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONUtils.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || (class$java$lang$Long == null ? (class$java$lang$Long = JSONUtils.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || (class$java$lang$Float == null ? (class$java$lang$Float = JSONUtils.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz));
    }

    public static boolean isNumber(Object obj) {
        if (obj != null && obj.getClass() == Byte.TYPE || obj != null && obj.getClass() == Short.TYPE || obj != null && obj.getClass() == Integer.TYPE || obj != null && obj.getClass() == Long.TYPE || obj != null && obj.getClass() == Float.TYPE || obj != null && obj.getClass() == Double.TYPE) {
            return true;
        }
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double;
    }

    public static boolean isObject(Object obj) {
        return !JSONUtils.isNumber(obj) && !JSONUtils.isString(obj) && !JSONUtils.isBoolean(obj) && !JSONUtils.isArray(obj) || JSONUtils.isNull(obj);
    }

    public static boolean isString(Class clazz) {
        return clazz != null && ((class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = JSONUtils.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz));
    }

    public static boolean isString(Object obj) {
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        return obj != null && obj.getClass() == Character.TYPE;
    }

    public static boolean mayBeJSON(String string) {
        return string != null && ("null".equalsIgnoreCase(string) || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}"));
    }

    public static JSONDynaBean newDynaBean(JSONObject jsonObject) throws Exception {
        Map props = JSONUtils.getProperties(jsonObject);
        JSONDynaClass dynaClass = new JSONDynaClass("JSON", class$net$sf$json$util$JSONDynaBean == null ? (class$net$sf$json$util$JSONDynaBean = JSONUtils.class$("net.sf.json.util.JSONDynaBean")) : class$net$sf$json$util$JSONDynaBean, props);
        JSONDynaBean dynaBean = (JSONDynaBean)dynaClass.newInstance();
        dynaBean.setDynamicFormClass(dynaClass);
        return dynaBean;
    }

    public static String numberToString(Number n) {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONUtils.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String quote(String string) {
        if (JSONUtils.isFunction(string)) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void testValidity(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public static Number transformNumber(Number input) {
        if (input instanceof Float) {
            return new Double(input.doubleValue());
        }
        if (input instanceof Short) {
            return new Integer(input.intValue());
        }
        if (input instanceof Byte) {
            return new Integer(input.intValue());
        }
        if (input instanceof Long) {
            Long max = new Long(Integer.MAX_VALUE);
            if (input.longValue() <= max) {
                return new Integer(input.intValue());
            }
        }
        return input;
    }

    public static String valueToString(Object value) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        return JSONUtils.quote(value.toString());
    }

    public static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        return JSONUtils.quote(value.toString());
    }

    private JSONUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        morpherRegistry = new MorpherRegistry();
        FUNCTION_HEADER_MATCHER = RegexpUtils.getMatcher(FUNCTION_HEADER_PATTERN);
        FUNCTION_PARAMS_MATCHER = RegexpUtils.getMatcher(FUNCTION_PARAMS_PATTERN);
        FUNCTION_MACTHER = RegexpUtils.getMatcher(FUNCTION_PATTERN);
        MorphUtils.registerStandardMorphers((MorpherRegistry)morpherRegistry);
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(Character.TYPE));
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(class$java$lang$Character == null ? (class$java$lang$Character = JSONUtils.class$("java.lang.Character")) : class$java$lang$Character));
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(array$C == null ? (array$C = JSONUtils.class$("[C")) : array$C));
        morpherRegistry.deregisterMorpher(morpherRegistry.getMorpherFor(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = JSONUtils.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character));
        morpherRegistry.registerMorpher((Morpher)new CharMorpher('\u0000'));
        morpherRegistry.registerMorpher((Morpher)new CharacterObjectMorpher(new Character('\u0000')));
        morpherRegistry.registerMorpher((Morpher)new CharArrayMorpher('\u0000'));
        morpherRegistry.registerMorpher((Morpher)new CharacterObjectArrayMorpher(new Character('\u0000')));
    }
}

