/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.control;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.event.ElementEvent;
import org.apache.jcs.engine.control.event.ElementEventQueue;
import org.apache.jcs.engine.control.event.behavior.IElementEvent;
import org.apache.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.MemoryCache;
import org.apache.jcs.engine.memory.lru.LRUMemoryCache;

public class CompositeCache
implements ICache,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$control$CompositeCache == null ? (class$org$apache$jcs$engine$control$CompositeCache = CompositeCache.class$("org.apache.jcs.engine.control.CompositeCache")) : class$org$apache$jcs$engine$control$CompositeCache));
    private AuxiliaryCache[] auxCaches;
    private boolean alive = true;
    final String cacheName;
    public IElementAttributes attr;
    public ICompositeCacheAttributes cacheAttr;
    public IElementEventQueue elementEventQ;
    private int hitCountRam;
    private int hitCountAux;
    private int[] auxHitCountByIndex;
    private int missCountNotFound = 0;
    private int missCountExpired = 0;
    MemoryCache memCache;
    static /* synthetic */ Class class$org$apache$jcs$engine$control$CompositeCache;

    public CompositeCache(String cacheName, ICompositeCacheAttributes cattr, IElementAttributes attr) {
        this.cacheName = cacheName;
        this.attr = attr;
        this.cacheAttr = cattr;
        this.elementEventQ = new ElementEventQueue(cacheName);
        this.createMemoryCache(cattr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed cache with name " + cacheName + " and cache attributes: " + cattr));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Constructed cache with name: " + cacheName));
        }
    }

    public void setAuxCaches(AuxiliaryCache[] auxCaches) {
        this.auxCaches = auxCaches;
        if (auxCaches != null) {
            this.auxHitCountByIndex = new int[auxCaches.length];
        }
    }

    public synchronized void update(ICacheElement ce) throws IOException {
        this.update(ce, false);
    }

    public synchronized void localUpdate(ICacheElement ce) throws IOException {
        this.update(ce, true);
    }

    protected synchronized void update(ICacheElement ce, boolean localOnly) throws IOException {
        if (ce.getKey() instanceof String && ce.getKey().toString().endsWith(":")) {
            throw new IllegalArgumentException("key must not end with : for a put operation");
        }
        if (ce.getKey() instanceof GroupId) {
            throw new IllegalArgumentException("key cannot be a GroupId  for a put operation");
        }
        log.debug((Object)"Updating memory cache");
        this.memCache.update(ce);
        if (log.isDebugEnabled()) {
            if (this.auxCaches.length > 0) {
                log.debug((Object)"Updating auxilliary caches");
            } else {
                log.debug((Object)"No auxilliary cache to update");
            }
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache aux = this.auxCaches[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("Auxilliary cache type: " + aux.getCacheType()));
            }
            if (aux != null && aux.getCacheType() == 4) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ce.getElementAttributes().getIsRemote() = " + ce.getElementAttributes().getIsRemote()));
                }
                if (!ce.getElementAttributes().getIsRemote() || localOnly) continue;
                try {
                    aux.update(ce);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Updated remote store for " + ce.getKey() + ce));
                }
                catch (IOException ex) {
                    log.error((Object)"Failure in updateExclude", (Throwable)ex);
                }
                continue;
            }
            if (aux != null && aux.getCacheType() == 3) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("lateralcache in aux list: cattr " + this.cacheAttr.getUseLateral()));
                }
                if (!this.cacheAttr.getUseLateral() || !ce.getElementAttributes().getIsLateral() || localOnly) continue;
                aux.update(ce);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("updated lateral cache for " + ce.getKey()));
                continue;
            }
            if (aux != null && aux.getCacheType() != 2) continue;
        }
    }

    public void spoolToDisk(ICacheElement ce) {
        boolean diskAvailable = false;
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache aux = this.auxCaches[i];
            if (aux == null || aux.getCacheType() != 2) continue;
            diskAvailable = true;
            try {
                ArrayList eventHandlers = ce.getElementAttributes().getElementEventHandlers();
                if (eventHandlers != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Handlers are registered.  Event -- ELEMENT_EVENT_SPOOLED_DISK_AVAILABLE");
                    }
                    ElementEvent event = new ElementEvent(ce, 4);
                    Iterator hIt = ((AbstractList)eventHandlers).iterator();
                    while (hIt.hasNext()) {
                        IElementEventHandler hand = (IElementEventHandler)hIt.next();
                        this.addElementEvent(hand, event);
                    }
                }
                aux.update(ce);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new IllegalStateException(ex.getMessage());
            }
            catch (Exception oee) {
                // empty catch block
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("spoolToDisk done for: " + ce.getKey() + " on disk cache[" + i + "]"));
        }
        if (!diskAvailable) {
            try {
                ArrayList eventHandlers = ce.getElementAttributes().getElementEventHandlers();
                if (eventHandlers != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Handlers are registered.  Event -- ELEMENT_EVENT_SPOOLED_DISK_NOT_AVAILABLE");
                    }
                    ElementEvent event = new ElementEvent(ce, 5);
                    Iterator hIt = ((AbstractList)eventHandlers).iterator();
                    while (hIt.hasNext()) {
                        IElementEventHandler hand = (IElementEventHandler)hIt.next();
                        this.addElementEvent(hand, event);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Trouble handling the event", (Throwable)e);
            }
        }
    }

    public ICacheElement get(Serializable key) {
        return this.get(key, false);
    }

    public ICacheElement localGet(Serializable key) {
        return this.get(key, true);
    }

    protected ICacheElement get(Serializable key, boolean localOnly) {
        boolean found;
        ICacheElement element;
        block23: {
            element = null;
            found = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("get: key = " + key + ", localOnly = " + localOnly));
            }
            try {
                element = this.memCache.get(key);
                if (element != null) {
                    if (this.isExpired(element)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.cacheName + " - Memory cache hit, but element expired"));
                        }
                        ++this.missCountExpired;
                        this.remove(element);
                        element = null;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.cacheName + " - Memory cache hit"));
                        }
                        ++this.hitCountRam;
                    }
                    found = true;
                    break block23;
                }
                for (int i = 0; i < this.auxCaches.length; ++i) {
                    block25: {
                        long cacheType;
                        AuxiliaryCache aux;
                        block24: {
                            aux = this.auxCaches[i];
                            if (aux == null) continue;
                            cacheType = aux.getCacheType();
                            if (!localOnly) break block24;
                            if (cacheType != 2L) break block25;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Attempting to get from aux: " + aux.getCacheName() + " which is of type: " + cacheType));
                        }
                        try {
                            element = aux.get(key);
                        }
                        catch (IOException ex) {
                            log.error((Object)"Error getting from aux", (Throwable)ex);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Got CacheElement: " + element));
                    }
                    if (element == null) continue;
                    if (this.isExpired(element)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.cacheName + " - Aux cache[" + i + "] hit, but element expired"));
                        }
                        ++this.missCountExpired;
                        this.remove(element);
                        element = null;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.cacheName + " - Aux cache[" + i + "] hit"));
                        }
                        ++this.hitCountAux;
                        int n = i;
                        this.auxHitCountByIndex[n] = this.auxHitCountByIndex[n] + 1;
                        this.memCache.update(element);
                    }
                    found = true;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (!found) {
            ++this.missCountNotFound;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + " - Miss"));
            }
        }
        return element;
    }

    private boolean isExpired(ICacheElement element) {
        try {
            IElementAttributes attributes = element.getElementAttributes();
            if (!attributes.getIsEternal()) {
                long now = System.currentTimeMillis();
                long maxLifeSeconds = attributes.getMaxLifeSeconds();
                long createTime = attributes.getCreateTime();
                if (maxLifeSeconds != -1L && now - createTime > maxLifeSeconds * 1000L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exceeded maxLife: " + element.getKey()));
                    }
                    return true;
                }
                long idleTime = attributes.getIdleTime();
                long lastAccessTime = attributes.getLastAccessTime();
                if (idleTime != -1L && now - lastAccessTime > idleTime * 1000L) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)("Exceeded maxIdle: " + element.getKey()));
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error determining expiration period, expiring", (Throwable)e);
            return true;
        }
        return false;
    }

    public Set getGroupKeys(String group) {
        HashSet allKeys = new HashSet();
        allKeys.addAll(this.memCache.getGroupKeys(group));
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache aux = this.auxCaches[i];
            if (aux == null) continue;
            allKeys.addAll(aux.getGroupKeys(group));
        }
        return allKeys;
    }

    public boolean remove(Serializable key) {
        return this.remove(key, false);
    }

    public boolean localRemove(Serializable key) {
        return this.remove(key, true);
    }

    protected synchronized boolean remove(Serializable key, boolean localOnly) {
        boolean removed = false;
        try {
            removed = this.memCache.remove(key);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache aux = this.auxCaches[i];
            if (aux == null) continue;
            int cacheType = aux.getCacheType();
            if (localOnly && (cacheType == 4 || cacheType == 3)) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing " + key + " from cacheType" + cacheType));
                }
                boolean b = aux.remove(key);
                if (removed || cacheType == 4) continue;
                removed = b;
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"Failure removing from aux", (Throwable)ex);
            }
        }
        return removed;
    }

    public void removeAll() throws IOException {
        this.removeAll(false);
    }

    public void localRemoveAll() throws IOException {
        this.removeAll(true);
    }

    protected synchronized void removeAll(boolean localOnly) throws IOException {
        try {
            this.memCache.removeAll();
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        for (int i = 0; i < this.auxCaches.length; ++i) {
            AuxiliaryCache aux = this.auxCaches[i];
            int cacheType = aux.getCacheType();
            if (aux == null || cacheType != 2 && localOnly) continue;
            try {
                aux.removeAll();
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"Failure removing all from aux", (Throwable)ex);
            }
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    protected synchronized void dispose(boolean fromRemote) {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (int i = 0; i < this.auxCaches.length; ++i) {
            try {
                AuxiliaryCache aux = this.auxCaches[i];
                if (aux == null || aux.getStatus() != 1 || fromRemote && aux.getCacheType() == 4) continue;
                if (aux.getCacheType() != 3 || this.cacheAttr.getUseLateral()) {
                    Iterator itr = this.memCache.getIterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = (Map.Entry)itr.next();
                        ICacheElement ce = (ICacheElement)entry.getValue();
                        try {
                            if (aux.getCacheType() == 3 && !ce.getElementAttributes().getIsLateral()) continue;
                            aux.update(ce);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                }
                aux.dispose();
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"Failure disposing of aux", (Throwable)ex);
            }
        }
        log.warn((Object)("Called close for " + this.cacheName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.alive) {
            return;
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            for (int i = 0; i < this.auxCaches.length; ++i) {
                try {
                    AuxiliaryCache aux = this.auxCaches[i];
                    if (aux.getStatus() != 1) continue;
                    Iterator itr = this.memCache.getIterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = (Map.Entry)itr.next();
                        ICacheElement ce = (ICacheElement)entry.getValue();
                        aux.update(ce);
                    }
                    continue;
                }
                catch (IOException ex) {
                    log.error((Object)"Failure saving aux caches", (Throwable)ex);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Called save for " + this.cacheName));
        }
    }

    public int getSize() {
        return this.memCache.getSize();
    }

    public int getCacheType() {
        return 1;
    }

    public int getStatus() {
        return this.alive ? 1 : 2;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public IElementAttributes getElementAttributes() {
        return this.attr;
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttr = cattr;
        this.memCache.initialize(this);
    }

    public IElementAttributes getElementAttributes(Serializable key) throws CacheException, IOException {
        CacheElement ce = (CacheElement)this.get(key);
        if (ce == null) {
            throw new ObjectNotFoundException("key " + key + " is not found");
        }
        return ce.getElementAttributes();
    }

    public void addElementEvent(IElementEventHandler hand, IElementEvent event) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding to Q");
        }
        this.elementEventQ.addElementEvent(hand, event);
    }

    private void createMemoryCache(ICompositeCacheAttributes cattr) {
        if (this.memCache == null) {
            try {
                Class<?> c = Class.forName(cattr.getMemoryCacheName());
                this.memCache = (MemoryCache)c.newInstance();
                this.memCache.initialize(this);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to init mem cache, using: LRUMemoryCache", (Throwable)e);
                this.memCache = new LRUMemoryCache();
                this.memCache.initialize(this);
            }
        } else {
            log.warn((Object)"Refusing to create memory cache -- already exists.");
        }
    }

    public MemoryCache getMemoryCache() {
        return this.memCache;
    }

    public int getHitCountRam() {
        return this.hitCountRam;
    }

    public int getHitCountAux() {
        return this.hitCountAux;
    }

    public int getMissCountNotFound() {
        return this.missCountNotFound;
    }

    public int getMissCountExpired() {
        return this.missCountExpired;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

