/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    public static final String WEB_SITE_DTD = "http://db.apache.org/torque/dtd/database_3_2.dtd";
    private InputSource databaseDTD = null;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$engine$database$transform$DTDResolver == null ? (class$org$apache$torque$engine$database$transform$DTDResolver = DTDResolver.class$("org.apache.torque.engine.database.transform.DTDResolver")) : class$org$apache$torque$engine$database$transform$DTDResolver));
    static /* synthetic */ Class class$org$apache$torque$engine$database$transform$DTDResolver;

    public DTDResolver() throws SAXException {
        try {
            InputStream dtdStream = this.getClass().getResourceAsStream("database.dtd");
            if (dtdStream != null) {
                this.databaseDTD = new InputSource(dtdStream);
            } else {
                log.warn((Object)"Could not locate database.dtd");
            }
        }
        catch (Exception ex) {
            throw new SAXException("Could not get stream for database.dtd", ex);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (this.databaseDTD != null && WEB_SITE_DTD.equals(systemId)) {
            String pkg = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf(46));
            log.info((Object)("Resolver: used database.dtd from '" + pkg + "' package"));
            return this.databaseDTD;
        }
        if (systemId == null || "".equals(systemId.trim())) {
            log.info((Object)"Resolver: used 'http://db.apache.org/torque/dtd/database_3_2.dtd'");
            return this.getInputSource(WEB_SITE_DTD);
        }
        log.info((Object)("Resolver: used '" + systemId + '\''));
        return this.getInputSource(systemId);
    }

    private InputSource getInputSource(String urlString) throws IOException {
        URL url = new URL(urlString);
        return new InputSource(url.openStream());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

