/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.SchemaType;

public class TypeMap {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$engine$database$model$Column == null ? (class$org$apache$torque$engine$database$model$Column = TypeMap.class$("org.apache.torque.engine.database.model.Column")) : class$org$apache$torque$engine$database$model$Column));
    private static final SchemaType[] TEXT_TYPES = new SchemaType[]{SchemaType.CHAR, SchemaType.VARCHAR, SchemaType.LONGVARCHAR, SchemaType.CLOB, SchemaType.DATE, SchemaType.TIME, SchemaType.TIMESTAMP, SchemaType.BOOLEANCHAR};
    public static final String CHAR_OBJECT_TYPE = "\"\"";
    public static final String VARCHAR_OBJECT_TYPE = "\"\"";
    public static final String LONGVARCHAR_OBJECT_TYPE = "\"\"";
    public static final String CLOB_OBJECT_TYPE = "\"\"";
    public static final String NUMERIC_OBJECT_TYPE = "new BigDecimal(0)";
    public static final String DECIMAL_OBJECT_TYPE = "new BigDecimal(0)";
    public static final String BIT_OBJECT_TYPE = "new Boolean(true)";
    public static final String TINYINT_OBJECT_TYPE = "new Byte((byte)0)";
    public static final String SMALLINT_OBJECT_TYPE = "new Short((short)0)";
    public static final String INTEGER_OBJECT_TYPE = "new Integer(0)";
    public static final String BIGINT_OBJECT_TYPE = "new Long(0)";
    public static final String REAL_OBJECT_TYPE = "new Float(0)";
    public static final String FLOAT_OBJECT_TYPE = "new Double(0)";
    public static final String DOUBLE_OBJECT_TYPE = "new Double(0)";
    public static final String BINARY_OBJECT_TYPE = "new Object()";
    public static final String VARBINARY_OBJECT_TYPE = "new Object()";
    public static final String LONGVARBINARY_OBJECT_TYPE = "new Object()";
    public static final String BLOB_OBJECT_TYPE = "new Object()";
    public static final String DATE_OBJECT_TYPE = "new Date()";
    public static final String TIME_OBJECT_TYPE = "new Date()";
    public static final String TIMESTAMP_OBJECT_TYPE = "new Date()";
    public static final String BOOLEANCHAR_OBJECT_TYPE = "\"\"";
    public static final String BOOLEANINT_OBJECT_TYPE = "new Integer(0)";
    public static final String CHAR_NATIVE_TYPE = "String";
    public static final String VARCHAR_NATIVE_TYPE = "String";
    public static final String LONGVARCHAR_NATIVE_TYPE = "String";
    public static final String CLOB_NATIVE_TYPE = "String";
    public static final String NUMERIC_NATIVE_TYPE = "BigDecimal";
    public static final String DECIMAL_NATIVE_TYPE = "BigDecimal";
    public static final String BIT_NATIVE_TYPE = "boolean";
    public static final String TINYINT_NATIVE_TYPE = "byte";
    public static final String SMALLINT_NATIVE_TYPE = "short";
    public static final String INTEGER_NATIVE_TYPE = "int";
    public static final String BIGINT_NATIVE_TYPE = "long";
    public static final String REAL_NATIVE_TYPE = "float";
    public static final String FLOAT_NATIVE_TYPE = "double";
    public static final String DOUBLE_NATIVE_TYPE = "double";
    public static final String BINARY_NATIVE_TYPE = "byte[]";
    public static final String VARBINARY_NATIVE_TYPE = "byte[]";
    public static final String LONGVARBINARY_NATIVE_TYPE = "byte[]";
    public static final String BLOB_NATIVE_TYPE = "byte[]";
    public static final String DATE_NATIVE_TYPE = "Date";
    public static final String TIME_NATIVE_TYPE = "Date";
    public static final String TIMESTAMP_NATIVE_TYPE = "Date";
    public static final String BOOLEANCHAR_NATIVE_TYPE = "boolean";
    public static final String BOOLEANINT_NATIVE_TYPE = "boolean";
    public static final String BIT_NATIVE_OBJECT_TYPE = "Boolean";
    public static final String TINYINT_NATIVE_OBJECT_TYPE = "Byte";
    public static final String SMALLINT_NATIVE_OBJECT_TYPE = "Short";
    public static final String INTEGER_NATIVE_OBJECT_TYPE = "Integer";
    public static final String BIGINT_NATIVE_OBJECT_TYPE = "Long";
    public static final String REAL_NATIVE_OBJECT_TYPE = "Float";
    public static final String FLOAT_NATIVE_OBJECT_TYPE = "Double";
    public static final String DOUBLE_NATIVE_OBJECT_TYPE = "Double";
    public static final String BOOLEANCHAR_NATIVE_OBJECT_TYPE = "Boolean";
    public static final String BOOLEANINT_NATIVE_OBJECT_TYPE = "Boolean";
    public static final String CHAR_VILLAGE_METHOD = "asString()";
    public static final String VARCHAR_VILLAGE_METHOD = "asString()";
    public static final String LONGVARCHAR_VILLAGE_METHOD = "asString()";
    public static final String CLOB_VILLAGE_METHOD = "asString()";
    public static final String NUMERIC_VILLAGE_METHOD = "asBigDecimal()";
    public static final String DECIMAL_VILLAGE_METHOD = "asBigDecimal()";
    public static final String BIT_VILLAGE_METHOD = "asBoolean()";
    public static final String TINYINT_VILLAGE_METHOD = "asByte()";
    public static final String SMALLINT_VILLAGE_METHOD = "asShort()";
    public static final String INTEGER_VILLAGE_METHOD = "asInt()";
    public static final String BIGINT_VILLAGE_METHOD = "asLong()";
    public static final String REAL_VILLAGE_METHOD = "asFloat()";
    public static final String FLOAT_VILLAGE_METHOD = "asDouble()";
    public static final String DOUBLE_VILLAGE_METHOD = "asDouble()";
    public static final String BINARY_VILLAGE_METHOD = "asBytes()";
    public static final String VARBINARY_VILLAGE_METHOD = "asBytes()";
    public static final String LONGVARBINARY_VILLAGE_METHOD = "asBytes()";
    public static final String BLOB_VILLAGE_METHOD = "asBytes()";
    public static final String DATE_VILLAGE_METHOD = "asUtilDate()";
    public static final String TIME_VILLAGE_METHOD = "asUtilDate()";
    public static final String TIMESTAMP_VILLAGE_METHOD = "asUtilDate()";
    public static final String BOOLEANCHAR_VILLAGE_METHOD = "asBoolean()";
    public static final String BOOLEANINT_VILLAGE_METHOD = "asBoolean()";
    public static final String BIT_VILLAGE_OBJECT_METHOD = "asBooleanObj()";
    public static final String TINYINT_VILLAGE_OBJECT_METHOD = "asByteObj()";
    public static final String SMALLINT_VILLAGE_OBJECT_METHOD = "asShortObj()";
    public static final String INTEGER_VILLAGE_OBJECT_METHOD = "asIntegerObj()";
    public static final String BIGINT_VILLAGE_OBJECT_METHOD = "asLongObj()";
    public static final String REAL_VILLAGE_OBJECT_METHOD = "asFloatObj()";
    public static final String FLOAT_VILLAGE_OBJECT_METHOD = "asDoubleObj()";
    public static final String DOUBLE_VILLAGE_OBJECT_METHOD = "asDoubleObj()";
    public static final String BOOLEANCHAR_VILLAGE_OBJECT_METHOD = "asBooleanObj()";
    public static final String BOOLEANINT_VILLAGE_OBJECT_METHOD = "asBooleanObj()";
    public static final String CHAR_PP_METHOD = "getString(ppKey)";
    public static final String VARCHAR_PP_METHOD = "getString(ppKey)";
    public static final String LONGVARCHAR_PP_METHOD = "getString(ppKey)";
    public static final String NUMERIC_PP_METHOD = "getBigDecimal(ppKey)";
    public static final String DECIMAL_PP_METHOD = "getBigDecimal(ppKey)";
    public static final String BIT_PP_METHOD = "getBoolean(ppKey)";
    public static final String TINYINT_PP_METHOD = "getByte(ppKey)";
    public static final String SMALLINT_PP_METHOD = "getShort(ppKey)";
    public static final String INTEGER_PP_METHOD = "getInt(ppKey)";
    public static final String BIGINT_PP_METHOD = "getLong(ppKey)";
    public static final String REAL_PP_METHOD = "getFloat(ppKey)";
    public static final String FLOAT_PP_METHOD = "getDouble(ppKey)";
    public static final String DOUBLE_PP_METHOD = "getDouble(ppKey)";
    public static final String BINARY_PP_METHOD = "getBytes(ppKey)";
    public static final String VARBINARY_PP_METHOD = "getBytes(ppKey)";
    public static final String LONGVARBINARY_PP_METHOD = "getBytes(ppKey)";
    public static final String DATE_PP_METHOD = "getDate(ppKey)";
    public static final String TIME_PP_METHOD = "getDate(ppKey)";
    public static final String TIMESTAMP_PP_METHOD = "getDate(ppKey)";
    public static final String BOOLEANCHAR_PP_METHOD = "getBoolean(ppKey)";
    public static final String BOOLEANINT_PP_METHOD = "getBoolean(ppKey)";
    private static Hashtable jdbcToJavaObjectMap = null;
    private static Hashtable jdbcToJavaNativeMap = null;
    private static Hashtable jdbcToJavaNativeObjectMap = null;
    private static Hashtable jdbcToVillageMethodMap = null;
    private static Hashtable jdbcToVillageObjectMethodMap = null;
    private static Hashtable jdbcToPPMethodMap = null;
    private static Hashtable torqueTypeToJdbcTypeMap = null;
    private static Hashtable jdbcToTorqueTypeMap = null;
    private static boolean isInitialized = false;
    static /* synthetic */ Class class$org$apache$torque$engine$database$model$Column;

    public static synchronized void initialize() {
        if (!isInitialized) {
            jdbcToJavaObjectMap = new Hashtable();
            jdbcToJavaObjectMap.put(SchemaType.CHAR, "\"\"");
            jdbcToJavaObjectMap.put(SchemaType.VARCHAR, "\"\"");
            jdbcToJavaObjectMap.put(SchemaType.LONGVARCHAR, "\"\"");
            jdbcToJavaObjectMap.put(SchemaType.CLOB, "\"\"");
            jdbcToJavaObjectMap.put(SchemaType.NUMERIC, "new BigDecimal(0)");
            jdbcToJavaObjectMap.put(SchemaType.DECIMAL, "new BigDecimal(0)");
            jdbcToJavaObjectMap.put(SchemaType.BIT, BIT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(SchemaType.TINYINT, TINYINT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(SchemaType.SMALLINT, SMALLINT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(SchemaType.INTEGER, "new Integer(0)");
            jdbcToJavaObjectMap.put(SchemaType.BIGINT, BIGINT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(SchemaType.REAL, REAL_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(SchemaType.FLOAT, "new Double(0)");
            jdbcToJavaObjectMap.put(SchemaType.DOUBLE, "new Double(0)");
            jdbcToJavaObjectMap.put(SchemaType.BINARY, "new Object()");
            jdbcToJavaObjectMap.put(SchemaType.VARBINARY, "new Object()");
            jdbcToJavaObjectMap.put(SchemaType.LONGVARBINARY, "new Object()");
            jdbcToJavaObjectMap.put(SchemaType.BLOB, "new Object()");
            jdbcToJavaObjectMap.put(SchemaType.DATE, "new Date()");
            jdbcToJavaObjectMap.put(SchemaType.TIME, "new Date()");
            jdbcToJavaObjectMap.put(SchemaType.TIMESTAMP, "new Date()");
            jdbcToJavaObjectMap.put(SchemaType.BOOLEANCHAR, "\"\"");
            jdbcToJavaObjectMap.put(SchemaType.BOOLEANINT, "new Integer(0)");
            jdbcToJavaNativeMap = new Hashtable();
            jdbcToJavaNativeMap.put(SchemaType.CHAR, "String");
            jdbcToJavaNativeMap.put(SchemaType.VARCHAR, "String");
            jdbcToJavaNativeMap.put(SchemaType.LONGVARCHAR, "String");
            jdbcToJavaNativeMap.put(SchemaType.CLOB, "String");
            jdbcToJavaNativeMap.put(SchemaType.NUMERIC, "BigDecimal");
            jdbcToJavaNativeMap.put(SchemaType.DECIMAL, "BigDecimal");
            jdbcToJavaNativeMap.put(SchemaType.BIT, "boolean");
            jdbcToJavaNativeMap.put(SchemaType.TINYINT, TINYINT_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(SchemaType.SMALLINT, SMALLINT_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(SchemaType.INTEGER, INTEGER_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(SchemaType.BIGINT, BIGINT_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(SchemaType.REAL, REAL_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(SchemaType.FLOAT, "double");
            jdbcToJavaNativeMap.put(SchemaType.DOUBLE, "double");
            jdbcToJavaNativeMap.put(SchemaType.BINARY, "byte[]");
            jdbcToJavaNativeMap.put(SchemaType.VARBINARY, "byte[]");
            jdbcToJavaNativeMap.put(SchemaType.LONGVARBINARY, "byte[]");
            jdbcToJavaNativeMap.put(SchemaType.BLOB, "byte[]");
            jdbcToJavaNativeMap.put(SchemaType.DATE, "Date");
            jdbcToJavaNativeMap.put(SchemaType.TIME, "Date");
            jdbcToJavaNativeMap.put(SchemaType.TIMESTAMP, "Date");
            jdbcToJavaNativeMap.put(SchemaType.BOOLEANCHAR, "boolean");
            jdbcToJavaNativeMap.put(SchemaType.BOOLEANINT, "boolean");
            jdbcToJavaNativeObjectMap = new Hashtable();
            jdbcToJavaNativeObjectMap.put(SchemaType.BIT, "Boolean");
            jdbcToJavaNativeObjectMap.put(SchemaType.TINYINT, TINYINT_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(SchemaType.SMALLINT, SMALLINT_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(SchemaType.INTEGER, INTEGER_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(SchemaType.BIGINT, BIGINT_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(SchemaType.REAL, REAL_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(SchemaType.FLOAT, "Double");
            jdbcToJavaNativeObjectMap.put(SchemaType.DOUBLE, "Double");
            jdbcToJavaNativeObjectMap.put(SchemaType.BOOLEANCHAR, "Boolean");
            jdbcToJavaNativeObjectMap.put(SchemaType.BOOLEANINT, "Boolean");
            jdbcToVillageMethodMap = new Hashtable();
            jdbcToVillageMethodMap.put(SchemaType.CHAR, "asString()");
            jdbcToVillageMethodMap.put(SchemaType.VARCHAR, "asString()");
            jdbcToVillageMethodMap.put(SchemaType.LONGVARCHAR, "asString()");
            jdbcToVillageMethodMap.put(SchemaType.CLOB, "asString()");
            jdbcToVillageMethodMap.put(SchemaType.NUMERIC, "asBigDecimal()");
            jdbcToVillageMethodMap.put(SchemaType.DECIMAL, "asBigDecimal()");
            jdbcToVillageMethodMap.put(SchemaType.BIT, "asBoolean()");
            jdbcToVillageMethodMap.put(SchemaType.TINYINT, TINYINT_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(SchemaType.SMALLINT, SMALLINT_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(SchemaType.INTEGER, INTEGER_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(SchemaType.BIGINT, BIGINT_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(SchemaType.REAL, REAL_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(SchemaType.FLOAT, "asDouble()");
            jdbcToVillageMethodMap.put(SchemaType.DOUBLE, "asDouble()");
            jdbcToVillageMethodMap.put(SchemaType.BINARY, "asBytes()");
            jdbcToVillageMethodMap.put(SchemaType.VARBINARY, "asBytes()");
            jdbcToVillageMethodMap.put(SchemaType.LONGVARBINARY, "asBytes()");
            jdbcToVillageMethodMap.put(SchemaType.BLOB, "asBytes()");
            jdbcToVillageMethodMap.put(SchemaType.DATE, "asUtilDate()");
            jdbcToVillageMethodMap.put(SchemaType.TIME, "asUtilDate()");
            jdbcToVillageMethodMap.put(SchemaType.TIMESTAMP, "asUtilDate()");
            jdbcToVillageMethodMap.put(SchemaType.BOOLEANCHAR, "asBoolean()");
            jdbcToVillageMethodMap.put(SchemaType.BOOLEANINT, "asBoolean()");
            jdbcToVillageObjectMethodMap = new Hashtable();
            jdbcToVillageObjectMethodMap.put(SchemaType.BIT, "asBooleanObj()");
            jdbcToVillageObjectMethodMap.put(SchemaType.TINYINT, TINYINT_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(SchemaType.SMALLINT, SMALLINT_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(SchemaType.INTEGER, INTEGER_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(SchemaType.BIGINT, BIGINT_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(SchemaType.REAL, REAL_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(SchemaType.FLOAT, "asDoubleObj()");
            jdbcToVillageObjectMethodMap.put(SchemaType.DOUBLE, "asDoubleObj()");
            jdbcToVillageObjectMethodMap.put(SchemaType.BOOLEANCHAR, "asBooleanObj()");
            jdbcToVillageObjectMethodMap.put(SchemaType.BOOLEANINT, "asBooleanObj()");
            jdbcToPPMethodMap = new Hashtable();
            jdbcToPPMethodMap.put(SchemaType.CHAR, "getString(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.VARCHAR, "getString(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.LONGVARCHAR, "getString(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.NUMERIC, "getBigDecimal(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.DECIMAL, "getBigDecimal(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.BIT, "getBoolean(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.TINYINT, TINYINT_PP_METHOD);
            jdbcToPPMethodMap.put(SchemaType.SMALLINT, SMALLINT_PP_METHOD);
            jdbcToPPMethodMap.put(SchemaType.INTEGER, INTEGER_PP_METHOD);
            jdbcToPPMethodMap.put(SchemaType.BIGINT, BIGINT_PP_METHOD);
            jdbcToPPMethodMap.put(SchemaType.REAL, REAL_PP_METHOD);
            jdbcToPPMethodMap.put(SchemaType.FLOAT, "getDouble(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.DOUBLE, "getDouble(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.BINARY, "getBytes(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.VARBINARY, "getBytes(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.LONGVARBINARY, "getBytes(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.DATE, "getDate(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.TIME, "getDate(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.TIMESTAMP, "getDate(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.BOOLEANCHAR, "getBoolean(ppKey)");
            jdbcToPPMethodMap.put(SchemaType.BOOLEANINT, "getBoolean(ppKey)");
            torqueTypeToJdbcTypeMap = new Hashtable();
            Iterator iter = SchemaType.iterator();
            while (iter.hasNext()) {
                SchemaType type = (SchemaType)((Object)iter.next());
                torqueTypeToJdbcTypeMap.put(type, type);
            }
            torqueTypeToJdbcTypeMap.put(SchemaType.BOOLEANCHAR, SchemaType.CHAR);
            torqueTypeToJdbcTypeMap.put(SchemaType.BOOLEANINT, SchemaType.INTEGER);
            jdbcToTorqueTypeMap = new Hashtable();
            jdbcToTorqueTypeMap.put(new Integer(1), SchemaType.CHAR);
            jdbcToTorqueTypeMap.put(new Integer(12), SchemaType.VARCHAR);
            jdbcToTorqueTypeMap.put(new Integer(-1), SchemaType.LONGVARCHAR);
            jdbcToTorqueTypeMap.put(new Integer(2005), SchemaType.CLOB);
            jdbcToTorqueTypeMap.put(new Integer(2), SchemaType.NUMERIC);
            jdbcToTorqueTypeMap.put(new Integer(3), SchemaType.DECIMAL);
            jdbcToTorqueTypeMap.put(new Integer(-7), SchemaType.BIT);
            jdbcToTorqueTypeMap.put(new Integer(-6), SchemaType.TINYINT);
            jdbcToTorqueTypeMap.put(new Integer(5), SchemaType.SMALLINT);
            jdbcToTorqueTypeMap.put(new Integer(4), SchemaType.INTEGER);
            jdbcToTorqueTypeMap.put(new Integer(-5), SchemaType.BIGINT);
            jdbcToTorqueTypeMap.put(new Integer(7), SchemaType.REAL);
            jdbcToTorqueTypeMap.put(new Integer(6), SchemaType.FLOAT);
            jdbcToTorqueTypeMap.put(new Integer(8), SchemaType.DOUBLE);
            jdbcToTorqueTypeMap.put(new Integer(-2), SchemaType.BINARY);
            jdbcToTorqueTypeMap.put(new Integer(-3), SchemaType.VARBINARY);
            jdbcToTorqueTypeMap.put(new Integer(-4), SchemaType.LONGVARBINARY);
            jdbcToTorqueTypeMap.put(new Integer(2004), SchemaType.BLOB);
            jdbcToTorqueTypeMap.put(new Integer(91), SchemaType.DATE);
            jdbcToTorqueTypeMap.put(new Integer(92), SchemaType.TIME);
            jdbcToTorqueTypeMap.put(new Integer(93), SchemaType.TIMESTAMP);
            isInitialized = true;
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static String getJavaObject(SchemaType jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToJavaObjectMap.get((Object)jdbcType);
    }

    public static String getJavaNative(SchemaType jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToJavaNativeMap.get((Object)jdbcType);
    }

    public static String getJavaNativeObject(SchemaType jdbcType) {
        String s;
        if (!isInitialized) {
            TypeMap.initialize();
        }
        if ((s = (String)jdbcToJavaNativeObjectMap.get((Object)jdbcType)) == null) {
            s = (String)jdbcToJavaNativeMap.get((Object)jdbcType);
        }
        return s;
    }

    public static String getVillageMethod(SchemaType jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToVillageMethodMap.get((Object)jdbcType);
    }

    public static String getVillageObjectMethod(SchemaType jdbcType) {
        String s;
        if (!isInitialized) {
            TypeMap.initialize();
        }
        if ((s = (String)jdbcToVillageObjectMethodMap.get((Object)jdbcType)) == null) {
            s = (String)jdbcToVillageMethodMap.get((Object)jdbcType);
        }
        return s;
    }

    public static String getPPMethod(SchemaType jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToPPMethodMap.get((Object)jdbcType);
    }

    public static SchemaType getJdbcType(SchemaType type) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (SchemaType)((Object)torqueTypeToJdbcTypeMap.get((Object)type));
    }

    public static SchemaType getTorqueType(Integer sqlType) {
        SchemaType st;
        if (!isInitialized) {
            TypeMap.initialize();
        }
        if ((st = (SchemaType)((Object)jdbcToTorqueTypeMap.get(sqlType))) == null) {
            st = SchemaType.VARCHAR;
            log.warn((Object)("SchemaType for JdbcType '" + sqlType + "' is not defined: Defaulting to '" + (Object)((Object)st) + '\''));
        }
        return st;
    }

    public static boolean isBooleanInt(SchemaType type) {
        return SchemaType.BOOLEANINT.equals((Object)type);
    }

    public static boolean isBooleanChar(SchemaType type) {
        return SchemaType.BOOLEANCHAR.equals((Object)type);
    }

    public static boolean isBit(SchemaType type) {
        return SchemaType.BIT.equals((Object)type);
    }

    public static final boolean isTextType(SchemaType type) {
        for (int i = 0; i < TEXT_TYPES.length; ++i) {
            if (!type.equals((Object)TEXT_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

