/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.util.SqlEnum;
import org.apache.torque.util.UniqueList;

public class Query {
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private static final String WHERE = " WHERE ";
    private static final String AND = " AND ";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String GROUP_BY = " GROUP BY ";
    private static final String HAVING = " HAVING ";
    private static final String LIMIT = " LIMIT ";
    private static final String ROWCOUNT = " SET ROWCOUNT ";
    private UniqueList selectModifiers = new UniqueList();
    private UniqueList selectColumns = new UniqueList();
    private UniqueList fromTables = new UniqueList();
    private UniqueList whereCriteria = new UniqueList();
    private UniqueList orderByColumns = new UniqueList();
    private UniqueList groupByColumns = new UniqueList();
    private String having;
    private String limit;
    private String preLimit;
    private String postLimit;
    private String rowcount;

    public UniqueList getSelectModifiers() {
        return this.selectModifiers;
    }

    public void setSelectModifiers(UniqueList modifiers) {
        this.selectModifiers = modifiers;
    }

    public UniqueList getSelectClause() {
        return this.selectColumns;
    }

    public void setSelectClause(UniqueList columns) {
        this.selectColumns = columns;
    }

    public UniqueList getFromClause() {
        return this.fromTables;
    }

    public void setFromClause(UniqueList tables) {
        this.fromTables = tables;
    }

    public UniqueList getWhereClause() {
        return this.whereCriteria;
    }

    public void setWhereClause(UniqueList where) {
        this.whereCriteria = where;
    }

    public UniqueList getOrderByClause() {
        return this.orderByColumns;
    }

    public UniqueList getGroupByClause() {
        return this.groupByColumns;
    }

    public void setHaving(String having) {
        this.having = having;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public void setPreLimit(String preLimit) {
        this.preLimit = preLimit;
    }

    public void setPostLimit(String postLimit) {
        this.postLimit = postLimit;
    }

    public void setRowcount(String rowcount) {
        this.rowcount = rowcount;
    }

    public String getHaving() {
        return this.having;
    }

    public String getLimit() {
        return this.limit;
    }

    public String getPostLimit() {
        return this.postLimit;
    }

    public String getPreLimit() {
        return this.preLimit;
    }

    public boolean hasLimit() {
        return this.preLimit != null || this.postLimit != null || this.limit != null;
    }

    public String getRowcount() {
        return this.rowcount;
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer stmt) {
        if (this.preLimit != null) {
            stmt.append(this.preLimit);
        }
        if (this.rowcount != null) {
            stmt.append(ROWCOUNT).append(this.rowcount).append(" ");
        }
        stmt.append(SELECT).append(StringUtils.join(this.selectModifiers.iterator(), (String)" ")).append(StringUtils.join(this.selectColumns.iterator(), (String)", ")).append(FROM);
        boolean first = true;
        Iterator it = this.fromTables.iterator();
        while (it.hasNext()) {
            FromElement fromElement = (FromElement)it.next();
            if (!first && fromElement.getJoinCondition() == null) {
                stmt.append(", ");
            }
            first = false;
            stmt.append(fromElement.toString());
        }
        if (!this.whereCriteria.isEmpty()) {
            stmt.append(WHERE).append(StringUtils.join(this.whereCriteria.iterator(), (String)AND));
        }
        if (!this.groupByColumns.isEmpty()) {
            stmt.append(GROUP_BY).append(StringUtils.join(this.groupByColumns.iterator(), (String)", "));
        }
        if (this.having != null) {
            stmt.append(HAVING).append(this.having);
        }
        if (!this.orderByColumns.isEmpty()) {
            stmt.append(ORDER_BY).append(StringUtils.join(this.orderByColumns.iterator(), (String)", "));
        }
        if (this.limit != null) {
            stmt.append(LIMIT).append(this.limit);
        }
        if (this.rowcount != null) {
            stmt.append(ROWCOUNT).append("0");
        }
        if (this.postLimit != null) {
            stmt.append(this.postLimit);
        }
        return stmt;
    }

    public static class FromElement {
        String tableName = null;
        SqlEnum joinType = null;
        String joinCondition = null;

        public FromElement(String tableName, SqlEnum joinType, String joinCondition) {
            this.tableName = tableName;
            this.joinType = joinType;
            this.joinCondition = joinCondition;
        }

        public String getJoinCondition() {
            return this.joinCondition;
        }

        public SqlEnum getJoinType() {
            return this.joinType;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            if (this.joinType != null) {
                result.append(this.joinType);
            }
            result.append(this.tableName);
            if (this.joinCondition != null) {
                result.append(SqlEnum.ON);
                result.append(this.joinCondition);
            }
            return result.toString();
        }
    }
}

