/***************************************************************************/
/*! \file   csourceformat.h
    \brief  饹CSourceFormatΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  6 13  15:46:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CSOURCEFORMAT_H
#define CSOURCEFORMAT_H

#include <qstring.h>
#include <qstringlist.h>

/*-------------------------------------------------------------------------*/
/*! \class  CSourceFormat
    \brief  Υץ󥰥եޥåȡͥץ󥰥졼
    ݲ饹
*/
/*-------------------------------------------------------------------------*/
class CSourceFormat
{
public:
  enum SampleFormat {
    U8     = 0, 
    S16_LE = 1, 
    S16_BE = 2, 
    S24_LE = 3, 
    S24_BE = 4, 
    S32_LE = 5,
    S32_BE = 6, 
    F32_LE = 7, 
    F32_BE = 8,
    Invalid = -1
  };
  //! \brief ץ󥰥եޥåȤEcasoundͭʸ֤
  static QString      sampleFormatString(SampleFormat format);
  //! \brief ץ󥰥եޥåʸꥹȤ֤
  static QStringList  sampleFormatStringList();
  //! \brief EcasoundͭΥץ󥰥եޥåʸ󤫤
  //! ̻Ҥ֤
  static SampleFormat sampleFormatIdentifier(const QString& strFormat);

  //! \brief 󥹥ȥ饯
  CSourceFormat(SampleFormat format=S16_LE, 
                int          nChannel=2, 
                int          nRate=44100);
  //! \brief 󥹥ȥ饯
  //! \param strEcaFormat EcasoundǻѤեޥåʸ
  //!        "s16_le,2,44100"
  CSourceFormat(const QString& strEcaFormat);
  //! \brief ǥȥ饯
  virtual ~CSourceFormat();

  //! \brief ץ󥰥եޥåȤ֤
  SampleFormat sampleFormat() const;
  //! \brief ֤ͥ
  int          channelCount() const;
  //! \brief ץ󥰥졼Ȥ֤
  int          sampleRate() const;

  //! \brief ץ󥰥եޥåȤꤹ롣
  void         setSampleFormat(SampleFormat format);
  //! \brief ץ󥰥եޥåȤꤹ롣
  void         setSampleFormat(const QString& strFormat);
  //! \brief ͥꤹ롣
  void         setChannelCount(int nChannel);
  //! \brief ץ󥰥졼Ȥꤹ롣
  void         setSampleRate(int nRate);

  //! \brief EcasoundǻѤեޥåʸ֤
  QString      sourceFormatInString() const;

private:
  SampleFormat sfFormat;
  int          nChannelCount;
  int          nSampleRate;
};

#endif
