/***************************************************************************
                          cladspapluginlibrary.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 18  22:43:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlibrary.h>
#include "cladspapluginlibrary.h"

/////////////////////////////////////////////////////////////////////////////

CLadspaPluginLibrary::CLadspaPluginLibrary(const QString& strLibFileName)
{
  QLibrary library(strLibFileName);
  library.load();
  library.setAutoUnload(true);

  LADSPA_Descriptor_Function getDescriptor;
  if ( (getDescriptor = 
        (LADSPA_Descriptor_Function)(library.resolve("ladspa_descriptor"))) == NULL ) {
    strFileName = "";
    return;
  }

  const LADSPA_Descriptor* Desc;

  int nEffects = 0;
  while ( (Desc = getDescriptor(nEffects)) != NULL ) {
    CLadspaEffect effect(strLibFileName, Desc);
    if ( effect.effectPortCount() == 0 ) {
      nEffects++;
      continue;
    }

    effects.push_back(effect);
    nEffects++;
  }

  this->strFileName = strLibFileName;
}

/////////////////////////////////////////////////////////////////////////////

CLadspaPluginLibrary::CLadspaPluginLibrary(const CLadspaPluginLibrary& src)
{
  strFileName = src.strFileName;
  effects = src.effects;
}

/////////////////////////////////////////////////////////////////////////////

CLadspaPluginLibrary::~CLadspaPluginLibrary()
{
}

/////////////////////////////////////////////////////////////////////////////

CLadspaPluginLibrary&
CLadspaPluginLibrary::operator=(const CLadspaPluginLibrary& src)
{
  strFileName = src.strFileName;
  effects = src.effects;

  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

bool
CLadspaPluginLibrary::isLadspaPluginLibrary() const
{
  if ( strFileName.isEmpty() ) {
    return false;
  } else {
    return true;
  }
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaPluginLibrary::fileName() const
{
  return strFileName;
}

/////////////////////////////////////////////////////////////////////////////

int
CLadspaPluginLibrary::effectCount() const
{
  return effects.size();
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect
CLadspaPluginLibrary::effect(int nIndex) const
{
  if ( (nIndex < 0) || (effects.size() <= static_cast<uint>(nIndex)) ) {
    return CLadspaEffect();
  }

  return effects[nIndex];
}
    
/////////////////////////////////////////////////////////////////////////////
