/***************************************************************************
                          cladspaeffect.cpp  -  description
                             -------------------
    begin                : 2004ǯ  8  1  21:42:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cecaladspaeffect.h"

/////////////////////////////////////////////////////////////////////////////

CEcaLadspaEffect::CEcaLadspaEffect()
  : CLadspaEffect()
{
  
}

/////////////////////////////////////////////////////////////////////////////

CEcaLadspaEffect::CEcaLadspaEffect(
  const QString& strLibFileName,
  const LADSPA_Descriptor* Desc)
  : CLadspaEffect(strLibFileName, Desc)
{
}

/////////////////////////////////////////////////////////////////////////////

CEcaLadspaEffect::CEcaLadspaEffect(const CLadspaEffect& effect)
  : CLadspaEffect(effect)
{
}

/////////////////////////////////////////////////////////////////////////////

CEcaLadspaEffect::CEcaLadspaEffect(const CEcaLadspaEffect& src)
  : CLadspaEffect(src)
{
}

/////////////////////////////////////////////////////////////////////////////

CEcaLadspaEffect::~CEcaLadspaEffect()
{
}

/////////////////////////////////////////////////////////////////////////////

CEcaLadspaEffect&
CEcaLadspaEffect::operator=(const CEcaLadspaEffect& src)
{
  CLadspaEffect::operator=(src);
  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

QString
CEcaLadspaEffect::settingInEcaFormat() const
{
  QString strReturn = "-el:";

  strReturn += label();

  int nCount = effectPortCount();
  int i;
  for ( i = 0; i < nCount; i++ ) {
    strReturn += ",";
    CEffectPort port = effectPort(i);

    switch ( port.type() ) {
    case NEffectPort::Bool:
      if ( port.value().bVal ) {
	strReturn += "1";
      } else {
	strReturn += "0";
      }
      break;
    case NEffectPort::Int:
      strReturn += QString("%1").arg(port.value().nVal);
      break;
    case NEffectPort::Float:
      strReturn += QString("%1").arg(port.value().fVal);
      break;
    default:
      break;
    } 
  }

  return strReturn;
}
  
/////////////////////////////////////////////////////////////////////////////

int 
CEcaLadspaEffect::effectPortCount() const
{
  return CLadspaEffect::effectPortCount();
}

/////////////////////////////////////////////////////////////////////////////

QString 
CEcaLadspaEffect::effectPortInEcaFormat(int nPortID) const
{
  CEffectPort port(effectPort(nPortID));

  switch ( port.type() ) {
  case NEffectPort::Bool:
    if ( port.value().bVal ) {
      return "1";
    } else {
      return "0";
    }
    break;
  case NEffectPort::Int:
    return QString("%1").arg(port.value().nVal);
    break;
  case NEffectPort::Float:
    return QString("%1").arg(port.value().fVal);
    break;
  default:
    break;
  } 

  return "";
}

/////////////////////////////////////////////////////////////////////////////
