static char sccsid[]="%Z% %M% %I% %D% %T%";
/*************************************************
 *
 *  akbCrePack.c
 *
 *        coded by A.Kobayashi 2000/7/26
 *
 *************************************************/
#include "akbcommon.h"

/********************************************************/
/*                                                      */
/********************************************************/
int akb_create_pk_data(applid,tpHead,tpSendMsgCom,cppPacket)
char            *applid;
tdtCOMM_PACK_HEAD   *tpHead;
tdtMSG_COM       *tpSendMsgCom;
char            **cppPacket;
{
	INT4 lPackLen, lFileLen, lw, lLen;
	char *cpPacket,*cp,*cpF,cver;
	int i,l,iHSize,iINDIRECT;
	struct stat tStat;
	tdtCOMM_PACK_HEADA  *pHA;

	if (!tpHead || !tpSendMsgCom || !cppPacket) return -1;
	*cppPacket = NULL;
	if (tpSendMsgCom->msg_mlen < 0 ||
	    (tpSendMsgCom->msg_mlen>0 && !tpSendMsgCom->msg_pmsg))
		return -1;
	iINDIRECT = (tpSendMsgCom->msg_form & AKB_PFM_INDIRECT)
	        /* |(tpHead->PrtclId.cSendPrtcl & AKB_PFM_INDIRECT)*/;
	if (tpSendMsgCom->msg_filc>0 && tpSendMsgCom->msg_filv) iINDIRECT = 1;
	AKBGETHSIZEETC(tpHead,cver,pHA,iHSize,lLen)
	if (iINDIRECT) {
		lPackLen = iHSize+tpSendMsgCom->msg_mlen+4+sizeof(INT4);
		if (tpSendMsgCom->msg_filc>0 && !tpSendMsgCom->msg_filv) return -2;
		for (i=0;i<tpSendMsgCom->msg_filc;i++) {
			if (!(cpF=tpSendMsgCom->msg_filv[i])) return -3;
			if (!(l=strlen(cpF))) return -4;
			lPackLen += l+4+sizeof(INT4);
		}
		if (!(cpPacket=Malloc(lPackLen+1))) return D_ERR_MEM_ALLOC;
		*cppPacket = cpPacket;
		lw = lPackLen - iHSize;
		if (cver == 'A') pHA->pha_plen = htonl(lw);
		else tpHead->cph_plen = htonl(lw);
		memcpy(cpPacket,tpHead,iHSize);
		cp = cpPacket + iHSize;
		*cp++ = 'P';
		*cp++ = '\0';
		*cp++ = '\0';
		*cp++ = '\0';
		lw = htonl(tpSendMsgCom->msg_mlen);
		memcpy(cp,(char *)&lw,sizeof(INT4));
		cp += sizeof(INT4);
		if (tpSendMsgCom->msg_mlen && tpSendMsgCom->msg_pmsg)
			memcpy(cp,tpSendMsgCom->msg_pmsg,tpSendMsgCom->msg_mlen);
		cp += tpSendMsgCom->msg_mlen;
		for (i=0;i<tpSendMsgCom->msg_filc;i++) {
			if (!(cpF = tpSendMsgCom->msg_filv[i])) return -3;
			l   = strlen(cpF);
			*cp++ = 'F';
			*cp++ = l + sizeof(INT4);
			*cp++ = '\0';
			*cp++ = '\0';
			if (stat(akb_akb_home_add(cpF),&tStat)) return -5;
			lFileLen = tStat.st_size;
			lw = htonl(lFileLen);
			memcpy(cp,(char *)&lw,sizeof(INT4));
			cp += sizeof(INT4);
			memcpy(cp,cpF,l);
			cp += l;
		}
		tpHead = (pCOMM_PACK_HEAD)cpPacket;
		tpHead->cph_prt.prt_send |= AKB_PFM_INDIRECT;
	}
	else {
		if ((l=tpSendMsgCom->msg_mlen) > 0) l++;
		if (!(cpPacket=Malloc(iHSize+l)))
			return -6;
		if (cver == 'A') pHA->pha_plen = htonl(tpSendMsgCom->msg_mlen);
		else tpHead->cph_plen = htonl(tpSendMsgCom->msg_mlen);
		memcpy(cpPacket,tpHead,iHSize);
		if (tpSendMsgCom->msg_mlen && tpSendMsgCom->msg_pmsg)
			memcpy(cpPacket+iHSize,tpSendMsgCom->msg_pmsg,
			       tpSendMsgCom->msg_mlen);
	}
	if (applid) {
		i = akb_mem_to_indir_f(applid,cpPacket,cpPacket+iHSize,&cp);
#ifdef DEBUG
printf("CreatePkData: akb_mem_to_indir_f irc=%d\n",i);
#endif
		if (i<0) return i;
		else if (i>0) {
			Free(cpPacket);
			cpPacket = cp;
		}
	}
	*cppPacket = cpPacket;
	tpHead = (pCOMM_PACK_HEAD)cpPacket;
	AKBGETHSIZEETC(tpHead,cver,pHA,iHSize,lLen)
	lPackLen = iHSize + lLen;
#ifdef DEBUG_X
akxaxdump("CreatePkData",cpPacket,lPackLen);
#endif
	return lPackLen;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_recv_msg(pPacket,tpRcMsg,cppFilev,cppToFree)
char       *pPacket;
tdtMSG_COM  *tpRcMsg;
char       **cppFilev;
char       **cppToFree;
{
	tdtCOMM_PACK_HEAD   *pHead,tHead;
	pCOMM_PACK_HEADB   pHeadB;
	pCOMM_PACK_HEADA   pHeadA;
	char *pPa, cver;
	int iRc,iHSize;
	INT4 lLen, lm, ld, lw;

	if (!pPacket || !tpRcMsg || !cppToFree) return -1;

	pHead = (pCOMM_PACK_HEAD)pPacket;
	AKBGETHSIZE(pHead,iHSize)
	iRc = akb_from_indir_f(pPacket,pPacket+iHSize,&pPa);
	if (iRc<0) {
		return -2;
	}
	else if (iRc>0) {
		*cppToFree = pPa;
	}
	else pPa = pPacket;

	memset(tpRcMsg,0,sizeof(tdtMSG_COM));
	pHead = (pCOMM_PACK_HEAD)pPa;
	AKBGETHSIZE(pHead,iHSize)
	cver = pHead->cph_prt.prt_ver;
	if (cver == 'A') {
		pHeadA = (pCOMM_PACK_HEADA)pHead;
		tpRcMsg->msg_apid = pHeadA->pha_sinf.ina_apid;
		akb_get_head_from_a(&tHead,pHeadA);
		pHead = &tHead;
	}
	tpRcMsg->msg_form = pHead->cph_prt.prt_send;
	if (cver != 'B') {
		if (pHead->cph_sinf.ind_thrd) {	/* Command */
			tpRcMsg->msg_disp = 0;
			tpRcMsg->msg_aopt  |= pHead->cph_dinf.ind_disp;
			tpRcMsg->msg_pret      = ntohs(pHead->cph_dinf.ind_pano);
			/* add 1998.9.3 Koba */
			tpRcMsg->msg_resv        = pHead->cph_sinf.ind_disp;
/*
printf("akb_set_recv_msg:ucResv=%d\n",tpRcMsg->msg_resv);
*/
		}
		else {
			tpRcMsg->msg_disp = pHead->cph_dinf.ind_disp;
			tpRcMsg->msg_aopt  |= pHead->cph_sinf.ind_disp;
			tpRcMsg->msg_pret      = ntohs(pHead->cph_sinf.ind_pano);
		}
		tpRcMsg->msg_prid  = ntohs(pHead->cph_sinf.ind_prid);
		tpRcMsg->msg_clid = ntohs(pHead->cph_sinf.ind_clid);
	}
	else {
		pHeadB = (pCOMM_PACK_HEADB)pPa;
	    if (pHeadB->phb_dind.inb_pkid == 0) {	/* Command */
			tpRcMsg->msg_disp = 0;
/* 97.6.11 Koba
			tpRcMsg->msg_aopt   = 0;
*/
			tpRcMsg->msg_aopt  |= AKB_AKO_VER_B;
			tpRcMsg->msg_pret      = 0;
			tpRcMsg->msg_resv        = 1;	/* add 1999.10.14 Koba */
		}
		else {
			if (pHead->cph_dinf.ind_thrd)
				tpRcMsg->msg_disp = pHead->cph_dinf.ind_disp;
			else
				tpRcMsg->msg_disp = ntohl(pHeadB->phb_dind.inb_pkid);
		/*	tpRcMsg->ucAkbOption   = 0;	*/
			tpRcMsg->msg_pret      = ntohl(pHeadB->phb_sind.inb_pkid);
		}
		tpRcMsg->msg_prid  = ntohs(pHead->cph_sinf.ind_prid);
		tpRcMsg->msg_clid = 1;
	}
	tpRcMsg->msg_hoid   = ntohl(pHead->cph_sinf.ind_hoid);
/* 2000.12.19 Koba Ԑڎw'P'ȂƂcore
	tpRcMsg->msg_mlen = lLen = ntohl(pHead->cph_plen);
*/
	lLen = ntohl(pHead->cph_plen);
	tpRcMsg->msg_pmsg   = NULL;
	tpRcMsg->msg_filc = 0;
	tpRcMsg->msg_filv = cppFilev;
	if (lLen < 0) return -3;
	else if (lLen > 0) {
		pPa += iHSize;
	    if (tpRcMsg->msg_form & AKB_PFM_INDIRECT) {
			while (lLen>8) {
				lm = *(unsigned char *)(pPa+1);
				memcpy((char *)&lw,pPa+4,sizeof(INT4));
				ld = ntohl(lw);
				if (ld < 0) return -4;
				if (*pPa== 'P') {
					if (ld > 0)
						tpRcMsg->msg_pmsg = pPa + 4 + sizeof(INT4);
					else
						tpRcMsg->msg_pmsg = NULL;
					tpRcMsg->msg_mlen = lm = ld;
				}		
				else if (*pPa== 'F') {
					if (!tpRcMsg->msg_filv) {
						if (!(tpRcMsg->msg_filv=(char **)Malloc(256*sizeof(char *))))
							return -5;
					}
					lm -= sizeof(INT4);
					memcpy(pPa+1,pPa+8,lm);
					*(pPa+1+lm) = '\0';
					memcpy(pPa+lm+2,(char *)&ld,sizeof(INT4));
					if (tpRcMsg->msg_filc < 255)
						tpRcMsg->msg_filv[tpRcMsg->msg_filc++] = pPa+1;
				}
				else return -1;
				pPa  += lm + 4 + sizeof(INT4);
				lLen -= lm + 4 + sizeof(INT4);
			}
		}
		else {
			tpRcMsg->msg_mlen = lLen;	/* add 2000.12.19 Koba */
			tpRcMsg->msg_pmsg   = pPa;
		}
	}
	if (tpRcMsg->msg_filv) tpRcMsg->msg_filv[tpRcMsg->msg_filc] = NULL;
/*
	if (tpRcMsg->msg_mlen > 0)
		*(tpRcMsg->msg_pmsg+tpRcMsg->msg_mlen) = '\0';
*/

	return 0;
}
