static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akalib3.c
 *
 *        coded by A.Kobayashi 96/1/30
 *      updated by A.Kobayashi 2000/2/18
 *
 *===============================================*
 * static int   get_src_ch(pHead)
 * tdtCLASS_CTL *aka_srch_class2(iClassId,opt)
 * tdtCLASS_CTL *aka_srch_class(iClassId)
 * static int   max_thread_check(tpClass,tpClassHead)
 * static int   set_recv_msg_com(pPacket,tpInst)
 * static int   exec_func(iKind,tpClass,iThread,cpPacket)
 * static int   used_instance()
 * static int   re_send(pRcCurrent,iErrorCode)
 * static int   wait_msg_time_out()
 * static int   set_shut_packet(iCom,pRcShut)
 *        int   aka_get_msg(iWaitTime)
 *        int   aka_dispatch_msg()
 *        int   aka_dispatch_recv_msg(tpComObject)
 *        int   aka_packet_read(iWaitTime)
 *        int   aka_packet_write()
 * static int   check_del_wait_packet(tpIns, pHead)
 *        int   aka_wake_up_msg(lInstanceHandle,iRetCode)
 * static int   stat_set_rb_pack_err_cd(iCh,pPacket,pRbCtl,iErrorCode)
 * static int   sys_class_func(lInstanceHandle,cpInstanceData,tpRecvMsg)
 *************************************************/
#include "akacommon.h"

extern tdtMSG_CTL         tMsgCtl;
extern tdtCLASS_CTLHead   tClassHead;
extern tdtSTATISTICS     tStatistics;

void aka_set_shut_packet();
void aka_wait_packet_free();
static int check_del_wait_packet();
static int stat_set_rb_pack_err_cd();
static int sys_class_func();

static char *nullstring = "";

/********************************************************/
/*                                                      */
/********************************************************/
static int get_src_ch(pHead)
pCOMM_PACK_HEAD  pHead;
{
	int iCh;
	uchar ucAkbOpt;

if (DEBUGOUTCHECK(AKA_LOG_GROUP|252)) {
	int len = sizeof(tdtCOMM_PACK_HEAD);
	if (pHead->cph_prt.prt_ver == 'A') len = sizeof(tdtCOMM_PACK_HEADA);
	akxaxdump("get_src_ch:pHead",pHead,len);
}
	iCh = 0;
	if (pHead->cph_prt.prt_ver == 'C') {
		if (pHead->cph_sinf.ind_thrd) {	/* Command packet */
			ucAkbOpt = pHead->cph_dinf.ind_disp;
			if (ucAkbOpt & AKA_AKO_CHANNEL) {
				if (ucAkbOpt & AKA_AKO_CHANNEL_CMD)
					iCh = ntohs(pHead->cph_sinf.ind_prid);
			}
		}
		else {
			ucAkbOpt = pHead->cph_sinf.ind_disp;
			if (ucAkbOpt & AKA_AKO_CHANNEL) {
				if (!(ucAkbOpt & AKA_AKO_CHANNEL_CMD))
					iCh = ntohs(pHead->cph_sinf.ind_prid);
			}
		}
		if (iCh >= tMsgCtl.channel_used) iCh = -1;
	}
DEBUGOUTL1(AKA_LOG_GROUP|250,"get_src_ch:iCh=%d",iCh);
	return iCh;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtCLASS_CTL *aka_srch_class2(iClassId,opt)
int iClassId,opt;
{
	tdtCLASS_CTL *tpClass,*tp_b=NULL;
	int opt1;

	opt1 = opt & 0x01;
	tpClass = tClassHead.class;
	while (tpClass) {
DEBUGOUTL2(AKA_LOG_GROUP|255,
"aka_srch_class2:in = %d, reg = %d",iClassId,tpClass->class_id);
		if (tpClass->class_id == iClassId) {
			if (opt1 && tp_b) {
				tp_b->class_next = tpClass->class_next;
				tpClass->class_next = tClassHead.class;
				tClassHead.class = tpClass;
			}
			break;
		}
		tp_b = tpClass;
		tpClass = tpClass->class_next;
	}
	return tpClass;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtCLASS_CTL *aka_srch_class(iClassId)
int iClassId;
{
	return aka_srch_class2(iClassId,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
static int max_thread_check(tpClass,tpClassHead)
tdtCLASS_CTL     *tpClass;
tdtCLASS_CTLHead *tpClassHead;
{
	int i,iThread=0;

	if (tpClassHead) {
		if (tpClassHead->max_thread_total>0 &&
		    tpClassHead->used_thread_total>=tpClassHead->max_thread_total) {
#ifdef DEBUG
printf("max_thread_check: max = %d over\n",tpClassHead->used_thread_total);
#endif
			return 0;
		}
	}
#ifdef TP_MON
	if (tpClass->used_count < tpClass->max_exec_thread) {
#else
	if (tpClass->used_count < tpClass->max_thread) {
#endif
		for (i=0;i<tpClass->max_thread;i++) {
			if (!tpClass->instance[i].used) {
				iThread = i + 1;
				break;
			}
		}
	}
#ifdef DEBUG
printf("max_thread_check: iThread = %d\n",iThread);
#endif
	return iThread;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int set_recv_msg_com(pPacket,tpInst)
char        *pPacket;
tdtINSTANCE *tpInst;
{
	AKAMSGCOM *tpRcMsg;
	char **cppFilev;
	int iRc;
	tdtCOMM_PACK_HEAD   *pHead;

	tpRcMsg = tpInst->recv_msg_com;
	cppFilev = (char **)((char *)tpRcMsg + sizeof(AKAMSGCOM));

	iRc = akb_set_recv_msg(pPacket,tpRcMsg,cppFilev,&tpInst->to_free);
	if (iRc < 0) {
		return iRc;
	}
	pHead = (pCOMM_PACK_HEAD)pPacket;
	if (pHead->cph_prt.prt_ver == 'A') {
		tpRcMsg->msg_aopt |= AKA_AKO_EXTENSION;
		tpRcMsg->msg_kopt     |= AKA_EXO_VER_A;
	}
	if (ntohs(pHead->cph_prt.prt_cmnd) != AKB_CMD_SEND) {
		tpRcMsg->msg_aopt |= AKA_AKO_EXTENSION;
		tpRcMsg->msg_kopt     |= AKA_EXO_COMMAND;
	}

	if (!tpRcMsg->msg_pmsg) tpRcMsg->msg_pmsg = nullstring; /* add 2000.12.20 Koba */
	if (tpRcMsg->msg_mlen > 0)	/* add 2000.7.14 Koba */
		*(tpRcMsg->msg_pmsg+tpRcMsg->msg_mlen) = '\0';
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _exist_wait_packet(tpWait,iChk)
tdtWAIT_PACKET *tpWait;
int iChk;
{
	tdtWAIT_PACKET *tpNext=tpWait;
	int f;

	while (tpNext) {
		f = tpNext->status & AKA_WMSG_FUNC2;
		if ((!iChk && !f) || (iChk && f)) return 1;
		tpNext = tpNext->wait_next;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int exec_func(iKind,tpClass,iThread,cpPacket)
int iKind; /* 1/0 = Command/Reply */	/* add 2000.11.9 Koba */
tdtCLASS_CTL *tpClass;
int iThread;
char *cpPacket;
{
	int iRc,iHSize,iRc2,iDataSize;
	long lHnd;
	pRC_PACKET_TABLE  pRc;
	pCOMM_PACK_HEAD   pHead;
	tdtINSTANCE    *tpInst;
	char           *p,cver;
	tdtMSG_COM      *tpRcMsg;
	tdtCOMM_PACK_HEADA *pHA;
	ushort          usClassId;
	int (*pFunc)();

	tpInst = &tpClass->instance[iThread-1];

DEBUGOUTL2(110,"exec_func: iThread=%d tpInst=%08x",iThread,tpInst);

	if (tpInst->to_free) {
		Free(tpInst->to_free);
		tpInst->to_free = NULL;
	}
	if (iRc=set_recv_msg_com(cpPacket,tpInst)) {
		ERROROUT1("exec_func:Recv msg invalid format ret=%d. Can't exec.",iRc);
	/* 2000.11.9 Koba
		tpInst->used = 0;
		tpClass->used_count--;
		tClassHead.used_thread_total--;
	*/
		return iRc;
	}
	/* move from DispatchMsg 2000.11.9 Koba */
	tpInst->kind = iKind;
	if (iKind) {
		pHead = (pCOMM_PACK_HEAD)cpPacket;
		AKBGETHSIZE(pHead,iHSize)
		tpInst->used = 1;
		memcpy(tpInst->pack_head,cpPacket,iHSize);
		tpClass->used_count++;
		tClassHead.used_thread_total++;
	}
	else {
		/* set_recv_msg_com()ŃG[ɂȂƃCX^X^CAEgłȂ
		   ̂łWaitPacket */
		check_del_wait_packet(tpInst, cpPacket, 1);
	}
#if 1	/* 2000.12.21 Koba */
	pHead = tpInst->pack_head;
	tpRcMsg = tpInst->recv_msg_com;
	cver = pHead->cph_prt.prt_ver;
	if (cver == 'C') tpRcMsg->msg_resv = pHead->cph_sinf.ind_disp;
	else if (cver == 'A') {
		pHA = (tdtCOMM_PACK_HEADA *)pHead;
		tpRcMsg->msg_resv = pHA->pha_sinf.ina_disp;
	}
	else tpRcMsg->msg_resv = 1;
#endif
	aka_statistics_count(2,0);
	lHnd = iThread<<16 | tpClass->class_id;
	iRc2 = iRc = 0;
	if (tpClass->func_name2) {
		if (iKind==1 || tpInst->kind & 0x04) {
			tpInst->kind |= 0x02;
			if ((iDataSize=tpClass->instance_data_size) > 0)
				iDataSize = (iDataSize+15) & ~0x0f;
			if (tpClass->option & AKA_RCO_SYS_CLASS) pFunc = sys_class_func;
			else pFunc = tpClass->func_name2;
			iRc = pFunc(lHnd,tpInst->instance_data+iDataSize,
			            tpInst->recv_msg_com);
			if (!iKind && !iRc) iRc = _exist_wait_packet(tpInst->wait_next,0);
			iRc2 = iRc;
			tpInst->kind &= ~0x02;
		}
	}
	if (iRc < 0) iRc = 0;
	else {
		if (iKind==1 || !(tpInst->kind & 0x04)) {
			if (tpClass->option & AKA_RCO_SYS_CLASS) pFunc = sys_class_func;
			else pFunc = tpClass->func_name;
			iRc = pFunc(lHnd,tpInst->instance_data,tpInst->recv_msg_com);
			if (!iKind && !iRc) iRc = _exist_wait_packet(tpInst->wait_next,1);
		}
	}
	if (iRc2 > 0) iRc = iRc2;
#if 1	/* 97.5.8 Koba */
	if (iRc) {
		if (!tpInst->wait_next) {
			ERROROUT1("Wait ReturnłvpPbgȂBiRc=%d",iRc);
			iRc = 0;
		}
	}
#endif
	if (!iRc) {
		aka_wait_packet_free(tpInst->wait_next);
		tpInst->wait_next = NULL;
		if (tpInst->to_free) {
			Free(tpInst->to_free);
			tpInst->to_free = NULL;
		}
/*
printf("exec_func:tpInst=%08x, pRbComObject=%08x\n",
tpInst,tpInst->rb_com_object);
*/
		if (tpInst->rb_com_object) {
			while (p=akxs_rb_get_n(tpInst->rb_com_object)) {
/*
printf("         p=%08x\n",p);
*/
				aka_free_com_object_sub(p,0);
			}
		/***
			akxs_rb_free(tpInst->rb_com_object);
		***/
		}
		/* ʔԂ̍폜 */
		aka_channel_inst_free_seq(iThread<<16|tpClass->class_id);

		if (tpInst->comment) {
			Free(tpInst->comment);
			tpInst->comment = NULL;
		}
		tpInst->used = 0;
		tpClass->used_count--;
		tClassHead.used_thread_total--;
#ifndef NEW_GETMSG
#ifndef TP_MON
		/* WaitL[s\NX̃pPbgReadL[Ɉڂ */
		akxs_que_move(tMsgCtl.que_rwctl,QUE_MOVE_TOPP);
		while (akxs_que_peek(tMsgCtl.que_rwctl,QUE_MOVE_PEEK_NEXT,&pRc)>0) {
			pHead = (pCOMM_PACK_HEAD)(pRc->sp_content);
			cver = pHead->cph_prt.prt_ver;
			if (cver == 'A') {
				pHA = (tdtCOMM_PACK_HEADA *)pHead;
				usClassId = pHA->pha_dinf.ina_clid;
			}
			else usClassId = pHead->cph_dinf.ind_clid;
/*
printf("exec_func: call aka_srch_class\n");
*/
			if (tpClass=aka_srch_class(ntohs(usClassId))) {
				if (tpClass->used_count < tpClass->max_thread) {
					akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRc);
#if 1	/* 2000.4.7 Koba */
					akxs_rb_set_t(tMsgCtl.rb_rctl,pRc);
#else
					akxs_rb_set_n(tMsgCtl.rb_rctl,pRc);
#endif

DEBUGOUTL1(110,"exec_func: Class(%d) waitque moved to RbRCtl.",ntohs(usClassId));

					break;
				}
			}
			else {

DEBUGOUTL1(110,"exec_func: Class(%d) not registered.",ntohs(usClassId));

				akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRc);
				return -18504501;
			}
		}
#endif /* TP_MON */
#endif
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int used_instance()
{
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	int i,count=0;

	tpClass = tClassHead.class;
	while (tpClass) {
		if (!(tpClass->option & AKA_RCO_NOWAITSHUT)) {
			tpIns = tpClass->instance;
			for (i=0;i<tpClass->max_thread;i++)
				if (tpIns[i].used) count++;
		}
		tpClass = tpClass->class_next;
	}
/*
printf("used_instance:count=%d\n",count);
*/
	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int re_send(pRcCurrent,iErrorCode)
pRC_PACKET_TABLE  pRcCurrent;
int             iErrorCode;
{
	int iCh;
	tdtCHANNEL *pCh=NULL;
	tdtRB_CTL *pRbCtl=NULL;

/*	iCh = get_src_ch(pRcCurrent->pContent);	*/
	iCh = pRcCurrent->sp_srcch - 1;
	if (iCh == 0) {
		pRbCtl = tMsgCtl.rb_wctl;
	}
	else if (iCh > 0) {
		if (pCh = aka_channel_get(iCh)) {
			if (pCh->sys_opt & AKA_CHSO_USE_AKB_HEAD) {
				pRbCtl = tMsgCtl.rb_wctl;
			}
			else ERROROUT("Packet droped.because of Channel I/O");
		}
		else ERROROUT("Packet droped.because of invalid Channel No");
	}
	else pRbCtl = tMsgCtl.rb_rctl;

	if (pRbCtl) {
		if (stat_set_rb_pack_err_cd(iCh,pRcCurrent->sp_content,pRbCtl,iErrorCode))
			Free(pRcCurrent->sp_content);
	}
	else Free(pRcCurrent->sp_content);

	pRcCurrent->sp_content = NULL;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
#define AKA_NEXT_WAIT_TIME	60000

static int wait_msg_time_out()
{
	struct timeval ttime;
	time_t ltime;
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	int i,count=0;
	pCOMM_PACK_HEAD   pHead;
	pCOMM_PACK_HEADA  pHA;
	tdtWAIT_PACKET *tpWait;
	int iWaitTime,iMinWait,iSubTime;
	int iRetCode,iHSize;
	char cver;

	/* ݎ̎肾 */
	if ((ltime = aka_get_msec(&ttime))<0) return -1;
DEBUGOUTL2(AKA_LOG_GROUP|255,
"wait_msg_time_out:ttime=%d:%d",ttime.tv_sec,ttime.tv_usec);
	iMinWait = -1;
	tpClass = tClassHead.class;
	while (tpClass) {
	  tpIns = tpClass->instance;
	  for (i=0;i<tpClass->max_thread;i++) {
		if (tpIns[i].used && (tpWait=tpIns[i].wait_next)) {
		  while (tpWait) {
#if 1	/* 2001.8.6 Koba */
			iSubTime = akxe_timer_sub(NULL,&tpWait->time_out,&ttime);
DEBUGOUTL5(AKA_LOG_GROUP|255,
"wait_msg_time_out:ttime=%d:%d TimeOut=%d:%d iSubTime=%d",
ttime.tv_sec,ttime.tv_usec,tpWait->time_out.tv_sec,tpWait->time_out.tv_usec,iSubTime);
			if (iSubTime <= 0) {
#else
			if (!timercmp(&tpWait->time_out,&ttime,>)) {
#endif
				pHead = (pCOMM_PACK_HEAD)tpWait->wait_packet;
				cver = pHead->cph_prt.prt_ver;
				if (cver == 'A') iHSize = sizeof(tdtCOMM_PACK_HEADA);
				else iHSize = sizeof(tdtCOMM_PACK_HEAD);
				if (pHead=(pCOMM_PACK_HEAD)Malloc(iHSize)) {
					memcpy(pHead,tpWait->wait_packet,iHSize);
					if (cver == 'A') {
						pHA = (tdtCOMM_PACK_HEADA *)pHead;
						pHA->pha_plen = 0;
					}
					else pHead->cph_plen = 0;
					iRetCode = PACKET_TIMEOUT_ERROR;
					if (tpWait->status & AKA_WMSG_NULL_CLASS) iRetCode = 0;
					if (tpWait->status & AKA_WMSG_WAKEUP)
						iRetCode = tpWait->ret_code;
					if (stat_set_rb_pack_err_cd(get_src_ch(tpWait->wait_packet),
					    tpWait->wait_packet,tMsgCtl.rb_rctl,iRetCode)<0) {
						akxe_timer_add_msec(&tpWait->time_out,&tpWait->time_out,
							AKA_NEXT_WAIT_TIME);
						Free(tpWait->wait_packet);
					}
					else {
						if (!(tpWait->status &
						      (AKA_WMSG_NULL_CLASS | AKA_WMSG_WAKEUP)))
							ERROROUT("vpPbg^CAEg");
						count++;
					/*
						tpWait->iTimeOut += tMsgCtl.send_msg_time_out;
					*/
						akxe_timer_add_msec(&tpWait->time_out,&tpWait->time_out,
							AKA_NEXT_WAIT_TIME);
						tpWait->status |= AKA_WMSG_TIMEOUT;
					}
					/* akb_set_rb_pack_err_cdŃZbgpPbg͕ԋppPbg
					   ƂăfBXpb`AWaitPacket邩ǂ
					   `FbN邽FreełȂ */
					tpWait->wait_packet = (char *)pHead;
				}
				else {
					akxe_timer_add_msec(&tpWait->time_out,&tpWait->time_out,
						AKA_NEXT_WAIT_TIME);
				}
			}
			else {
				if (iSubTime >= AKA_NEXT_WAIT_TIME/2)
					tpWait->status &= ~AKA_WMSG_TIMEOUT;
			/*
				iSubTime = akxe_timer_sub(NULL,&tpWait->time_out,&ttime);
			*/
DEBUGOUTL3(AKA_LOG_GROUP|255,
"wait_msg_time_out:iSubTime=%d iMinWait=%d Status=%08x",
iSubTime,iMinWait,tpWait->status);
				if (iMinWait<0 || iSubTime<iMinWait) iMinWait = iSubTime;
			}
			tpWait = tpWait->wait_next;
		  }
		}
	  }
	  tpClass = tpClass->class_next;
	}
DEBUGOUTL2(AKA_LOG_GROUP|255,
"wait_msg_time_out:tMsgCtl.iSendMsgMinWait=%d iMinWait=%d",tMsgCtl.send_msg_min_wait,iMinWait);
	tMsgCtl.send_msg_min_wait = iMinWait;

	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int set_shut_packet(iCom,pRcShut)
int iCom;
pRC_PACKET_TABLE pRcShut;
{
	tdtCOMM_PACK_HEAD   *tpHead;
/*	qIndicate        tmp;	*/

	if (!pRcShut) return -1;
	tpHead = (pCOMM_PACK_HEAD)(pRcShut->sp_content);
	akb_exchg_indicate(tpHead);
/*
	memcpy((char *)&tmp,(char *)&(tpHead->cph_sinf),sizeof(tdtINDICATE));
	memcpy((char *)&(tpHead->cph_sinf),(char *)&(tpHead->cph_dinf),
	       sizeof(tdtINDICATE));
	memcpy((char *)&(tpHead->cph_dinf),(char *)&tmp,sizeof(tdtINDICATE));
*/
	if (iCom == AKB_CMD_FSHUT) {
		while (akxs_rb_get_n(tMsgCtl.rb_wctl)) ;
		while (aka_packet_write()>0) ;
	}
	aka_set_shut_packet(tpHead);
	return 0;
}
#ifndef AKASYS
/********************************************************
 *
 *    aka_get_msg(iWaitTime)
 *
 * ret  >0 ̂ƂApPbgB
 *      =0 ̂ƂApPbgȂB
 *      <0 ̂ƂAG[R[hB
 ********************************************************/
int aka_get_msg(iWaitTime)
int  iWaitTime  ;	/* select VXeR[ WaitTimei1/10bj */
{
	int iRc = 0;
	int iRcW,iRcR,iShutMode;
	int lmtime;
	struct timeval tmtime;
	int iMinWaitTime,iTimerMinWait;

DEBUGOUTL1(AKA_LOG_GROUP|200,"aka_get_msg: Enter iWaitTime=%d",iWaitTime);

	if (tMsgCtl.sd<0) return -18505001;

	iShutMode = aka_shut_control(AKA_SHUT_GET,NULL);

DEBUGOUTL1(AKA_LOG_GROUP|200,"aka_get_msg: iShutMode=%d",iShutMode);

	tMsgCtl.get_msg_wait_time = iWaitTime*100;
	if (tMsgCtl.get_msg_wait_time>=0) {
		if ((lmtime=aka_get_msec(&tmtime))<0) return -18505002;
		akxe_timer_add_msec(&tmtime,&tmtime,tMsgCtl.get_msg_wait_time);
		if (!timerisset(&tMsgCtl.get_msg_time_out) ||
		    timercmp(&tMsgCtl.get_msg_time_out,&tmtime,>)) {
			akxe_timer_add_msec(&tMsgCtl.get_msg_time_out,&tmtime,-5);
		}
DEBUGOUTL2(AKA_LOG_GROUP|200,
"aka_get_msg: tmtime=%d:%d",tmtime.tv_sec,tmtime.tv_usec);
	}

DEBUGOUTL2(AKA_LOG_GROUP|200,
"aka_get_msg: tGetMsgTimeOut=%d:%d",
tMsgCtl.get_msg_time_out.tv_sec,tMsgCtl.get_msg_time_out.tv_usec);

	for (;;) {
		/**************************************************************
		 * PacketRead,PacketWriteȂƂP͎sĂ
		 * {֐烊^[鎞𔻒肵ĂǂAłȂ
		 * ȂŃ^[ꍇ
		 *************************************************************/
		if (iWaitTime>=0 && tMsgCtl.rsv1) {
			if ((lmtime=aka_get_msec(&tmtime))<0) return -18505002;

DEBUGOUTL4(AKA_LOG_GROUP|210,
"aka_get_msg: tmtime=%d:%d tGetMsgTimeOut=%d:%d",
tmtime.tv_sec,tmtime.tv_usec,tMsgCtl.get_msg_time_out.tv_sec,
tMsgCtl.get_msg_time_out.tv_usec);

		    if (!timercmp(&tMsgCtl.get_msg_time_out,&tmtime,>)) {
				timerclear(&tMsgCtl.get_msg_time_out);
				tMsgCtl.rsv1 = 0;
				break;
			}
			/* ҂ԍĐݒ */
			tMsgCtl.get_msg_wait_time = akxe_timer_sub(NULL,
				&tMsgCtl.get_msg_time_out,&tmtime);

DEBUGOUTL1(AKA_LOG_GROUP|210,
"aka_get_msg: iGetMsgWaitTime=%d",tMsgCtl.get_msg_wait_time);

		}
		/****************
		 * ^C}[ *
		 ****************/
		aka_timer_proc();
		/**********************
		 * pPbgv *
		 **********************/
		tMsgCtl.rsv1 = 1;
		if ((iRcW=aka_packet_write())<0) {
			iRc = iRcW;
			break;
		}
		aka_rwque_remain(0x02);
		/*************************
		 * RWQueTimer̊Jn/~ *
		 *************************/
		aka_rwque_timer_ctl();
#if 0	/* ŏsleep 0 ŃXbh؂ւ悤ƂƂɁA
		   ̃bZ[WǂޑOwaitbZ[W^CAEgĂ܂A
		   ŏ̂P񂾂́ÃbZ[WɃXbh؂ւȂ		*/
		/**************************************
		 * ԐM҂pPbg̃^CAEg *
		 **************************************/
		wait_msg_time_out();
#endif
		/****************
		 * ҂Ԑݒ *
		 ****************/
		iMinWaitTime = aka_get_min_wait_time(tMsgCtl.get_msg_wait_time);
		if (iShutMode && iMinWaitTime<0) iMinWaitTime = 0;
		/**********************
		 * pPbgq   *
		 **********************/
		tMsgCtl.rsv1 = 2;

DEBUGOUTL1(AKA_LOG_GROUP|200,
"aka_get_msg: aka_packet_read(iMinWaitTime=%d)",iMinWaitTime);

		if ((iRcR=aka_packet_read(iMinWaitTime))<0) {
			iRc = iRcR;
			break;
		}
		tMsgCtl.rqsuspend = aka_rwque_remain(0x11);
#if 1
		/**************************************
		 * ԐM҂pPbg̃^CAEg *
		 **************************************/
		wait_msg_time_out();
#endif
		/**********************
		 * ^[l̐ݒ  *
		 **********************/
/* 2005.6.13 Koba
		if (iRcW == 0) {
*/
			if (iRcR) {
				iRc = iRcR;
				break;
			}
			else if (iShutMode == 2) {
				iRc = AKB_CMD_FSHUT;
				break;
			}
			else if (iShutMode == 1) {
				iRc = AKB_CMD_SHUT;
				break;
			}
/* 2005.6.13 Koba
		}
*/
	}
/*
	if (iRc == D_ERR_READ_SOCKET) aka_set_connect_sd(-1);
*/

DEBUGOUTL1(AKA_LOG_GROUP|200,"aka_get_msg: Exit iRc=%d",iRc);

	return iRc;
}
#endif
/********************************************************/
/*                                                      */
/********************************************************/
static int is_recv_proc(usRecvProcId,usProcId)
ushort *usRecvProcId,usProcId;
{
	int i,n;
	ushort *usR;

	if (usR=usRecvProcId) {
		n = (int)usR[0];
/*
printf("is_recv_procId: usProcId=%d n=%d\n",usProcId,n);
*/
		usR += 2;
		for (i=0;i<n;i++) {
/*
printf("is_recv_procId: i=%d usR0=%d usR1=%d\n",i,usR[0],usR[1]);
*/
			if (usProcId >= usR[0] && usProcId <= usR[1]) return 1;
			usR += 2;
		}
	}
	return 0;
}
#ifndef AKASYS
/*************************************************************/
/*                                                           */
/*  ret : AKB_CMD_SHUT̂ƂArgtsR}hMA     */
/*          ҂̃bZ[W                           */
/*          ̃CX^XȂB                     */
/*        AKB_CMD_FSHUT̂ƂAergtsR}hMB*/
/*************************************************************/
int aka_dispatch_msg()
{
	int iRc;

	iRc = aka_dispatch_recv_msg(NULL);
	if (iRc == D_ERR_READ_SOCKET) aka_set_connect_sd(-1);
	return iRc;
}
#endif
int aka_dispatch_recv_msg(tpComObject)
tdtCOM_OBJECT    *tpComObject;
{
	pRC_PACKET_TABLE     pRcCurrent, pRcNext;
	tdtCOMM_PACK_HEAD     *pHead,tHead;
	pCOMM_PACK_HEADB     pHeadB;
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	int iClassId,iThread,iRc,iCom,iMode,iKind,iAkbError;
	tdtWAIT_PACKET *tpWait;
	char cver,*cpPacket;
	uchar ucShutMode[2];
/*	AKAMSGCOM       *tpRecvMsg;	*/
	int             iOptions;
	tdtINSTANCE     *tpRecvIns;
	int             iRecvClass, iChkDel;
	short           sPacketNo;

	if (tMsgCtl.sd<0) return -18505101;

	tpRecvIns  = NULL;
	if (tpComObject) {
		iOptions   = tpComObject->options;
		iRecvClass = tpComObject->recv_ins_hnd & 0xffff;
/*
printf("Dipatch:opt=%d,class=%d,sPacketNo = %d\n",iOptions,iRecvClass,tpComObject->packet_no);
*/
	}
	else {
		iOptions   = 0;
		iRecvClass = 0;
	}

	iThread = 0;
	tpClass = NULL;
	/* Mpe[u */
#ifdef NEW_GETMSG
	iRc = akxs_que_move(tMsgCtl.que_rwctl,QUE_MOVE_TOP,NULL);
	if (iRc<0) return -18505102;
	for (;;) {
		iRc=akxs_que_peek(tMsgCtl.que_rwctl,QUE_PEEK_CUR,&pRcCurrent);
		if (iRc<=0 || !pRcCurrent) {
			pRcCurrent = NULL;
			break;
		}
#else
	while (pRcCurrent = (pRC_PACKET_TABLE)akxs_rb_get_n(tMsgCtl.rb_rctl)) {
#endif
#ifdef DEBUG
printf("aka_dispatch_msg:There is Read Msg.\n");
#endif
		aka_statistics_count(0,pRcCurrent->sp_len);

		cpPacket = pRcCurrent->sp_content;
/*
{
char buf[256];
sprintf(buf,"[%s]Dispatch:packet",akb_log_get_proc_name());
akxaxdump(buf,cpPacket,pRcCurrent->sp_len);
}
*/
		pHead = (pCOMM_PACK_HEAD)cpPacket;
		pHeadB = (pCOMM_PACK_HEADB)cpPacket;
		iCom  = ntohs(pHead->cph_prt.prt_cmnd);
		cver = pHead->cph_prt.prt_ver;
		if (cver == 'A') {
			akb_get_head_from_a(&tHead,pHead);
			pHead = &tHead;
			cver = 'C';
		}

DEBUGOUTL1(AKA_LOG_GROUP|255,"aka_dispatch_msg:iCom=%d",iCom);

		if ((cver=='C' && pHead->cph_sinf.ind_thrd) ||
		    (cver=='B' && pHeadB->phb_dind.inb_pkid == 0)) {
			/* Command Packet */
			iKind = 1;
			if (iOptions) {
				akxs_rb_set_n(tMsgCtl.rb_dwctl, pRcCurrent);
				continue;
			}
			if (iCom == AKB_CMD_REGIST || iCom == AKB_CMD_DELETE ||
			    iCom == AKB_CMD_QUERY  || iCom == AKB_CMD_WATCH  ||
			    iCom == AKB_CMD_NOTIFY ||
			    iCom == AKB_CMD_START  ||
			    iCom == AKB_CMD_SHUT   || iCom == AKB_CMD_FSHUT) {
				iClassId = AKA_CLASS_BASE - iCom;
/*
printf("aka_dispatch_msg(C): call aka_srch_class2(%d,1)\n",iClassId);
*/
				if (tpClass=aka_srch_class2(iClassId,1)) {
					if (!(iThread=max_thread_check(tpClass,NULL))) {
						if (iCom == AKB_CMD_QUERY ||
						    iCom == AKB_CMD_WATCH) {
							re_send(pRcCurrent,0);
						}
#ifndef NEW_GETMSG
						else if (iCom != AKB_CMD_FSHUT) {
							akxs_que_put(tMsgCtl.que_rwctl,QUE_PUT,pRcCurrent);
							aka_statistics_count(3,pRcCurrent->sp_len);
							pRcCurrent = NULL;
						}
#endif
					}
					else {
						exec_func(iKind,tpClass,iThread,cpPacket);
						iThread = 0;
						tpClass = NULL;
					}
				}
				if (iCom == AKB_CMD_SHUT || iCom == AKB_CMD_FSHUT) {
					if (pRcCurrent) set_shut_packet(iCom,pRcCurrent);
					if (iCom == AKB_CMD_SHUT) {
						ucShutMode[0] = 1;
					}
					else {
						ucShutMode[0] = 2;
						if (pRcCurrent) {
							if (pRcCurrent->sp_content)
								Free(pRcCurrent->sp_content);
							Free(pRcCurrent);
						}
#ifdef NEW_GETMSG
						akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRcCurrent);
#endif
					}
					aka_shut_control(AKA_SHUT_MODE,ucShutMode);
					if (iCom == AKB_CMD_FSHUT) return AKB_CMD_FSHUT;
				}
			}
			else if (iCom == AKB_CMD_SEND) {
				if (cver == 'C')
					iClassId = ntohs(pHead->cph_dinf.ind_clid);
				else
					iClassId = 1;

DEBUGOUTL1(AKA_LOG_GROUP|255,"aka_dispatch_msg(C):CMD_SEND: class=%d",iClassId);

				if (iClassId != AKA_CLASS_FSHUT &&
				    aka_shut_control(AKA_SHUT_GET,NULL)) {
					re_send(pRcCurrent,D_ERR_SHUT_MODE);
					break;
				}
				if (tpComObject && iClassId == iRecvClass) {
					akxs_rb_set_n(tMsgCtl.rb_dwctl, pRcCurrent);
					continue;
				}
/*
printf("aka_dispatch_msg(C5): call aka_srch_class2(%d,1)\n",iClassId);
*/
				if (tpClass=aka_srch_class2(iClassId,1)) {
					if (!(iThread=max_thread_check(tpClass,&tClassHead))) {
#ifdef DEBUG
printf("aka_dispatch_msg: Read Msg is put QUE\n");
#endif
#ifndef NEW_GETMSG
						akxs_que_put(tMsgCtl.que_rwctl,QUE_PUT,pRcCurrent);
						aka_statistics_count(3,pRcCurrent->sp_len);
						pRcCurrent = NULL;
#endif
					}
					else {
						if ((tpClass->option & AKA_RCO_RECVPROC) &&
						    (pHead->cph_sinf.ind_prid != tMsgCtl.us_proc) &&
						    !is_recv_proc(tpClass->recv_proc_id,
						                  ntohs(pHead->cph_sinf.ind_prid))) {
							re_send(pRcCurrent,D_ERR_RCO_RECVPROC);
						}
						else if (!(tpClass->option & AKA_RCO_NODROPCERR) &&
							     (iAkbError=ntohs(pHead->cph_dinf.ind_pano))) {
							ERROROUT2("C:Droped Error Packet ClassID=%d akberr=%d",
							          iClassId,iAkbError);
						}
						else break;
					}
				}
				else {
					ERROROUT1("C:o^NXhc = %d",iClassId);
					re_send(pRcCurrent,D_ERR_UNKNOWN_CLASS);
				}
			}
			else {
				ERROROUT1("C:`R}h cmd= %d",iCom);
				re_send(pRcCurrent,D_ERR_UNKNOWN_CMD);
			}
		}
		else {	/* Return Packet */
			iKind = 0;
			if (iCom == AKB_CMD_SHUT || iCom == AKB_CMD_FSHUT) {
				ERROROUT1("ԐM cmd=%d",iCom);
			}
			else if (iCom == AKB_CMD_NEED_REPLY) {
				akb_re_set_need_reply_pa(pRcCurrent,tMsgCtl.write_que_pa);
			}
#ifndef NO_COMMAND
			else if (iCom>=1 && iCom<=255) {
				if (iCom == AKB_CMD_SEND) {
					if (cver == 'C')
						iClassId = ntohs(pHead->cph_dinf.ind_clid);
					else
						iClassId = 1;
				}
				else iClassId = AKA_CLASS_BASE - iCom;
#else
			else if (iCom == AKB_CMD_SEND) {
				if (cver == 'C')
					iClassId = ntohs(pHead->cph_dinf.ind_clid);
				else
					iClassId = 1;
#endif
				iThread  = pHead->cph_dinf.ind_thrd;
/*
printf("aka_dispatch_msg(R): call aka_srch_class2(%d,1)\n",iClassId);
*/
				if (tpClass=aka_srch_class2(iClassId,1)) {
					if (tpClass->option & AKA_RCO_NOREPLY) {
						re_send(pRcCurrent,D_ERR_RCO_NOREPLY);
					}
					else {
						tpIns = &tpClass->instance[iThread-1];
						if (tpWait=tpIns->wait_next) {
							iChkDel = 1;
							if (tpComObject) {
								sPacketNo = ntohs(pHead->cph_dinf.ind_pano);
/*
printf("Dipatch:Msg class=%d,sPacketNo = %d\n",iClassId,sPacketNo);
*/
								if (sPacketNo!=tpComObject->packet_no &&
								    (iOptions ||
								     (!iOptions && iClassId==iRecvClass)))
									iChkDel = 0;
							}
							if (iChkDel) {
								if (check_del_wait_packet(tpIns,pHead,0)){
									if (tpComObject &&
									    iClassId == iRecvClass &&
									    sPacketNo == tpComObject->packet_no)
										tpRecvIns = tpComObject->recv_ins;
									break;
								}
								else ERROROUT("vpPbg̔ԍȂ");
							}
							else {
								akxs_rb_set_n(tMsgCtl.rb_dwctl, pRcCurrent);
							}
						}
						else ERROROUT("vpPbgȂ");
					}
				}
				else {
					ERROROUT1("R:o^NXhc = %d",iClassId);
					re_send(pRcCurrent,D_ERR_UNKNOWN_CLASS);
				}
			}
			else {
				ERROROUT1("R:`R}h cmd= %d",iCom);
			}
		}
		if (pRcCurrent) {
			if (pRcCurrent->sp_content) Free(pRcCurrent->sp_content);
			Free(pRcCurrent);
#ifdef NEW_GETMSG
			iRc = akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRcCurrent);
			if (iRc<0) return -18505104;
#endif
			pRcCurrent = NULL;
		}
#ifdef NEW_GETMSG
		else {
			iRc = akxs_que_move(tMsgCtl.que_rwctl,QUE_MOVE,NULL);
			if (iRc<0) return -18505105;
		}
#endif
		iThread = 0;
		tpClass = NULL;
	}
#ifdef NEW_GETMSG
	if (iRc<0) return -18505103;
#endif
	if (pRcCurrent) {
		Free(pRcCurrent);
#ifdef NEW_GETMSG
		iRc = akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRcCurrent);
		if (iRc<0) return -18505105;
#endif
	}
	if (tpRecvIns) {
		if (tpComObject->to_free) {
			Free(tpComObject->to_free);
			tpComObject->to_free = NULL;
		}
		iRc = set_recv_msg_com(cpPacket,tpRecvIns);
		if (iRc) {
			ERROROUT1("ComObj:Recv msg invalid format ret=%d. Can't exec.",iRc);
			if (cpPacket) Free(cpPacket);
		}
		else {
			iRc = AKB_CMD_RECVMSG;
			tpComObject->to_free = (char *)cpPacket;
			check_del_wait_packet(tpIns, cpPacket, 1);
		}
		return iRc;
	}
	else if (tpClass && iThread) {
		exec_func(iKind,tpClass,iThread,cpPacket);
		if (cpPacket) Free(cpPacket);
#if 1
		tpIns = &tpClass->instance[iThread-1];
		if (!tpIns->used && (tMsgCtl.msg_opt & AKA_MSO_EXEC_NOFREE)) {
			if ((iRc=Nofree(0)) >= 0)
				PRINTOUTL1(tMsgCtl.rsv2,"aka_dispatch: nofree no=%d",iRc);
		}
#endif
	}
/*
	if (tMsgCtl.shut_mode && !tMsgCtl.shut_suspend &&
*/
	iMode = aka_shut_control(AKA_SHUT_GET,NULL);
	if (iMode == 2) {	/* FSHUT mode */
		return AKB_CMD_FSHUT;
	}
	else if (iMode == 1 &&	/* SHUT mode */
	   !(akxs_rb_get(tMsgCtl.rb_rctl) || akxs_rb_get(tMsgCtl.rb_wctl) ||
         tMsgCtl.wqsuspend ||
	     akb_qscheck_pa(tMsgCtl.channel_used,tMsgCtl.write_que_pa) ||
		used_instance() || akxs_que_peek(tMsgCtl.que_rwctl,QUE_PEEK,NULL))) {
		return AKB_CMD_SHUT;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static struct timeval *_set_read_select_tval(iWaitTime,pTval)
int iWaitTime;	/* msec */
struct timeval *pTval;
{
	struct timeval *ptval=pTval;
	int msec;

	msec=akb_get_select_wait_time(iWaitTime,tMsgCtl.rb_rctl,tMsgCtl.rb_wctl,ptval);
#ifdef NEW_GETMSG
	if (msec) {
		if (akxs_que_peek(tMsgCtl.que_rwctl,QUE_PEEK,NULL)) {
			akxe_timer_set_msec(ptval,1);
		}
	}
#endif

DEBUGOUTL2(AKA_LOG_GROUP|254,
"_set_read_select_tval: iWaitTime=%d ptval=0x%08x",iWaitTime,ptval);
if (ptval)
DEBUGOUTL2(AKA_LOG_GROUP|254,
"     tv_sec=%d tv_usec=%d",ptval->tv_sec,ptval->tv_usec);

	return ptval;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int  _set_read_select_readfds(preadfds,ptval)
fd_set *preadfds;
struct timeval *ptval;
{
	int iCUIO_f, iSelectMin, iSelectWait;
	int i,iSd;
	tdtCHANNEL *pCh,**ppCh;
	tdtCHANNEL_USER_IO *pCuio;
	struct timeval tvalnow;

	aka_get_msec(&tvalnow);
	if ((iSelectMin=akxe_timer_set(NULL,ptval)) < 0) iSelectMin = INT_MAX;
DEBUGOUTL2(AKA_LOG_GROUP|254,
"_set_read_select_readfds: Enter: tvalnow=%d %d",
tvalnow.tv_sec,tvalnow.tv_usec);
	iCUIO_f = 0;
	akb_fd_zero( preadfds );
	i = tMsgCtl.channel_akb_used;
	ppCh = &tMsgCtl.channel_pa[i];
	for (;i<tMsgCtl.channel_used;i++,ppCh++) {
		if (!(pCh = *ppCh)) continue;
		pCh->select = 0;
		if ((iSd=pCh->sd) > 0) {
			if (pCuio = pCh->cuio) {
				if (pCuio->select_interval >= 0) {
					if (pCuio->read) {
DEBUGOUTL3(AKA_LOG_GROUP|254,
"_set_read_select_readfds: iSelectMin=%d tSelectTime=%d %d",
iSelectMin,pCuio->select_time.tv_sec,pCuio->select_time.tv_usec);
						if (!(pCh->sys_opt & AKA_CHSO_UIO_JUST_INTRVL) ||
						    ((pCh->sys_opt & AKA_CHSO_UIO_JUST_INTRVL) &&
						     akxe_timer_cmp(&tvalnow,&pCuio->select_time)>=0)) {
							if (pCuio->select)
								pCh->select = pCuio->select(pCh->index,
								                              pCuio->parm,0);
							else pCh->select = 1;
							if (pCh->select > 0) {
								iCUIO_f = 1;
								iSelectWait = 0;
							}
							else iSelectWait = pCuio->select_interval;
							akxe_timer_add_msec(&pCuio->select_time,
							                 &tvalnow,iSelectWait);
DEBUGOUTL3(AKA_LOG_GROUP|254,
"_set_read_select_readfds: iSelectWait=%d tSelectTime=%d %d",
iSelectWait,pCuio->select_time.tv_sec,pCuio->select_time.tv_usec);

						}
					}
					if (pCh->sys_opt & AKA_CHSO_UIO_JUST_INTRVL) {
						iSelectWait = akxe_timer_sub(NULL,&pCuio->select_time,
						                           &tvalnow);
						if (iSelectWait < 0) iSelectWait = 0;
					}
					else iSelectWait = pCuio->select_interval;
					if (iSelectWait < iSelectMin) iSelectMin = iSelectWait;
				}
			}
			else {
				akb_fd_set(iSd , preadfds );
			}
		}
	}
	if (iSelectMin < INT_MAX) akxe_timer_set_msec(ptval,iSelectMin);

	return iCUIO_f;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _read_que_cuio()
{
	int iRc,i;
	tdtCHANNEL *pCh,**ppCh;
	tdtRW_QUE *pRQ,**ppRQ;

	i = tMsgCtl.channel_akb_used;
	ppCh = &tMsgCtl.channel_pa[i];
	ppRQ = &tMsgCtl.read_que_pa[i];
	for (;i<tMsgCtl.channel_used;i++,ppCh++,ppRQ++) {
		if ((pCh = *ppCh) && (pRQ = *ppRQ)) {
			if (pCh->select>0 || akb_rwqtis_time_out(pRQ)) {
				iRc = aka_read_que(pCh,pRQ,tMsgCtl.rb_rctl);
				if (iRc < 0) aka_channel_close(i);
			}
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _read_que_sd(preadfds)
fd_set *preadfds;
{
	int iRc,i,iSd;
	tdtCHANNEL *pCh,**ppCh;
	tdtRW_QUE *pRQ,**ppRQ;

	iRc = 0;
	i = tMsgCtl.channel_akb_used;
	ppCh = &tMsgCtl.channel_pa[i];
	ppRQ = &tMsgCtl.read_que_pa[i];
	for (;i<tMsgCtl.channel_used;i++,ppCh++,ppRQ++) {
		if (!(pCh = *ppCh)) continue;
		if ((iSd=pCh->sd)>0 && !pCh->cuio) {
			if (!(pRQ = *ppRQ)) continue;
			if (FD_ISSET(iSd,preadfds) || akb_rwqtis_time_out(pRQ)) {
				pCh->select = 1;
				if (i == 0) {
					iRc = akb_read_que_w(i,pRQ,tMsgCtl.rb_rctl,tMsgCtl.rb_wctl);
					if (iRc < 0) {
						if (iRc == -1) {
							aka_channel_close(0);
							if (aka_init_status(AKA_IST_STANDALONE,0)) iRc = 0;
							else iRc = D_ERR_READ_SOCKET;
						}
						return iRc ;
					}
				}
				else {
					if (AKAGETCHACCEPT(pCh->status) &&
						AKAGETCHSTATUS(pCh->status) == 1) {
						iRc = akb_accept2(iSd,-1,pCh->linger);
						if (iRc >= 0) {
							if (pCh->head_check) {
								if (pCh->head_check(pCh,iRc)<0) close(iRc);
							}
							else {
								if (pCh->exception) pCh->exception(i,12);
								close(iRc);
							}
						}
						else if (pCh->exception) pCh->exception(i,11);
					}
					else {
						iRc = aka_read_que(pCh,pRQ,tMsgCtl.rb_rctl);
						if (iRc<0 && AKAGETCHUDP(pCh->status)) {
							akb_clear_rwque(pRQ,iSd);
							iRc = 0;
						}
					}
					if (iRc < 0) iRc = aka_channel_close(i);
				}
			}
		}
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_packet_read(iWaitTime)
int iWaitTime;	/* msec */
{
	fd_set readfds;
	struct timeval  tval, *ptval;
	int iRc,i,iCUIO_f,ret;
	char *p;

	if (tMsgCtl.sd<0) return -18505201;

	/* set tval for read select() */
	_set_read_select_tval(iWaitTime,&tval);

	iRc = 0;	/* Add 2016.11.27 koba */
	for (i=0;i<1;i++) {
		ptval = &tval;
		/* set readfds for read select() */
		iCUIO_f = _set_read_select_readfds(&readfds,ptval);
		if (iCUIO_f > 0) {
			_read_que_cuio();
			akxe_timer_set_msec(ptval,0);
		}
		else if (ptval->tv_sec < 0) ptval = NULL;
		ret = select(akb_fd_setsize(), &readfds, NULL, NULL, ptval);
		if (ret < 0) {
			ERROROUTL2(250,"aka_packet_read:select errno=%d [%s]",
			           errno,strerror(errno));
			if (errno == EINTR) {
				akb_fd_zero(&readfds);
				ret = 0;
			}
			else return -18505202 ;
		}
		if (ret > 0) {
			if ((iRc = _read_que_sd(&readfds)) < 0) break;
		}
/*
DEBUGOUTL3(AKA_LOG_GROUP|255,
"aka_packet_read: i=%d iCUIO_f=%d ret=%d",i,iCUIO_f,ret);
		if (!iCUIO_f && ret==0) break;
		akxe_timer_set_msec(&tval,0);
		ptval = &tval;
*/
	}
#ifndef NEW_GETMSG
	if (akxs_rb_get(tMsgCtl.rb_rctl)) {
#ifdef DEBUG
printf("aka_packet_read: There is Read Msg.\n");
#endif
		iRc = 1;
	}
#else
	while (p = akxs_rb_get_n(tMsgCtl.rb_rctl)) {
#ifdef DEBUG
printf("aka_packet_read: There is Read Msg.\n");
#endif
		iRc = akxs_que_put(tMsgCtl.que_rwctl,QUE_PUT,p);
		if (iRc < 0) return iRc ;
	}
	iRc = akxs_que_peek(tMsgCtl.que_rwctl,QUE_PEEK,NULL);
#endif

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_packet_write()
{
	fd_set  writefds;
	int iRc,i,nsel,iQSCheck,iSdi;
	struct timeval  tval;
	tdtCHANNEL *pCh,**ppCh;
	tdtRW_QUE *pWQ,**ppWQ;
	tdtCHANNEL_USER_IO *pCuio;
	int max=tMsgCtl.channel_used;

	if (tMsgCtl.sd<0) return -18505301;

	if (!tMsgCtl.channel_akb_used && akb_get_nwselect() <= 0) {
		akb_wqset_par(tMsgCtl.write_que_pa,tMsgCtl.rb_wctl,tMsgCtl.rb_wwctl,
		            tMsgCtl.rb_rctl);
	}

	akb_fd_zero(&writefds);

	iQSCheck = 0;
	i = tMsgCtl.channel_akb_used;
	ppCh = &tMsgCtl.channel_pa[i];
	ppWQ = &tMsgCtl.write_que_pa[i];
	for (;i<max;i++,ppCh++,ppWQ++) {
		if (pCh = *ppCh) {
			iSdi = pCh->sd;

DEBUGOUTL3(AKA_LOG_GROUP|255,
"aka_packet_write:i=%2d Stat=%02x Sd=%d",i,pCh->status,iSdi);

			if (iSdi>0 && !pCh->cuio) {
				if (pWQ = *ppWQ) {
					if (pWQ->rwq_torwlen > 0) {
						akb_fd_set(iSdi, &writefds);
						iQSCheck++;
#if 1
						if (!pWQ->rwq_rwlen) akb_set_need_reply(pWQ);
#endif
					}
				}
			}
		}
	}
	akb_set_wqsuspend(iQSCheck);
	if (!iQSCheck) return 0;

	tval.tv_sec  = 0;
	tval.tv_usec = 0;
	nsel = select(akb_fd_setsize(), NULL, &writefds, NULL, &tval);
	if (nsel < 0) {
		akb_set_nwselect(0);
		ERROROUTL2(250,"aka_packet_write:select errno=%d [%s]",errno,strerror(errno));
		if (errno == EINTR) akb_fd_zero(&writefds);
		else return -18505302;
	}
	else if (nsel > 0) {
		akb_set_nwselect(0);
	}
	else {
		akb_nwselect_increment();
	}

	tMsgCtl.wqsuspend = 0;
	i = tMsgCtl.channel_akb_used;
	ppWQ = &tMsgCtl.write_que_pa[i];
	ppCh = &tMsgCtl.channel_pa[i];
	for (;i<max;i++,ppCh++,ppWQ++) {
		if (!(pCh = *ppCh)) continue;
		if (pCh->sd > 0) {
			if (!(pWQ = *ppWQ)) continue;
			if (pCuio = pCh->cuio) {
/*
printf("aka_packet_write: UIO Write ucOpt1=%02x\n",pCh->opt1);
*/
				if (pCuio->write && !(pCh->opt1 & AKA_UIO_LOCK_WRITE)) {
					pCh->opt1 |= AKA_UIO_LOCK_WRITE;
					if (pCuio->select)
						pCh->select = pCuio->select(pCh->index,
						                              pCuio->parm,1);
					else
						pCh->select = 1;
					if (pCh->select>0 || akb_rwqtis_time_out(pWQ)) {
						iRc = aka_write_que(pCh,pWQ);
						if (iRc>0) tMsgCtl.wqsuspend++;
						else if (iRc<0) {
							Free(pWQ->rwq_buf);
							pWQ->rwq_torwlen = 0;
							pWQ->rwq_buf = NULL;
						}
					}
					pCh->opt1 &= ~AKA_UIO_LOCK_WRITE;
				}
			}
			else {
				if ((nsel>0 && FD_ISSET(pCh->sd,&writefds)) ||
				    akb_rwqtis_time_out(pWQ)) {
					if (i==0) iRc = akb_write_que(pWQ);
					else      iRc = aka_write_que(pCh,pWQ);
					if (iRc>0) tMsgCtl.wqsuspend++;
					else if (iRc<0) {
						if (stat_set_rb_pack_err_cd(get_src_ch(pWQ->rwq_buf),
						    pWQ->rwq_buf,
						    tMsgCtl.rb_rctl,D_ERR_WRITE_SOCKET)<0) {
							ERROROUT("aka_packet_write:akb_set_rb_pack_err_cd error.");
						/*	Free(pWQ->cpBuff);	*/
						}
						pWQ->rwq_torwlen = 0;
						pWQ->rwq_buf = NULL;
					}
				}
			}
		}
	}
	if (!tMsgCtl.wqsuspend && !nsel) tMsgCtl.wqsuspend = iQSCheck;
	akb_set_wqsuspend((int)tMsgCtl.wqsuspend);
/*	if (tMsgCtl.pRWQTimeOut->ucQRemain[1] || */
	if (akxs_rb_get(tMsgCtl.rb_wctl) || tMsgCtl.wqsuspend) iRc = 1;
	else iRc = 0;

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int check_del_wait_packet(tpIns, pHead, idel)
tdtINSTANCE   *tpIns;
pCOMM_PACK_HEAD  pHead;
int idel;
{
	pCOMM_PACK_HEAD  pHWait;
	pCOMM_PACK_HEADA pHWaitA;
    tdtWAIT_PACKET *tpWait,*tpNext;
	short sPacketNo_n,sPackNo;
	int iMR_wait,iMR;

#ifdef DEBUG_X
akxaxdump("RecvPacket",pHead,32);
#endif
	sPacketNo_n = pHead->cph_dinf.ind_pano;
	tpIns->recv_packet_no = ntohs(sPacketNo_n);
	iMR = pHead->cph_sinf.ind_disp & AKA_AKO_MULTI_REPLY;
	tpWait = NULL;
	tpNext = tpIns->wait_next;
	while (tpNext) {
		if (pHWait =(pCOMM_PACK_HEAD)tpNext->wait_packet) {
			if (pHWait->cph_prt.prt_ver == 'A') {
				pHWaitA = (pCOMM_PACK_HEADA)pHWait;
				sPackNo = pHWaitA->pha_sinf.ina_pano;
				iMR_wait = pHWaitA->pha_dinf.ina_disp & AKA_AKO_MULTI_REPLY;
			}
			else {
				sPackNo = pHWait->cph_sinf.ind_pano;
				iMR_wait = pHWait->cph_dinf.ind_disp & AKA_AKO_MULTI_REPLY;
			}
			if (sPackNo == sPacketNo_n) {
#ifdef DEBUG
printf("check_del_wait_packet:tpWait=%08x tpNext=%08x\n",tpWait,tpNext);
printf("check_del_wait_packet:iMR_wait=%02x iMR=%02x\n",iMR_wait,iMR);
#endif
				if (tpNext->status & AKA_WMSG_FUNC2) tpIns->kind |= 0x04;
				if (!(iMR_wait & iMR) && idel) {
					if (tpWait) tpWait->wait_next = tpNext->wait_next;
					else        tpIns->wait_next  = tpNext->wait_next;
					Free(pHWait);
					Free(tpNext);
				}
				return 1;
			}
		}
		tpWait = tpNext;
		tpNext = tpWait->wait_next;
	}
	return 0;
}

/********************************************************/
/*  ԐM҂bZ[W^CAEgɂ              */
/********************************************************/
int aka_wake_up_msg(lInstanceHandle,iRetCode)
long lInstanceHandle;
int  iRetCode;
{
	int    i,is,ie,count=0;
	int    iThread,iClassId;
	int    iMinWait;
	time_t ltime;
	struct timeval ttime;
	tdtCLASS_CTL   *tpClass;
	tdtINSTANCE   *tpIns;
	tdtWAIT_PACKET *tpWait;

	if (tMsgCtl.sd<0) return -18505501;

	/* NXƃXbhm̎o */
	iThread  = (lInstanceHandle>>16) & 0xff;
	iClassId = lInstanceHandle & 0xffff;


	/* ݎ̎肾 */
	if ((ltime = aka_get_msec(&ttime))<0) return -18505502;
DEBUGOUTL2(AKA_LOG_GROUP|255,
"aka_wake_up_msg:ttime=%d:%d",ttime.tv_sec,ttime.tv_usec);
	tpClass = tClassHead.class;
	iMinWait = -1;
	while (tpClass) {
		if (iClassId==0 || iClassId==tpClass->class_id) {
			tpIns = tpClass->instance;
			if (iThread == 0) {
				is = 0;
				ie = tpClass->max_thread;
			}
			else {
				ie = iThread;
				is = ie - 1;
			}
			for (i=is;i<ie;i++) {
				if (tpIns[i].used && (tpWait=tpIns[i].wait_next)) {
					while (tpWait) {
DEBUGOUTL3(AKA_LOG_GROUP|255,"aka_wake_up_msg:TimeOut=%d:%d Status=%08x",
tpWait->time_out.tv_sec,tpWait->time_out.tv_usec,tpWait->status);
						if (!(tpWait->status & AKA_WMSG_TIMEOUT)) {
							akxe_timer_set(&tpWait->time_out,&ttime);
							tpWait->status |= AKA_WMSG_WAKEUP;
							tpWait->ret_code = iRetCode;
							iMinWait = 0;
							count++;
						}
						tpWait = tpWait->wait_next;
					}
				}
			}
		}
		tpClass = tpClass->class_next;
	}
	if (iMinWait >= 0) tMsgCtl.send_msg_min_wait = iMinWait;

	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int stat_set_rb_pack_err_cd(iCh,pPacket,pRbCtl,iErrorCode)
int             iCh;
pCOMM_PACK_HEAD   pPacket;
tdtRB_CTL  *pRbCtl;
int  iErrorCode;
{
	char ver;
	int ret,iHSize;
	int lLen;
	tdtCOMM_PACK_HEAD *pHead;
	tdtCOMM_PACK_HEADA *pPHA;

	if (!(ret=akb_set_rb_pack_err_cd(iCh,pPacket,pRbCtl,iErrorCode))) {
		pHead = (tdtCOMM_PACK_HEAD *)pPacket;
		AKBGETHSIZEETC(pHead,ver,pPHA,iHSize,lLen);
		aka_statistics_count(1,iHSize+lLen);
	}
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_class_func(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	int ret;
    AKAMSGCOM tReplyMsg;
    char buf[512];

printf("sys_class_func: lInstanceHandle=%08x\n",lInstanceHandle);
	ret = aka_exec_method(lInstanceHandle,cpInstanceData,tpRecvMsg,NULL);
	if (ret < 0) {
		sprintf(buf,"sys_class_func: aka_exec_method ret=%d",ret);
		ERROROUT(buf);
		if (tpRecvMsg->msg_resv) { /* MԐM҂ĂƂ */
			memset(&tReplyMsg,0,sizeof(AKAMSGCOM));
			tReplyMsg.msg_pmsg   = buf;
			tReplyMsg.msg_mlen = strlen(buf);
			aka_reply_msg(lInstanceHandle,&tReplyMsg);
        }
		ret = 0;
	}
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_exec_method(lInstanceHandle,cpInstanceData,tpRecvMsg,cpUserData)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
char *cpUserData;
{
	static char *pp=NULL;
	int iThread,iClassId,iRc,iLen,len,argc,maxargc,i;
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	tdtINST_HNDL tInstHndl;
	tdtMETHOD *pMethod;
	tdtWAIT_METHOD *pWait;
	SSP_S ssp;
	char *p,**argv,*parm,*data;

	if (!tpRecvMsg) return -18505601;
	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS) return 0;

	/* NXƃXbhm̎o */
	if (lInstanceHandle) {
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))	/* -1 to -4 */
			return iRc - 18505602;
		tpClass  = tInstHndl.class;
		if (tpClass->max_method<=0 || !(pMethod=tpClass->method))
			return AKA_ERR_METHOD_NO_CMD;
		iThread  = tInstHndl.thread;
		iClassId = tInstHndl.class_id;
		tpIns    = tInstHndl.instance;
	}
	else return -18505601;

	iRc = AKA_ERR_METHOD_NO_CMD;
	if (tpRecvMsg->msg_disp == 0) {
		tpIns->method = NULL;
	    if (tpRecvMsg->msg_pret) return AKA_ERR_METHOD_NO_CMD;
		if ((iLen=tpRecvMsg->msg_mlen)<=0 || !(p=tpRecvMsg->msg_pmsg))
			return AKA_ERR_METHOD_NO_CMD;
		ssp.sp = 0;
		if ((len=akxtmgetline(p,iLen,&ssp)) > 0) {
			if ((maxargc=tpClass->max_method_parm) < 0) maxargc = 0;
			maxargc++;
			i = len + maxargc + 1 + maxargc*sizeof(char *);
			if (pp) pp=Realloc(pp,i);
			else pp=Malloc(i);
			if (!pp) return -18505606;
			argv = (char **)pp;
			parm = (char *)(argv+maxargc);
			ssp.wd[len] = '\0';
printf("aka_exec_method: len=%d wd=[%s]\n",len,ssp.wd);
			len += maxargc + 1;
			if ((argc=akxtgetargv2(ssp.wd,argv,maxargc,parm,len,0x17))<=0) {
printf("aka_exec_method: argc=%d\n",argc);
				return AKA_ERR_METHOD_NO_CMD;
			}
printf("aka_exec_method: argc=%d argv[0]=[%s]\n",argc,argv[0]);
			if (!*argv[0]) return AKA_ERR_METHOD_NO_CMD;
			for (i=0;i<tpClass->max_method;i++,pMethod++) {
				if (!strcmp(argv[0],pMethod->method_name)) {
					if ((iLen -= ssp.sp) <= 0) {
						p += iLen;
						iLen = 0;
					}
					else p += ssp.sp;
					tpRecvMsg->msg_mlen = iLen;
					tpRecvMsg->msg_pmsg   = p;
					tpIns->method = pMethod;
					return pMethod->func_name(lInstanceHandle,cpInstanceData,
							tpRecvMsg,argc,argv,cpUserData);
				}
			}
			iRc = AKA_ERR_METHOD_NOT_DEF;
			ERROROUT1("aka_exec_method: method[%s] not defined.",argv[0]);
		}
	}
	else {
printf("aka_exec_method: sRecvPacketNo=%d\n",tpIns->recv_packet_no);
		pWait=tpIns->wait_method;
		while (pWait) {
printf("aka_exec_method: pWait->sPacketNo=%d\n",pWait->packet_no);
			if (pWait->packet_no == tpIns->recv_packet_no) {
				pWait->packet_no = 0;	/* set to unused */
				pMethod = pWait->method;
				tpIns->method = pMethod;
				if (!pp) {
					if (!(pp=Malloc(sizeof(char *)))) return -18505606;
				}
				argv = (char **)pp;
				argv[0] = pMethod->method_name;
				return pMethod->func_name(lInstanceHandle,cpInstanceData,
						tpRecvMsg,1,argv,cpUserData);
			}
			pWait = pWait->wait_method;
		}
	}
	return iRc;
}

#if 0
/********************************************************
 *
 *    aka_get_msg(iWaitTime)
 *
 * ret  >0 ̂ƂApPbgB
 *      =0 ̂ƂApPbgȂB
 *      <0 ̂ƂAG[R[hB
 ********************************************************/
int aka_get_msg(iWaitTime)
int  iWaitTime  ;	/* select VXeR[ WaitTimei1/10bj */
{
	int iRc = 0;
	int iRcW,iRcR,iShutMode;
	int  lmtime;
	struct timeval tmtime;
	int iMinWaitTime,iTimerMinWait;

	if (tMsgCtl.sd<0) return -18505001;

	iShutMode = aka_shut_control(AKA_SHUT_GET,NULL);
	tMsgCtl.get_msg_wait_time = iWaitTime*100;
	if (tMsgCtl.get_msg_wait_time>=0) {
		if ((lmtime=aka_get_msec(&tmtime))<0) return -18505002;
		akxe_timer_add_msec(&tmtime,&tmtime,tMsgCtl.get_msg_wait_time);
		if (!timerisset(&tMsgCtl.get_msg_time_out) ||
		    timercmp(&tMsgCtl.get_msg_time_out,&tmtime,>)) {
			akxe_timer_add_msec(&tMsgCtl.get_msg_time_out,&tmtime,-5);
		}
	}

DEBUGOUTL5(AKA_LOG_GROUP|254,
"aka_get_msg:iWaitTime=%d tmtime=%d:%d tGetMsgTimeOut=%d:%d",
iWaitTime,tmtime.tv_sec,tmtime.tv_usec,tMsgCtl.get_msg_time_out.tv_sec,
tMsgCtl.get_msg_time_out.tv_usec);

	for (;;) {
#ifndef NO_TIMERPROC	/* add 2000.8.21 Koba */
		/****************
		 * ^C}[ *
		 ****************/
		aka_timer_proc();
#endif
		if (iWaitTime>=0 && tMsgCtl.rsv1) {
			if ((lmtime=aka_get_msec(&tmtime))<0) return -18505002;

DEBUGOUTL4(AKA_LOG_GROUP|254,
"aka_get_msg:tmtime=%d:%d tGetMsgTimeOut=%d:%d",
tmtime.tv_sec,tmtime.tv_usec,tMsgCtl.get_msg_time_out.tv_sec,
tMsgCtl.get_msg_time_out.tv_usec);

		    if (!timercmp(&tMsgCtl.get_msg_time_out,&tmtime,>)) {
				timerclear(&tMsgCtl.get_msg_time_out);
				tMsgCtl.rsv1 = 0;
				break;
			}
			/* ҂ԍĐݒ */
			tMsgCtl.get_msg_wait_time = akxe_timer_sub(NULL,
				&tMsgCtl.get_msg_time_out,&tmtime);

DEBUGOUTL1(AKA_LOG_GROUP|254,
"aka_get_msg:iGetMsgWaitTime=%d",tMsgCtl.get_msg_wait_time);

		}
		tMsgCtl.rsv1 = 1;
		/**********************
		 * pPbgv *
		 **********************/
		if ((iRcW=aka_packet_write())<0) {
			iRc = iRcW;
			break;
		}
		tMsgCtl.rsv1 = 2;
		if (tMsgCtl.send_msg_min_wait >= 0) {
			iMinWaitTime = tMsgCtl.send_msg_min_wait;
			if (tMsgCtl.get_msg_wait_time>0 &&
			    tMsgCtl.send_msg_min_wait>tMsgCtl.get_msg_wait_time)
				iMinWaitTime = tMsgCtl.get_msg_wait_time;
		}
		else iMinWaitTime = tMsgCtl.get_msg_wait_time;
#ifndef NO_TIMERPROC	/* add 2000.8.21 Koba */
		/*************************
		 * RWQueTimer̊Jn/~ *
		 *************************/
		aka_rwque_timer_ctl();
		iTimerMinWait = aka_timer_min_wait();

DEBUGOUTL2(AKA_LOG_GROUP|254,
"aka_get_msg:iMinWaitTime=%d iTimerMinWait=%d",
iMinWaitTime,iTimerMinWait);

		if ((iMinWaitTime < 0) ||
		    (iMinWaitTime >= 0 && iTimerMinWait >= 0 &&
		     iTimerMinWait < iMinWaitTime))
			iMinWaitTime = iTimerMinWait;

DEBUGOUTL1(AKA_LOG_GROUP|254,"aka_get_msg:iMinWaitTime=%d",iMinWaitTime);

#endif
	/*
		if (tMsgCtl.shut_mode && !tMsgCtl.shut_suspend && iMinWaitTime<0)
	*/
		if (iShutMode && iMinWaitTime<0) iMinWaitTime = 0;
		/**********************
		 * pPbgq   *
		 **********************/
		if ((iRcR=aka_packet_read(iMinWaitTime))<0) {
			iRc = iRcR;
			break;
		}
		tMsgCtl.rsv1 = 3;
		if (iRcW == 0) {
			if (iRcR > 0) {
				iRc = iRcR;
				break;
			}
		/*
			else if (tMsgCtl.shut_mode && !tMsgCtl.shut_suspend) {
		*/
			else if (iShutMode == 2) {
				iRc = AKB_CMD_FSHUT;
				break;
			}
			else if (iShutMode == 1) {
				iRc = AKB_CMD_SHUT;
				break;
			}
		}
	}
	if (iRc == D_ERR_READ_SOCKET) aka_set_connect_sd(-1);
	return iRc;
}
#endif
#ifdef AKASYS
#include "akasys3.c"
#endif
