static char sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */
/*                                                   */
/*           coded by A.Kobayashi  1994.06.11        */
/*         updated by A.Kobayashi  1996.05.28        */
/*         updated by A.Kobayashi  1998.10.01        */
/*         updated by A.Kobayashi  1999.01.20        */
/*         updated by A.Kobayashi  2000.01.28        */
/*                                                   */
/*===================================================*/
/*        int   fil_init()                           */
/*        int   fil_connect(p)                       */
/* static int fil_bindindex(bndp,nclm,buf,ssp,sep,opt)*/
/* static int   fil_bindtable(tablefile,cp)          */
/* static int   fil_sqldacopy(pd,ps,n)               */
/*        int   fil_bind(table,cp)                   */
/*        int   fil_exec_sql(sql,cp)                 */
/* static int   fil_insert(sql,cp,pos)               */
/* static uchar atox1(c)                             */
/* static int   butobi(bu, len, bi)                  */
/*        int   strmemcpy(d,s,l)                     */
/*        int   strmemcat(d,s,l)                     */
/*        int   fil_chk_date(s,d)                    */
/*        int   fil_make_tblnam(buf,buflen,table)    */
/*****************************************************/
#include "somn.h"

extern SQLCA_FIL sqlca_fil;

static char Dbname[256];

static int   fil_bindindex();
static int   fil_bindtable();
static int   fil_sqldacopy();
static int   fil_insert();
static uchar atox1();
static int   butobi();
static char *gcpWord=NULL;
static char *gcolm_argv[255];

int fil_init()
{
	int iRc;

	fil_init_engine();
	iRc = fil_init_cache(FIL_CACHE_TDF_EXT,FIL_CACHE_INTERVAL);
	if (iRc) return iRc;
	memset(gcolm_argv,0,sizeof(char *)*255);
	return 0;
}

int fil_connect(p)
char *p;
{
	int len;

	if (p) {
		if (*p) {
			strcpy(Dbname,p);
			len = strlen(Dbname);
			if (Dbname[len-1] != '/') {
				Dbname[len++] = '/';
				Dbname[len] = '\0';
			}
			sqlca_fil.sqlcode = 0;
			return 0;
		}
	}
	fil_errmsg(ERROR_NO_DBNAME);
	return 0;
}

static int fil_bindindex(bndp,nclm,buf,ssp,sep,opt)
SQLDA_FIL *bndp;
int    nclm;
char  *buf;
SSP_S *ssp;
char  *sep;
int    opt;
{
	int nix,ret=0;

	if (axtgwse(buf,ssp,sep,opt)) {
		if (!stricmp(ssp->wd,"INDEX")) {
			bndp->M[nclm] = 1;
			nix = *bndp->I[0];
			*bndp->I[0] = ++nix;
			*bndp->I[nix] = nclm;
		}
		else {
			ret= ERROR_SYNTAX;
		}
	}
	return ret;
}

static int _check_bulk_dir_colm(w,nclm)
char *w;
int  nclm;
{
	char c,*p;
	int  i,f;

	f = 0;
	while (c = *w++) {
		if (c == '<') {
			if (nclm <= 0) return 1;
			p = w;
			while (c = *w++) {
				if (c == '>') {
					i = atoi(p);
					if (i<=0 || i>=nclm) return -1;
					f++;
					break;
				}
				else if (c<'0' || c>'9') return -2;
			}
		}
	}
	return f;
}

static int _bulk_dir_colm_name(ww,name,maxsize)
char *ww,*name;
int  maxsize;
{
	char c,*p,*w,*na;
	int i,f,l,len;

	maxsize--;
	len = f = 0;
	w = ww;
	na = name;
	while ((c = *w++) && len<maxsize) {
		if (c == '<') {
			p = w;
			while (c = *w++) {
				if (c == '>') {
					i = atoi(p);
					p = gcolm_argv[i];
					l = strlen(p);
					if (len+l < maxsize) {
						memcpy(na,p,l);
						na  += l;
						len += l;
					}
					f++;
					break;
				}
			}
		}
		else {
			*na++ = c;
			len++;
		}
	}
	*na = '\0';
printf("_bulk_dir_colm_name:ww=[%s] name=[%s] f=%d len=%d\n",ww,name,f,len);
	return f;
}

#ifdef OLD_TABLE
static int fil_bindtable(tablefile,cp)
#else
static int fil_bindtable_s(tablefile,cp)
#endif
char *tablefile;
CURSOR *cp;
{
	static char sep[]=" \t,()\"'";
	static char sep1[]=" \t";
	SSP_S ssp;
	SQLDA_FIL *bndp;
	FILE *fp;
	char w[256],buf[256],file_name[256];
	int len,nclm,ret,opt,i;

	bndp = cp->bind;
	cp->inflg = 0;	/* csv format */
/*
printf("file=%s\n",tablefile);
*/
	if (!(fp=fopen(tablefile,"r"))) {
		return fil_errmsg(ERROR_OPEN);
	}
	ssp.wd = w;
	opt = 7;
	ret = nclm = 0;
	strcpy(bndp->S[nclm],ROWID_NAM);
	bndp->M[nclm] = 0;
	bndp->T[nclm] = TYPE_FIL_INTEGER;
	bndp->L[nclm] = 16;
	*bndp->I[0] = 0;
	nclm++;
	while (fgets(buf,sizeof(buf),fp) && !ret) {
		if (*buf == '#') {
			if (*(buf+1) == '!') {
				ssp.sp = 2;
				if (len=akxtgwsp(buf,&ssp)) {
					if (!stricmp(w,"CSV")) cp->inflg = FIL_FORM_CSV;
					else if (!stricmp(w,"FIXED")) cp->inflg = FIL_FORM_FIXED;
					else if (!stricmp(w,"FREE")) cp->inflg = FIL_FORM_FREE;
					else if (!stricmp(w,"SSV")) cp->inflg = FIL_FORM_SSV;
					else {
						ret = ERROR_SYNTAX;
						break;
					}
				}
			}
			continue;
		}
		ssp.sp = 0;
		if (!(len=axtgwse(buf,&ssp,sep1,opt))) continue;
/*
printf("w=%s\n",w);
*/
		if (!(len=axtgwse(buf,&ssp,sep,opt))) {
			ret = ERROR_SYNTAX;
			break;
		}
/*
printf("w=%s\n",w);
*/
		strmemcpy(bndp->S[nclm],w,bndp->Y[nclm]);
		if (!(len=axtgwse(buf,&ssp,sep,opt))) {
			ret = ERROR_SYNTAX;
			break;
		}
/*
printf("w=%s\n",w);
*/
		if (!stricmp(w,"CHAR") || !stricmp(w,"CHARACTER")) {
			bndp->M[nclm] = 0;
			bndp->T[nclm] = TYPE_FIL_CHAR;
			if (axtgwse(buf,&ssp,sep,opt)) { /* ( */
/*
printf("w=%s\n",w);
*/
				if (axtgwse(buf,&ssp,sep,opt)) {
/*
printf("w=%s\n",w);
*/
					bndp->L[nclm] = atoi(w);
					if (axtgwse(buf,&ssp,sep,opt)) { /* ) */
						ret = fil_bindindex(bndp,nclm,buf,&ssp,sep,opt);
					}
					else {
						ret= ERROR_SYNTAX;
					}
				}
				else {
					ret= ERROR_SYNTAX;
				}
			}
			else {
				ret= ERROR_SYNTAX;
			}
		}
		else if (!stricmp(w,"INTEGER") || !stricmp(w,"NUMBER")) {
			bndp->M[nclm] = 0;
			bndp->T[nclm] = TYPE_FIL_INTEGER;
			bndp->L[nclm] = 16;
			ret = fil_bindindex(bndp,nclm,buf,&ssp,sep,opt);
		}
		else if (!stricmp(w,"BULK")) {
			bndp->M[nclm] = 0;
			bndp->T[nclm] = TYPE_FIL_BULK;
			bndp->L[nclm] = 0;
			if (axtgwse(buf,&ssp,sep,opt)) {
/*
printf("w=%s\n",w);
*/
				if (!stricmp(w,"DIR")) {
					if (axtgwse(buf,&ssp,sep,opt)) {
/*
printf("w=%s\n",w);
*/
						i = _check_bulk_dir_colm(w,nclm);
printf("fil_bindtable_s: w=[%s] i=%d\n",w,i);
						if (i < 0) ret = ERROR_SYNTAX;
						if (bndp->X[nclm]=Malloc(strlen(w+1))) {
							strcpy(bndp->X[nclm],w);
							sprintf(file_name,w,0);
							bndp->T[nclm] |= 0x80;
							bndp->L[nclm] = strlen(tablefile)+
							strlen(bndp->S[nclm])+strlen(file_name)+2;
						}
						else {
							ret= ERROR_MALLOC;
						}
					}
					else {
						ret= ERROR_SYNTAX;
					}
				}
				else {
					ret= ERROR_SYNTAX;
				}
			}
		}
		else if (!stricmp(w,"DATE")) {
			bndp->M[nclm] = 0;
			bndp->T[nclm] = TYPE_FIL_DATE;
			bndp->L[nclm] = 19;	/* YYYY/MM/DD HH:MM:SS */
			ret = fil_bindindex(bndp,nclm,buf,&ssp,sep,opt);
		}
		else {
			ret= ERROR_SYNTAX;
		}
/*
printf("fil_bindtable:nclm=%d S=[%s] L=%d T=%d\n",nclm,bndp->S[nclm],bndp->L[nclm],bndp->T[nclm]);
*/
		nclm++;
	}
	fclose(fp);
	bndp->F = nclm;
	return ret;
}

#ifndef OLD_TABLE
static int fil_bindtable(table,cp)
char *table;
CURSOR *cp;
{
	char w[256];
	int  rc;

	strcpy(w,Dbname);
	strcat(w,table);
	strcat(w,".tdf");
	rc = fil_bindtable_s(w,cp);
	if (rc == ERROR_OPEN) {
		strcpy(w,Dbname);
		strcat(w,"default.tdf");
		rc = fil_bindtable_s(w,cp);
	}
	return rc;
}
#endif

static int fil_sqldacopy(pd,ps,n)
SQLDA_FIL *pd, *ps;
int n;
{
	int i;

	pd->F = n;
	memcpy((char *)(pd->T),(char *)(ps->T),n*sizeof(short));
	memcpy((char *)(pd->L),(char *)(ps->L),n*sizeof(long));
	memcpy((char *)(pd->M),(char *)(ps->M),n*sizeof(short));
/*
	if ((i=pd->LS) > ps->LS) i=ps->LS;
	memcpy(pd->S[0],ps->S[0],i);
*/
	memcpy(pd->S[0],ps->S[0],(ps->Y[0]+1)*n);
	memcpy((char *)(pd->X),(char *)(ps->X),n*sizeof(char *));
	memcpy((char *)(pd->I[0]),(char *)(ps->I[0]),sizeof(short)*n);
	return 0;
}

int fil_bind(table,cp)
char *table;
CURSOR *cp;
{
	int ret=0;
	char w[256];
	TABLECACHE *ptc;
	SQLDA_FIL *bndp;
/*
	strcpy(w,Dbname);
	strcat(w,table);
*/
	if ((ret=fil_make_tblnam(w,sizeof(w),table)) < 0) return ret;
	ret = 0;
	strcat(w,".tdf");
#ifdef OLD_CACHE
#ifndef NO_CACHE
	ptc = fil_cache(table,w);
	cp->tptc = ptc;
	if (ptc) {
		if (bndp=ptc->bndp) {
			fil_sqldacopy(cp->bind,bndp,bndp->F);
		}
		else {
			if (!(ret=fil_bindtable(w,cp))) {
				bndp = cp->bind;
				ptc->bndp = sqlald(bndp->F,bndp->Y[0],0);
				fil_sqldacopy(ptc->bndp,bndp,bndp->F);
			}
		}
	}
	else
#endif
		ret = fil_bindtable(w,cp);
	if (!ret) {
		if (!(cp->tblnam=
		      fil_realloc(cp->tblnam,0,strlen(Dbname)+strlen(table)+1)))
			return ERROR_MALLOC;
	/*
		strcpy(cp->tblnam,Dbname);
		strcat(cp->tblnam,table);
	*/
		fil_make_tblnam(cp->tblnam,-1,table);
	}
#else
	ptc = fil_cache(table,w);
	cp->tptc = ptc;
	if (ptc) {
		if (ptc->bndp) {
			cp->bind = ptc->bndp;
			cp->tblnam = ptc->tblnam;
/*
printf("fil_bind(found): bndp = %08x  tblnam = [%s]\n",ptc->bndp,ptc->tblnam);
akxaxdump("tblnam",ptc->tblnam-16,32);
bndp = cp->bind;
akxaxdump("tblnam",bndp->S[0],bndp->F*(bndp->Y[0]+1));
*/
		}
		else {
#ifdef OLD_TABLE
			if (!(ret=fil_bindtable(w,cp))) {
#else
			if (!(ret=fil_bindtable(table,cp))) {
#endif
				bndp = cp->bind;
				if (!(ptc->bndp = sqlald_fil(bndp->F,30,0)))
					return ERROR_MALLOC;
				fil_sqldacopy(ptc->bndp,bndp,bndp->F);
				if (!(cp->tblnam= Malloc(strlen(Dbname)+strlen(table)+1)))
					return ERROR_MALLOC;
			/*
				strcpy(cp->tblnam,Dbname);
				strcat(cp->tblnam,table);
			*/
				fil_make_tblnam(cp->tblnam,-1,table);
				ptc->tblnam = cp->tblnam;
/*
printf("fil_bind(new): bndp = %08x  tblnam = [%s]\n",ptc->bndp,ptc->tblnam);
akxaxdump("tblnam",ptc->tblnam-16,32);
*/
			}
		}
	}
	else {
#ifdef OLD_TABLE
		ret = fil_bindtable(w,cp);
#else
		ret = fil_bindtable(table,cp);
#endif
		if (!ret) {
			if (!(cp->tblnam=
			      fil_realloc(cp->tblnam,0,strlen(Dbname)+strlen(table)+1)))
				return ERROR_MALLOC;
		/*
			strcpy(cp->tblnam,Dbname);
			strcat(cp->tblnam,table);
		*/
			fil_make_tblnam(cp->tblnam,-1,table);
		}
	}
#endif
	return ret;
}

int fil_exec_sql(sql,cp)
char  *sql;
CURSOR *cp;
{
	SSP_S ssp;
	SQLDA_FIL *bndp;
	FILE *fp;
	char w[128],buf[128];
	int len,nclm,ret,i,j;

	bndp = cp->bind;
	sqlca_fil.sqlcode = 0;
	bndp->F = nclm = 0;
	ssp.sp = 0;
	ssp.wd = w;
	len=axtgwsp(sql,&ssp);
	if (len==0) {
		fil_errmsg(ERROR_NO_SQL);
		return 0;
	}
	if (!stricmp(w,"insert")) {
		fil_errmsg(fil_insert(sql,cp,ssp.sp));
	}
	else if (!stricmp(w,"update")) {
		return 0;
	}
	else if (!stricmp(w,"START")) {
		return 0;
	}
	else if (!stricmp(w,"COMMIT")) {
		return 0;
	}
	else if (!stricmp(w,"ROLLBACK")) {
		return 0;
	}
	else {
		fil_errmsg(ERROR_NOT_COMMAND);
	}
	return 0;
}

static int fil_insert(sql,cp,pos)
char  *sql;
CURSOR *cp;
int   pos;
{
	static char sep[]=" \t,()\"'";
	SQLDA_FIL *bndp;
	SSP_S ssp;
	FILE *fp;
	char *w, c, buf[256],name[64], *ww, *p, c_cur,*name_p,name2[128];
	int len,ret,i,opt,cnt,iLen,rett,iform,irem,dtlen,type;
	TABLECACHE *tptc=NULL;
	INDEX *tpIx=NULL;
	int  ixpos, ixlen, ixset;
	char ixrec[256];
	int bulk_dir_colm_flg,colm,bulk_dir_seqn_flg;

	/* [hpGAmۂ */
	len = strlen(sql);
	if (gcpWord) gcpWord = Realloc(gcpWord,len);
	else         gcpWord = Malloc(len);
	if (!gcpWord) return ERROR_MALLOC;

	ssp.sp = pos;
	ssp.wd = w = gcpWord;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (stricmp(w,"into")) return ERROR_SYNTAX;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (!stricmp(w,"values")) return ERROR_NO_TABLENAME;
	if (ret=fil_bind(w,cp)) return ret;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (stricmp(w,"values")) return ERROR_SYNTAX;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (*w!='(') return ERROR_SYNTAX;
/*
	if (!(cp->fp = fopen(cp->tblnam,"a"))) return ERROR_OPEN;
*/
	sqlca_fil.sqlerrd[2] = 0;
	iLen=ret=ixpos=ixset=0;
	bndp = cp->bind;

	/* add start 2000.01.27 Koba */
#ifdef OPENINDEX_BY_INSERT
	if (cp->fp = fopen(cp->tblnam,"r")) {
		fil_openindex(cp);
		fclose(cp->fp);
	}
#endif
	if (tptc=cp->tptc) {
		if (tpIx=tptc->tpIndex) {
			ixlen = fil_indexlen(bndp) + 1;
			if (ixlen > sizeof(ixrec)) {
				return ERROR_TOO_MANY;
			}
/*
printf("fil_insert:ixlen=%d\n",ixlen);
*/
			memset(ixrec,0,ixlen);
		}
	}
	/* add end   2000.01.27 Koba */

	if (!(cp->fp = fopen(cp->tblnam,"a"))) return ERROR_OPEN;
/*
printf("fil_insert:bndp->F=%d\n",bndp->F);
*/
	if (iform = cp->inflg) {
		opt  = 7;
	}
	else {
		opt  = 1;
	}
	opt |= 0x20;

	bulk_dir_colm_flg = bulk_dir_seqn_flg = 0;
	for (i=1;i<bndp->F;i++) {
		if (bndp->T[i] & 0x80) {
			ww = bndp->X[i];
			if (strchr(ww,'<')) bulk_dir_colm_flg = 1;
			if (strchr(ww,'%')) bulk_dir_seqn_flg = 1;
		}
	}
	i=1;
	dtlen = 0;
	while (i < bndp->F) {
		if (!(len=akxtgwse(sql,&ssp,sep,opt))) {
			ret = ERROR_NO_VALUE;
			break;
		}
		type = bndp->T[i];
		c_cur = *ssp.wd;
		if (c_cur==')' || c_cur==',') {
			if (type & 0x80) {
				strcpy(buf,cp->tblnam);
				strcat(buf,".");
				strcat(buf,bndp->S[i]);
				strcat(buf,"/");
				ww = buf + strlen(buf);
				p = name_p = bndp->X[i];
				if (bulk_dir_colm_flg) {
					_bulk_dir_colm_name(p,name2,sizeof(name2));
					p = name_p = name2;
				}
				if (bulk_dir_seqn_flg) {
					strcpy(ww,"syscount.dat");
					cnt = fil_syscount(buf,1);
/*
printf("fil_insert:i=%d w=[%s] buf=[%s] X=[%s] T=%04x\n",i,w,buf,bndp->X[i],bndp->T[i]);
*/
					sprintf(name,p,cnt);
					name_p = name;
				}
				strcpy(ww,name_p);
				if (!(fp = fopen(buf,"w"))) {
					ret = ERROR_OPEN;
					break;
				}
				if (*w == '\'' || *w == '"') {
					ww = w + 1;
					dtlen -= 2;
				}
				else ww = w;
				if ((type & 0x0f) == TYPE_FIL_BULK)
					dtlen = butobi(ww,dtlen,ww);
				fwrite(ww,1,dtlen,fp);
				fclose(fp);
				strcpy(w,name_p);
			}
			else if (type == TYPE_FIL_DATE) {
				if (dtlen > 0) {
					strmemcpy(name,w,sizeof(name)-1);
					if (*w == '\'' || *w == '"') {
						ww = name + 1;
						if (strlen(name) == dtlen) name[dtlen-1] = '\0';
					}
					else ww = name;
					ret = fil_chk_date(ww,buf);
					if (ret < 0) {
						ret = ERROR_DATE_FORMAT;
					/*	break;	*/
					}
					dtlen = strlen(buf);
				}
				if (!dtlen) strcpy(buf,akb_log_time());	/* defalt SYSDATE */
				if (!iform || (iform & FIL_FORM_SSV))	/* CSV or SSV */
					sprintf(w,"\"%s\"",buf);
				else strcpy(w,buf);
			}
			dtlen = strlen(w);
/*
printf("fil_insert:%c:dtlen=%d wd=[%s]\n",c,dtlen,w);
*/
			if (iform & FIL_FORM_FIXED) {	/* FIXED */
				irem = bndp->L[i] - dtlen;
				if (irem < 0) {
					fwrite(w,1,bndp->L[i],cp->fp);
				}
				else {
					fwrite(w,1,dtlen,cp->fp);
					while (irem--) {
						fwrite(" ",1,1,cp->fp);
					}
				}
				iLen += bndp->L[i];
			}
			else if (iform & FIL_FORM_FREE) {	/* FREE */
				w[dtlen++] = ' ';
				fwrite(w,1,dtlen,cp->fp);
				iLen += dtlen;
			}
			else {	/* CSV or SSV */
				if ((iform & FIL_FORM_SSV) && !dtlen) {
					strcpy(w,"\"\"");
					dtlen = 2;
				}
				fwrite(w,1,dtlen,cp->fp);
				iLen += dtlen;
			}
			if (bulk_dir_colm_flg || (tpIx && bndp->M[i])) {
				dtlen--;
				ww = w;
				if (*w == '\'' || *w == '"') ww++;
				c = *(w+dtlen);
				if (c=='\'' || c=='"') *(w+dtlen) = '\0';
				if (tpIx && bndp->M[i]) {
					strmemcpy(ixrec+ixpos,ww,bndp->L[i]);
					ixpos += bndp->L[i] + 1;
/*
printf("fil_insert:i=%d ixpos=%d ww=[%s]\n",i,ixpos,ww);
*/
					ixset = i;
				}
				if (bulk_dir_colm_flg) {
printf("fil_insert:ww=[%s]\n",ww);
					dtlen = strlen(ww);
					if (p=gcolm_argv[i]) p = Realloc(p,dtlen+1);
					else p = Malloc(dtlen+1);
					if (gcolm_argv[i] = p) strcpy(p,ww);
					else return ERROR_MALLOC;
printf("fil_insert:i=%d dtlen=%d gcolm_argv=[%s]\n",i,dtlen,p);
				}
			}
			if (c_cur==')') break;
#if 0
			if (tpIx && bndp->M[i] && ixset<i) {
				ixpos += bndp->L[i] + 1;
				ixset = i;
/*
printf("fil_insert:i=%d ixpos=%d\n",i,ixpos);
*/
			}
#endif
			if (!iform || (iform & FIL_FORM_SSV)) {	/* CSV or SSV */
				if (!iform) strcpy(w,",");	/* CSV */
				else strcpy(w," ");
				fwrite(w,1,1,cp->fp);
				iLen++;
			}
			i++;
			dtlen = 0;
			*w = '\0';
		}
		else {
			dtlen = len;
			memcpy(w,ssp.wd,dtlen);
			*(w+dtlen) = '\0';
/*
printf("fil_insert:data:dtlen=%d wd=[%s]\n",dtlen,w);
*/
		}
	}
	if (i >= bndp->F) ret = ERROR_TOO_MANY;
	sqlca_fil.sqlerrd[2] = 1;
	fprintf(cp->fp,"\n");
	iLen++;
	fclose(cp->fp);
	if (tpIx) {
		ixrec[ixlen-1] = '\n';
/*
akxaxdump("ixrec",ixrec,ixlen);
*/
#ifndef NO_INDEX
		if (rett=fil_addindex2(tpIx,iLen,ixrec,ixlen)) {
#else
		if (rett=fil_addindex(tpIx,iLen)) {
#endif
			fil_IndexFree(tpIx);
			tptc->tpIndex = NULL;
		}
	}
	return ret;
}

static unsigned char atox1(c)
char    c;
{
	c = toupper(c);
	if( (c >= '0') && (c <= '9') )
	{
		return(c - '0');
	}
	else if( (c >= 'A') && (c <= 'F') )
	{
		return(c - 'A' + 10);
	}
	else
	{
		return(0);
	}
}
		 
/* Convert bulk --> Binary */
static int butobi(bu, len, bi)
char    *bu;
char    *bi;
long    len;
{
	long   i, j = 0;
	char    c;
												  
/* 2-Byte zutu Henkan */
/*
printf("strlen = %d\n",len);
*/
	for( i = 0 ; i < len ; i++ )
	{
		c = toupper(*bu++);
		if( (c >= '0') && (c <= '9') )
			c -= '0';
		else if( (c >= 'A') && (c <= 'F') )
			c -= ('A' - 10);
		else
			continue;
		*bi++ = (c << 4) + atox1(*bu++);
		j++;
		i++;
	}
/*
printf("j = %d\n",j);
*/
	return(j);
}

int strmemcpy(d,s,n)
char *d,*s;
int n;
{
	int l;

	if (!d || !s || n<0) return 0;
	strncpy(d,s,n);
	*(d+n) = '\0';
	l = strlen(d);
	if (l < n) memset(d+l,0,n-l);
	return l;
}

int strmemcat(d,n,s)
char *d,*s;
int n;
{
	int l,m;

	if (!d || !s || n<0) return 0;
	*(d+n) = '\0';
	l = strlen(d);
	if ((m = n - l)>0) {
		strncat(d,s,m);
		l = strlen(d);
	}
	if (l < n) memset(d+l,0,n-l);
	return l;
}

int fil_chk_date(s,d)
char *s, *d;
{
	int len,ssp,n,ret;
	char wd[20],c,yyyy[5],mm[3],dd[3];

	if (!s || !d) return -1;
	*d = yyyy[4] = mm[2] = dd[2] = '\0';
	ssp = 0;
	len = akxtgetw(s, &ssp, wd, sizeof(wd));	/* YYYY/MM/DD */
/*
printf("chk_date:len=%d wd=[%s]\n",len,wd);
*/
	if (len == 10) {	/* YYYY/MM/DD */
		memcpy(yyyy,wd,4);
		memcpy(mm,wd+5,2);
		memcpy(dd,wd+8,2);
	}
	else if (len == 8) {	/* YY/MM/DD or YYYYMMDD */
		if ((c=wd[2])<'0' || c>'9') {	/* YY/MM/DD */
			ret = akxccvn(10,wd,2,&n);
			if (ret) return ret;
			if (n >= 51) strcpy(yyyy,"19");
			else         strcpy(yyyy,"20");
			memcpy(yyyy+2,wd,2);
			memcpy(mm,wd+3,2);
			memcpy(dd,wd+6,2);
		}
		else {	/* YYYYMMDD */
			memcpy(yyyy,wd,4);
			memcpy(mm,wd+4,2);
			memcpy(dd,wd+6,2);
		}
	}
	else if (len == 6) {	/* YYMMDD */
		ret = akxccvn(10,wd,2,&n);
		if (ret) return ret;
		if (n >= 51) strcpy(yyyy,"19");
		else         strcpy(yyyy,"20");
		memcpy(yyyy+2,wd,2);
		memcpy(mm,wd+2,2);
		memcpy(dd,wd+4,2);
	}
	else if (len < 6) return -2;
/*** wheresɂĂ΂̂łŃVXeݒłȂ
	else if (!len) {
		strcpy(d,akb_log_time());
		return 0;
	}
***/
	else return -3;

	len = akxtgetw(s, &ssp, wd, sizeof(wd));	/* HH:MM:SS */
	if (len == 0) {
		strcpy(wd,"00:00:00");
	}
	else if (len != 8) return -4;
	sprintf(d,"%s/%s/%s %s",yyyy,mm,dd,wd);
	return 0;
}

int fil_make_tblnam(buf,buflen,table)
char *table,*buf;
int  buflen;
{
	int len1,len2,len;

	if (!table || !buf) return -1;

	len1 = strlen(Dbname);
	len2 = strlen(table) + 1;
	if (buflen>=0 && buflen<(len=len1+len2)) return -2;

	memcpy(buf,Dbname,len1);
	memcpy(buf+len1,table,len2);

	return len;
}

#if 0
FILE *fil_dbms_fopen(buf,buflen,table,rw)
char *buf,*table,*rw;
int  buflen;
{
	FILE *fp=NULL;
	char *p;
	int len1,len2,len3,len;

	if (!table || !rw) return NULL;

	if (fp=fopen(table,rw)) return fp;

	len1 = strlen(Dbname);
	len2 = strlen(table);
	if (buflen>=0 && buflen<(len=len1+len2+1)) return NULL;
	memcpy(buf,Dbname,len1);
	memcpy(buf+len1,table,len2+1);
	if (fp=fopen(buf,rw)) return fp;

	if (len2>4 && !strcmp(table+len2-4,".tdf")) p = FIL_DIR_TDF;
	else p = FIL_DIR_DATA;
	len3 = strlen(p);
	if (buflen>=0 && buflen<(len+=len3+1)) return NULL;
	memcpy(buf,Dbname,len1);
	memcpy(buf+len1,p,len3);
	*(buf+len1+len3) = '/';
	memcpy(buf+len1+len3+1,table,len2+1);
	fp = fopen(buf,rw);
	return fp;
}
#endif
#if 0	/* org */
static int fil_insert(sql,cp,pos)
char  *sql;
CURSOR *cp;
int   pos;
{
	static char sep[]=" \t,()\"'";
	SQLDA_FIL *bndp;
	SSP_S ssp;
	FILE *fp;
	char *w, c, buf[256],name[64], *ww;
	int len,ret,i,opt,cnt,iLen,rett,iform,irem,dtlen,type;
	TABLECACHE *tptc=NULL;
	INDEX *tpIx=NULL;
	int  ixpos, ixlen, ixset;
	char ixrec[256];
/*
	if (!(w=Malloc(strlen(sql)))) return ERROR_SYNTAX;
*/
	ssp.sp = pos;
	ssp.wd = w = sql;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (stricmp(w,"into")) return ERROR_SYNTAX;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (!stricmp(w,"values")) return ERROR_NO_TABLENAME;
	if (ret=fil_bind(w,cp)) return ret;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (stricmp(w,"values")) return ERROR_SYNTAX;
	if (!(len=axtgwsp(sql,&ssp))) return ERROR_SYNTAX;
	if (*w!='(') return ERROR_SYNTAX;
/*
	if (!(cp->fp = fopen(cp->tblnam,"a"))) return ERROR_OPEN;
*/
	sqlca_fil.sqlerrd[2] = 0;
	iLen=ret=ixpos=ixset=0;
	bndp = cp->bind;

	/* add start 2000.01.27 Koba */
#ifdef OPENINDEX_BY_INSERT
	if (cp->fp = fopen(cp->tblnam,"r")) {
		fil_openindex(cp);
		fclose(cp->fp);
	}
#endif
	if (tptc=cp->tptc) {
		if (tpIx=tptc->tpIndex) {
			ixlen = fil_indexlen(bndp) + 1;
			if (ixlen > sizeof(ixrec)) {
				return ERROR_TOO_MANY;
			}
/*
printf("fil_insert:ixlen=%d\n",ixlen);
*/
			memset(ixrec,0,ixlen);
		}
	}
	/* add end   2000.01.27 Koba */

	if (!(cp->fp = fopen(cp->tblnam,"a"))) return ERROR_OPEN;
/*
printf("fil_insert:bndp->F=%d\n",bndp->F);
*/
	if (iform = cp->inflg) {
		opt  = 7;
	}
	else {
		opt  = 1;
	}
	i=1;
	dtlen = 0;
	while (i < bndp->F) {
		if (!(len=akxtgwse(sql,&ssp,sep,opt))) {
			ret = ERROR_NO_VALUE;
			break;
		}
		type = bndp->T[i];
		c = *w;
		if (c==')' || c==',') {
			if (!dtlen && type==TYPE_FIL_DATE && !iform) {
				sprintf(w,"\"%s\"",akb_log_time());	/* defalt SYSDATE */
				dtlen = strlen(w);
				fwrite(w,1,dtlen,cp->fp);
				iLen += dtlen;
			}
			if (c==')') break;
			else if (c==',') {
				if (ixset<i) {
					if (tpIx && bndp->M[i]) {
						ixpos += bndp->L[i] + 1;
/*
printf("fil_insert:i=%d ixpos=%d\n",i,ixpos);
*/
					}
					ixset = i;
				}
				if (!iform) {	/* csv */
					fwrite(w,1,1,cp->fp);
					iLen++;
				}
				else if (iform & FIL_FORM_SSV) {	/* ssv */
					fwrite(" ",1,1,cp->fp);
					iLen++;
				}
				i++;
				dtlen = 0;
			}
		}
		else {
/*
printf("fil_insert:len=%d wd=[%s]\n",len,w);
*/
			if (type & 0x80) {
				strcpy(buf,cp->tblnam);
				strcat(buf,".");
				strcat(buf,bndp->S[i]);
				strcat(buf,"/");
				ww = buf + strlen(buf);
				strcpy(ww,"syscount.dat");
				cnt = fil_syscount(buf,1);
/*
printf("fil_insert:i=%d w=[%s] buf=[%s] X=[%s] T=%04x\n",i,w,buf,bndp->X[i],bndp->T[i]);
*/
				sprintf(name,bndp->X[i],cnt);
				strcpy(ww,name);
				if (!(fp = fopen(buf,"w"))) {
					ret = ERROR_OPEN;
					break;
				}
				if (*w == '\'' || *w == '"') {
					ww = w + 1;
					len -= 2;
				}
				else ww = w;
				if ((type & 0x0f) == TYPE_FIL_BULK)
					len = butobi(ww,len,ww);
				fwrite(ww,1,len,fp);
				fclose(fp);
				strcpy(w,name);
			}
			else if (type == TYPE_FIL_DATE) {
				strmemcpy(name,w,sizeof(name)-1);
				if (*w == '\'' || *w == '"') {
					ww = name + 1;
					if (strlen(name) == len) name[len-1] = '\0';
				}
				else ww = name;
				ret = fil_chk_date(ww,buf);
				if (ret < 0) {
					ret = ERROR_DATE_FORMAT;
				/*	break;	*/
				}
				else {
					if (!iform) sprintf(w,"\"%s\"",buf);	/* csv */
					else strcpy(w,buf);
				}
			}
			dtlen = len = strlen(w);
			if (iform & FIL_FORM_FIXED) {	/* FIXED */
				irem = bndp->L[i] - len;
				if (irem < 0) {
					fwrite(w,1,bndp->L[i],cp->fp);
				}
				else {
					fwrite(w,1,len,cp->fp);
					while (irem--) {
						fwrite(" ",1,1,cp->fp);
					}
				}
				iLen += bndp->L[i];
			}
			else if (iform & FIL_FORM_FREE) {	/* FREE */
				w[len++] = ' ';
				fwrite(w,1,len,cp->fp);
				iLen += len;
			}
			else {	/* CSV or SSV */
				fwrite(w,1,len,cp->fp);
				iLen += len;
			}
			if (tpIx && bndp->M[i]) {
				len--;
				ww = w;
				if (*w == '\'' || *w == '"') ww++;
				if (*(w+len)=='\'' || *(w+len)=='"') *(w+len) = '\0';
				strmemcpy(ixrec+ixpos,ww,bndp->L[i]);
				ixpos += bndp->L[i] + 1;
/*
printf("fil_insert:i=%d ixpos=%d ww=[%s]\n",i,ixpos,ww);
*/
				ixset = i;
			}
		}
	}
	if (i >= bndp->F) ret = ERROR_TOO_MANY;
	sqlca_fil.sqlerrd[2] = 1;
	fprintf(cp->fp,"\n");
	iLen++;
	fclose(cp->fp);
	if (tpIx) {
		ixrec[ixlen-1] = '\n';
/*
akxaxdump("ixrec",ixrec,ixlen);
*/
#ifndef NO_INDEX
		if (rett=fil_addindex2(tpIx,iLen,ixrec,ixlen)) {
#else
		if (rett=fil_addindex(tpIx,iLen)) {
#endif
			fil_IndexFree(tpIx);
			tptc->tpIndex = NULL;
		}
	}
	return ret;
}
#endif
