static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*
 *	akbdump.c
 *
 *		coded     by       9292/02/24
 *		updated   by A.Kobayashi 96/04/22
 *		updated   by A.Kobayashi 98/03/03
 *		updated   by A.Kobayashi 2001/10/18
 *		updated   by A.Kobayashi 2002/03/13
 *
 */
#include	<akbcommon.h>

static void akb_dump_c();
static void akb_dump_b();
static void akb_dump_a();

/* **************************************************/
/*		pPbg_v								*/
/* **************************************************/
void akb_dump2(dump_file, flag, pHead, para, opt)
char            *dump_file;
int				flag;	/* 0: read, 1: write		*/
pCOMM_PACK_HEAD	pHead ;	/* AKB HEADER				*/
char			*para;	/* Parameter				*/
int             opt;	/* 0x10=1:binery dump		*/
						/* 0x20=1:header dump		*/
{
	unsigned char	*p, ucThrd;
	FILE	*fp;
	time_t  tt;
	struct  tm *tm_str;
	char    buf[64];
	pCOMM_PACK_HEADA	pHeadA;
	int bina_dump,len,head_dump;

	if (!dump_file || !pHead) return;
	fp = fopen(akb_akb_home_add(dump_file),"a");
	if(!fp) return;
	if (flag == 2) p = "OUTPUT(R)";
	else if(!flag) p = "INPUT    ";
	else           p = "OUTPUT   ";
	fprintf(fp,"\n***** %s *****\n",p);
	akb_get_log_time(buf,63,NULL);
	bina_dump = opt & AKB_TRACE_BINARY;
	head_dump = opt & AKB_TRACE_HEAD_DUMP;
	if (pHead->cph_prt.prt_ver == 'A') {
		akb_dump_a(fp, pHead, buf, opt);
		if (bina_dump) fwrite(pHead,1,sizeof(tdtCOMM_PACK_HEADA),fp);
		else if (head_dump) akxafxdmp(fp, NULL, pHead, sizeof(tdtCOMM_PACK_HEADA));
		if (para) {
			pHeadA = (pCOMM_PACK_HEADA)pHead;
			len = ntohl(pHeadA->pha_plen);
			if (bina_dump) fwrite(para,1,len,fp);
			else akxafxdmp(fp, NULL, para, len);
		}
	}
	else {
		if (pHead->cph_prt.prt_ver == 'C') akb_dump_c(fp, pHead, buf, opt);
		else                            akb_dump_b(fp, pHead, buf, opt);
		if (bina_dump) fwrite(pHead,1,sizeof(tdtCOMM_PACK_HEAD),fp);
		else if (head_dump) akxafxdmp(fp, NULL, pHead, sizeof(tdtCOMM_PACK_HEAD));
		if (para) {
			len = ntohl(pHead->cph_plen);
			if (bina_dump) fwrite(para,1,len,fp);
			else akxafxdmp(fp, NULL, para, len);
		}
	}
	fputc('\n',fp);
	fclose(fp);
}

static void akb_dump_c(fp, pHead, buf, opt)
FILE *fp;
pCOMM_PACK_HEAD pHead;
char *buf;
int  opt;
{
	unsigned char	*p, ucThrd;

	ucThrd = pHead->cph_sinf.ind_thrd;
	if(ucThrd) fprintf( fp, "\n***** M (%s) *****\n",buf);
	else       fprintf( fp, "\n***** ԐM (%s) *****\n",buf);
	if (opt & AKB_TRACE_BINARY) return;
	fprintf( fp,"Ver      : %c\n",pHead->cph_prt.prt_ver);
	fprintf( fp,"Inf      : 0x%02x\n",(int)pHead->cph_prt.prt_send);
	fprintf( fp,"Command  : %d\n",(int)ntohs(pHead->cph_prt.prt_cmnd));
	p = (unsigned char *)&pHead->cph_dinf.ind_hoid;
	fprintf( fp,"Host (d) : %d.%d.%d.%d\n",
	            (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3));
	fprintf( fp,"Proc (d) : %d\n",ntohs(pHead->cph_dinf.ind_prid));
	fprintf( fp,"Class(d) : %d\n",ntohs(pHead->cph_dinf.ind_clid));
	if (ucThrd) {	/* M/*/
		fprintf( fp,"Akbopt   : %d\n",     pHead->cph_dinf.ind_disp);
		fprintf( fp,"Akberror : %d\n",ntohs(pHead->cph_dinf.ind_pano));
	}
	else {	/* ԐM/*/
		fprintf( fp,"Thread   : %d\n",     pHead->cph_dinf.ind_thrd);
		fprintf( fp,"Dispos   : %d\n",     pHead->cph_dinf.ind_disp);
		fprintf( fp,"PackNo   : %d\n",ntohs(pHead->cph_dinf.ind_pano));
	}
	p = (unsigned char *)&pHead->cph_sinf.ind_hoid;
	fprintf( fp,"Host (s) : %d.%d.%d.%d\n",
	            (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3));
	fprintf( fp,"Proc (s) : %d\n",ntohs(pHead->cph_sinf.ind_prid));
	fprintf( fp,"Class(s) : %d\n",ntohs(pHead->cph_sinf.ind_clid));
	if (ucThrd) {	/* M/*/
		fprintf( fp,"Thread   : %d\n",     pHead->cph_sinf.ind_thrd);
		fprintf( fp,"Dispos   : %d\n",     pHead->cph_sinf.ind_disp);
		fprintf( fp,"PackNo   : %d\n",ntohs(pHead->cph_sinf.ind_pano));
	}
	else {	/* ԐM/*/
		fprintf( fp,"Akbopt   : %d\n",     pHead->cph_sinf.ind_disp);
		fprintf( fp,"Akberror : %d\n",ntohs(pHead->cph_sinf.ind_pano));
	}
	fprintf( fp,"PackLen  : %d\n",(int)ntohl(pHead->cph_plen));
}

static void akb_dump_b(fp, pHead, buf, opt)
FILE *fp;
pCOMM_PACK_HEADB pHead;
char *buf;
int  opt;
{
	unsigned char	*p, ucThrd;
	INT4 lPackId;

	lPackId = pHead->phb_dind.inb_pkid;
	if(!lPackId) fprintf( fp, "\n***** M(%s) *****\n",buf);
	else         fprintf( fp, "\n***** ԐM(%s) *****\n",buf);
	if (opt & AKB_TRACE_BINARY) return;
	fprintf( fp,"Ver      : %c\n",pHead->phb_prt.prt_ver);
	fprintf( fp,"Inf      : 0x%02x\n",(int)pHead->phb_prt.prt_send);
	fprintf( fp,"Command  : %d\n",(int)ntohs(pHead->phb_prt.prt_cmnd));
	p = (unsigned char *)&pHead->phb_dind.inb_hoid;
	fprintf( fp,"Host (d) : %d.%d.%d.%d\n",
	            (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3));
	fprintf( fp,"Proc (d) : %d\n",ntohl(pHead->phb_dind.inb_prid));
	if(!lPackId)	/* M/*/
		fprintf( fp,"Akberror : %d\n",ntohl(pHead->phb_dind.inb_pkid));
	else	/* ԐM/*/
		fprintf( fp,"PacketId : 0x%08x\n",ntohl(pHead->phb_dind.inb_pkid));
	p = (unsigned char *)&pHead->phb_sind.inb_hoid;
	fprintf( fp,"Host (s) : %d.%d.%d.%d\n",
	            (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3));
	fprintf( fp,"Proc (s) : %d\n",ntohl(pHead->phb_sind.inb_prid));
	if(!lPackId)	/* M/*/
		fprintf( fp,"PacketId : 0x%08x\n",ntohl(pHead->phb_sind.inb_pkid));
	else	/* ԐM/*/
		fprintf( fp,"Akberror : %d\n",ntohl(pHead->phb_sind.inb_pkid));
	fprintf( fp,"PackLen  : %d\n",(int)ntohl(pHead->phb_plen));
}

static void akb_dump_a(fp, pHead, buf, opt)
FILE *fp;
pCOMM_PACK_HEADA pHead;
char *buf;
int  opt;
{
	unsigned char	*p, ucThrd;

	ucThrd = pHead->pha_sinf.ina_thrd;
	if(ucThrd) fprintf( fp, "\n***** M (%s) *****\n",buf);
	else       fprintf( fp, "\n***** ԐM (%s) *****\n",buf);
	if (opt & AKB_TRACE_BINARY) return;
	fprintf( fp,"Ver      : %c\n",pHead->pha_prt.prt_ver);
	fprintf( fp,"Inf      : 0x%02x\n",(int)pHead->pha_prt.prt_send);
	fprintf( fp,"Command  : %d\n",(int)ntohs(pHead->pha_prt.prt_cmnd));
	p = (unsigned char *)&pHead->pha_dinf.ina_hoid;
	fprintf( fp,"Host (d) : %d.%d.%d.%d\n",
	            (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3));
	fprintf( fp,"Resv (d) : %d\n",ntohs(pHead->pha_dinf.ina_resv));
	fprintf( fp,"APSys(d) : %d\n",ntohs(pHead->pha_dinf.ina_apid));
	fprintf( fp,"Proc (d) : %d\n",ntohs(pHead->pha_dinf.ina_prid));
	fprintf( fp,"Class(d) : %d\n",ntohs(pHead->pha_dinf.ina_clid));
	if (ucThrd) {	/* M/*/
		fprintf( fp,"Akbopt   : %d\n",     pHead->pha_dinf.ina_disp);
		fprintf( fp,"Akberror : %d\n",ntohs(pHead->pha_dinf.ina_pano));
	}
	else {	/* ԐM/*/
		fprintf( fp,"Thread   : %d\n",     pHead->pha_dinf.ina_thrd);
		fprintf( fp,"Dispos   : %d\n",     pHead->pha_dinf.ina_disp);
		fprintf( fp,"PackNo   : %d\n",ntohs(pHead->pha_dinf.ina_pano));
	}
	p = (unsigned char *)&pHead->pha_sinf.ina_hoid;
	fprintf( fp,"Host (s) : %d.%d.%d.%d\n",
	            (int)*p,(int)*(p+1),(int)*(p+2),(int)*(p+3));
	fprintf( fp,"Resv (s) : %d\n",ntohs(pHead->pha_sinf.ina_resv));
	fprintf( fp,"APSys(s) : %d\n",ntohs(pHead->pha_sinf.ina_apid));
	fprintf( fp,"Proc (s) : %d\n",ntohs(pHead->pha_sinf.ina_prid));
	fprintf( fp,"Class(s) : %d\n",ntohs(pHead->pha_sinf.ina_clid));
	if (ucThrd) {	/* M/*/
		fprintf( fp,"Thread   : %d\n",     pHead->pha_sinf.ina_thrd);
		fprintf( fp,"Dispos   : %d\n",     pHead->pha_sinf.ina_disp);
		fprintf( fp,"PackNo   : %d\n",ntohs(pHead->pha_sinf.ina_pano));
	}
	else {	/* ԐM/*/
		fprintf( fp,"Akbopt   : %d\n",     pHead->pha_sinf.ina_disp);
		fprintf( fp,"Akberror : %d\n",ntohs(pHead->pha_sinf.ina_pano));
	}
	fprintf( fp,"PackLen  : %d\n",(int)ntohl(pHead->pha_plen));
}

void akb_dump( dump_file, flag, pHead, para )
char            *dump_file;
int				flag;	/* 0: read, 1: write		*/
pCOMM_PACK_HEAD	pHead ;	/* AKB HEADER				*/
char			*para;	/* Parameter				*/
{
	akb_dump2(dump_file, flag, pHead, para, 0);
}
