/*

	lj (line join)

	2004.3.11 A.Kobayashi

*/
#include "akxcommon.h"

typedef struct {
	int obj_line;
	int skip_line;
	int join_line;
	int tr_line;
	int opt_put_obj;
	int opt_put_skip;
	int padding[2];
} qProcLine;

char buf[4096];
FILE *fp=NULL;
int opt_cr,opt_bj,loop_max;
int header_skip_line;
int opt_put_header;
qProcLine *pProcLine;

static void _usage(p)
char *p;
{
	fprintf(stderr,"usage: %s [-h|-?] [--{e|p|d|l}[LOG_PARM]] [-r][-b][-number]\n          {-|filename} [-]header_skip_line [LINE_PARM-1 LINE_PARM-2 ...]\n",p);
	fprintf(stderr,"  where\n     LOG_PARM := [FLAG],[LEVEL],[SIZE_MAX],[FILE_MAX],[OPTION],[FILE],[PRIORITY]]\n");
	fprintf(stderr,"    LINE_PARM := [-]obj_line[,[-]skip_line[,join_line]]\n\n");
}

static void _put_kai()
{
	if (opt_cr) putchar('\r');
	putchar('\n');
}

int main (argc,argv)
int  argc;
char *argv[];
{
	char *pn,c,*p,*filename=NULL;
	int  i,len,ret;
	qProcLine *pPL;

	pn = akxt_get_last_name("\\/",argv[0]);
	akx_log_set_up_name(pn);
	XLOGFLG(X_LOG_NO_ERROR,D_LOG_FLG_STDERR);
	XLOGFLG(X_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	opt_cr = opt_bj = 0;
	loop_max = -1;
	while (--argc > 0) {
		argv++;
		p = argv[0];
		if ((c=*p) == '-') {
			p++;
			if (!(c=*p)) {
				fp = stdin;
				break;
			}
			else if (c=='-') {
				p++;
				if ((ret=akx_log_set_command_parm(*p,p+1)) < 0) {
					if (ret == -1)
						XERROROUTL5(0,"internal error!!",0,0,0,0,0);
					else
						_usage(pn);
					exit(2);
				}
			}
			else if (c=='r') opt_cr = 1;
			else if (c=='b') opt_bj = 1;
			else if (c>='0' && c<='9') loop_max = atoi(p);
		/*	else if (c=='h' || c=='?') {	*/
			else {
				_usage(pn);
				exit(1);
			}
		}
		else {
			filename = p;
			break;
		}
	}
	if (--argc < 1) {
		_usage(pn);
		exit(3);
	}
	if (!fp && filename) {
		if (!(fp=fopen(filename,"r"))) {
			XERROROUTL5(0,"file[%s] open error!!",filename,0,0,0,0);
			exit(4);
		}
	}
	argv++;
	opt_put_header = 1;
	if ((header_skip_line = atoi(argv[0])) < 0) {
		header_skip_line = -header_skip_line;
		opt_put_header = 0;
	}
/*
printf("opt_cr=%d,loop_max=%d,header_skip_line=%d,opt_put_header=%d\n",
opt_cr,loop_max,header_skip_line,opt_put_header);
*/
	argc--;
	argv++;
	pProcLine=(qProcLine *)Malloc(sizeof(qProcLine)*argc);
	pPL = pProcLine;
	for (i=0;i<argc;i++,pPL++) {
		set_line(pPL,argv[i]);
	}

	for (i=0;i<header_skip_line;i++) {
		if (read_line(buf,sizeof(buf),fp) < 0) exit(0);
		if (opt_put_header) {
			printf("%s",buf);
			_put_kai();
		}
	}

	len = 0;
	if (argc > 0) {
		for (;;) {
			if (loop_max >= 0) {
				if (loop_max-- <= 0) break;
			}
			pPL = pProcLine;
			for (i=0;i<argc;i++,pPL++) {
				if ((len=proc_line(pPL))<0) break;
			}
			if (len < 0) break;
		}
	}

	fclose(fp);
	exit(0);
}

int read_line()
{
	return akxa_get_line(buf,sizeof(buf),fp,0x03);
}

int set_line(pPL,buf)
qProcLine *pPL;
char *buf;
{
	int header_skip_line,obj_line,skip_line,join_line,tr_line;
	int opt_put_header,opt_put_obj,opt_put_skip;
	char *argv[3],parm[256];
	int  argc;

	pPL->obj_line = pPL->skip_line = pPL->join_line = 0;
	pPL->opt_put_obj = pPL->opt_put_skip = 1;

	argc = akxtgetargv2(buf,argv,3,parm,sizeof(parm),5);
	if (argc >= 1) {
		if ((pPL->obj_line  = atoi(argv[0])) < 0) {
			pPL->obj_line = -pPL->obj_line;
			pPL->opt_put_obj = 0;
		}
	}
	if (argc >= 2) {
		if ((pPL->skip_line = atoi(argv[1])) < 0) {
			pPL->skip_line = -pPL->skip_line;
			pPL->opt_put_skip = 0;
		}
	}
	if (argc >= 3) {
		if ((pPL->join_line = atoi(argv[2])) < 0) {
			XERROROUTL5(0,"join_line(%d) invalid!!",pPL->join_line,0,0,0,0);
			return -4;
		}
	}
	if ((pPL->tr_line=pPL->obj_line-(pPL->skip_line+pPL->join_line)) < 0) {
		XERROROUTL5(0,"obj_line(%d) < skip_line(%d)+join_line(%d)!!",
			pPL->obj_line,pPL->skip_line,pPL->join_line,0,0);
		return -5;
	}
/*
printf("set_line: obj_line=%d,skip_line=%d,join_line=%d,tr_line=%d,opt_put_obj=%d,opt_put_skip=%d\n",pPL->obj_line,pPL->skip_line,pPL->join_line,pPL->tr_line,
pPL->opt_put_obj,pPL->opt_put_skip);
*/
	return 0;
}

int proc_line(pPL)
qProcLine *pPL;
{
	int len=0,i;

	for (i=0;i<pPL->skip_line;i++) {
		if ((len=read_line(buf,sizeof(buf),fp)) < 0) return len;
		if (pPL->opt_put_skip) {
			printf("%s",buf);
			_put_kai();
		}
	}
	if (pPL->join_line > 0) {
		for (i=0;i<pPL->join_line;i++) {
			if ((len=read_line(buf,sizeof(buf),fp)) < 0) break;
			if (opt_bj && (i>0)) putchar(' ');
			printf("%s",buf);
		}
		_put_kai();
		if (len < 0) return len;
	}
	for (i=0;i<pPL->tr_line;i++) {
		if ((len=read_line(buf,sizeof(buf),fp)) < 0) break;
		if (pPL->opt_put_obj) {
			printf("%s",buf);
			_put_kai();
		}
	}
	return len;
}
