/*******************************************/
/*						*/
/*	glike	 			*/
/*						*/
/*		by A.Kobayashi 2004.10.9	*/
/*						*/
/*******************************************/
#include "akxcommon.h"

#define	ESCAPE_CHAR	'\\'

static char *VERSION="1.0.0";
static FILE *fp;
static char c,*p,buf[256],*pat,*pattern,*patv[128],*patfile;
static int  size,ret,len,opt,pat_len,pos[4],*posp,npat;
static int  iHV,iCASE,iCR,iFN,iLN,iTRY,iV,iTRIM;
static struct {
	char *pat;
	int  len;
} Pat[128];
static tdtLike *plike;

static void _usage()
{
	static char *h[]=
	{"\nUsage: glike [Option] PatternList { - | File ... }"
	,"  Search for PATTERN in each FILE or standard input."
	,"  Example: glike -i 'hello world' menu.h main.c"
	,"\n  Option:"
#if 1
	,"\t--h: help"
	,"\t--v: version"
	,"\t-h : not display file name and line number"
	,"\t-i : ignore case pattern"
	,"\t-o : display only matching string"
	,"\t-n : display line number"
	,"\t-W : display CR+LF"
	,"\t-S[ ]LineSize : input line size (byte)"
	,"\t-f[ ]PatternFile : matching pattern file"
	,"\t-v : Invert the sense of matching, to select non-matching lines."
	,"\t-y : try matching to line end"
	,"\t-t : trim content before display"
	,"\n  PatternList : matching pattern list"
	,"  -  : stdin"
	,"  File ... : input files"
	,""
#else
	,"\t-r : sƂCRLF(0x0d0a)o͂B\n"
#endif
	,NULL
	};
	char **ph,*p;

	ph = h;
	while (p = *ph++) fprintf(stderr,"%s\n",p);
}

static void _check_usage()
{
	if (!(iHV & 0x01)) _usage();
}

static int _set_pattern(pattern)
char *pattern;
{
	char *pat,*p,*pp,*wrk,*ps,*pd,c;
	int  pat_len,i,n,len;

	pat_len = strlen(pattern);
	if (!(wrk=Malloc(pat_len+1))) return -1;
	if (!(pat=Malloc(pat_len+128*2))) return -1;
	if (*pattern == '(') {
		if (*(p=pattern+pat_len-1) == ')') *p = '\0';
		n = akxtgetnvsep(pattern+1,patv,128,"|",0x08);
		if (n < 0) return n;
		n++;
	}
	else {
		n = 1;
		patv[0] = pattern;
	}
	pp = pat;
	for (i=0;i<n;i++) {
		ps = patv[i];
		len = strlen(ps);
		pd = pp;
		if ((c=*ps)=='^') ps++;
		else {
			pd[0] = '%';
			pd++;
		}
		strcpy(pd,ps);
		len = strlen(pd);
		if (!(len>=2 && pd[len-2]==ESCAPE_CHAR) &&
		    (c=pd[len-1])=='$') pd[len-1] = '\0';
		else memcpy(pd+len,"%",2);
		pat_len = strlen(pp);
		Pat[npat].pat = pp;
		Pat[npat].len = pat_len;
		npat++;
/*
printf("i=%d len=%d pp=[%s]\n",i,pat_len,pp);
*/
		pp += pat_len + 1;
	}
	return 0;
}

static int _mk_pat()
{
	int  ret,len;
	FILE *fp;

	npat = 0;
	if (pattern) ret = _set_pattern(pattern);
	else if (patfile) {
		if (fp = fopen(patfile,"r")) {
			while ((len = akxa_read_line_opt(buf,sizeof(buf),fp,0x03)) >= 0) {
				if (len > 0) {
					if (ret=_set_pattern(buf)) break;
				}
			}
			fclose(fp);
		}
		else {
			fprintf(stderr,"pattern file[%s] open error!!\n",patfile);
			ret = -2;
		}
	}
	else ret = -1;
	return ret;
}

static int _like(fn)
char *fn;
{
	int  ret,cl,len,i,line=0,sp;
	char *p;

	while ((len = akxa_read_line_opt(buf,sizeof(buf),fp,0x03)) >= 0) {
		if (ret = akxs_xlike_set_line(plike,buf,len)) break;
		line++;
		for (i=0;i<npat;i++) {
		/*	ret = akxs_xlike_pos(buf,len,Pat[i].pat,Pat[i].len,iCASE,posp);	*/
			if (posp) memset(pos,0,sizeof(pos));
			sp = 0;
			while (sp <= plike->lk_la) {
				ret = akxs_pxlike(plike,Pat[i].pat,Pat[i].len);
				if (!ret) {
					if (posp) {
						p = buf+pos[0];
						cl = pos[1];
/*
printf("_like: pos=%d %d %d %d\n",pos[0],pos[1],pos[2],pos[3]);
*/
					}
					else {
						p = buf;
						cl = len;
					}
					if (iTRIM) cl = akxtsapb(1,p,cl);
					if (fn) fprintf(stdout,"%s",fn);
					if (fn || iLN) fprintf(stdout,"(%d):",line);
					if (fwrite(p,1,cl,stdout) != cl) {
						fprintf(stderr,"file write error (%s)!!\n",
						        strerror(errno));
						return -1;
					}
					if (iCR) putchar('\r');
					putchar('\n');
					if (posp && iTRY) {
						sp = pos[2] + pos[3];
					}
					else break;
				}
				else {
					if (ret < 0) {
						fprintf(stderr,"akxs_xlike_pos error ret=%d\n",ret);
						return ret;
					}
					break;
				}
			}
			if (!ret && !posp) break;
		}
	}

	return ret;
}

static int _like_iv(fn)
char *fn;
{
	int  ret,cl,len,i,line=0,sp;
	char *p;

	while ((len = akxa_read_line_opt(buf,sizeof(buf),fp,0x03)) >= 0) {
		if (ret = akxs_xlike_set_line(plike,buf,len)) break;
		line++;
		ret = 1;
		for (i=0;i<npat;i++) {
			if (posp) memset(pos,0,sizeof(pos));
			sp = 0;
			ret = akxs_pxlike(plike,Pat[i].pat,Pat[i].len);
			if (ret < 0) {
				fprintf(stderr,"akxs_xlike_pos error ret=%d\n",ret);
				return ret;
			}
			else if (!ret) break;
		}
		if (ret) {
			p = buf;
			cl = len;
			if (iTRIM) cl = akxtsapb(1,p,cl);
			if (fn) fprintf(stdout,"%s",fn);
			if (fn || iLN) fprintf(stdout,"(%d):",line);
			if (fwrite(p,1,cl,stdout) != cl) {
				fprintf(stderr,"file write error (%s)!!\n",
				        strerror(errno));
				return -1;
			}
			if (iCR) putchar('\r');
			putchar('\n');
		}
	}

	return ret;
}

int main(argc,argv)
int  argc;
char *argv[];
{
	int  iExit,iError,loc;

	iHV = 0;
	iTRIM = iV = iTRY = iLN = iCASE = iCR = loc = 0;
	iFN = 1;
	pattern = NULL;
	patfile = NULL;
	posp = NULL;
	fp = NULL;

	if (--argc <= 0) {
		_usage();
		exit(0);
	}
	argv++;
	iError = 0;
	while (argc > 0) {
		p = argv[0];
		if ((c=*p) == '-') {
			if (!(c=*(++p))) {
				fp = stdin;
			}
			else if (c == '-') {
				if ((c=*(++p)) == 'h') {
					iHV |= 1;
					_usage();
				}
				else if (c == 'v') {
					iHV |= 2;
					fprintf(stderr,"ver = %s\n",VERSION);
				}
				else {
					iError = 1;
					fprintf(stderr,"unknown option --%s\n",p);
					break;
				}
			}
			else {
				while (c = *p) {
					if (c == 'o') posp = pos;
					else if (c == 'r') iCR = 1;
					else if (c == 'i') iCASE = 1;
					else if (c == 'h') iFN = 0;
					else if (c == 'n') iLN = 1;
					else if (c == 'v') iV = 1;
					else if (c == 'y') iTRY = 1;
					else if (c == 't') iTRIM = 1;
					else if (c=='S' || c=='f') {
						if (*(p+1)) p++;
						else if (--argc > 0) {
							argv++;
							p = argv[0];
							if (*p == '-') {
								iError = 1;
								fprintf(stderr,"few parameter for -%c\n",c);
								break;
							}
						}
						else {
							iError = 1;
							fprintf(stderr,"few parameter for -%c\n",c);
							break;
						}
						if (c=='S') size = atoi(p);
						else if (c=='f') {
							if (pattern) {
								iError = 1;
								break;
							}
							patfile = p;
						}
						break;
					}
					else {
						iError = 1;
						fprintf(stderr,"unknown option -%s\n",p);
						break;
					}
					p++;
				}
				if (iError) break;
			}
		}
		else {
			if (loc == 0) {	/* PatternList */
				if (patfile) break;
				pattern = p;
			}
			else {	/* File ... */
				if (fp) {
					iError = 1;
					fprintf(stderr,"already defined stdin\n");
				}
				break;
			}
			loc++;
		}
		argc--;
		argv++;
	}

	if (iError) {
		_check_usage();
		exit(1);
	}
	else {
		if ((pattern || patfile) && (fp || argc>0)) ;
		else {
			if (pattern || patfile) {
				fprintf(stderr,"no File or stdin\n");
				_check_usage();
				exit(1);
			}
			else if (fp) {
				fprintf(stderr,"no pattern or patfile\n");
				_check_usage();
				exit(1);
			}
			else if (iHV) {
				exit(0);
			}
			else {
				_usage();
				exit(1);
			}
		}
	}

	if (_mk_pat(pattern)) exit(3);

	if (!(plike = akxs_xlike_new(0,iCASE,posp))) exit(4);

	if (fp) {
		if (iV) _like_iv(NULL);
		else _like(NULL);
	}
	else {
/*
printf("argc=%d argv[0]=[%s]\n",argc,argv[0]);
*/
		if (argc==1 && npat==1 && !iLN) iFN = 0;
		if (argc>1 && iLN) iFN = 1;
		while (argc > 0) {
			if (p = argv[0]) {
				fp = fopen(p,"r");
				if (fp){
					if (!iFN) p = NULL;
					if (iV) _like_iv(p);
					else _like(p);
					fclose(fp);
				}
				else {
					fprintf(stderr,"file[%s] open error!!\n",p);
					exit(2);
				}
			}
			argc--;
			argv++;
		}
	}
	exit(0);
}
