/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnableDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;

public abstract class SafeRunnable
implements ISafeRunnable {
    private static boolean ignoreErrors = false;
    private static ISafeRunnableRunner runner;
    private String message;
    private static SafeRunnableDialog dialog;

    public SafeRunnable() {
    }

    public SafeRunnable(String message) {
        this.message = message;
    }

    public void handleException(Throwable e) {
        if (!ignoreErrors) {
            if (this.message == null) {
                this.message = JFaceResources.getString("SafeRunnable.errorMessage");
            }
            Status status = new Status(4, "org.eclipse.jface", this.message, e);
            Runnable runnable = new Runnable((IStatus)status){
                private final /* synthetic */ IStatus val$status;
                {
                    this.val$status = iStatus;
                }

                public void run() {
                    if (dialog == null || dialog.getShell().isDisposed()) {
                        dialog = new SafeRunnableDialog(this.val$status);
                        dialog.create();
                        dialog.getShell().addDisposeListener(new DisposeListener(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void widgetDisposed(DisposeEvent e) {
                                SafeRunnable.access$1(null);
                            }
                        });
                        dialog.open();
                    } else {
                        dialog.addStatus(this.val$status);
                        dialog.refresh();
                    }
                }
            };
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                Display.getDefault().asyncExec(runnable);
            }
        }
    }

    public static boolean getIgnoreErrors(boolean flag) {
        return ignoreErrors;
    }

    public static boolean getIgnoreErrors() {
        return ignoreErrors;
    }

    public static void setIgnoreErrors(boolean flag) {
        ignoreErrors = flag;
    }

    public static ISafeRunnableRunner getRunner() {
        if (runner == null) {
            runner = SafeRunnable.createDefaultRunner();
        }
        return runner;
    }

    private static ISafeRunnableRunner createDefaultRunner() {
        return new ISafeRunnableRunner(){

            public void run(ISafeRunnable code) {
                try {
                    code.run();
                }
                catch (Exception e) {
                    this.handleException(code, e);
                }
                catch (LinkageError e) {
                    this.handleException(code, e);
                }
            }

            private void handleException(ISafeRunnable code, Throwable e) {
                if (!(e instanceof OperationCanceledException)) {
                    try {
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, "Exception occurred", e));
                    }
                    catch (Exception exception) {
                        e.printStackTrace();
                    }
                }
                code.handleException(e);
            }
        };
    }

    public static void setRunner(ISafeRunnableRunner runner) {
        SafeRunnable.runner = runner;
    }

    public static void run(ISafeRunnable runnable) {
        SafeRunnable.getRunner().run(runnable);
    }
}

