/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.wsp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.ExtractionUnit;
import jp.sourceforge.stigmata.birthmarks.ASMBirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.sourceforge.stigmata.birthmarks.wsp.CurrentDepth;
import jp.sourceforge.stigmata.birthmarks.wsp.LabelOpcode;
import jp.sourceforge.stigmata.birthmarks.wsp.Opcode;
import jp.sourceforge.stigmata.birthmarks.wsp.OpcodeExtractionMethodVisitor;
import jp.sourceforge.stigmata.birthmarks.wsp.StackPatternBasedBirthmarkElement;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class StackPatternBasedBirthmarkExtractor
extends ASMBirthmarkExtractor {
    public StackPatternBasedBirthmarkExtractor(BirthmarkSpi service) {
        super(service);
    }

    public BirthmarkExtractVisitor createExtractVisitor(ClassWriter writer, Birthmark birthmark, BirthmarkContext context) {
        return new Visitor(writer, birthmark, context);
    }

    public ExtractionUnit[] getAcceptableUnits() {
        return new ExtractionUnit[]{ExtractionUnit.CLASS};
    }

    private BirthmarkElement[] buildElement(List<Opcode> opcodes, BirthmarkContext context) {
        List<CurrentDepth> pattern = this.buildStackPattern(opcodes, context);
        ArrayList<StackPatternBasedBirthmarkElement> elements = new ArrayList<StackPatternBasedBirthmarkElement>();
        ArrayList<CurrentDepth> subPattern = new ArrayList<CurrentDepth>();
        for (CurrentDepth depth : pattern) {
            subPattern.add(depth);
            if (depth.getDepth() != 0) continue;
            elements.add(new StackPatternBasedBirthmarkElement(subPattern.toArray(new CurrentDepth[subPattern.size()])));
            subPattern.clear();
        }
        elements.add(new StackPatternBasedBirthmarkElement(subPattern.toArray(new CurrentDepth[subPattern.size()])));
        return elements.toArray(new BirthmarkElement[elements.size()]);
    }

    private List<CurrentDepth> buildStackPattern(List<Opcode> opcodes, BirthmarkContext context) {
        HashMap<Label, Integer> tableMap = new HashMap<Label, Integer>();
        ArrayList<CurrentDepth> pattern = new ArrayList<CurrentDepth>();
        Map weights = (Map)context.getProperty("birthmarks.wsp.weights");
        int currentDepth = 0;
        Integer forwardedStatus = null;
        for (Opcode opcode : opcodes) {
            if (opcode.getCategory() == Opcode.Category.TARGETER) {
                forwardedStatus = (Integer)tableMap.get(((LabelOpcode)opcode).getLabel());
                continue;
            }
            opcode.setWeight((Integer)weights.get(opcode.getOpcode()));
            currentDepth = forwardedStatus == null ? (currentDepth += opcode.getAct()) : forwardedStatus + opcode.getAct();
            forwardedStatus = null;
            pattern.add(new CurrentDepth(currentDepth, opcode));
            if (opcode.getCategory() != Opcode.Category.BRANCH) continue;
            Iterator<Label> i = opcode.labels();
            while (i.hasNext()) {
                Label label = i.next();
                tableMap.put(label, currentDepth);
            }
        }
        return pattern;
    }

    private class Visitor
    extends BirthmarkExtractVisitor {
        private List<Opcode> opcodeList;

        public Visitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
            super(visitor, birthmark, context);
            this.opcodeList = new ArrayList<Opcode>();
        }

        public void visitEnd() {
            BirthmarkElement[] elements;
            for (BirthmarkElement element : elements = StackPatternBasedBirthmarkExtractor.this.buildElement(this.opcodeList, this.getContext())) {
                this.addElement(element);
            }
        }

        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            MethodVisitor visitor = super.visitMethod(arg0, arg1, arg2, arg3, arg4);
            OpcodeExtractionMethodVisitor opcodeVisitor = new OpcodeExtractionMethodVisitor(visitor, this.opcodeList);
            return opcodeVisitor;
        }
    }
}

