/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.wsp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmarkPreprocessor;
import jp.sourceforge.stigmata.birthmarks.wsp.Opcode;
import jp.sourceforge.stigmata.birthmarks.wsp.OpcodeExtractionMethodVisitor;
import jp.sourceforge.stigmata.digger.ClassFileArchive;
import jp.sourceforge.stigmata.digger.ClassFileEntry;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class OpcodeWeightCalculatePreprocessor
extends AbstractBirthmarkPreprocessor {
    public OpcodeWeightCalculatePreprocessor(BirthmarkSpi spi) {
        super(spi);
    }

    public void preprocess(ClassFileArchive[] targets, BirthmarkContext context) {
        HashMap<Integer, Integer> targetMap = new HashMap<Integer, Integer>();
        int classCount = 0;
        for (ClassFileArchive archive : targets) {
            classCount += this.readOpcodes(archive, targetMap);
        }
        HashMap<Integer, Integer> weights = new HashMap<Integer, Integer>();
        for (Map.Entry entry : targetMap.entrySet()) {
            int opcode = (Integer)entry.getKey();
            Integer count = (Integer)entry.getValue();
            int c = 0;
            if (count != null) {
                c = count;
            }
            weights.put(opcode, (int)Math.round(Math.log(classCount / c)));
        }
        context.putProperty("birthmarks.wsp.weights", weights);
    }

    private int readOpcodes(ClassFileArchive archive, Map<Integer, Integer> targetMap) {
        int count = 0;
        for (ClassFileEntry entry : archive) {
            ++count;
            final ArrayList opcodes = new ArrayList();
            try {
                InputStream in = entry.getLocation().openStream();
                ClassReader reader = new ClassReader(in);
                ClassWriter writer = new ClassWriter(0);
                ClassAdapter opcodeExtractVisitor = new ClassAdapter(writer){

                    @Override
                    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
                        OpcodeExtractionMethodVisitor visitor = new OpcodeExtractionMethodVisitor(super.visitMethod(arg0, arg1, arg2, arg3, arg4), opcodes);
                        return visitor;
                    }
                };
                reader.accept(opcodeExtractVisitor, 0);
                HashSet<Integer> set = new HashSet<Integer>();
                for (Opcode opcode : opcodes) {
                    if (opcode.getCategory() == Opcode.Category.TARGETER) continue;
                    set.add(opcode.getOpcode());
                }
                for (Integer i : set) {
                    Integer v = targetMap.get(i);
                    if (v == null) {
                        v = 0;
                    }
                    v = v + 1;
                    targetMap.put(i, v);
                }
            }
            catch (IOException e) {
            }
        }
        return count;
    }
}

