/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.utils;

import java.util.ArrayList;
import java.util.List;
import jp.naist.se.stigmata.utils.WellknownClassJudgeRule;

public class WellknownClassManager {
    public static final int FULLY_PREFIX_TYPE = 17;
    public static final int FULLY_SUFFIX_TYPE = 18;
    public static final int FULLY_MATCH_TYPE = 20;
    public static final int PACKAGE_PREFIX_TYPE = 33;
    public static final int PACKAGE_SUFFIX_TYPE = 34;
    public static final int PACKAGE_MATCH_TYPE = 36;
    public static final int CLASS_NAME_PREFIX_TYPE = 65;
    public static final int CLASS_NAME_SUFFIX_TYPE = 66;
    public static final int CLASS_NAME_MATCH_TYPE = 68;
    private List<WellknownClassJudgeRule> systemClassesList = new ArrayList<WellknownClassJudgeRule>();
    private List<WellknownClassJudgeRule> excludes = new ArrayList<WellknownClassJudgeRule>();

    public WellknownClassManager() {
    }

    public WellknownClassManager(WellknownClassManager manager) {
        this.systemClassesList = new ArrayList<WellknownClassJudgeRule>(manager.systemClassesList);
        this.excludes = new ArrayList<WellknownClassJudgeRule>(manager.excludes);
    }

    public void remove(String value, int type) {
        int index = -1;
        for (int i = 0; i < this.systemClassesList.size(); ++i) {
            WellknownClassJudgeRule section = this.systemClassesList.get(i);
            if (!section.getName().equals(value) || section.getType() != type) continue;
            index = i;
            break;
        }
        this.systemClassesList.remove(index);
    }

    public void clear() {
        this.systemClassesList.clear();
        this.excludes.clear();
    }

    public WellknownClassJudgeRule[] getSections() {
        ArrayList<WellknownClassJudgeRule> sections = new ArrayList<WellknownClassJudgeRule>();
        sections.addAll(this.excludes);
        sections.addAll(this.systemClassesList);
        return sections.toArray(new WellknownClassJudgeRule[sections.size()]);
    }

    public void add(WellknownClassJudgeRule section) {
        if (section.isExcludeType()) {
            this.excludes.add(section);
        } else {
            this.systemClassesList.add(section);
        }
    }

    private boolean checkSystemClass(String className) {
        String fully = className.replace('/', '.');
        int index = className.lastIndexOf(46);
        String cn = className.substring(index + 1);
        String pn = "";
        if (index > 0) {
            pn = fully.substring(0, index - 1);
        }
        if (this.isExcludes(fully)) {
            return false;
        }
        for (WellknownClassJudgeRule section : this.systemClassesList) {
            String target = fully;
            if (section.isClassNameType()) {
                target = cn;
            } else if (section.isPackageType()) {
                target = pn;
            }
            switch (section.getMatchType()) {
                case 1: {
                    if (!target.startsWith(section.getName())) break;
                    return true;
                }
                case 2: {
                    if (!target.endsWith(section.getName())) break;
                    return true;
                }
                case 4: {
                    if (!target.equals(section.getName())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isExcludes(String fully) {
        for (WellknownClassJudgeRule s : this.excludes) {
            switch (s.getMatchType()) {
                case 1: {
                    if (!fully.startsWith(s.getName())) break;
                    return true;
                }
                case 2: {
                    if (!fully.endsWith(s.getName())) break;
                    return true;
                }
                case 4: {
                    if (!fully.equals(s.getName())) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkSystemMethod(int access, String methodName, String signature) {
        if (methodName.equals("main")) {
            return signature.equals("([Ljava/lang/String;)V") && this.checkAccess(access, 1);
        }
        if (methodName.equals("<clinit>")) {
            return signature.equals("()V") && this.checkAccess(access, 8);
        }
        if (methodName.equals("<init>")) {
            return !this.checkAccess(access, 8);
        }
        return false;
    }

    private boolean checkSystemField(int access, String fieldName, String signature) {
        if (fieldName.equals("serialVersionUID")) {
            return this.checkAccess(access, 8) && this.checkAccess(access, 16) && signature.equals("J");
        }
        return false;
    }

    public boolean isWellKnownClass(String className) {
        return this.checkSystemClass(className);
    }

    public boolean isSystemMethod(int access, String methodName, String signature) {
        return this.checkSystemMethod(access, methodName, signature);
    }

    public boolean isSystemField(int access, String fieldName, String signature) {
        return this.checkSystemField(access, fieldName, signature);
    }

    private boolean checkAccess(int access, int code) {
        return (access & code) == code;
    }
}

