/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import javax.swing.tree.DefaultMutableTreeNode;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkSet;

public class BirthmarkTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -12323457653245L;
    private Birthmark birthmark;

    public BirthmarkTreeNode(Birthmark birthmark) {
        super(birthmark.getType() + "(" + birthmark.getElementCount() + ")");
        this.setBirthmark(birthmark);
    }

    public BirthmarkTreeNode(BirthmarkSet birthmark) {
        super(birthmark.getClassName() + "(" + birthmark.getSumOfElementCount() + ")");
        this.setBirthmark(birthmark);
    }

    public Birthmark getBirthmark() {
        return this.birthmark;
    }

    public void setBirthmark(BirthmarkSet holder) {
        this.addChildBirthmarks(holder, this);
    }

    public void setBirthmark(Birthmark birthmark) {
        this.birthmark = birthmark;
        this.addChildren(birthmark, this);
    }

    private void addChildren(Birthmark birthmark, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(birthmark.getType() + "(" + birthmark.getElementCount() + ")");
        parent.add(node);
        BirthmarkElement[] elements = birthmark.getElements();
        for (int i = 0; i < elements.length; ++i) {
            node.add(new DefaultMutableTreeNode(elements[i]));
        }
    }

    private void addChildBirthmarks(BirthmarkSet holder, DefaultMutableTreeNode parent) {
        Birthmark[] birthmarks;
        for (Birthmark birthmark : birthmarks = holder.getBirthmarks()) {
            this.addChildren(birthmark, parent);
        }
    }
}

