<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2013 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================ //
	// settings.inc.php //
	// ================ //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// make sure nobody has direct acces to this script
	if(!defined('ADMINISTRATION'))
		{
		include ("error.html");
		die();
		}
	else
		{
		require ("../includes/functions.inc.php");

		if(!isset($_GET['action'])) { $_GET['action'] = "settings"; }
		if(check_rights($_GET['action'], $_SESSION['ID']))
			{
			if(isset($_POST['sent_settings']) AND $_POST['sent_settings'] == 1)
				{
				if(!empty($_POST['template_path']) AND !empty($_POST['language_path']) AND !empty($_POST['entries_per_page']) AND !empty($_POST['admin_name']) AND !empty($_POST['admin_email']) AND !empty($_POST['admin_gbemail']) AND ($_POST['session_timeout'] >= 60))
					{
					if($_POST['password_min_length'] < 3)
						{
						$_POST['password_min_length'] = $settings['password_min_length'];
						}

					$_POST['sendmail_admin_text'] = nl2br(cleanstr($_POST['sendmail_admin_text']));
					$_POST['sendmail_user_text'] = nl2br(cleanstr($_POST['sendmail_user_text']));
					$_POST['sendmail_user_text_moderated'] = nl2br(cleanstr($_POST['sendmail_user_text_moderated']));
					$_POST['sendmail_user_notification_text'] = nl2br(cleanstr($_POST['sendmail_user_notification_text']));
					$_POST['sendmail_comment_text'] = nl2br(cleanstr($_POST['sendmail_comment_text']));
					$_POST['sendmail_contactmail_text'] = nl2br(cleanstr($_POST['sendmail_contactmail_text']));
					$_POST['sendmail_contactmail_text_copy'] = nl2br(cleanstr($_POST['sendmail_contactmail_text_copy']));

					$t1 = chr(10); // new line
					$t2 = chr(13); // carriage return

					$_POST['sendmail_admin_text'] = str_ireplace($t1,'', $_POST['sendmail_admin_text']);
					$_POST['sendmail_user_text'] = str_ireplace($t1,'', $_POST['sendmail_user_text']);
					$_POST['sendmail_user_text_moderated'] = str_ireplace($t1,'', $_POST['sendmail_user_text_moderated']);
					$_POST['sendmail_user_notification_text'] = str_ireplace($t1,'', $_POST['sendmail_user_notification_text']);
					$_POST['sendmail_comment_text'] = str_ireplace($t1,'', $_POST['sendmail_comment_text']);
					$_POST['sendmail_contactmail_text'] = str_ireplace($t1,'', $_POST['sendmail_contactmail_text']);
					$_POST['sendmail_contactmail_text_copy'] = str_ireplace($t1,'', $_POST['sendmail_contactmail_text_copy']);

					$_POST['sendmail_admin_text'] = str_ireplace($t2,'', $_POST['sendmail_admin_text']);
					$_POST['sendmail_user_text'] = str_ireplace($t2,'', $_POST['sendmail_user_text']);
					$_POST['sendmail_user_text_moderated'] = str_ireplace($t2,'', $_POST['sendmail_user_text_moderated']);
					$_POST['sendmail_user_notification_text'] = str_ireplace($t2,'', $_POST['sendmail_user_notification_text']);
					$_POST['sendmail_comment_text'] = str_ireplace($t2,'', $_POST['sendmail_comment_text']);
					$_POST['sendmail_contactmail_text'] = str_ireplace($t2,'', $_POST['sendmail_contactmail_text']);
					$_POST['sendmail_contactmail_text_copy'] = str_ireplace($t2,'', $_POST['sendmail_contactmail_text_copy']);

					if($_POST['h_domain'] == "") { $_POST['h_domain'] = $_SERVER["SERVER_NAME"]; }
					if($_POST['gb_path'] == "")
						{
						$_POST['gb_path'] = str_ireplace("admin/admin.php", "", $_SERVER["SCRIPT_NAME"]);
						}

					// load the default style and iconset for template if changed
					if($_POST['template_path'] != $settings['template_path'])
						{
						include ("../templates/".$_POST['template_path']."/settings.php");
						$_POST['template_style_path'] = $template['default_style'];
						$_POST['iconset_path'] = $template['default_iconset'];
						}

					// load text for emails if another language is selected
					if($_POST['language_path'] != $settings['language_path'])
						{
						include ("../language/".$_POST['language_path']."/lang_admin.php");
						$_POST['sendmail_admin_text'] = $lang['sendmail_admin_text'];
						$_POST['sendmail_user_text'] = $lang['sendmail_user_text'];
						$_POST['sendmail_user_text_moderated'] = $lang['sendmail_user_text_moderated'];
						$_POST['sendmail_user_notification_text'] = $lang['sendmail_user_notification_text'];
						$_POST['sendmail_comment_text'] = $lang['sendmail_comment_text'];
						$_POST['sendmail_contactmail_text'] = $lang['sendmail_contactmail_text'];
						$_POST['sendmail_contactmail_text_copy'] = $lang['sendmail_contactmail_text_copy'];
						}

					// check if the captcha angles are correct
					if($_POST['captcha_angle_1'] >= $_POST['captcha_angle_2'])
						{
						$_POST['captcha_angle_1'] = $settings['captcha_angle_1'];
						$_POST['captcha_angle_2'] = $settings['captcha_angle_2'];
						}

					// save data to database
					$sql = "UPDATE `".$db['prefix']."settings` SET
									`title` = '".cleanstr($_POST['title'])."',
									`h_author` = '".cleanstr($_POST['h_author'])."',
									`h_domain` = '".cleanstr($_POST['h_domain'])."',
									`gb_path` = '".cleanstr($_POST['gb_path'])."',
									`h_keywords` = '".cleanstr($_POST['h_keywords'])."',
									`h_description` = '".cleanstr($_POST['h_description'])."',
									`timezone` = '".cleanstr($_POST['timezone'])."',
									`admin_name` = '".cleanstr($_POST['admin_name'])."',
									`admin_email` = '".cleanstr($_POST['admin_email'])."',
									`admin_gbemail` = '".cleanstr($_POST['admin_gbemail'])."',
									`sendmail_admin` = '".$_POST['sendmail_admin']."',
									`sendmail_admin_text` = '".$_POST['sendmail_admin_text']."',
									`sendmail_user` = '".$_POST['sendmail_user']."',
									`sendmail_user_text` = '".$_POST['sendmail_user_text']."',
									`sendmail_user_text_moderated` = '".$_POST['sendmail_user_text_moderated']."',
									`sendmail_user_notification_text` = '".$_POST['sendmail_user_notification_text']."',
									`sendmail_comment_text` = '".$_POST['sendmail_comment_text']."',
									`sendmail_contactmail_text` = '".$_POST['sendmail_contactmail_text']."',
									`sendmail_contactmail_text_copy` = '".$_POST['sendmail_contactmail_text_copy']."',
									`template_path` = '".cleanstr($_POST['template_path'])."',
									`template_style_path` = '".cleanstr($_POST['template_style_path'])."',
									`iconset_path` = '".cleanstr($_POST['iconset_path'])."',
									`language_path` = '".cleanstr($_POST['language_path'])."',
									`badwords` = '".cleanstr($_POST['badwords'])."',
									`bbcode` = '".cleanstr($_POST['bbcode'])."',
									`allow_img_tag` = '".cleanstr($_POST['allow_img_tag'])."',
									`max_img_width` = '".cleanstr($_POST['max_img_width'])."',
									`max_img_height` = '".cleanstr($_POST['max_img_height'])."',
									`center_img` = '".cleanstr($_POST['center_img'])."',
									`allow_flash_tag` = '".cleanstr($_POST['allow_flash_tag'])."',
									`max_flash_width` = '".cleanstr($_POST['max_flash_width'])."',
									`max_flash_height` = '".cleanstr($_POST['max_flash_height'])."',
									`center_flash` = '".cleanstr($_POST['center_flash'])."',
									`smileys` = '".cleanstr($_POST['smileys'])."',
									`smileys_break` = '".cleanstr($_POST['smileys_break'])."',
									`smileys_order` = '".cleanstr($_POST['smileys_order'])."',
									`captcha` = '".cleanstr($_POST['captcha'])."',
									`captcha_method` = '".cleanstr($_POST['captcha_method'])."',
									`captcha_coords_x` = '".cleanstr($_POST['captcha_coords_x'])."',
									`captcha_coords_y` = '".cleanstr($_POST['captcha_coords_y'])."',
									`captcha_color` = '".cleanstr($_POST['captcha_color'])."',
									`captcha_angle_1` = '".cleanstr($_POST['captcha_angle_1'])."',
									`captcha_angle_2` = '".cleanstr($_POST['captcha_angle_2'])."',
									`akismet_plugin` = '".cleanstr($_POST['akismet_plugin'])."',
									`akismet_api` = '".cleanstr($_POST['akismet_api'])."',
									`akismet_mark_as_spam` = '".cleanstr($_POST['akismet_mark_as_spam'])."',
									`time_lock` = '".cleanstr($_POST['time_lock'])."',
									`time_lock_value` = '".cleanstr($_POST['time_lock_value'])."',
									`time_lock_maxtime` = '".cleanstr($_POST['time_lock_maxtime'])."',
									`user_notification` = '".cleanstr($_POST['user_notification'])."',
									`user_show_email` = '".cleanstr($_POST['user_show_email'])."',
									`session_timeout` = '".cleanstr($_POST['session_timeout'])."',
									`password_min_length` = '".cleanstr($_POST['password_min_length'])."',
									`moderated` = '".cleanstr($_POST['moderated'])."',
									`require_email` = '".cleanstr($_POST['require_email'])."',
									`entries_per_page` = '".cleanstr($_POST['entries_per_page'])."',
									`entries_order` = '".cleanstr($_POST['entries_order'])."',
									`entries_order_asc_desc` = '".cleanstr($_POST['entries_order_asc_desc'])."',
									`entries_numbering` = '".cleanstr($_POST['entries_numbering'])."',
									`ipblocker` = '".cleanstr($_POST['ipblocker'])."',
									`wordwrap` = '".cleanstr($_POST['wordwrap'])."',
									`dateform` = '".cleanstr($_POST['dateform'])."',
									`gravatar_show` = '".cleanstr($_POST['gravatar_show'])."',
									`gravatar_rating` = '".cleanstr($_POST['gravatar_rating'])."',
									`gravatar_type` = '".cleanstr($_POST['gravatar_type'])."',
									`gravatar_size` = '".cleanstr($_POST['gravatar_size'])."',
									`gravatar_position` = '".cleanstr($_POST['gravatar_position'])."'";

					$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(settings.inc.php) Error, line 167: ".mysql_error());
					@mysql_select_db($db['dbname'], $link) or die ("(settings.inc.php) Error, line 168: ".mysql_error());
					if( @mysql_query($sql, $link) or die ("(settings.inc.php) Error, line 169: ".mysql_error()) )
						{
						$saved_settings_successfull = 1;
						}

					// close sql connection
					@mysql_close($link);

					require ("../includes/load_settings.inc.php");
					}
				}

			// get names of languages
			$path = "../language/";
			foreach (glob($path."*") as $filename)
				{
				if($filename != "." && $filename != "..")
					{
					if(is_dir($filename))
						{
						if(!isset($edit_option_language_path)) { $edit_option_language_path = ""; }
						include ($filename."/settings.php");
						if(isset($charset) AND $charset == "utf-8") // only utf-8 languages are loaded into the guestbook
							{
							$edit_option_language_path .= "<option ";
							if($filename == $settings['language_path'])
								{
								$edit_option_language_path .= "selected ";
								$active_language_short = $language_short;
								}
							$edit_option_language_path .= "value=\"".$filename."\">".$language."</option>";
							}
						}
					}
				}

			// get names of templates
			$path = "../templates/";
			foreach (glob($path."*") as $filename)
				{
				if($filename != "." && $filename != "..")
						{
						if(is_dir($filename))
							{
							if(!isset($edit_option_template_path)) { $edit_option_template_path = ""; }
							$edit_option_template_path .= "<option ";
							$filename = preg_replace("/..\/templates\//", "", $filename);
							if($filename == $settings['template_path'])
								{
								$edit_option_template_path .= "selected ";
								$active_template = $filename;
								}
							include ($path.$filename."/settings.php");
							$filename = preg_replace("/..\/templates\//", "", $filename);
							if(!isset($template['name']))
								{
								$edit_option_template_path .= "value=\"".$filename."\">".$filename."</option>";
								}
							else
								{
								$edit_option_template_path .= "value=\"".$filename."\">".$template['name']."</option>";
								}
							}
						}
				}

			// get names of template styles
			$path = "../templates/".$active_template."/css/";
			foreach (glob($path."*") as $filename)
				{
				if($filename != "." && $filename != "..")
						{
						if(is_dir($filename))
							{
							if(!isset($edit_option_template_style_path)) { $edit_option_template_style_path = ""; }
							$edit_option_template_style_path .= "<option ";
							$filename = preg_replace("/..\/templates\/".$active_template."\/css\//", "", $filename);
							if($filename == $settings['template_style_path']) { $edit_option_template_style_path .= "selected "; }
							$edit_option_template_style_path .= "value=\"".$filename."\">".$filename."</option>";
							}
						}
				}

			// get names of iconsets
			$path = "../images/iconsets/";
			foreach (glob($path."*") as $filename)
				{
				if($filename != "." && $filename != "..")
						{
						if(is_dir($filename))
							{
							if(!isset($edit_option_iconset_path)) { $edit_option_iconset_path = ""; }
							$edit_option_iconset_path .= "<option ";
							include ($filename."/settings.php");
							$filename = preg_replace("/..\/images\/iconsets\//", "", $filename);
							if($filename == $settings['iconset_path']) { $edit_option_iconset_path .= "selected "; }
							$edit_option_iconset_path .= "value=\"".$filename."\">".$name[$active_language_short]."</option>";
							}
						}
				}

			// load active language
			include ("../language/".$settings['language_path']."/settings.php");
			include ("functions.inc.php");

			// load template
			$page_include = $content_settings;

			// general replacement
			$page_include = template("URL_SETTINGS", "admin.php?action=settings".$sid, $page_include);
			$page_include = template("LANG_NO", $lang['no'], $page_include);
			$page_include = template("LANG_YES", $lang['yes'], $page_include);
			$page_include = template("LANG_ASC", $lang['asc'], $page_include);
			$page_include = template("LANG_DESC", $lang['desc'], $page_include);
			$page_include = template("LANG_SAVE", $lang['save'], $page_include);
			$page_include = template("LANG_ENTRY_ID", remove_evil_things($lang['ID'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_NAME", remove_evil_things($lang['name'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_CITY", remove_evil_things($lang['city'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_EMAIL", remove_evil_things($lang['email'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_ICQ", remove_evil_things($lang['icq'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_AIM", remove_evil_things($lang['aim'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_MSN", remove_evil_things($lang['msn'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_HP", remove_evil_things($lang['hp'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_MESSAGE", remove_evil_things($lang['message'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_COMMENT", remove_evil_things($lang['comment'], "/:/"), $page_include);
			$page_include = template("LANG_ENTRY_TIMESTAMP", $lang['timestamp'], $page_include);
			$page_include = template("LANG_GRAVATAR_TYPE_0", $lang['gravatar_type_0'], $page_include);
			$page_include = template("LANG_GRAVATAR_TYPE_1", $lang['gravatar_type_1'], $page_include);
			$page_include = template("LANG_GRAVATAR_TYPE_2", $lang['gravatar_type_2'], $page_include);
			$page_include = template("LANG_GRAVATAR_TYPE_3", $lang['gravatar_type_3'], $page_include);
			$page_include = template("LANG_GRAVATAR_TYPE_4", $lang['gravatar_type_4'], $page_include);
			$page_include = template("LANG_GRAVATAR_TYPE_5", $lang['gravatar_type_5'], $page_include);
			$page_include = template("LANG_GRAVATAR_POSITION_LEFT", $lang['gravatar_position_left'], $page_include);
			$page_include = template("LANG_GRAVATAR_POSITION_RIGHT", $lang['gravatar_position_right'], $page_include);
			$page_include = template("LANG_CAPTCHA_METHOD_CODE", $lang['captcha_method_code'], $page_include);
			$page_include = template("LANG_CAPTCHA_METHOD_MATH", $lang['captcha_method_math'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_GENERAL", $lang['edit_caption_general'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_LOOK", $lang['edit_caption_look'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_BBCODES", $lang['edit_caption_bbcodes'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_SMILIES", $lang['edit_caption_smilies'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_GRAVATARS", $lang['edit_caption_gravatars'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_SECURITY", $lang['edit_caption_security'], $page_include);
			$page_include = template("LANG_EDIT_CAPTION_EMAIL", $lang['edit_caption_email'], $page_include);

			// replace short descriptions
			$page_include = template("LANG_EDIT_TITLE", $lang['edit_title'], $page_include);
			$page_include = template("LANG_EDIT_H_AUTHOR", $lang['edit_h_author'], $page_include);
			$page_include = template("LANG_EDIT_H_DOMAIN", $lang['edit_h_domain'], $page_include);
			$page_include = template("LANG_EDIT_GB_PATH", $lang['edit_gb_path'], $page_include);
			$page_include = template("LANG_EDIT_H_KEYWORDS", $lang['edit_h_keywords'], $page_include);
			$page_include = template("LANG_EDIT_H_DESCRIPTION", $lang['edit_h_description'], $page_include);
			$page_include = template("LANG_EDIT_TIMEZONE", $lang['edit_timezone'], $page_include);
			$page_include = template("LANG_EDIT_ADMIN_NAME", $lang['edit_admin_name'], $page_include);
			$page_include = template("LANG_EDIT_ADMIN_EMAIL", $lang['edit_admin_email'], $page_include);
			$page_include = template("LANG_EDIT_ADMIN_GBEMAIL", $lang['edit_admin_gbemail'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_ADMIN", $lang['edit_sendmail_admin'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_ADMIN_TEXT", $lang['edit_sendmail_admin_text'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_USER", $lang['edit_sendmail_user'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_USER_TEXT", $lang['edit_sendmail_user_text'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_USER_TEXT_MODERATED", $lang['edit_sendmail_user_text_moderated'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_USER_NOTIFICATION_TEXT", $lang['edit_sendmail_user_notification_text'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_COMMENT_TEXT", $lang['edit_sendmail_comment_text'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_CONTACTMAIL_TEXT", $lang['edit_sendmail_contactmail_text'], $page_include);
			$page_include = template("LANG_EDIT_SENDMAIL_CONTACTMAIL_TEXT_COPY", $lang['edit_sendmail_contactmail_text_copy'], $page_include);
			$page_include = template("LANG_EDIT_TEMPLATE_PATH", $lang['edit_template_path'], $page_include);
			$page_include = template("LANG_EDIT_TEMPLATE_STYLE_PATH", $lang['edit_template_style_path'], $page_include);
			$page_include = template("LANG_EDIT_ICONSET_PATH", $lang['edit_iconset_path'], $page_include);
			$page_include = template("LANG_EDIT_LANGUAGE_PATH", $lang['edit_language_path'], $page_include);
			$page_include = template("LANG_EDIT_BADWORDS", $lang['edit_badwords'], $page_include);
			$page_include = template("LANG_EDIT_BBCODE", $lang['edit_bbcode'], $page_include);
			$page_include = template("LANG_EDIT_ALLOW_IMG_TAG", $lang['edit_allow_img_tag'], $page_include);
			$page_include = template("LANG_EDIT_MAX_IMG_WIDTH", $lang['edit_max_img_width'], $page_include);
			$page_include = template("LANG_EDIT_MAX_IMG_HEIGHT", $lang['edit_max_img_height'], $page_include);
			$page_include = template("LANG_EDIT_CENTER_IMG", $lang['edit_center_img'], $page_include);
			$page_include = template("LANG_EDIT_ALLOW_FLASH_TAG", $lang['edit_allow_flash_tag'], $page_include);
			$page_include = template("LANG_EDIT_MAX_FLASH_WIDTH", $lang['edit_max_flash_width'], $page_include);
			$page_include = template("LANG_EDIT_MAX_FLASH_HEIGHT", $lang['edit_max_flash_height'], $page_include);
			$page_include = template("LANG_EDIT_CENTER_FLASH", $lang['edit_center_flash'], $page_include);
			$page_include = template("LANG_EDIT_SMILEYS", $lang['edit_smileys'], $page_include);
			$page_include = template("LANG_EDIT_SMILEYS_BREAK", $lang['edit_smileys_break'], $page_include);
			$page_include = template("LANG_EDIT_SMILEYS_ORDER", $lang['edit_smileys_order'], $page_include);
			$page_include = template("LANG_EDIT_CAPTCHA", $lang['edit_captcha'], $page_include);
			$page_include = template("LANG_EDIT_CAPTCHA_METHOD", $lang['edit_captcha_method'], $page_include);
			$page_include = template("LANG_EDIT_CAPTCHA_COORDS", $lang['edit_captcha_coords'], $page_include);
			$page_include = template("LANG_EDIT_CAPTCHA_COLOR", $lang['edit_captcha_color'], $page_include);
			$page_include = template("LANG_EDIT_CAPTCHA_ANGLE", $lang['edit_captcha_angle'], $page_include);
			$page_include = template("LANG_EDIT_AKISMET_PLUGIN", $lang['edit_akismet_plugin'], $page_include);
			$page_include = template("LANG_EDIT_AKISMET_API", $lang['edit_akismet_api'], $page_include);
			$page_include = template("LANG_EDIT_AKISMET_MARK_AS_SPAM", $lang['edit_akismet_mark_as_spam'], $page_include);
			$page_include = template("LANG_EDIT_TIME_LOCK", $lang['edit_time_lock'], $page_include);
			$page_include = template("LANG_EDIT_TIME_LOCK_VALUE", $lang['edit_time_lock_value'], $page_include);
			$page_include = template("LANG_EDIT_TIME_LOCK_MAXTIME", $lang['edit_time_lock_maxtime'], $page_include);
			$page_include = template("LANG_EDIT_USER_NOTIFICATION", $lang['edit_user_notification'], $page_include);
			$page_include = template("LANG_EDIT_USER_SHOW_EMAIL", $lang['edit_user_show_email'], $page_include);
			$page_include = template("LANG_EDIT_SESSION_TIMEOUT", $lang['edit_session_timeout'], $page_include);
			$page_include = template("LANG_EDIT_PASSWORD_MIN_LENGTH", $lang['edit_password_min_length'], $page_include);
			$page_include = template("LANG_EDIT_MODERATED", $lang['edit_moderated'], $page_include);
			$page_include = template("LANG_EDIT_REQUIRE_EMAIL", $lang['edit_require_email'], $page_include);
			$page_include = template("LANG_EDIT_ENTRIES_PER_PAGE", $lang['edit_entries_per_page'], $page_include);
			$page_include = template("LANG_EDIT_ENTRIES_ORDER", $lang['edit_entries_order'], $page_include);
			$page_include = template("LANG_EDIT_ENTRIES_ORDER_ASC_DESC", $lang['edit_entries_order_asc_desc'], $page_include);
			$page_include = template("LANG_EDIT_ENTRIES_NUMBERING", $lang['edit_entries_numbering'], $page_include);
			// $page_include = template("LANG_EDIT_SPAM_PROTECTION", $lang['edit_spam_protection'], $page_include);
			$page_include = template("LANG_EDIT_IPBLOCKER", $lang['edit_ipblocker'], $page_include);
			$page_include = template("LANG_EDIT_WORDWRAP", $lang['edit_wordwrap'], $page_include);
			$page_include = template("LANG_EDIT_DATEFORM", $lang['edit_dateform'], $page_include);
			$page_include = template("LANG_EDIT_GRAVATAR_SHOW", $lang['edit_gravatar_show'], $page_include);
			$page_include = template("LANG_EDIT_GRAVATAR_RATING", $lang['edit_gravatar_rating'], $page_include);
			$page_include = template("LANG_EDIT_GRAVATAR_TYPE", $lang['edit_gravatar_type'], $page_include);
			$page_include = template("LANG_EDIT_GRAVATAR_SIZE", $lang['edit_gravatar_size'], $page_include);
			$page_include = template("LANG_EDIT_GRAVATAR_POSITION", $lang['edit_gravatar_position'], $page_include);
			$page_include = template("LANG_EDIT_AUTHOR", $language_author, $page_include);
			$page_include = template("LANG_EDIT_VERSION", $language_version, $page_include);
			$page_include = template("LANG_EDIT_CHARSET", $charset, $page_include);

			// replace long descriptions
			$page_include = template("LANG_EDIT_EXPL_TITLE", $lang['edit_expl_title'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_H_AUTHOR", $lang['edit_expl_h_author'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_H_DOMAIN", $lang['edit_expl_h_domain'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_GB_PATH", $lang['edit_expl_gb_path'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_H_KEYWORDS", $lang['edit_expl_h_keywords'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_H_DESCRIPTION", $lang['edit_expl_h_description'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_TIMEZONE", $lang['edit_expl_timezone'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ADMIN_NAME", $lang['edit_expl_admin_name'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ADMIN_EMAIL", $lang['edit_expl_admin_email'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ADMIN_GBEMAIL", $lang['edit_expl_admin_gbemail'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_ADMIN", $lang['edit_expl_sendmail_admin'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_ADMIN_TEXT", $lang['edit_expl_sendmail_admin_text'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_USER", $lang['edit_expl_sendmail_user'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_USER_TEXT", $lang['edit_expl_sendmail_user_text'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_USER_TEXT_MODERATED", $lang['edit_expl_sendmail_user_text_moderated'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_USER_NOTIFICATION_TEXT", $lang['edit_expl_sendmail_user_notification_text'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_COMMENT_TEXT", $lang['edit_expl_sendmail_comment_text'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_CONTACTMAIL_TEXT", $lang['edit_expl_sendmail_contactmail_text'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SENDMAIL_CONTACTMAIL_TEXT_COPY", $lang['edit_expl_sendmail_contactmail_text_copy'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_TEMPLATE_PATH", $lang['edit_expl_template_path'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_TEMPLATE_STYLE_PATH", $lang['edit_expl_template_style_path'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ICONSET_PATH", $lang['edit_expl_iconset_path'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_LANGUAGE_PATH", $lang['edit_expl_language_path'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_LANGUAGE_AUTHOR", $lang['edit_h_author'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_LANGUAGE_VERSION", $lang['version'].":", $page_include);
			$page_include = template("LANG_EDIT_EXPL_LANGUAGE_CHARSET", $lang['edit_expl_language_charset'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_BADWORDS", $lang['edit_expl_badwords'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_BBCODE", $lang['edit_expl_bbcode'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ALLOW_IMG_TAG", $lang['edit_expl_allow_img_tag'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_MAX_IMG_WIDTH", $lang['edit_expl_max_img_width'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_MAX_IMG_HEIGHT", $lang['edit_expl_max_img_height'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CENTER_IMG", $lang['edit_expl_center_img'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ALLOW_FLASH_TAG", $lang['edit_expl_allow_flash_tag'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_MAX_FLASH_WIDTH", $lang['edit_expl_max_flash_width'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_MAX_FLASH_HEIGHT", $lang['edit_expl_max_flash_height'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CENTER_FLASH", $lang['edit_expl_center_flash'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SMILEYS", $lang['edit_expl_smileys'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SMILEYS_BREAK", $lang['edit_expl_smileys_break'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SMILEYS_ORDER", $lang['edit_expl_smileys_order'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CAPTCHA", $lang['edit_expl_captcha'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CAPTCHA_METHOD", $lang['edit_expl_captcha_method'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CAPTCHA_COORDS", $lang['edit_expl_captcha_coords'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CAPTCHA_COLOR", $lang['edit_expl_captcha_color'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_CAPTCHA_ANGLE", $lang['edit_expl_captcha_angle'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_AKISMET_PLUGIN", $lang['edit_expl_akismet_plugin'], $page_include);
			if(file_exists("../plugins/akismet/akismet.class.php"))
				{
				$page_include = template("EDIT_AKISMET_CHECK_IMAGE", "<img src='templates/default/images/active.png' height='16' width='16' alt='active.png' title='active.png'>&nbsp;", $page_include);
				$page_include = template("LANG_EDIT_EXPL_AKISMET_CHECK", $lang['edit_expl_akismet_check_ok'], $page_include);
				}
			else
				{
				$page_include = template("EDIT_AKISMET_CHECK_IMAGE", "<img src='templates/default/images/inactive.png' height='16' width='16' alt='inactive.png' title='inactive.png'>&nbsp;", $page_include);
				$page_include = template("LANG_EDIT_EXPL_AKISMET_CHECK", $lang['edit_expl_akismet_check_fail'], $page_include);
				}
			$page_include = template("LANG_EDIT_EXPL_AKISMET_API", $lang['edit_expl_akismet_api'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_AKISMET_MARK_AS_SPAM", $lang['edit_expl_akismet_mark_as_spam'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_TIME_LOCK", $lang['edit_expl_time_lock'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_TIME_LOCK_VALUE", $lang['edit_expl_time_lock_value'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_TIME_LOCK_MAXTIME", $lang['edit_expl_time_lock_maxtime'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_USER_NOTIFICATION", $lang['edit_expl_user_notification'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_USER_SHOW_EMAIL", $lang['edit_expl_user_show_email'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_SESSION_TIMEOUT", $lang['edit_expl_session_timeout'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_PASSWORD_MIN_LENGTH", $lang['edit_expl_password_min_length'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_MODERATED", $lang['edit_expl_moderated'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_REQUIRE_EMAIL", $lang['edit_expl_require_email'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ENTRIES_PER_PAGE", $lang['edit_expl_entries_per_page'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ENTRIES_ORDER", $lang['edit_expl_entries_order'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ENTRIES_ORDER_ASC_DESC", $lang['edit_expl_entries_order_asc_desc'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_ENTRIES_NUMBERING", $lang['edit_expl_entries_numbering'], $page_include);
			// $page_include = template("LANG_EDIT_EXPL_SPAM_PROTECTION", $lang['edit_expl_spam_protection'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_IPBLOCKER", $lang['edit_expl_ipblocker'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_WORDWRAP", $lang['edit_expl_wordwrap'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_DATEFORM", $lang['edit_expl_dateform'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_GRAVATAR_SHOW", $lang['edit_expl_gravatar_show'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_GRAVATAR_RATING", $lang['edit_expl_gravatar_rating'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_GRAVATAR_TYPE", $lang['edit_expl_gravatar_type'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_GRAVATAR_SIZE", $lang['edit_expl_gravatar_size'], $page_include);
			$page_include = template("LANG_EDIT_EXPL_GRAVATAR_POSITION", $lang['edit_expl_gravatar_position'], $page_include);

			if($settings['sendmail_admin'] == 0) { $selected_sendmail_admin_0 = " selected"; } else { $selected_sendmail_admin_1 = " selected"; }
			if($settings['sendmail_user'] == 0) { $selected_sendmail_user_0 = " selected"; } else { $selected_sendmail_user_1 = " selected"; }
			if($settings['bbcode'] == 0) { $selected_bbcode_0 = " selected"; } else { $selected_bbcode_1 = " selected"; }
			if($settings['allow_img_tag'] == 0) { $selected_allow_img_tag_0 = " selected"; } else { $selected_allow_img_tag_1 = " selected"; }
			if($settings['center_img'] == 0) { $selected_center_img_0 = " selected"; } else { $selected_center_img_1 = " selected"; }
			if($settings['allow_flash_tag'] == 0) { $selected_allow_flash_tag_0 = " selected"; } else { $selected_allow_flash_tag_1 = " selected"; }
			if($settings['center_flash'] == 0) { $selected_center_flash_0 = " selected"; } else { $selected_center_flash_1 = " selected"; }
			if($settings['smileys'] == 0) { $selected_smileys_0 = " selected"; } else { $selected_smileys_1 = " selected"; }
			if($settings['smileys_order'] == "ASC") { $selected_smileys_order_0 = " selected"; } else { $selected_smileys_order_1 = " selected"; }
			if($settings['captcha'] == 0) { $selected_captcha_0 = " selected"; } else { $selected_captcha_1 = " selected"; }
			if($settings['captcha_method'] == 0) { $selected_captcha_method_0 = " selected"; } else { $selected_captcha_method_1 = " selected"; }
			if($settings['akismet_plugin'] == 0) { $selected_akismet_plugin_0 = " selected"; } else { $selected_akismet_plugin_1 = " selected"; }
			if($settings['akismet_mark_as_spam'] == 0) { $selected_akismet_mark_as_spam_0 = " selected"; } else { $selected_akismet_mark_as_spam_1 = " selected"; }
			if($settings['time_lock'] == 0) { $selected_time_lock_0 = " selected"; } else { $selected_time_lock_1 = " selected"; }
			if($settings['user_notification'] == 0) { $selected_user_notification_0 = " selected"; } else { $selected_user_notification_1 = " selected"; }
			if($settings['user_show_email'] == 0) { $selected_user_show_email_0 = " selected"; } else { $selected_user_show_email_1 = " selected"; }
			if($settings['entries_order'] == "ID") {
				$selected_entries_order_0 = " selected"; }
			elseif($settings['entries_order'] == "name") {
				$selected_entries_order_1 = " selected"; }
			elseif($settings['entries_order'] == "city") {
				$selected_entries_order_2 = " selected"; }
			elseif($settings['entries_order'] == "email") {
				$selected_entries_order_3 = " selected"; }
			elseif($settings['entries_order'] == "icq") {
				$selected_entries_order_4 = " selected"; }
			elseif($settings['entries_order'] == "aim") {
				$selected_entries_order_5 = " selected"; }
			elseif($settings['entries_order'] == "msn") {
				$selected_entries_order_6 = " selected"; }
			elseif($settings['entries_order'] == "hp") {
				$selected_entries_order_7 = " selected"; }
			elseif($settings['entries_order'] == "message") {
				$selected_entries_order_8 = " selected"; }
			elseif($settings['entries_order'] == "comment") {
				$selected_entries_order_9 = " selected"; }
			elseif($settings['entries_order'] == "timestamp") {
				$selected_entries_order_10 = " selected"; }
			if($settings['entries_order_asc_desc'] == "ASC") { $selected_entries_order_asc_desc_0 = " selected"; } else { $selected_entries_order_asc_desc_1 = " selected"; }
			if($settings['entries_numbering'] == 0) { $selected_entries_numbering_0 = " selected"; } else { $selected_entries_numbering_1 = " selected"; }
			if($settings['gravatar_show'] == 0) { $selected_gravatar_show_0 = " selected"; } else { $selected_gravatar_show_1 = " selected"; }
			if($settings['gravatar_rating'] == 0) { $selected_gravatar_rating_0 = " selected"; }
			if($settings['gravatar_rating'] == 1) { $selected_gravatar_rating_1 = " selected"; }
			if($settings['gravatar_rating'] == 2) { $selected_gravatar_rating_2 = " selected"; }
			if($settings['gravatar_rating'] == 3) { $selected_gravatar_rating_3 = " selected"; }
			if($settings['gravatar_type'] == 0) {
				$selected_gravatar_type_0 = " selected"; }
			elseif($settings['gravatar_type'] == 1) {
				$selected_gravatar_type_1 = " selected"; }
			elseif($settings['gravatar_type'] == 2) {
				$selected_gravatar_type_2 = " selected"; }
			elseif($settings['gravatar_type'] == 3) {
				$selected_gravatar_type_3 = " selected"; }
			elseif($settings['gravatar_type'] == 4) {
				$selected_gravatar_type_4 = " selected"; }
			elseif($settings['gravatar_type'] == 5) {
				$selected_gravatar_type_5 = " selected"; }
			if($settings['gravatar_position'] == 0) { $selected_gravatar_position_0 = " selected"; } else { $selected_gravatar_position_1 = " selected"; }
			if($settings['moderated'] == 0) { $selected_moderated_0 = " selected"; } else { $selected_moderated_1 = " selected"; }
			if($settings['require_email'] == 0) { $selected_require_email_0 = " selected"; } else { $selected_require_email_1 = " selected"; }
			// if($settings['spam_protection'] == 0) { $selected_spam_protection_0 = " selected"; } else { $selected_spam_protection_1 = " selected"; }
			if($settings['ipblocker'] == 0) { $selected_ipblocker_0 = " selected"; } else { $selected_ipblocker_1 = " selected"; }

			// replace values
			$page_include = template("EDIT_TITLE", $settings['title'], $page_include);
			$page_include = template("EDIT_H_AUTHOR", $settings['h_author'], $page_include);
			$page_include = template("EDIT_H_DOMAIN", $settings['h_domain'], $page_include);
			$page_include = template("EDIT_GB_PATH", $settings['gb_path'], $page_include);
			$page_include = template("EDIT_H_KEYWORDS", $settings['h_keywords'], $page_include);
			$page_include = template("EDIT_H_DESCRIPTION", $settings['h_description'], $page_include);
			$page_include = template("EDIT_TIMEZONE", $settings['timezone'], $page_include);
			$page_include = template("EDIT_ADMIN_NAME", $settings['admin_name'], $page_include);
			$page_include = template("EDIT_ADMIN_EMAIL", $settings['admin_email'], $page_include);
			$page_include = template("EDIT_ADMIN_GBEMAIL", $settings['admin_gbemail'], $page_include);
			$page_include = template("SELECTED_SENDMAIL_ADMIN_0", $selected_sendmail_admin_0, $page_include);
			$page_include = template("SELECTED_SENDMAIL_ADMIN_1", $selected_sendmail_admin_1, $page_include);
			$page_include = template("EDIT_SENDMAIL_ADMIN_TEXT", $settings['sendmail_admin_text'], $page_include);
			$page_include = template("SELECTED_SENDMAIL_USER_0", $selected_sendmail_user_0, $page_include);
			$page_include = template("SELECTED_SENDMAIL_USER_1", $selected_sendmail_user_1, $page_include);
			$page_include = template("EDIT_SENDMAIL_USER_TEXT", $settings['sendmail_user_text'], $page_include);
			$page_include = template("EDIT_SENDMAIL_USER_TEXT_MODERATED", $settings['sendmail_user_text_moderated'], $page_include);
			$page_include = template("EDIT_SENDMAIL_USER_NOTIFICATION_TEXT", $settings['sendmail_user_notification_text'], $page_include);
			$page_include = template("EDIT_SENDMAIL_COMMENT_TEXT", $settings['sendmail_comment_text'], $page_include);
			$page_include = template("EDIT_SENDMAIL_CONTACTMAIL_TEXT", $settings['sendmail_contactmail_text'], $page_include);
			$page_include = template("EDIT_SENDMAIL_CONTACTMAIL_TEXT_COPY", $settings['sendmail_contactmail_text_copy'], $page_include);
			$page_include = template("EDIT_OPTION_TEMPLATE_PATH", $edit_option_template_path, $page_include);
			$page_include = template("EDIT_OPTION_TEMPLATE_STYLE_PATH", $edit_option_template_style_path, $page_include);
			$page_include = template("EDIT_OPTION_ICONSET_PATH", $edit_option_iconset_path, $page_include);
			$page_include = template("EDIT_OPTION_LANGUAGE_PATH", $edit_option_language_path, $page_include);
			$page_include = template("EDIT_BADWORDS", $settings['badwords'], $page_include);
			$page_include = template("SELECTED_BBCODE_0", $selected_bbcode_0, $page_include);
			$page_include = template("SELECTED_BBCODE_1", $selected_bbcode_1, $page_include);
			$page_include = template("SELECTED_ALLOW_IMG_TAG_0", $selected_allow_img_tag_0, $page_include);
			$page_include = template("SELECTED_ALLOW_IMG_TAG_1", $selected_allow_img_tag_1, $page_include);
			$page_include = template("SELECTED_CENTER_IMG_0", $selected_center_img_0, $page_include);
			$page_include = template("SELECTED_CENTER_IMG_1", $selected_center_img_1, $page_include);
			$page_include = template("EDIT_MAX_IMG_WIDTH", $settings['max_img_width'], $page_include);
			$page_include = template("EDIT_MAX_IMG_HEIGHT", $settings['max_img_height'], $page_include);
			$page_include = template("SELECTED_ALLOW_FLASH_TAG_0", $selected_allow_flash_tag_0, $page_include);
			$page_include = template("SELECTED_ALLOW_FLASH_TAG_1", $selected_allow_flash_tag_1, $page_include);
			$page_include = template("SELECTED_CENTER_FLASH_0", $selected_center_flash_0, $page_include);
			$page_include = template("SELECTED_CENTER_FLASH_1", $selected_center_flash_1, $page_include);
			$page_include = template("EDIT_MAX_FLASH_WIDTH", $settings['max_flash_width'], $page_include);
			$page_include = template("EDIT_MAX_FLASH_HEIGHT", $settings['max_flash_height'], $page_include);
			$page_include = template("SELECTED_SMILEYS_0", $selected_smileys_0, $page_include);
			$page_include = template("SELECTED_SMILEYS_1", $selected_smileys_1, $page_include);
			$page_include = template("EDIT_SMILEYS_BREAK", $settings['smileys_break'], $page_include);
			$page_include = template("SELECTED_SMILEYS_ORDER_0", $selected_smileys_order_0, $page_include);
			$page_include = template("SELECTED_SMILEYS_ORDER_1", $selected_smileys_order_1, $page_include);
			$page_include = template("SELECTED_CAPTCHA_0", $selected_captcha_0, $page_include);
			$page_include = template("SELECTED_CAPTCHA_1", $selected_captcha_1, $page_include);
			$page_include = template("SELECTED_CAPTCHA_METHOD_0", $selected_captcha_method_0, $page_include);
			$page_include = template("SELECTED_CAPTCHA_METHOD_1", $selected_captcha_method_1, $page_include);
			$page_include = template("EDIT_CAPTCHA_COORDS_X", $settings['captcha_coords_x'], $page_include);
			$page_include = template("EDIT_CAPTCHA_COORDS_Y", $settings['captcha_coords_y'], $page_include);
			$page_include = template("EDIT_CAPTCHA_COLOR", $settings['captcha_color'], $page_include);
			$page_include = template("EDIT_CAPTCHA_ANGLE_1", $settings['captcha_angle_1'], $page_include);
			$page_include = template("EDIT_CAPTCHA_ANGLE_2", $settings['captcha_angle_2'], $page_include);
			$page_include = template("SELECTED_AKISMET_PLUGIN_0", $selected_akismet_plugin_0, $page_include);
			$page_include = template("SELECTED_AKISMET_PLUGIN_1", $selected_akismet_plugin_1, $page_include);
			$page_include = template("EDIT_AKISMET_API", $settings['akismet_api'], $page_include);
			$page_include = template("SELECTED_AKISMET_MARK_AS_SPAM_0", $selected_akismet_mark_as_spam_0, $page_include);
			$page_include = template("SELECTED_AKISMET_MARK_AS_SPAM_1", $selected_akismet_mark_as_spam_1, $page_include);
			$page_include = template("SELECTED_TIME_LOCK_0", $selected_time_lock_0, $page_include);
			$page_include = template("SELECTED_TIME_LOCK_1", $selected_time_lock_1, $page_include);
			$page_include = template("EDIT_TIME_LOCK_VALUE", $settings['time_lock_value'], $page_include);
			$page_include = template("EDIT_TIME_LOCK_MAXTIME", $settings['time_lock_maxtime'], $page_include);
			$page_include = template("SELECTED_USER_NOTIFICATION_0", $selected_user_notification_0, $page_include);
			$page_include = template("SELECTED_USER_NOTIFICATION_1", $selected_user_notification_1, $page_include);
			$page_include = template("SELECTED_USER_SHOW_EMAIL_0", $selected_user_show_email_0, $page_include);
			$page_include = template("SELECTED_USER_SHOW_EMAIL_1", $selected_user_show_email_1, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_0", $selected_entries_order_0, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_1", $selected_entries_order_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_SHOW_0", $selected_gravatar_show_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_SHOW_1", $selected_gravatar_show_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_0", $selected_gravatar_rating_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_1", $selected_gravatar_rating_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_2", $selected_gravatar_rating_2, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_3", $selected_gravatar_rating_3, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_0", $selected_gravatar_type_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_1", $selected_gravatar_type_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_2", $selected_gravatar_type_2, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_3", $selected_gravatar_type_3, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_4", $selected_gravatar_type_4, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_5", $selected_gravatar_type_5, $page_include);
			$page_include = template("SELECTED_GRAVATAR_POSITION_0", $selected_gravatar_position_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_POSITION_1", $selected_gravatar_position_1, $page_include);
			$page_include = template("EDIT_GRAVATAR_SIZE", $settings['gravatar_size'], $page_include);
			$page_include = template("EDIT_SESSION_TIMEOUT", $settings['session_timeout'], $page_include);
			$page_include = template("EDIT_PASSWORD_MIN_LENGTH", $settings['password_min_length'], $page_include);
			$page_include = template("SELECTED_MODERATED_0", $selected_moderated_0, $page_include);
			$page_include = template("SELECTED_MODERATED_1", $selected_moderated_1, $page_include);
			$page_include = template("SELECTED_REQUIRE_EMAIL_0", $selected_require_email_0, $page_include);
			$page_include = template("SELECTED_REQUIRE_EMAIL_1", $selected_require_email_1, $page_include);
			$page_include = template("EDIT_ENTRIES_PER_PAGE", $settings['entries_per_page'], $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_0", $selected_entries_order_0, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_1", $selected_entries_order_1, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_2", $selected_entries_order_2, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_3", $selected_entries_order_3, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_4", $selected_entries_order_4, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_5", $selected_entries_order_5, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_6", $selected_entries_order_6, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_7", $selected_entries_order_7, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_8", $selected_entries_order_8, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_9", $selected_entries_order_9, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_10", $selected_entries_order_10, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_ASC_DESC_0", $selected_entries_order_asc_desc_0, $page_include);
			$page_include = template("SELECTED_ENTRIES_ORDER_ASC_DESC_1", $selected_entries_order_asc_desc_1, $page_include);
			$page_include = template("SELECTED_ENTRIES_NUMBERING_0", $selected_entries_numbering_0, $page_include);
			$page_include = template("SELECTED_ENTRIES_NUMBERING_1", $selected_entries_numbering_1, $page_include);
			// $page_include = template("SELECTED_SPAM_PROTECTION_0", $selected_spam_protection_0, $page_include);
			// $page_include = template("SELECTED_SPAM_PROTECTION_1", $selected_spam_protection_1, $page_include);
			$page_include = template("SELECTED_IPBLOCKER_0", $selected_ipblocker_0, $page_include);
			$page_include = template("SELECTED_IPBLOCKER_1", $selected_ipblocker_1, $page_include);
			$page_include = template("EDIT_WORDWRAP", $settings['wordwrap'], $page_include);
			$page_include = template("EDIT_DATEFORM", $settings['dateform'], $page_include);

			$content_scrolling_function = "";
		}
	else
		{
		$page_include = "<span class=\"admin\">".$lang['errormessage4']."</span>"; // user has no access to this page, user level too low
		$content_scrolling_function = "<br>";
		}
	}
?>