<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================= //
	// functions.inc.php //
	// ================= //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// badwords
	if (!function_exists("badwords"))
		{
		function badwords($text)
			{
			global $badwords;
			foreach($badwords as $b)
				{
				if($b != "")
					{
					$r = $b[0].str_repeat("*", strlen($b)-2).$b[strlen($b)-1];
					if(function_exists("str_ireplace"))
						{
						$text = str_ireplace($b, $r, $text);
						}
					else
						{
						$text = str_replace($b, $r, $text);
						}
					}
				}
				return $text;
				}
		}


	// checks if email is valid
	if (!function_exists("check_mail"))
		{
		function check_mail($email)
			{
			if (preg_match("/^[a-zA-Z0-9]+([-_\.]?[a-zA-Z0-9])+@[a-zA-Z0-9]+([-_\.]?[a-zA-Z0-9])+\.[a-zA-Z]{2,4}/", $email))
				{
				return TRUE;
				}
			else
				{
				return FALSE;
				}
				}
			}


	// checks if icq number is valid
	if (!function_exists("check_number"))
		{
		function check_number($number)
			{
			if (preg_match("=^[0-9]+$=i", $number))
				{
				return TRUE;
				}
			else
				{
				return FALSE;
				}
			}
		}


	// sets smilies
	if (!function_exists("set_smilies"))
		{
		function set_smilies($text)
			{
			// load smilies
			require "includes/config.inc.php";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, set_smilies) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, set_smilies) Error, cannot select database: ".mysql_error());
			$sql="SELECT * FROM ".$db['prefix']."smilies ORDER BY ID DESC";
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, set_smilies) Error in sql query: ".mysql_error());

			for($i = 0; $i < mysql_num_rows($result); $i++)
				{
				$smiley[$i] = mysql_fetch_array($result);
				}

			if(!isset($smiley)) { $smiley = NULL; }

			for($i = 0; $i < count($smiley); $i++)
				{
				// replace smilies in entry
				if (preg_match("/,/is", $smiley[$i]['replacement'], $treffer))
					{
					$smilies = explode(", ", $smiley[$i]['replacement']);
					for($e = 0; $e < count($smilies); $e++)
						{
						if(($smilies[$e] != ":/") AND ($smilies[$e] != "//") AND ($smilies[$e] != "://"))
							{
							$smilie_replace[$e] = $text;
							$smilie_replace[$e] = str_ireplace($smilies[$e], '<img src="images/smilies/'.$smiley[$i]['path'].'" alt="" title="" width="'.$smiley[$i]['width'].'" height="'.$smiley[$i]['height'].'">', $smilie_replace[$e]);
							$text = $smilie_replace[$e];
							}
						}
					}
				if(($smiley[$i]['replacement'] != ":/") AND ($smiley[$i]['replacement'] != "//") AND ($smiley[$i]['replacement'] != "://"))
					{
					$smilie_replace[$i] = $text;
					$smilie_replace[$i] = str_ireplace($smiley[$i]['replacement'], '<img src="images/smilies/'.$smiley[$i]['path'].'" alt="" title="" width="'.$smiley[$i]['width'].'" height="'.$smiley[$i]['height'].'">', $smilie_replace[$i]);
					$text = $smilie_replace[$i];
					}
				}
			return $text;
			}
		}


	// delete smilies
	if (!function_exists("delete_smilies"))
		{
		function delete_smilies($text)
			{
			// load smilies
			require "includes/config.inc.php";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, delete_smilies) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, delete_smilies) Error, cannot select database: ".mysql_error());
			$sql="SELECT * FROM ".$db['prefix']."smilies ORDER BY ID DESC";
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php_delete_smilies) Error in sql query: ".mysql_error());

			for($i = 0; $i < mysql_num_rows($result); $i++)
				{
				$smiley[$i] = mysql_fetch_array($result);
				}

			if(!isset($smiley)) { $smiley = NULL; }

			for($i = 0; $i < count($smiley); $i++)
				{
				// replace smilies in entry
				if (preg_match("/,/is", $smiley[$i]['replacement'], $treffer))
					{
					$smilies = explode(", ", $smiley[$i]['replacement']);
					for($e = 0; $e < count($smilies); $e++)
						{
						if(($smilies[$e] != ":/") AND ($smilies[$e] != "//") AND ($smilies[$e] != "://"))
							{
							$smilie_replace[$e] = $text;
							$smilie_replace[$e] = str_ireplace($smilies[$e], '', $smilie_replace[$e]);
							$text = $smilie_replace[$e];
							}
						}
					}
				if(($smiley[$i]['replacement'] != ":/") AND ($smiley[$i]['replacement'] != "//") AND ($smiley[$i]['replacement'] != "://"))
					{
					$smilie_replace[$i] = $text;
					$smilie_replace[$i] = str_ireplace($smiley[$i]['replacement'], '', $smilie_replace[$i]);
					$text = $smilie_replace[$i];
					}
				}
			return $text;
			}
		}


	// this function caches images for guestbook entries
	// (NOT ACTIVE NOW, MAYBE IN 0.7...)
	if (!function_exists("img_cache"))
		{
		function img_cache($image, $entry_id)
			{
			ob_start();
			$fp = fopen($image, "rb");
			fpassthru($fp);
			fclose($fp);
			$file = ob_get_contents();
			ob_end_clean();

			$fp = fopen("../cache/foo.gif", "wb+");
			fwrite($fp, $file);
			fclose($fp); 
			}
		}


	// this function adds "http://" to a bbcode url
	// if it isn't there
	if (!function_exists("http"))
		{
		function http($treffer)
			{
			$url = $treffer[1];
			if (!preg_match("/http:\/\//i", $url))
				{
				$url = "http://".$url;
				}
			$link = "<a href='".$url."' target='_blank' title='".$url."'>".$url."</a>";
			return $link;
			}
		}

	// this function adds "http://" to a bbcode url
	// if it isn't there AND checks if there is an image between the [url] bbcode
	if (!function_exists("http_img"))
		{
		function http_img($treffer)
			{
			$url = $treffer[1];
			$text = $treffer[2];

			// load maximum width and height settings
			require "config.inc.php";
			$sql = "SELECT allow_img_tag, max_img_width, max_img_height, center_img FROM ".$db['prefix']."settings";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, http_img) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, http_img) Error, cannot select database: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, http_img) Error in sql query: ".mysql_error());
			$settings = @mysql_fetch_array($result);
			if ($settings['center_img'] == 1) { $center_1 = "<center>"; $center_2 = "</center>"; }

			// search for missing http://
			if (!preg_match("/http:\/\//i", $url))
				{
				$url = "http://".$url;
				}

			$link = "<a href='".$url."' target='_blank' title='".$url."'>".$text."</a>";

			if(isset($settings['allow_img_tag']) AND $settings['allow_img_tag'] == 1)
				{
				// does [url] contain an image?
				if (preg_match("/\[img\](.*?)\[\/img\]/is", $text, $image))
					{
					$img_url = $image[1];
					if(function_exists("getimagesize"))
						{
						if($img_size = @getimagesize($img_url))
							{
							$max_width = $settings['max_img_width'];
							if($img_size[0] > $max_width)
								{
								$proportion = $img_size[0] / $max_width;
								$image_width = $max_width;
								$image_height = ceil($img_size[1] / $proportion);
								}
							else
								{
								$image_width = $img_size[0];
								$image_height = $img_size[1];
								}
							$link = $center_1."<a href='".$url."' target='_blank' title='".$url."'><img class='entry' src='".$img_url."' alt='".$img_url."' title='".$img_url."' width='".$image_width."' height='".$image_height."'></a>".$center_2;
							}
						else
							{
							$link = $center_1."<a href='".$url."' target='_blank' title='".$url."'><img class='entry' src='".$img_url."' alt='".$img_url."' title='".$img_url."'></a>".$center_2;
							}
						}
					else
						{
						$link = $center_1."<a href='".$url."' target='_blank' title='".$url."'><img class='entry' src='".$img_url."' alt='".$img_url."' title='".$img_url."'></a>".$center_2;
						}
					}
				elseif (preg_match("/\[img=([0-9]+),([0-9]+)\](.*?)\[\/img\]/is", $text, $image))
					{
					$max_width = $settings['max_img_width'];
					$max_height = $settings['max_img_height'];

					if ($image[1] > $max_width) { $image_width = $max_width; } else { $image_width = $image[1]; }
					if ($image[2] > $max_height) { $image_height = $max_height; } else { $image_height = $image[2]; }

					$link = $center_1."<a href='".$url."' target='_blank' title='".$url."'><img class='entry' src='".$image[3]."' alt='".$image[3]."' title='".$image[3]."' width='".$image_width."' height='".$image_height."'></a>".$center_2;
					}
				}
			return $link;
			}
		}


	// this function analyzes the size of the image in the [img]-tag and reduces it's
	// dimensions to "normal" ones that don't break up the flow of the template design
	if (!function_exists("img_1"))
		{
		function img_1($treffer)
			{
			// load maximum width and height settings
			require "config.inc.php";
			$sql = "SELECT allow_img_tag, max_img_width, max_img_height, center_img FROM ".$db['prefix']."settings";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, img_1) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, img_1) Error, cannot select database: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, img_1) Error in sql query: ".mysql_error());
			$settings = @mysql_fetch_array($result);

			if(isset($settings['allow_img_tag']) AND $settings['allow_img_tag'] == 1)
				{
				$img_url = $treffer[1];
				$max_width = $settings['max_img_width'];
				if ($settings['center_img'] == 1) { $center_1 = "<center>"; $center_2 = "</center>"; }
				if(function_exists("getimagesize"))
					{
					if($img_size = @getimagesize($img_url))
						{
						if($img_size[0] > $max_width)
							{
							$proportion = $img_size[0] / $max_width;
							$image_width = $max_width;
							$image_height = ceil($img_size[1] / $proportion);
							}
						else
							{
							$image_width = $img_size[0];
							$image_height = $img_size[1];
							}
						$bbcode = $center_1."<img class='entry' src='".$img_url."' alt='".$img_url."' title='".$img_url."' width='".$image_width."' height='".$image_height."'>".$center_2;
						}
					else
						{
						$bbcode = $center_1."<img class='entry' src='".$img_url."' alt='".$img_url."' title='".$img_url."'>".$center_2;
						}
					}
				else
					{
					$bbcode = $center_1."<img class='entry' src='".$img_url."' alt='".$img_url."' title='".$img_url."'>".$center_2;
					}
				}
			else
				{
				$bbcode = "Image: ".$treffer[1];
				}
			return $bbcode;
			}
		}


	// this functions analyzes the provided size values of the user and
	// reduces them to "normal" ones if they break up the flow of the template
	if (!function_exists("img_2"))
		{
		function img_2($treffer)
			{
			// load maximum width and height settings
			require "config.inc.php";
			$sql = "SELECT allow_img_tag, max_img_width, max_img_height, center_img FROM ".$db['prefix']."settings";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, img_2) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, img_2) Error, cannot select database: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, img_2) Error in sql query: ".mysql_error());
			$settings = @mysql_fetch_array($result);

			if(isset($settings['allow_img_tag']) AND $settings['allow_img_tag'] == 1)
				{
				$image_width = $treffer[1];
				$image_height = $treffer[2];
				$image_url = $treffer[3];

				$max_width = $settings['max_img_width'];
				$max_height = $settings['max_img_height'];

				if ($treffer[1] > $max_width) { $image_width = $max_width; } else { $image_width = $treffer[1]; }
				if ($treffer[2] > $max_height) { $image_height = $max_height; } else { $image_height = $treffer[2]; }
				if ($settings['center_img'] == 1) { $center_1 = "<center>"; $center_2 = "</center>"; }
				$bbcode = $center_1."<img class='entry' src='".$image_url."' alt='".$image_url."' title='".$image_url."' width='".$image_width."' height='".$image_height."'>".$center_2;
				}
			else
				{
				$bbcode = "Image: ".$treffer[3];
				}
			return $bbcode;
			}
		}


	if (!function_exists("quote"))
		{
		function quote($treffer)
			{
			$quote_text = $treffer[1];
			$bbcode = "<blockquote><span class='quote_text'>&raquo;".$quote_text."&laquo;</span></blockquote>";
			return $bbcode;
			}
		}


	if (!function_exists("quote_name"))
		{
		function quote_name($treffer)
			{
			$quote_name = $treffer[1];
			$quote_text = $treffer[2];
			$bbcode = "<blockquote><span class='quote_name'>{LANG_QUOTE}&nbsp;".$quote_name.":</span><br><span class='quote_text'>&raquo;".$quote_text."&laquo;</span></blockquote>";
			return $bbcode;
			}
		}


	if (!function_exists("flash"))
		{
		function flash($treffer)
			{
			// load maximum width and height settings
			require "config.inc.php";
			$sql = "SELECT allow_flash_tag, max_flash_width, max_flash_height, center_flash FROM ".$db['prefix']."settings";
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, flash) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, flash) Error, cannot select database: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, flash) Error in sql query: ".mysql_error());
			$settings = @mysql_fetch_array($result);

			if(isset($settings['allow_flash_tag']) AND $settings['allow_flash_tag'] == 1)
				{
				$flash_width = $treffer[1];
				$flash_height = $treffer[2];
				$flash_url = $treffer[3];

				$max_width = $settings['max_flash_width'];
				$max_height = $settings['max_flash_height'];

				if ($treffer[1] > $max_width) { $flash_width = $max_width; } else { $flash_width = $treffer[1]; }
				if ($treffer[2] > $max_height) { $flash_height = $max_height; } else { $flash_height = $treffer[2]; }

				// simplify youtube urls for the user
				if (preg_match("/http:\/\/www.youtube.com\/watch\?v\=(.*?)/is", $flash_url, $found)) { $flash_url = preg_replace("/http:\/\/www.youtube.com\/watch\?v=(.*?)/is", "http://www.youtube.com/v/$1", $flash_url); }
				if ($settings['center_flash'] == 1) { $center_1 = "<center>"; $center_2 = "</center>"; }
				/* $bbcode = $center_1."<iframe width='".$flash_width."' height='".$flash_height."' src='".$flash_url."' frameborder='0'></iframe>".$center_2; //allowfullscreen */
				// the following html code is taken from phpBB 3.0.9, released under GNU/GPL
				$bbcode = $center_1."<object classid='clsid:D27CDB6E-AE6D-11CF-96B8-444553540000' codebase='http://active.macromedia.com/flash2/cabs/swflash.cab#version=5,0,0,0' width='".$flash_width."' height='".$flash_height."'>
				<param name='movie' value='".$flash_url."' />
				<param name='play' value='false' />
				<param name='loop' value='false' />
				<param name='quality' value='high' />
				<param name='allowScriptAccess' value='never' />
				<param name='allowNetworking' value='internal' />
				<embed src='".$flash_url."' type='application/x-shockwave-flash' pluginspage='http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash' width='".$flash_width."' height='".$flash_height."' play='false' loop='false' quality='high' allowscriptaccess='never' allownetworking='internal'></embed>
				</object>".$center_2;
				}
			else
				{
				$bbcode = "Flash: ".$treffer[3];
				}
			return $bbcode;
			}
		}


	// bbcode formatting
	if (!function_exists("bbcode_format"))
		{
		function bbcode_format($bbcode, $page)
			{
			if($page != "adminpanel")
				{
				$bbcode = preg_replace_callback('/\[url\](.*?)\[\/url\]/is', 'http', $bbcode);
				$bbcode = preg_replace_callback('/\[url\=(.*?)\](.*?)\[\/url\]/is', 'http_img', $bbcode);
				$bbcode = preg_replace_callback('/\[img\](.*?)\[\/img\]/is', 'img_1', $bbcode);
				$bbcode = preg_replace_callback('/\[img\=([0-9]+),([0-9]+)\](.*?)\[\/img\]/is', 'img_2', $bbcode);
				$bbcode = preg_replace_callback('/\[quote\](.*?)\[\/quote\]/is', 'quote', $bbcode);
				$bbcode = preg_replace_callback('/\[quote\=(.*?)\](.*?)\[\/quote\]/is', 'quote_name', $bbcode);
				$bbcode = preg_replace_callback('/\[flash\=([0-9]+),([0-9]+)\](.*?)\[\/flash\]/is', 'flash', $bbcode);

				$bbcode_search = array(
							'/\[b\](.*?)\[\/b\]/is',
							'/\[i\](.*?)\[\/i\]/is',
							'/\[size\=(.*?)\]\[color\=(.*?)\](.*?)\[\/color\]\[\/size\]/is',
							'/\[color\=(.*?)\]\[size\=(.*?)\](.*?)\[\/size\]\[\/color\]/is',
							'/\[size\=(.*?)\](.*?)\[\/size\]/is',
							'/\[color\=(.*?)\](.*?)\[\/color\]/is',
							'/\[code\](.*?)\[\/code\]/is'
							);

				$bbcode_replace = array(
							'<b>$1</b>',
							'<i>$1</i>',
							'<span style="font-size: $1px; color: $2">$3</span>',
							'<span style="color: $1; font-size: $2px">$3</span>',
							'<span style="font-size: $1px;color:inherit;">$2</span>',
							'<span style="color: $1">$2</span>',
							'<blockquote class="code">$1</blockquote>'
							);

				$bbcode = preg_replace ($bbcode_search, $bbcode_replace, $bbcode);
				}
			else
				{
				$bbcode_search = array(
							'/\[b\](.*?)\[\/b\]/is',
							'/\[i\](.*?)\[\/i\]/is',
							'/\[size\=(.*?)\]\[color\=(.*?)\](.*?)\[\/color\]\[\/size\]/is',
							'/\[color\=(.*?)\]\[size\=(.*?)\](.*?)\[\/size\]\[\/color\]/is',
							'/\[size\=(.*?)\](.*?)\[\/size\]/is',
							'/\[color\=(.*?)\](.*?)\[\/color\]/is',
							'/\[img\](.*?)\[\/img\]/is',
							'/\[img\=([0-9]+),([0-9]+)\](.*?)\[\/img\]/is',
							'/\[url\](.*?)\[\/url\]/is',
							'/\[url\=(.*?)\](.*?)\[\/url\]/is',
							'/\[quote\](.*?)\[\/quote\]/is',
							'/\[quote\=(.*?)\](.*?)\[\/quote\]/is',
							'/\[flash\=([0-9]+),([0-9]+)\](.*?)\[\/flash\]/is',
							'/\[code\](.*?)\[\/code\]/is'
							);

				$bbcode_replace = array(
							'[b]$1[/b]',
							'[i]$1[/i]',
							'[size=$1][color=$2]$3[/color][/size]',
							'[color=$1][size=$2]$3[/size][/color]',
							'[size=$1]$2[/size]',
							'[color=$1]$2[/color]',
							'[img]$1[/img]',
							'[img=$1,$2]$3[/img]',
							'[url]$1[/url]',
							'[url=$1]$2[/url]',
							'[quote]$1[/quote]',
							'[quote=$1]$2[/quote]',
							'[flash=$1,$2]$3[/flash]',
							'[code]$1[/code]'
							);

				$bbcode = preg_replace ($bbcode_search, $bbcode_replace, $bbcode);
				}
			return $bbcode;
			}
		}

	// deletes bbcode
	if (!function_exists("bbcode_delete"))
		{
		function bbcode_delete($bbcode)
			{
			//$bbcode = htmlentities($bbcode);
			$bbcode_search = array(
						'/\[b\](.*?)\[\/b\]/is',
						'/\[i\](.*?)\[\/i\]/is',
						'/\[url\](.*?)\[\/url\]/is',
						'/\[url\=(.*?)\](.*?)\[\/url\]/is',
						'/\[size\=(.*?)\](.*?)\[\/size\]/is',
						'/\[color\=(.*?)\](.*?)\[\/color\]/is',
						'/\[img\](.*?)\[\/img\]/is',
						'/\[img=([0-9]+),([0-9]+)\](.*?)\[\/img\]/is',
						'/\[quote\](.*?)\[\/quote\]/is',
						'/\[quote\=(.*?)\](.*?)\[\/quote\]/is',
						'/\[flash\=([0-9]+),([0-9]+)\](.*?)\[\/flash\]/is',
						'/\[code\](.*?)\[\/code\]/is'
						);

			$bbcode_replace = array(
						'$1',
						'$1',
						'$1',
						'$1',
						'$2',
						'$2',
						'$1',
						'$3',
						'$1',
						'$2',
						'$3',
						'$1'
						);

			$bbcode = preg_replace ($bbcode_search, $bbcode_replace, $bbcode);

			return $bbcode;
			}
		}

	// checks if login is ok
	if (!function_exists("login_ok"))
		{
		function login_ok($name, $ID, $password)
			{
			require "../includes/config.inc.php";

			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, login_ok) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, login_ok) Error, cannot select database: ".mysql_error());
			
			if($ID != "")
				{
				$sql = "SELECT user_password FROM ".$db['prefix']."user WHERE ID=".$ID;
				}
			else
				{
				$sql = "SELECT user_password FROM ".$db['prefix']."user WHERE user_name=".$name;
				}
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, login_ok) Error in sql query: ".mysql_error());

			$user = @mysql_fetch_array($result);
			$pass = md5($password);

			if ($user['user_password'] == $pass)
				{
				return TRUE;
				unset($ID);
				unset($user['user_password']);
				unset($pass);
				}
			else
				{
				return FALSE;
				unset($ID);
				unset($user['user_password']);
				unset($pass);
				}
			}
		}

	// checks if username exists when adding new user
	if (!function_exists("check_if_user_exists"))
		{
		function check_if_user_exists($name, $email)
			{
			require "../includes/config.inc.php";

			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, check_if_user_exists) Error cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, check_if_user_exists) Error cannot select database: ".mysql_error());

			$sql = "SELECT user_name FROM ".$db['prefix']."user WHERE user_name=".$name;
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, check_if_user_exists, name) Error in sql query: ".mysql_error());

			$user = @mysql_fetch_array($result);

			if(secure_value(strtolower($user['user_name'])) == strtolower($name))
				{
				return FALSE;
				}
			else
				{
				$ok = 1;
				}

			$sql = "SELECT user_email FROM ".$db['prefix']."user WHERE user_email=".$email;
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, check_if_user_exists, email) Error in sql query: ".mysql_error());
			
			$user = @mysql_fetch_array($result);

			if(secure_value(strtolower($user['user_email'])) == strtolower($email))
				{
				return FALSE;
				}
			else
				{
				$ok = 1;
				}

			if($ok == 1) { return TRUE; }
			}
		}

	// wordwrap: if message contains words longer than $settings['wordwrap'] they will
	// be broken into two or more strings. If $settings['wordwrap'] == 0, function is off.
	// This method taken from http://de.php.net/manual/en/function.wordwrap.php#64517
	// by ab_at_notenet(dot)dk (thanks for that!!) will luckily not affect html tags
	if (!function_exists("textWrap"))
		{	
		function textWrap($text, $size)
			{
			$new_text = '';
			$text_1 = explode('>',$text);
			$sizeof = sizeof($text_1);
			for ($i=0; $i<$sizeof; ++$i)
				{
				$text_2 = explode('<',$text_1[$i]);
				if (!empty($text_2[0]))
					{
					$new_text .= preg_replace('#([^\n\r .]{'. $size .'})#i', '\\1  ', $text_2[0]);
					}
				if (!empty($text_2[1]))
					{
					$new_text .= '<' . $text_2[1] . '>'; 
					}
				}
			return $new_text;
			}
		}

	// secure values to prevent remote sql exploits
	if (!function_exists("secure_value"))
		{
		function secure_value($value)
			{
			if (get_magic_quotes_gpc()) {
				$value = stripslashes($value);
				}
			if (!is_numeric($value)) {
				$value = "'" . mysql_real_escape_string($value) . "'";
				}
			return $value;
			}
		}

	// turn xhtml breaks to new lines
	if (!function_exists("xhtmlbr2nl"))
		{
		function xhtmlbr2nl($value)
			{
			$value = preg_replace("/\<br \/>/", "\n", $value);
			return $value;
			}
		}

	// replace placeholders in email
	if (!function_exists("format_mail"))
		{
		function format_mail($value, $name, $date, $time, $message, $domain, $url_to_gb, $adduser_name, $adduser_password, $adduser_url, $new_password_key, $user_id, $new_password)
			{
			$value = preg_replace("/\{NAME\}/", $name, $value);
			$value = preg_replace("/\{DATE\}/", $date, $value);
			$value = preg_replace("/\{TIME\}/", $time, $value);
			$value = preg_replace("/\{DOMAIN\}/", $domain, $value);
			$value = preg_replace("/\{URL_TO_GB\}/", $url_to_gb, $value);
			$value = preg_replace("/\{MESSAGE\}/", $message, $value);
			$value = preg_replace("/\{ADDUSER_NAME\}/", $adduser_name, $value);
			$value = preg_replace("/\{ADDUSER_PASSWORD\}/", $adduser_password, $value);
			$value = preg_replace("/\{ADDUSER_URL\}/", $adduser_url, $value);
			$value = preg_replace("/\{NEW_PASSWORD_KEY\}/", $new_password_key, $value);
			$value = preg_replace("/\{NEW_PASSWORD_LINK\}/", $url_to_gb."?id=".$user_id."&key=".$new_password_key, $value);
			$value = preg_replace("/\{NEW_PASSWORD\}/", $new_password, $value);

			return $value;
			}
		}

	// replace umlauts in email
	if (!function_exists("repl_uml"))
		{
		function repl_uml($text, $charset)
			{
			if($charset == "utf-8")
				{
				$text = preg_replace("/\&uuml;/", utf8_encode(""), $text);
				$text = preg_replace("/\&auml;/", utf8_encode(""), $text);
				$text = preg_replace("/\&ouml;/", utf8_encode(""), $text);
				$text = preg_replace("/\&szlig;/", utf8_encode(""), $text);
				}
			else
				{
				$text = preg_replace("/\&uuml;/", "", $text);
				$text = preg_replace("/\&auml;/", "", $text);
				$text = preg_replace("/\&ouml;/", "", $text);
				$text = preg_replace("/\&szlig;/", "", $text);
				}
			
			return $text;
			}
		}

	// generate captcha
	if (!function_exists("generate_captcha"))
		{
		function generate_captcha($captcha_method)
			{
			require "includes/config.inc.php";
			if ($captcha_method == 0)
				{
				$captcha_letters = array("A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
				$captcha_numbers = array("2", "3", "4", "5", "6", "8", "9");
				$captcha_special = array("!", "?");
				for ($i = 0, $code = NULL; strlen($code) < 6; $i++)
					{
					// if you like to use special characters in your captcha
					// set the "2" in the following line to "3"
					$captcha_random = rand(1, 2);
					if ($captcha_random == 1)
						{
						$code .= $captcha_letters[rand(0, (count($captcha_letters))-1)];
						}
					elseif ($captcha_random == 2)
						{
						$code .= $captcha_numbers[rand(0, (count($captcha_numbers))-1)];
						}
					else
						{
						$code .= $captcha_special[rand(0, (count($captcha_special))-1)];
						}
					}
				$sql = "UPDATE `".$db['prefix']."captcha` SET `code` = '".$code."' LIMIT 1";
				}
			elseif ($captcha_method == 1)
				{
				$captcha_rnd_1 = rand(1, 10);
				$captcha_rnd_2 = rand(1, 20);
				$captcha_rnd_3 = rand(1, 30);

				$captcha_rnd_method = rand(1, 2);
				if ($captcha_rnd_method == 1)
					{
					$captcha_sum = $captcha_rnd_1 + $captcha_rnd_2;
					$captcha_math_symbol_1 = "+";
					}
				else
					{
					$captcha_sum = $captcha_rnd_1 - $captcha_rnd_2;
					$captcha_math_symbol_1 = "-";
					}
				$captcha_sum2 = $captcha_sum; // debug

				$captcha_rnd_method = rand(1, 2);
				if ($captcha_rnd_method == 1)
					{
					$captcha_sum = $captcha_sum + $captcha_rnd_3;
					$captcha_math_symbol_2 = "+";
					}
				else
					{
					$captcha_sum = $captcha_sum - $captcha_rnd_3;
					$captcha_math_symbol_2 = "-";
					}

				// generate formula for user
				$captcha_math = $captcha_rnd_1.$captcha_math_symbol_1.$captcha_rnd_2.$captcha_math_symbol_2.$captcha_rnd_3;

				$sql = "UPDATE `".$db['prefix']."captcha_math` SET `math` = '".$captcha_math."', `sum` = '".$captcha_sum."' LIMIT 1 ;";
				}

			if (isset ($captcha_method))
				{
				$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, generate_captcha) Error, line 815: ".mysql_error());
				@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, generate_captcha) Error, line 816: ".mysql_error());
				@mysql_query($sql, $link) or die ("(functions.inc.php, generate_captcha) Error, line 817: ".mysql_error());
				}
			}
		}

	// generate user_key
	if (!function_exists("generate_key_and_pw"))
		{
		function generate_key_and_pw($name, $length)
			{
			require "../includes/config.inc.php";

			$key_pw_letters = array("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
			$key_pw_letters_small = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
			$key_pw_numbers = array("1", "2", "3", "4", "5", "6", "7", "8", "9");
			$key_pw_special = array("!", "", "$", "%", "&", "=", "?", "+", "*", "~", "#", "-");

			for ($i = 0, $key_pw = NULL; strlen($key_pw) < $length; $i++)
				{
				// if you like to use special characters in your user_key
				// set the "3" in the following line to "4"
				$key_pw_random = rand(1, 3);
				if ($key_pw_random == 1)
					{
					$key_pw .= $key_pw_letters[rand(0, (count($key_pw_letters))-1)];
					}
				elseif ($key_pw_random == 2)
					{
					$key_pw .= $key_pw_letters_small[rand(0, (count($key_pw_letters_small))-1)];
					}
				elseif ($key_pw_random == 3)
					{
					$key_pw .= $key_pw_numbers[rand(0, (count($key_pw_numbers))-1)];
					}
				else
					{
					$key_pw .= $key_pw_special[rand(0, (count($key_pw_special))-1)];
					}
				}
			if($name != "")
				{
				// save user_key for user in database
				$sql = "UPDATE `".$db['prefix']."user` SET `user_key` = '".$key_pw."' WHERE `user_name` = ".$name." LIMIT 1";
				$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, generate_key_and_pw) Error, cannot connect to database: ".mysql_error());
				@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, generate_key_and_pw) Error, cannot select database: ".mysql_error());
				@mysql_query($sql, $link) or die ("(functions.inc.php, generate_key_and_pw) Error in sql query: ".mysql_error());
				}
			else
				{
				return $key_pw;
				}
			}
		}

	// check $_SESSION['key'}
	if (!function_exists("check_session"))
		{
		function check_session($sessid, $sessionkey, $timeout)
			{
			require "../includes/config.inc.php";

			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, check_session) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, check_session) Error, cannot select database: ".mysql_error());

			$sql = "SELECT user_key, logged_in FROM ".$db['prefix']."user WHERE ID=".$sessid." LIMIT 1";
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, check_session, select) Error in sql query: ".mysql_error());

			$user = @mysql_fetch_array($result);

			if($user['user_key'] == $sessionkey)
				{
				$ok = 1;
				}
			
			if(time() > ($user['logged_in'] + $timeout))
				{
				$ok = 0;
				}
			else
				{
				$sql = "UPDATE ".$db['prefix']."user SET `logged_in` = '".time()."' WHERE ID=".$sessid." LIMIT 1";
				@mysql_query($sql, $link) or die ("(functions.inc.php, check_session, update) Error in sql query: ".mysql_error());
				$ok = 1;
				}
			
			if($ok == 1) { return TRUE; } else { return FALSE; }
			}
		}

	// check rights for access of several adminsites
	if (!function_exists("check_rights"))
		{
		function check_rights($site, $sessid)
			{
			require "../includes/config.inc.php";
			
			$sql = "SELECT user_level, r_settings, r_activate, r_deactivate, r_delete, r_edit, r_spam, r_edit_smilies FROM ".$db['prefix']."user WHERE ID=".$sessid;
			$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(functions.inc.php, check_rights) Error, cannot connect to database: ".mysql_error());
			@mysql_select_db($db['dbname'], $link) or die ("(functions.inc.php, check_rights) Error, cannot select database: ".mysql_error());
			$result = @mysql_query($sql, $link) or die ("(functions.inc.php, check_rights) Error in sql query: ".mysql_error());

			$user = @mysql_fetch_array($result);
			
			switch ($user['user_level'])
				{
				case 0:
					return TRUE;
					break;
				case 1:
					if($site == "settings" AND $user['r_settings'] == 1)
						{
						return TRUE;
						}
					elseif($site == "activate" AND $user['r_activate'] == 1)
						{
						return TRUE;
						}
					elseif($site == "deactivate" AND $user['r_deactivate'] == 1)
						{
						return TRUE;
						}
					elseif($site == "delete" AND $user['r_delete'] == 1)
						{
						return TRUE;
						}
					elseif($site == "edit" AND $user['r_edit'] == 1)
						{
						return TRUE;
						}
					elseif($site == "spam" AND $user['r_spam'] == 1)
						{
						return TRUE;
						}
					elseif($site == "smilies" AND $user['r_edit_smilies'] == 1)
						{
						return TRUE;
						}
					elseif($site == "version")
						{
						return TRUE;
						}
					elseif($site == "editusers")
						{
						return FALSE;
						}
					else
						{
						return FALSE;
						}
					break;
				}
			}
		}

	// clean string
	if (!function_exists("cleanstr"))
		{
		function cleanstr($string)
			{
			$string = htmlspecialchars(stripslashes(strip_tags(trim($string))), ENT_QUOTES);
			return $string;
			}
		}

	// get version info with cURL
	if (!function_exists("get_mgb_version_info"))
		{
		function get_mgb_version_info($url)
			{
			if(function_exists("curl_init"))
				{
				$ch = curl_init($url);
				curl_setopt ($ch, CURLOPT_URL, $url);
				curl_setopt ($ch, CURLOPT_HEADER, 0);
				curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
				$result = curl_exec ($ch);
				curl_close ($ch);
				return $result;
				}
			}
		}

	// replace template placeholders
	if (!function_exists("template"))
		{
		function template($placeholder, $data, $content)
			{
			$content = preg_replace("/\{".$placeholder."\}/", $data, $content);
			return $content;
			}
		}
?>
