<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySQL Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ========= //
	// index.php //
	// ========= //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// show all errors
	error_reporting(E_ALL & ~E_NOTICE);

	// check if MGB has been already installed or updated
	if (file_exists("includes/config.inc.php"))
		{
		require ("includes/config.inc.php");
		if (!isset($mgb_installation_complete))
			{
			echo "<span style='font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; color: darkblue;'>It seems as if you haven't installed the MGB yet. You can do it
					<a href=\"install/install.php\">here</a>.<br><br> If MGB is already installed, try to copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.</span>";
			die();
			}
		elseif (isset($mgb_installation_complete) AND $mgb_installation_complete == TRUE AND file_exists('install'))
			{
			echo "<center><span style='font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; color: darkblue;'>If you upgraded to a newer version shortly, please run
			<a href='install/upgrade.php'>upgrade.php</a> in install directory <b>now!</b> Otherwise you might discover problems when using this software.<br>If you did a fresh install, you can ignore this message. To remove it, delete install directory. Thank you!<br><br></span></center>";
			}
		}
	else
		{
		echo "<span style='font-family: verdana, arial, helvetica, sans-serif; font-size: 12px; color: darkblue;'>The config file could not be found. If you haven't installed MGB yet,
				you can do it <a href=\"install/install.php\">here</a>.<br><br>Maybe you've forgotten to run <a href=\"install/upgrade.php\">upgrade.php</a>?<br><br>
				If MGB is already installed and you ran upgrade.php try to copy your 'config.inc.php' from root directory into 'includes/config.inc.php' manually.</span>";
		die();
		}

	$site_name = "index.php";

	// load config, templates, settings and language files
	include_once ("includes/functions.inc.php");
	require ("includes/load_settings.inc.php");
	include_once ("language/".$settings['language_path']."/lang_main.php");
	include_once ("language/".$settings['language_path']."/settings.php");
	include_once ("includes/load_templates.inc.php");

	// set number of site to "1" if it is "0"
	if(!isset($_GET['p'])) { $_GET['p'] = 1; }

	// connect to database
	$link = @mysql_connect($db['hostname'], $db['username'], $db['password']) or die ("(index.php) Error, line 67: ".mysql_error());
	@mysql_select_db($db['dbname'], $link) or die ("(index.php) Error, line 68: ".mysql_error());

	// get total number of entries
	$link_count = "SELECT COUNT(ID) FROM ".$db['prefix']."entries WHERE CHECKED=1";
	$results = @mysql_query($link_count) or die ("(index.php) Error, line 72: ".mysql_error()."<br><br>Did you upgrade to a newer version shortly? Try to run <a href='install/upgrade.php'>upgrade.php</a> in install directory if this problem exists permanently.");
	$total = @mysql_result($results, 0);

	// compute how many pages there are
	$p = ($total / $settings['entries_per_page']);

	if ($p <= 1)
		{
		$p = 0;
		if ($total > 1)
			{
			$how_many_entries = $total."&nbsp;".$lang['entries'];
			}
		elseif ($total == 0)
			{
			$how_many_entries = $lang['no_entries'];
			}
		else
			{
			$how_many_entries = $total."&nbsp;".$lang['entry'];
			}
		}
	else
		{
		$p = ceil($p);
		$how_many_entries = $total."&nbsp;".$lang['entries_on_pages'];
		}

	$load_start = ($_GET['p'] * $settings['entries_per_page']) - $settings['entries_per_page'];
	$load_end = $settings['entries_per_page'];

	$pages_total = ceil($p);

	if ($_GET['p'] == 1)
		{
		$sf_forwards = "<a href=\"index.php?p=".($_GET['p'] + 1)."\" title=\"".$lang['page_forwards']."\">".$lang['page_forwards_symbol']."</a>";
		$sf_pagenumber = $_GET['p'];
		if ($pages_total >= 3 )
			{
			$sf_last = "<a href=\"index.php?p=".$pages_total."\" title=\"".$lang['page_last']."\">".$lang['page_last_symbol']."</a>";
			}
		}

	if ($_GET['p'] > 1)
		{
		if (($pages_total >= 3) AND ($_GET['p'] > 2))
			{
			$sf_first = "<a href=\"index.php?p=1\" title=\"".$lang['page_first']."\">".$lang['page_first_symbol']."</a>";
			}
		$sf_backwards = "<a href=\"index.php?p=".($_GET['p'] - 1)."\" title=\"".$lang['page_backwards']."\">".$lang['page_backwards_symbol']."</a>";
		$sf_pagenumber = $_GET['p'];
		$sf_forwards = "<a href=\"index.php?p=".($_GET['p'] + 1)."\" title=\"".$lang['page_forwards']."\">".$lang['page_forwards_symbol']."</a>";
		if (($pages_total >= 3) AND ($_GET['p'] < ($pages_total - 1)))
			{
			 $sf_last = "&nbsp;<a href=\"index.php?p=".$pages_total."\" title=\"".$lang['page_last']."\">".$lang['page_last_symbol']."</a>";
			}
		}

	if ($_GET['p'] == $pages_total)
		{
		if ($pages_total >= 3)
			{
			$sf_first = "<a href=\"index.php?p=1\" title=\"".$lang['page_first']."\">".$lang['page_first_symbol']."</a>";
			}
		$sf_backwards = "<a href=\"index.php?p=".($_GET['p'] - 1)."\" title=\"".$lang['page_backwards']."\">".$lang['page_backwards_symbol']."</a>";
		$sf_pagenumber = $_GET['p'];
		$sf_forwards = "";
		}

	if ($pages_total <= 0)
		{
		$content_scrolling_function = "<br>";
		}

	// load guestbook entries
	$sql = "SELECT ID, name, city, email, icq, aim, msn, hp, message, comment, timestamp, user_show_email FROM ".$db['prefix']."entries WHERE checked=1 ORDER BY ".$settings['entries_order']." ".$settings['entries_order_asc_desc']." LIMIT $load_start, $load_end";
	$result = @mysql_query($sql, $link) or die ("(index.php) Error, line 148: ".mysql_error());

	for($i = 0; $i < @mysql_num_rows($result); $i++)
		{
		$entry[$i] = @mysql_fetch_array($result);
		}

	// fill header template with content
	$refresh = "";
	$page_header = $content_header;

	// check if "install" directory has been deleted
	if (file_exists("install"))
		{
		$page_header = template("INSTALL_DIRECTORY_EXISTS", "<div style=\"background-color: white; padding: 3px; border: 2px solid black; width: 500px;\"><span style=\"color: red; font-size: 12px; font-weight: bold;\">".$lang['install_directory_exists']."</span></div>", $page_header);
		}
	else
		{
		$page_header = template("INSTALL_DIRECTORY_EXISTS", "", $page_header);
		}

	$page_header = template("H_LANGUAGE_SHORT", $language_short, $page_header);
	$page_header = template("H_DOMAIN", $settings['h_domain'], $page_header);
	$page_header = template("H_AUTHOR", $settings['h_author'], $page_header);
	$page_header = template("H_KEYWORDS", $settings['h_keywords'], $page_header);
	$page_header = template("H_DESCRIPTION", $settings['h_description'], $page_header);
	$page_header = template("H_CHARSET", $charset, $page_header);
	$page_header = template("REFRESH", $refresh, $page_header);

	// fill entry template with content
	if($settings['entries_numbering'] == 0)
		{
		$entry_counter = ($settings['entries_per_page'] * $_GET['p']) - $settings['entries_per_page'];
		}
	else
		{
		$entry_counter = ($total - ($settings['entries_per_page'] * $_GET['p']) + ($settings['entries_per_page'] + 1));
		}

	if($total > 0)
		{
		for($i = 0; $i < count($entry); $i++)
			{
			$page_entry[$i] = $content_index_entry;
			if($settings['entries_numbering'] == 0)
				{
				$entry_counter++;
				}
			else
				{
				$entry_counter--;
				}

			// wordwrap: if message contains words longer than $settings['wordwrap'] they will
			// be broken into two or more strings. If $settings['wordwrap'] == 0, function is off
			// this method taken from http://de.php.net/manual/en/function.wordwrap.php#64517
			// by ab_at_notenet(dot)dk (thanks for that!!) will luckily not break html tags

			/* if ($charset == "utf-8")
				{
				$entry[$i]['message'] = utf8_encode($entry[$i]['message']);
				}
			else
				{
				$entry[$i]['message'] = utf8_decode($entry[$i]['message']);
				} */

			if (!$settings['wordwrap'] == 0)
				{
				$entry[$i]['message'] = textWrap($entry[$i]['message'], $settings['wordwrap']);
				}

			// set smilies
			if ($settings['smileys'] == 1)
				{
				$entry[$i]['message'] = set_smilies($entry[$i]['message']);
				$entry[$i]['comment'] = set_smilies($entry[$i]['comment']);
				}
			else
				{
				$entry[$i]['message'] = delete_smilies($entry[$i]['message']);
				$entry[$i]['comment'] = delete_smilies($entry[$i]['comment']);
				}

			// set bbcode
			if($settings['bbcode'] == 1)
				{
				$entry[$i]['message'] = bbcode_format($entry[$i]['message'], "");
				$entry[$i]['comment'] = bbcode_format($entry[$i]['comment'], "");
				}
			else
				{
				$entry[$i]['message'] = bbcode_delete($entry[$i]['message']);
				$entry[$i]['comment'] = bbcode_delete($entry[$i]['comment']);
				}

			// find out which optional data has been set by the user
			$email = $content_index_entry_email;
			$message = $content_index_entry_message;
			$city = $content_index_entry_city;
			$hp = $content_index_entry_hp;
			$gravatar = $content_index_entry_gravatar;
			$icq = $content_index_entry_icq;
			$aim = $content_index_entry_aim;
			$msn = $content_index_entry_msn;
			$comment = $content_index_entry_comment;

			if ($entry[$i]['city'] == "") { $city = ""; }
			if ($entry[$i]['hp'] == "") { $hp = ""; }
			if ($entry[$i]['icq'] == "") { $icq = ""; }
			if ($entry[$i]['aim'] == "") { $aim = ""; }
			if ($entry[$i]['msn'] == "") { $msn = ""; }
			if ($entry[$i]['comment'] == "") { $comment = ""; }

			// find out if the user wants his email to be shown
			if ($entry[$i]['user_show_email'] != 0)
				{
				if ($settings['spam_protection'] == 1)
					{
					$entry_email_path = "email.php?id=".$entry[$i]['ID'];
					$entry_email_pic = "images/iconsets/".$settings['iconset_path']."/email.png";
					$entry_email_text = $lang['email_yes'];
					}
				else
					{
					$entry_email_path = "mailto:".$entry[$i]['email'];
					$entry_email_pic = "images/iconsets/".$settings['iconset_path']."/email.png";
					$entry_email_text = $lang['email_yes'];
					}
				}
			else
				{
				$entry_email_path = "email.php?id=denied";
				$entry_email_pic = "images/iconsets/".$settings['iconset_path']."/email_error.png";
				$entry_email_text = $lang['email_no'];
				}

			if (!$settings['badwords'] == NULL)
				{
				// replace badwords
				$badwords = explode(',', $settings['badwords']);
				foreach($badwords as $key => $val)
				$badwords[$key] = trim($val);

				$entry[$i]['name'] = badwords($entry[$i]['name']);
				$entry[$i]['city'] = badwords($entry[$i]['city']);
				$entry[$i]['message'] = badwords($entry[$i]['message']);
				}

			// convert timestamp in mgb format
			$timestamp = $entry[$i]['timestamp'];

			$date = date($settings['dateform'], $timestamp);
			$time = date("G:i", $timestamp);

			$timestamp = $date."&nbsp;".$lang['at']."&nbsp;".$time."&nbsp;".$lang['oclock'];

		if (isset($settings['gravatar_show']) AND ($settings['gravatar_show'] == 1))
				{
				// load gravatar
				if($settings['gravatar_rating'] == 0) { $gravatar_rating = "G"; }
				if($settings['gravatar_rating'] == 1) { $gravatar_rating = "PG"; }
				if($settings['gravatar_rating'] == 2) { $gravatar_rating = "R"; }
				if($settings['gravatar_rating'] == 3) { $gravatar_rating = "X"; }
				if($settings['gravatar_type'] == 0) { $gravatar_type = "&amp;f=y"; }
				if($settings['gravatar_type'] == 1) { $gravatar_type = "&amp;d=mm"; }
				if($settings['gravatar_type'] == 2) { $gravatar_type = "&amp;d=identicon"; }
				if($settings['gravatar_type'] == 3) { $gravatar_type = "&amp;d=monsterid"; }
				if($settings['gravatar_type'] == 4) { $gravatar_type = "&amp;d=wavatar"; }
				if($settings['gravatar_type'] == 5) { $gravatar_type = "&amp;d=retro"; }

				$gravatar_url = "http://www.gravatar.com/avatar/".md5(strtolower(trim($entry[$i]['email'])))."?s=".$settings['gravatar_size']."&amp;r=".$gravatar_rating.$gravatar_type;
				$img_gravatar = "<img src=\"".$gravatar_url."\" class=\"gravatar\" style=\"width: ".$settings['gravatar_size']."px; height: ".$settings['gravatar_size']."px;\" alt=\"".$lang['gravatar']."\" title=\"".$lang['gravatar']."\">";
				}
			 else
				{
				$gravatar_size = 0;
				$img_gravatar = NULL;
				}

			// fill template with other templates if set
			$page_entry[$i] = template("TEMPLATE_ENTRY_CITY", $city, $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_ENTRY_MESSAGE", $message, $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_ENTRY_EMAIL", $email, $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_ENTRY_HP", $hp, $page_entry[$i]);
			if ($settings['gravatar_position'] == 0) {
			$page_entry[$i] = template("ENTRY_GRAVATAR_LEFT", $gravatar, $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_GRAVATAR_RIGHT", "", $page_entry[$i]);
			$page_entry[$i] = template("GRAVATAR_CSS", "entry_message_gravatar_left", $page_entry[$i]); }
			else {
			$page_entry[$i] = template("ENTRY_GRAVATAR_LEFT", "", $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_GRAVATAR_RIGHT", $gravatar, $page_entry[$i]);
			$page_entry[$i] = template("GRAVATAR_CSS", "entry_message_gravatar_right", $page_entry[$i]); }
			$page_entry[$i] = template("TEMPLATE_ENTRY_ICQ", $icq, $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_ENTRY_AIM", $aim, $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_ENTRY_MSN", $msn, $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_ENTRY_COMMENT", $comment, $page_entry[$i]);

			// fill template with entry (language)
			$page_entry[$i] = template("LANG_FROM", $lang['from'], $page_entry[$i]);
			$page_entry[$i] = template("LANG_EMAIL_OF", $entry_email_text, $page_entry[$i]);
			$page_entry[$i] = template("LANG_HP_OF", $lang['hp_of'], $page_entry[$i]);
			$page_entry[$i] = template("LANG_COMMENT", $lang['comment'], $page_entry[$i]);

			// fill template with entry (strings)
			$page_entry[$i] = template("ENTRY_ID", $entry_counter, $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_ANCHOR", "<a href=\"index.php?p=".$_GET['p']."#e".$entry_counter."\" title=\"".$lang['anchor']."\">&raquo;</a>", $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_CITY", $entry[$i]['city'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_EMAIL_PIC", $entry_email_pic, $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_EMAIL_PATH", $entry_email_path, $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_TIMESTAMP", $timestamp, $page_entry[$i]);
			$page_entry[$i] = template("GRAVATAR_SIZE", $settings['gravatar_size'], $page_entry[$i]);
			$page_entry[$i] = template("IMG_GRAVATAR", $img_gravatar, $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_MESSAGE", $entry[$i]['message'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_HP", $entry[$i]['hp'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_ICQ_NUMBER", $entry[$i]['icq'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_AIM_NAME", $entry[$i]['aim'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_MSN", $entry[$i]['msn'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_COMMENT", $entry[$i]['comment'], $page_entry[$i]);
			$page_entry[$i] = template("ENTRY_NAME", $entry[$i]['name'], $page_entry[$i]);
			$page_entry[$i] = template("TEMPLATE_PATH", "templates/".$settings['template_path'], $page_entry[$i]);

			if(!isset($page_entry_echo)) { $page_entry_echo = NULL; }
			$page_entry_echo .= $page_entry[$i];
			}
		}

	if(!isset($page_entry_echo)) { $page_entry_echo = NULL; }

	// fill index_body.tpl and load templates first
	$page_body_index = $content_index_body;	
	$page_body_index = template("HEADER", $page_header, $page_body_index);
	$page_body_index = template("TEMPLATE_SCROLLING_FUNCTION", $content_scrolling_function, $page_body_index);
	$page_body_index = template("TEMPLATE_ENTRIES", $page_entry_echo, $page_body_index);
	$page_body_index = template("TEMPLATE_PATH", "templates/".$settings['template_path'], $page_body_index);
	$page_body_index = template("TEMPLATE_STYLE_PATH", $settings['template_style_path'], $page_body_index);
	$page_body_index = template("TEMPLATE_COPYRIGHT", $content_copyright, $page_body_index);
	$page_body_index = template("TEMPLATE_FOOTER", $content_footer, $page_body_index);

	// then strings
	$page_body_index = template("TITLE", $settings['title'], $page_body_index);
	$page_body_index = template("LANG_NEW_ENTRY_DESCR", $lang['new_entry_descr'], $page_body_index);
	$page_body_index = template("LANG_NEW_ENTRY", $lang['new_entry'], $page_body_index);
	$page_body_index = template("LANG_CONTACT_DESCR", $lang['contact_descr'], $page_body_index);
	$page_body_index = template("LANG_CONTACT", $lang['contact'], $page_body_index);
	$page_body_index = template("LANG_ADMINPANEL_DESCR", $lang['adminpanel_descr'], $page_body_index);
	$page_body_index = template("LANG_ADMINPANEL", $lang['adminpanel'], $page_body_index);
	$page_body_index = template("LANG_HOW_MANY_ENTRIES", $how_many_entries, $page_body_index);
	$page_body_index = template("PAGES", $p, $page_body_index);
	$page_body_index = template("SF_FIRST", $sf_first, $page_body_index);
	$page_body_index = template("SF_BACKWARDS", $sf_backwards, $page_body_index);
	$page_body_index = template("SF_PAGENUMBER", $sf_pagenumber, $page_body_index);
	$page_body_index = template("SF_FORWARDS", $sf_forwards, $page_body_index);
	$page_body_index = template("SF_LAST", $sf_last, $page_body_index);
	$page_body_index = template("LANG_QUOTE", $lang['quote'], $page_body_index);
	$page_body_index = template("MGB_VERSION", $settings['version'], $page_body_index);
	$page_body_index = template("COPYRIGHT_DATE", date("Y"), $page_body_index);
	$page_body_index = template("ICONSET_PATH", $settings['iconset_path'], $page_body_index);

	// close sql connection
	@mysql_close($link);

	// generate page
	echo $page_body_index;
?>