<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2011 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// =============== //
	// admin.php - 2.0 //
	// =============== //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// Show all errors but no warnings
	error_reporting(E_ALL & ~E_NOTICE);

	define('ADMINISTRATION', TRUE);

	// check if MGB has been already installed
	if (file_exists('../includes/config.inc.php'))
		{
		require ('../includes/config.inc.php');
		if(!isset($mgb_installation_complete))
			{
			echo "It seems as if you haven't installed the MGB yet. You can do that <a href='../install/install.php'>here</a>.<br><br>If MGB is already installed, try copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.";
			die();
			}
		}
	else
		{
		echo "The config file could not be found. If you haven't installed the MGB yet, you can do that <a href='../install/install.php'>here</a>.<br><br>If MGB is already installed, try copy your 'config.inc.php' from root directory into 'includes/config.inc.php'.";
		die();
		}

	// start session
	session_name("sid");
	ini_set('url_rewriter.tags', '');
	session_start();
	session_regenerate_id();

	if(SID != NULL) { $sid = "&amp;".SID; } else {$sid = NULL; }

	require ("../includes/functions.inc.php");
	require ("../includes/config.inc.php");
	require ("../includes/load_settings.inc.php");
	require ("../language/".$settings['language_path']."/lang_admin.php");
	require ("../language/".$settings['language_path']."/settings.php");
	require ("load_template_admin.inc.php");

	if(isset($_SESSION['key']))
		{
		if(!check_session($_SESSION['ID'], $_SESSION['key'], $settings['session_timeout']))
			{
			session_destroy();
			//unset($_SESSION['ID']);
			$errorcode = 9;
			}
		}
	else
		{
		$include = "login.inc.php";
		}

	// login status
	if(!isset($_SESSION['ID']) OR isset($_GET['action']) AND $_GET['action'] == "logout")
		{
		$include = "login.inc.php";
		}
	else
		{
		// get info about new version
		$latest_version = get_mgb_version_info("http://www.m-gb.org/latest.txt");

		switch(version_compare($settings['version'], $latest_version)) {
		case -1: $new_version_available = $lang['new_version_available'];
			break;
		case 0: $new_version_available = "&nbsp;";
			break;
		case 1: $new_version_available = "&nbsp;";
			break;
		}

		$login_status_text = $lang['logged_in']."&nbsp;|&nbsp;<a class='admin' href='admin.php?action=logout' title='{LANG_LOGOUT}'>{LANG_LOGOUT}</a>&nbsp;";
		$login_status_img = "<img src='templates/default/images/logout.png' height='16' width='16' title='{LANG_LOGOUT}' alt='{LANG_LOGOUT}'>";
		$page_navigation = $content_navigation;
		$page_navigation = preg_replace("/\{LINK_SETTINGS\}/", "admin.php?action=settings".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_ACTIVATE\}/", "admin.php?action=activate".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_DEACTIVATE\}/", "admin.php?action=deactivate".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_DELETE\}/", "admin.php?action=delete".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_EDIT\}/", "admin.php?action=edit".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_SPAM\}/", "admin.php?action=spam".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_EDIT_USERS\}/", "admin.php?action=editusers".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_LICENSE\}/", "admin.php?action=license".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_FORUM\}/", "http://forum.m-gb.org/", $page_navigation);
		$page_navigation = preg_replace("/\{LINK_BUGREPORT\}/", "http://bugreport.m-gb.org/", $page_navigation);
		$page_navigation = preg_replace("/\{LINK_VERSION\}/", "admin.php?action=version".$sid, $page_navigation);
		$page_navigation = preg_replace("/\{LINK_MANUAL\}/", "http://www.m-gb.org/wiki/", $page_navigation);
		
		$page_navigation = preg_replace("/\{LANG_SETTINGS\}/", $lang['settings'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_ACTIVATE\}/", $lang['activate'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_DEACTIVATE\}/", $lang['deactivate'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_DELETE\}/", $lang['delete'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_EDIT\}/", $lang['edit'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_SPAM\}/", $lang['spam'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_EDIT_USERS\}/", $lang['users'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_LICENSE\}/", $lang['license'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_FORUM\}/", $lang['forum'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_BUGREPORT\}/", $lang['bugreport'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_VERSION\}/", $lang['version'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_MANUAL\}/", $lang['manual'], $page_navigation);
		$page_navigation = preg_replace("/\{LANG_PAYPAL\}/", $lang['paypal'], $page_navigation);

		$page_navigation = preg_replace("/\{TEMPLATE_PATH\}/", "../templates/".$settings['template_path'], $page_navigation);

		if(isset($_GET['action']) AND ($_GET['action'] == "activate"))
			{
			$include = "activate.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "deactivate"))
			{
			$include = "deactivate.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "delete"))
			{
			$include = "delete.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "edit"))
			{
			$include = "edit.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "spam"))
			{
			$include = "spam.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "editusers"))
			{
			$include = "edit_user.inc.php";
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "license"))
			{
			$page_include = file_get_contents("license.html");
			}
		elseif(isset($_GET['action']) AND ($_GET['action'] == "version"))
			{
			$include = "version.inc.php";
			}
		else
			{
			$include = "settings.inc.php";
			}
		}

	if (!isset($_GET['action']) OR $_GET['action'] != "license")
		{
		require $include;
		}
	elseif($_GET['action'] == "license")
		{
		$login_status_text = $lang['logged_in']."&nbsp;|&nbsp;<a class='admin' href='admin.php?action=logout' title='{LANG_LOGOUT}'>{LANG_LOGOUT}</a>&nbsp;";
		$login_status_img = "<img src='templates/default/images/logout.png' height='16' width='16' title='{LANG_LOGOUT}' alt='{LANG_LOGOUT}'>";

		// get info about new version
		$latest_version = get_mgb_version_info("http://www.m-gb.org/latest.txt");

		switch(version_compare($settings['version'], $latest_version)) {
		case -1: $new_version_available = $lang['new_version_available'];
			break;
		case 0: $new_version_available = "&nbsp;";
			break;
		case 1: $new_version_available = "&nbsp;";
			break;
		}

		if(isset($include) AND ($include == "login.inc.php"))
			{
			require $include;
			}
		else
			{
			$page_include = file_get_contents("license.html");
			$content_scrolling_function = "<br>";
			}
		}
	else
		{
		$content_scrolling_function = "<br>";
		}

	// fill header template with content
	$page_header = $content_header;
	$page_header = preg_replace("/\{H_LANGUAGE_SHORT\}/", $language_short, $page_header);
	$page_header = preg_replace("/\{H_DOMAIN\}/", $settings['h_domain'], $page_header);
	$page_header = preg_replace("/\{H_AUTHOR\}/", $settings['h_author'], $page_header);
	$page_header = preg_replace("/\{H_KEYWORDS\}/", $settings['h_keywords'], $page_header);
	$page_header = preg_replace("/\{H_DESCRIPTION\}/", $settings['h_description'], $page_header);
	$page_header = preg_replace("/\{H_CHARSET\}/", $charset, $page_header);
	if(!isset($refresh)) { $refresh = NULL; }
	$page_header = preg_replace("/\{REFRESH\}/", $refresh, $page_header);

	// fill admin_body template with content
	$page_admin = $content_admin;
	$page_admin = preg_replace("/\{TEMPLATE_HEADER\}/", $page_header, $page_admin);
	$page_admin = preg_replace("/\{TITLE\}/", $lang['title'], $page_admin);
	$page_admin = preg_replace("/\{LOGIN_STATUS_TEXT\}/", $login_status_text, $page_admin);
	$page_admin = preg_replace("/\{LOGIN_STATUS_IMG\}/", $login_status_img, $page_admin);

	if(!isset($_SESSION['username'])) { $_SESSION['username'] = NULL; }

	$page_admin = preg_replace("/\{SESSION_USERNAME\}/", $_SESSION['username'], $page_admin);
	$page_admin = preg_replace("/\{LANG_LOGOUT\}/", $lang['logout'], $page_admin);

	if(!isset($page_navigation)) { $page_navigation = NULL; }

	$page_admin = preg_replace("/\{TEMPLATE_NAVIGATION\}/", $page_navigation, $page_admin);

	if(!isset($how_many_entries)) { $how_many_entries = NULL; }

	$page_admin = preg_replace("/\{LANG_HOW_MANY_ENTRIES\}/", $how_many_entries, $page_admin);

	if(!isset($p)) { $p = NULL; }

	$page_admin = preg_replace("/\{PAGES\}/", $p, $page_admin);
	$page_admin = preg_replace("/\{TEMPLATE_SCROLLING_FUNCTION\}/", $content_scrolling_function, $page_admin);

	if(!isset($page_include)) { $page_include = NULL; }
	
	if ($saved_settings_successfull == 1)
		{
		if (($_GET['action'] == "settings") OR ($_GET['action'] == "editusers") OR ($_GET['action'] == "edit"))
			{
			$page_admin = preg_replace("/\{TEMPLATE_MESSAGE\}/", "<span class='newer_version'>".$lang['edit_save_message']."</span><br><br>", $page_admin);
			}
		}

	if ($sendemail_successfull == 1)
		{
		$page_admin = preg_replace("/\{TEMPLATE_MESSAGE\}/", "", $page_admin);
		}
	else
		{
		if (isset($_GET['action']) AND ($_GET['action'] == "activate") AND (isset($_GET['id'])  AND !isset($_GET['isspam'])))
			{
			$page_admin = preg_replace("/\{TEMPLATE_MESSAGE\}/", "<span class='old_version'>".$lang['errormessage14']."</span><br><br>", $page_admin);
			}
		elseif (isset($_GET['action']) AND ($_GET['action'] == "edit") AND (isset($_GET['id']) AND (isset($_POST['sent_edit']) AND ($_POST['sent_edit'] == 1)) AND !isset($_GET['isspam'])))
			{
			$page_admin = preg_replace("/\{TEMPLATE_MESSAGE\}/", "<span class='old_version'>".$lang['errormessage14']."</span><br><br>", $page_admin);
			}
		elseif (isset($_GET['action']) AND ($_GET['action'] == "editusers" AND (isset($_POST['sent_edit']) AND ($_POST['sent_edit'] == 1)) AND !isset($_GET['isspam'])))
			{
			$page_admin = preg_replace("/\{TEMPLATE_MESSAGE\}/", "<span class='old_version'>".$lang['errormessage14']."</span><br><br>", $page_admin);
			}
		else
			{
			$page_admin = preg_replace("/\{TEMPLATE_MESSAGE\}/", "", $page_admin);
			}
		}

	if($_GET['action'] == 'spam')
		{
		$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_NORMAL\}/", '', $page_admin);
		if($total >= 2)
			{
			$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_SPAM\}/", $content_dropbox_spam, $page_admin);
			}
		else
			{
			$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_SPAM\}/", '', $page_admin);
			}
		}
	else
		{
		if($total >= 1)
			{
			if($_GET['action'] == 'activate')
				{
				$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_NORMAL\}/", $content_dropbox_normal, $page_admin);
				$page_admin = preg_replace("/\{OPTION_ACTIVATE_ALL_ENTRIES\}/", "<option value='1'>{LANG_ACTIVATE_ALL_ENTRIES}</option>", $page_admin);
				$page_admin = preg_replace("/\{OPTION_MARK_ALL_AS_SPAM\}/", "<option value='2'>{LANG_MARK_ALL_AS_SPAM}</option>", $page_admin);
				$page_admin = preg_replace("/\{OPTION_DEACTIVATE_ALL_ENTRIES\}/", '', $page_admin);
				$page_admin = preg_replace("/\{OPTION_DELETE_ALL_ENTRIES\}/", '', $page_admin);
				$page_admin = preg_replace("/\{LANG_ACTIVATE_ALL_ENTRIES\}/", $lang['activate_all_entries'], $page_admin);
				$page_admin = preg_replace("/\{LANG_MARK_ALL_AS_SPAM\}/", $lang['mark_all_as_spam'], $page_admin);
				}
			elseif($_GET['action'] == 'deactivate')
				{
				$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_NORMAL\}/", $content_dropbox_normal, $page_admin);
				$page_admin = preg_replace("/\{OPTION_ACTIVATE_ALL_ENTRIES\}/", '', $page_admin);
				$page_admin = preg_replace("/\{OPTION_MARK_ALL_AS_SPAM\}/", '', $page_admin);
				$page_admin = preg_replace("/\{OPTION_DEACTIVATE_ALL_ENTRIES\}/", "<option value='1'>{LANG_DEACTIVATE_ALL_ENTRIES}</option>", $page_admin);
				$page_admin = preg_replace("/\{OPTION_DELETE_ALL_ENTRIES\}/", '', $page_admin);
				$page_admin = preg_replace("/\{LANG_DEACTIVATE_ALL_ENTRIES\}/", $lang['deactivate_all_entries'], $page_admin);
				}
			elseif($_GET['action'] == 'delete')
				{
				$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_NORMAL\}/", $content_dropbox_normal, $page_admin);
				$page_admin = preg_replace("/\{OPTION_ACTIVATE_ALL_ENTRIES\}/", '', $page_admin);
				$page_admin = preg_replace("/\{OPTION_MARK_ALL_AS_SPAM\}/", '', $page_admin);
				$page_admin = preg_replace("/\{OPTION_DEACTIVATE_ALL_ENTRIES\}/", '', $page_admin);
				$page_admin = preg_replace("/\{OPTION_DELETE_ALL_ENTRIES\}/", "<option value='1'>{LANG_DELETE_ALL_ENTRIES}</option>", $page_admin);
				$page_admin = preg_replace("/\{LANG_DELETE_ALL_ENTRIES\}/", $lang['delete_all_entries'], $page_admin);
				}
			elseif($_GET['action'] == 'edit')
				{
				$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_NORMAL\}/", '', $page_admin);
				}
			}
		else
			{
			$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_NORMAL\}/", '', $page_admin);
			}
		$page_admin = preg_replace("/\{TEMPLATE_DROPBOX_SPAM\}/", '', $page_admin);
		}

	$page_admin = preg_replace("/\{LANG_DO_NOTHING\}/", $lang['do_nothing'], $page_admin);
	$page_admin = preg_replace("/\{LANG_DELETE_WHOLE_SPAM\}/", $lang['delete_whole_spam'], $page_admin);
	$page_admin = preg_replace("/\{LANG_MARK_ALL_NO_SPAM_DEACTIVATE\}/", $lang['mark_all_no_spam_deactivate'], $page_admin);
	$page_admin = preg_replace("/\{LANG_MARK_ALL_NO_SPAM_ACTIVATE\}/", $lang['mark_all_no_spam_activate'], $page_admin);
	$page_admin = preg_replace("/\{LANG_GO\}/", $lang['go'], $page_admin);
	$page_admin = preg_replace("/\{ACTION\}/", $_GET['action'], $page_admin);
	$page_admin = preg_replace("/\{PAGE_NR\}/", $add_page_nr, $page_admin);
	$page_admin = preg_replace("/\{SID\}/", $sid, $page_admin);
	$page_admin = preg_replace("/\{INCLUDE\}/", $page_include, $page_admin);
	$page_admin = preg_replace("/\{LANG_NEW_VERSION_AVAILABLE\}/", $new_version_available, $page_admin);
	$page_admin = preg_replace("/\{LATEST_VERSION\}/", $latest_version, $page_admin);
	$page_admin = preg_replace("/\{LANG_LOGIN\}/", $lang['login'], $page_admin);
	$page_admin = preg_replace("/\{TEMPLATE_COPYRIGHT\}/", $content_copyright, $page_admin);
	$page_admin = preg_replace("/\{TEMPLATE_FOOTER\}/", $content_footer, $page_admin);
	$page_admin = preg_replace("/\{COPYRIGHT_DATE\}/", date("Y"), $page_admin);
	$page_admin = preg_replace("/\{MGB_VERSION\}/", $settings['version'], $page_admin);
	$page_admin = preg_replace("/\{TEMPLATE_SCROLLING_FUNCTION\}/", $content_scrolling_function, $page_admin);
	$page_admin = preg_replace("/\{SF_FIRST\}/", $sf_first, $page_admin);
	$page_admin = preg_replace("/\{SF_BACKWARDS\}/", $sf_backwards, $page_admin);
	$page_admin = preg_replace("/\{SF_PAGENUMBER\}/", $sf_pagenumber, $page_admin);
	$page_admin = preg_replace("/\{SF_FORWARDS\}/", $sf_forwards, $page_admin);
	$page_admin = preg_replace("/\{SF_LAST\}/", $sf_last, $page_admin);

	echo $page_admin;
?>
