/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.PropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public abstract class AbstractProperty
extends PropertySupport.ReadWrite {
    protected final Object object;

    public AbstractProperty(Class clazz, Object object) {
        super(null, clazz, null, null);
        this.object = object;
    }

    public Object getValue() {
        Object value = this.getPropertyValue();
        return value == null ? "" : value;
    }

    public void setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object oldValue = this.getOwnPropertyValue();
        this.validate(newValue);
        this.setPropertyValue(newValue);
        PropertyUndoableEdit undo = new PropertyUndoableEdit(this, oldValue, newValue);
        IReportManager.getInstance().addUndoableEdit(undo);
    }

    public boolean isDefaultValue() {
        Object value = this.getPropertyValue();
        return this.getDefaultValue() == null && value == null || this.getDefaultValue() != null && this.getDefaultValue().equals(value);
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(this.getDefaultValue());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public abstract Object getPropertyValue();

    public abstract Object getOwnPropertyValue();

    public abstract Object getDefaultValue();

    public abstract void validate(Object var1);

    public abstract void setPropertyValue(Object var1);
}

