/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.io.IOException;
import java.text.NumberFormat;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.cookies.LineCookie;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class SQLExecutionLoggerImpl
implements SQLExecutionLogger {
    private final LineCookie lineCookie;
    private final InputOutput inputOutput;
    private boolean inputOutputSelected = false;
    private int errorCount;

    public SQLExecutionLoggerImpl(String string, LineCookie lineCookie) {
        this.lineCookie = lineCookie;
        String string2 = NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_SQLFileExecution", (Object)string);
        this.inputOutput = IOProvider.getDefault().getIO(string2, true);
    }

    public void log(SQLExecutionResult sQLExecutionResult) {
        if (sQLExecutionResult.getException() != null) {
            this.logException(sQLExecutionResult);
        } else {
            this.logSuccess(sQLExecutionResult);
        }
    }

    public void finish(long l) {
        OutputWriter outputWriter = this.inputOutput.getOut();
        outputWriter.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionFinished", (Object)String.valueOf(this.millisecondsToSeconds(l)), (Object)String.valueOf(this.errorCount)));
        outputWriter.println("");
    }

    public void cancel() {
        OutputWriter outputWriter = this.inputOutput.getErr();
        outputWriter.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
        outputWriter.println("");
    }

    public void close() {
        this.inputOutput.closeInputOutput();
    }

    private void logException(SQLExecutionResult sQLExecutionResult) {
        ++this.errorCount;
        if (!this.inputOutputSelected) {
            this.inputOutputSelected = true;
            this.inputOutput.select();
        }
        OutputWriter outputWriter = this.inputOutput.getErr();
        outputWriter.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ErrorCodeStateMessage", (Object)String.valueOf(sQLExecutionResult.getException().getErrorCode()), (Object)sQLExecutionResult.getException().getSQLState(), (Object)sQLExecutionResult.getException().getMessage()));
        this.printLineColumn(outputWriter, sQLExecutionResult.getStatementInfo(), true);
        outputWriter.println("");
    }

    private void logSuccess(SQLExecutionResult sQLExecutionResult) {
        OutputWriter outputWriter = this.inputOutput.getOut();
        String string = this.millisecondsToSeconds(sQLExecutionResult.getExecutionTime());
        String string2 = null;
        string2 = sQLExecutionResult.getRowCount() >= 0 ? NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfullyTimeRows", (Object)String.valueOf(string), (Object)String.valueOf(sQLExecutionResult.getRowCount())) : NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutedSuccessfullyTime", (Object)String.valueOf(string));
        outputWriter.println(string2);
        this.printLineColumn(outputWriter, sQLExecutionResult.getStatementInfo(), false);
        outputWriter.println("");
    }

    private void printLineColumn(OutputWriter outputWriter, StatementInfo statementInfo, boolean bl) {
        String string = NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_LineColumn", (Object)String.valueOf(statementInfo.getStartLine() + 1), (Object)String.valueOf(statementInfo.getStartColumn() + 1));
        try {
            if (bl) {
                outputWriter.println(string, (OutputListener)new Hyperlink(statementInfo.getStartLine(), statementInfo.getStartColumn()));
            } else {
                outputWriter.println(string);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private String millisecondsToSeconds(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        return numberFormat.format((double)l / 1000.0);
    }

    public void logResultSetException(Exception exception) {
        this.inputOutput.select();
        OutputWriter outputWriter = this.inputOutput.getErr();
        outputWriter.println(NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ResultSetErrorDetailed", (Object)exception.getMessage()));
    }

    private final class Hyperlink
    implements OutputListener {
        private final int line;
        private final int column;

        public Hyperlink(int n, int n2) {
            this.line = n;
            this.column = n2;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.goToLine(false);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.goToLine(true);
        }

        private void goToLine(boolean bl) {
            Line line = SQLExecutionLoggerImpl.this.lineCookie.getLineSet().getOriginal(this.line);
            if (!line.isDeleted()) {
                line.show(bl ? 2 : 0, this.column);
            }
        }
    }
}

