/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.StatementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLExecuteHelper {
    private static final Logger LOGGER = Logger.getLogger(SQLExecuteHelper.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public static SQLExecutionResults execute(String string, int n, int n2, Connection connection, ProgressHandle progressHandle, SQLExecutionLogger sQLExecutionLogger) {
        boolean bl = false;
        List<StatementInfo> list = SQLExecuteHelper.getStatements(string, n, n2);
        boolean bl2 = list.size() == 1;
        ArrayList<SQLExecutionResult> arrayList = new ArrayList<SQLExecutionResult>();
        long l = 0L;
        Object object = list.iterator();
        while (object.hasNext() && !(bl = Thread.currentThread().isInterrupted())) {
            StatementInfo statementInfo = object.next();
            String string2 = statementInfo.getSQL();
            if (LOG) {
                LOGGER.log(Level.FINE, "Executing: " + string2);
            }
            SQLExecutionResult sQLExecutionResult = null;
            Statement statement = null;
            try {
                statement = string2.startsWith("{") ? connection.prepareCall(string2) : connection.createStatement();
                boolean bl3 = false;
                long l2 = System.currentTimeMillis();
                bl3 = statement instanceof PreparedStatement ? ((PreparedStatement)statement).execute() : statement.execute(string2);
                long l3 = System.currentTimeMillis() - l2;
                l += l3;
                sQLExecutionResult = bl3 ? new SQLExecutionResult(statementInfo, statement, statement.getResultSet(), l3) : new SQLExecutionResult(statementInfo, statement, statement.getUpdateCount(), l3);
            }
            catch (SQLException sQLException) {
                sQLExecutionResult = new SQLExecutionResult(statementInfo, statement, sQLException);
            }
            assert (sQLExecutionResult != null);
            sQLExecutionLogger.log(sQLExecutionResult);
            if (LOG) {
                LOGGER.log(Level.FINE, "Result: " + sQLExecutionResult);
            }
            if (bl2 || sQLExecutionResult.getException() != null) {
                arrayList.add(sQLExecutionResult);
                continue;
            }
            try {
                sQLExecutionResult.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger("global").log(Level.INFO, null, sQLException);
            }
        }
        if (!bl) {
            sQLExecutionLogger.finish(l);
        } else {
            if (LOG) {
                LOGGER.log(Level.FINE, "Execution cancelled");
            }
            sQLExecutionLogger.cancel();
        }
        object = new SQLExecutionResults(arrayList);
        if (!bl) {
            return object;
        }
        ((SQLExecutionResults)object).close();
        return null;
    }

    private static int[] getSupportedResultSetTypeConcurrency(Connection connection) throws SQLException {
        int n;
        int n2;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (!databaseMetaData.supportsResultSetConcurrency(n2 = 1004, n = 1008) && !databaseMetaData.supportsResultSetConcurrency(n2, n = 1007)) {
            n2 = 1003;
        }
        return new int[]{n2, n};
    }

    private static List<StatementInfo> getStatements(String string, int n, int n2) {
        List<StatementInfo> list = SQLExecuteHelper.split(string);
        if (n == 0 && n2 == string.length()) {
            return list;
        }
        ArrayList<StatementInfo> arrayList = new ArrayList<StatementInfo>();
        for (StatementInfo statementInfo : list) {
            if (n == n2) {
                if (statementInfo.getRawStartOffset() > n || statementInfo.getRawEndOffset() < n2) continue;
                arrayList.add(statementInfo);
                continue;
            }
            if (statementInfo.getStartOffset() < n || statementInfo.getEndOffset() > n2) continue;
            arrayList.add(statementInfo);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static List<StatementInfo> split(String string) {
        return new SQLSplitter(string).getStatements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SQLSplitter {
        private static final int STATE_MEANINGFUL_TEXT = 0;
        private static final int STATE_MAYBE_LINE_COMMENT = 1;
        private static final int STATE_LINE_COMMENT = 2;
        private static final int STATE_MAYBE_BLOCK_COMMENT = 3;
        private static final int STATE_BLOCK_COMMENT = 4;
        private static final int STATE_MAYBE_END_BLOCK_COMMENT = 5;
        private static final int STATE_STRING = 6;
        private String sql;
        private int sqlLength;
        private StringBuffer statement = new StringBuffer();
        private List<StatementInfo> statements = new ArrayList<StatementInfo>();
        private int pos = 0;
        private int line = -1;
        private int column;
        private boolean wasEOL = true;
        private int rawStartOffset;
        private int startOffset;
        private int startLine;
        private int startColumn;
        private int endOffset;
        private int rawEndOffset;
        private int state = 0;

        public SQLSplitter(String string) {
            assert (string != null);
            this.sql = string;
            this.sqlLength = string.length();
            this.parse();
        }

        private void parse() {
            block9: while (this.pos < this.sqlLength) {
                char c = this.sql.charAt(this.pos);
                if (c == '\r') {
                    if (!LOG) continue;
                    LOGGER.log(Level.FINE, "The SQL string contained non-supported \r characters.");
                    continue;
                }
                if (this.wasEOL) {
                    ++this.line;
                    this.column = 0;
                    this.wasEOL = false;
                } else {
                    ++this.column;
                }
                if (c == '\n') {
                    this.wasEOL = true;
                }
                switch (this.state) {
                    case 0: {
                        if (c == '-') {
                            this.state = 1;
                        }
                        if (c == '/') {
                            this.state = 3;
                        }
                        if (c != '\'') break;
                        this.state = 6;
                        break;
                    }
                    case 1: {
                        if (c == '-') {
                            this.state = 2;
                            break;
                        }
                        this.state = 0;
                        this.statement.append('-');
                        this.endOffset = this.pos;
                        break;
                    }
                    case 2: {
                        if (c != '\n') break;
                        this.state = 0;
                        ++this.pos;
                        continue block9;
                    }
                    case 3: {
                        if (c == '*') {
                            this.state = 4;
                            break;
                        }
                        this.statement.append('/');
                        this.endOffset = this.pos;
                        if (c == '/') break;
                        this.state = 0;
                        break;
                    }
                    case 4: {
                        if (c != '*') break;
                        this.state = 5;
                        break;
                    }
                    case 5: {
                        if (c == '/') {
                            this.state = 0;
                            ++this.pos;
                            continue block9;
                        }
                        if (c == '*') break;
                        this.state = 4;
                        break;
                    }
                    case 6: {
                        if (c != '\n' && c != '\'') break;
                        this.state = 0;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.state == 0 && c == ';') {
                    this.rawEndOffset = this.pos;
                    this.addStatement();
                    this.statement.setLength(0);
                    this.rawStartOffset = this.pos + 1;
                } else if (!(this.state != 0 && this.state != 6 || this.statement.length() <= 0 && Character.isWhitespace(c))) {
                    if (this.statement.length() == 0) {
                        this.startOffset = this.pos;
                        this.endOffset = this.pos;
                        this.startLine = this.line;
                        this.startColumn = this.column;
                    }
                    this.statement.append(c);
                    if (this.state == 6 || !Character.isWhitespace(c)) {
                        this.endOffset = this.pos + 1;
                    }
                }
                ++this.pos;
            }
            this.rawEndOffset = this.pos;
            this.addStatement();
        }

        private void addStatement() {
            String string = this.statement.toString().trim();
            if (string.length() <= 0) {
                return;
            }
            StatementInfo statementInfo = new StatementInfo(string, this.rawStartOffset, this.startOffset, this.startLine, this.startColumn, this.endOffset, this.rawEndOffset);
            this.statements.add(statementInfo);
        }

        public List<StatementInfo> getStatements() {
            return Collections.unmodifiableList(this.statements);
        }
    }
}

